/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.channel;

import com.taobao.aranger.core.entity.Callback;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.core.ipc.channel.IChannel;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.mit.IPCMonitor;
import java.util.List;

public abstract class BaseClientChannel
implements IChannel {
    public final void recycleClient(List<String> keyList) throws IPCException {
        IPCMonitor.IpcState ipcState = new IPCMonitor.IpcState(5);
        IPCException exception = null;
        long start = System.currentTimeMillis();
        try {
            this.internalRecycle(keyList);
            ipcState.setResult(0);
        }
        catch (IPCException e) {
            exception = e;
        }
        if (exception != null) {
            ipcState.setResult(exception.getErrorCode());
        }
        ipcState.setCostTime(System.currentTimeMillis() - start);
        ipcState.commit();
        if (exception != null) {
            throw exception;
        }
    }

    public final Reply sendCallback(Callback callback) throws IPCException {
        IPCMonitor.IpcState ipcState = new IPCMonitor.IpcState(3);
        long start = System.currentTimeMillis();
        IPCException exception = null;
        Reply reply = null;
        long invokeTime = 0L;
        try {
            reply = this.internalSendCallback(callback);
            ipcState.setDataSize(callback.getDataSize());
            ipcState.setResult(reply.getErrorCode());
            invokeTime = reply.getInvokeTime();
            if (reply.isError()) {
                exception = new IPCException(reply.getErrorCode(), reply.getErrorMessage());
            }
        }
        catch (IPCException e) {
            exception = e;
        }
        if (exception != null) {
            ipcState.setResult(exception.getErrorCode());
        }
        ipcState.setCostTime(System.currentTimeMillis() - start - invokeTime);
        ipcState.commit();
        if (exception != null) {
            throw exception;
        }
        return reply;
    }

    abstract Reply internalSendCallback(Callback var1) throws IPCException;
}

