/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.channel;

import com.taobao.aranger.core.entity.Call;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.core.ipc.channel.IChannel;
import com.taobao.aranger.core.ipc.channel.MixRemoteChannel;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.mit.IPCMonitor;
import java.util.List;

public abstract class BaseRemoteChannel
implements IChannel {
    public final Reply sendCall(Call call) throws IPCException {
        IPCMonitor.IpcState ipcState;
        switch (call.getObjectWrapper().getType()) {
            case 0: {
                ipcState = new IPCMonitor.IpcState(0);
                break;
            }
            case 1: {
                ipcState = new IPCMonitor.IpcState(1);
                ipcState.setMethodName(call.getMethodWrapper().getName());
                break;
            }
            default: {
                ipcState = new IPCMonitor.IpcState(2);
                ipcState.setMethodName(call.getMethodWrapper().getName());
            }
        }
        ipcState.setServiceName(call.getObjectWrapper().getName());
        long start = System.currentTimeMillis();
        IPCException exception = null;
        Reply reply = null;
        long invokeTime = 0L;
        try {
            reply = this.internalSendCall(call);
            ipcState.setDataSize(call.getDataSize());
            invokeTime = reply.getInvokeTime();
            if (reply.isError()) {
                exception = new IPCException(reply.getErrorCode(), reply.getErrorMessage());
            }
        }
        catch (IPCException e) {
            exception = e;
        }
        this.commitIPCState(ipcState, exception, start, invokeTime);
        return reply;
    }

    public final void connect() throws IPCException {
        IPCMonitor.IpcState ipcState = new IPCMonitor.IpcState(6);
        IPCException exception = null;
        long start = System.currentTimeMillis();
        try {
            this.internalConnect();
        }
        catch (IPCException e) {
            exception = e;
        }
        this.commitIPCState(ipcState, exception, start, 0L);
    }

    public final void recycleRemote(List<String> keyList) throws IPCException {
        IPCMonitor.IpcState ipcState = new IPCMonitor.IpcState(4);
        IPCException exception = null;
        long start = System.currentTimeMillis();
        try {
            this.internalRecycle(keyList);
        }
        catch (IPCException e) {
            exception = e;
        }
        this.commitIPCState(ipcState, exception, start, 0L);
    }

    private void commitIPCState(IPCMonitor.IpcState ipcState, IPCException exception, long start, long invokeTime) throws IPCException {
        ipcState.setResult(exception != null ? exception.getErrorCode() : 0);
        ipcState.setDegrade(MixRemoteChannel.isDegrade);
        ipcState.setCostTime(System.currentTimeMillis() - (start + invokeTime));
        ipcState.setInvokeTime(invokeTime);
        ipcState.commit();
        if (exception != null) {
            throw exception;
        }
    }

    abstract Reply internalSendCall(Call var1) throws IPCException;

    abstract void internalConnect() throws IPCException;
}

