/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.channel;

import android.os.IBinder;
import android.os.RemoteException;
import com.taobao.aranger.core.entity.Callback;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.core.ipc.channel.BaseClientChannel;
import com.taobao.aranger.core.ipc.proxy.ClientServiceProxy;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.intf.IClientService;
import java.util.List;

public class DefaultClientChannel
extends BaseClientChannel {
    private final IClientService clientService;

    public DefaultClientChannel(IBinder clientServiceBinder) {
        this.clientService = ClientServiceProxy.getProxy(clientServiceBinder);
    }

    @Override
    public void internalRecycle(List<String> keyList) throws IPCException {
        try {
            this.clientService.recycle(keyList);
        }
        catch (Exception e) {
            if (e instanceof IPCException) {
                throw (IPCException)e;
            }
            if (e instanceof RemoteException) {
                throw new IPCException(27, (Throwable)e);
            }
            throw new IPCException(9, (Throwable)e);
        }
    }

    @Override
    public Reply internalSendCallback(Callback callback) throws IPCException {
        try {
            return this.clientService.sendCallback(callback);
        }
        catch (Exception e) {
            if (e instanceof IPCException) {
                throw (IPCException)e;
            }
            if (e instanceof RemoteException) {
                throw new IPCException(2, (Throwable)e);
            }
            throw new IPCException(9, (Throwable)e);
        }
    }
}

