/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.channel;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import com.taobao.aranger.ARanger;
import com.taobao.aranger.core.entity.Call;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.core.ipc.channel.BaseRemoteChannel;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.logs.IPCLog;
import com.taobao.aranger.utils.IPCThreadCaller;
import java.util.ArrayList;
import java.util.List;

public class DefaultRemoteChannel
extends BaseRemoteChannel {
    private static final String TAG = DefaultRemoteChannel.class.getSimpleName();
    private final ContentResolver mContentResolver;
    private final Uri mRemoteProviderUri;

    DefaultRemoteChannel(Uri remoteProviderUri) {
        this.mRemoteProviderUri = remoteProviderUri;
        this.mContentResolver = ARanger.getContext().getContentResolver();
    }

    @Override
    public Reply internalSendCall(Call call) throws IPCException {
        Bundle bundle = new Bundle();
        bundle.putParcelable("call", (Parcelable)call);
        return this.call("call", bundle, call.isOneWay());
    }

    @Override
    public void internalConnect() throws IPCException {
        this.call("connect", null, true);
    }

    @Override
    public void internalRecycle(List<String> keyList) throws IPCException {
        Bundle bundle = new Bundle();
        bundle.putStringArrayList("keys", (ArrayList)keyList);
        this.call("recycle_remote", bundle, true);
    }

    private Reply call(final String method, final Bundle bundle, boolean isOneWay) throws IPCException {
        try {
            if (isOneWay) {
                IPCThreadCaller.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DefaultRemoteChannel.this.mContentResolver.call(DefaultRemoteChannel.this.mRemoteProviderUri, method, "", bundle);
                        }
                        catch (Exception e) {
                            IPCLog.e(TAG, "[call]", e, new Object[0]);
                        }
                    }
                });
                return Reply.obtain().setResult(null);
            }
            ContentProviderClient contentProviderClient = this.mContentResolver.acquireUnstableContentProviderClient(this.mRemoteProviderUri);
            Bundle resultBundle = contentProviderClient != null && Build.VERSION.SDK_INT >= 17 ? contentProviderClient.call(method, "", bundle) : this.mContentResolver.call(this.mRemoteProviderUri, method, "", bundle);
            resultBundle.setClassLoader(this.getClass().getClassLoader());
            Reply result = (Reply)resultBundle.getParcelable("reply");
            return result == null ? Reply.obtain().setResult(null) : result;
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                throw new IPCException(1, (Throwable)e);
            }
            throw new IPCException(9, (Throwable)e);
        }
    }
}

