/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.channel;

import android.net.Uri;
import com.taobao.aranger.core.entity.Call;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.core.ipc.channel.BaseRemoteChannel;
import com.taobao.aranger.core.ipc.channel.DefaultRemoteChannel;
import com.taobao.aranger.core.ipc.channel.QuickRemoteChannel;
import com.taobao.aranger.exception.IPCException;
import java.util.List;

public class MixRemoteChannel
extends BaseRemoteChannel {
    private final BaseRemoteChannel mDefaultRemoteChannel;
    private final BaseRemoteChannel mQuickRemoteChannel;
    static volatile boolean isDegrade = false;

    public MixRemoteChannel(Uri remoteProviderUri) {
        this.mDefaultRemoteChannel = new DefaultRemoteChannel(remoteProviderUri);
        this.mQuickRemoteChannel = new QuickRemoteChannel(remoteProviderUri);
    }

    @Override
    public Reply internalSendCall(Call call) throws IPCException {
        if (isDegrade) {
            return this.mDefaultRemoteChannel.internalSendCall(call);
        }
        try {
            return this.mQuickRemoteChannel.internalSendCall(call);
        }
        catch (IPCException e) {
            switch (e.getErrorCode()) {
                case 19: {
                    isDegrade = true;
                }
                case 1: {
                    return this.mDefaultRemoteChannel.internalSendCall(call);
                }
            }
            throw e;
        }
    }

    @Override
    public void internalConnect() throws IPCException {
        if (isDegrade) {
            this.mDefaultRemoteChannel.internalConnect();
        } else {
            try {
                this.mQuickRemoteChannel.internalConnect();
            }
            catch (IPCException e) {
                switch (e.getErrorCode()) {
                    case 19: {
                        isDegrade = true;
                    }
                    case 1: {
                        this.mDefaultRemoteChannel.internalConnect();
                        break;
                    }
                    default: {
                        throw e;
                    }
                }
            }
        }
    }

    @Override
    public void internalRecycle(List<String> keyList) throws IPCException {
        if (isDegrade) {
            this.mDefaultRemoteChannel.internalRecycle(keyList);
        } else {
            try {
                this.mQuickRemoteChannel.internalRecycle(keyList);
            }
            catch (IPCException e) {
                switch (e.getErrorCode()) {
                    case 19: {
                        isDegrade = true;
                    }
                    case 1: {
                        this.mDefaultRemoteChannel.internalRecycle(keyList);
                        break;
                    }
                    default: {
                        throw e;
                    }
                }
            }
        }
    }
}

