/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.channel;

import android.app.ActivityThread;
import android.content.ContentResolver;
import android.content.IContentProvider;
import android.content.Intent;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import com.taobao.aranger.ARanger;
import com.taobao.aranger.core.entity.Call;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.core.ipc.channel.BaseRemoteChannel;
import com.taobao.aranger.core.ipc.proxy.RemoteServiceProxy;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.intf.IRemoteService;
import com.taobao.aranger.logs.IPCLog;
import com.taobao.aranger.utils.IPCUtils;
import com.taobao.aranger.utils.ReflectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class QuickRemoteChannel
extends BaseRemoteChannel {
    private static final String TAG = QuickRemoteChannel.class.getSimpleName();
    private final ContentResolver mContentResolver;
    private final ActivityThread mActivityThread;
    private final Uri mRemoteProviderUri;
    private final String mProcessName;
    private Method acquireMethod;
    private IRemoteService remoteService;
    private static final Set<String> sProcessDeathSet = new CopyOnWriteArraySet<String>();

    QuickRemoteChannel(Uri targetContentUri) {
        this.mRemoteProviderUri = targetContentUri;
        this.mActivityThread = ActivityThread.currentActivityThread();
        this.mProcessName = IPCUtils.getProcessNameFromUri(targetContentUri);
        this.mContentResolver = ARanger.getContext().getContentResolver();
    }

    @Override
    public Reply internalSendCall(Call call) throws IPCException {
        try {
            return this.getRemoteService(this.mRemoteProviderUri).sendCall(call);
        }
        catch (Exception e) {
            if (e instanceof IPCException) {
                throw (IPCException)e;
            }
            if (e instanceof RemoteException) {
                throw new IPCException(1, (Throwable)e);
            }
            throw new IPCException(9, (Throwable)e);
        }
    }

    @Override
    public void internalConnect() throws IPCException {
        try {
            this.getRemoteService(this.mRemoteProviderUri).connect();
        }
        catch (Exception e) {
            if (e instanceof IPCException) {
                throw (IPCException)e;
            }
            if (e instanceof RemoteException) {
                throw new IPCException(1, (Throwable)e);
            }
            throw new IPCException(9, (Throwable)e);
        }
    }

    @Override
    public void internalRecycle(List<String> keyList) throws IPCException {
        try {
            this.getRemoteService(this.mRemoteProviderUri).recycle(keyList);
        }
        catch (Exception e) {
            if (e instanceof IPCException) {
                throw (IPCException)e;
            }
            if (e instanceof RemoteException) {
                throw new IPCException(1, (Throwable)e);
            }
            throw new IPCException(9, (Throwable)e);
        }
    }

    private IRemoteService getRemoteService(Uri targetContentUri) throws Exception {
        if (this.remoteService == null || this.remoteService.isRemote() && !this.remoteService.asBinder().isBinderAlive()) {
            try {
                IContentProvider contentProvider;
                try {
                    if (this.acquireMethod == null) {
                        this.acquireMethod = ReflectUtils.getHideMethod(ContentResolver.class, "acquireUnstableProvider", Uri.class);
                    }
                    contentProvider = (IContentProvider)this.acquireMethod.invoke((Object)this.mContentResolver, targetContentUri);
                }
                catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
                    contentProvider = Build.VERSION.SDK_INT <= 16 ? this.mActivityThread.acquireProvider(ARanger.getContext(), targetContentUri.getAuthority(), false) : (Build.VERSION.SDK_INT < 21 ? this.mActivityThread.acquireProvider(ARanger.getContext(), targetContentUri.getAuthority(), Binder.getCallingUid() / 100000, false) : this.mActivityThread.acquireProvider(ARanger.getContext(), IPCUtils.getAuthorityWithoutUserId(targetContentUri.getAuthority()), IPCUtils.getUserIdFromAuthority(targetContentUri.getAuthority(), Process.myUserHandle().hashCode()), false));
                }
                if (contentProvider == null) {
                    throw new IPCException(19, "can't get content provider");
                }
                this.remoteService = RemoteServiceProxy.getProxy(contentProvider.asBinder());
            }
            catch (Exception e) {
                throw new IPCException(19, (Throwable)e);
            }
        }
        if (this.remoteService.isRemote() && !sProcessDeathSet.contains(this.mProcessName)) {
            sProcessDeathSet.add(this.mProcessName);
            final IBinder iBinder = this.remoteService.asBinder();
            try {
                iBinder.linkToDeath(new IBinder.DeathRecipient(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void binderDied() {
                        iBinder.unlinkToDeath((IBinder.DeathRecipient)this, 0);
                        Class<QuickRemoteChannel> clazz = QuickRemoteChannel.class;
                        synchronized (QuickRemoteChannel.class) {
                            if (!TextUtils.isEmpty((CharSequence)QuickRemoteChannel.this.mProcessName) && sProcessDeathSet.contains(QuickRemoteChannel.this.mProcessName)) {
                                Intent intent = new Intent();
                                intent.setAction("com.taobao.aranger.DISCONNECT");
                                intent.putExtra("processName", QuickRemoteChannel.this.mProcessName);
                                ARanger.getContext().sendBroadcast(intent);
                                sProcessDeathSet.remove(QuickRemoteChannel.this.mProcessName);
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, 0);
            }
            catch (RemoteException e) {
                IPCLog.e(TAG, "[getRemoteService][linkToDeath]", e, new Object[0]);
            }
        }
        return this.remoteService;
    }
}

