/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.taobao.aranger.ARanger;
import com.taobao.aranger.core.entity.Call;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.core.handler.reply.ReplyHandlerFactory;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.intf.IRemoteService;
import com.taobao.aranger.logs.IPCLog;
import com.taobao.aranger.utils.IPCThreadCaller;
import com.taobao.aranger.utils.IPCUtils;
import com.taobao.aranger.utils.ObjectCenter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ARangerProvider
extends ContentProvider
implements IRemoteService {
    private static final String TAG = ARangerProvider.class.getSimpleName();
    private static final AtomicBoolean isConnectFlag = new AtomicBoolean(false);
    private final RemoteService mRemoteService = new RemoteService();

    public boolean onCreate() {
        this.connect();
        return false;
    }

    public Cursor query(Uri uri, String[] strings, String s, String[] strings1, String s1) {
        return null;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        return null;
    }

    public int delete(Uri uri, String s, String[] strings) {
        return 0;
    }

    public int update(Uri uri, ContentValues contentValues, String s, String[] strings) {
        return 0;
    }

    @Keep
    public IContentProvider getIContentProvider() {
        return this.mRemoteService;
    }

    @Keep
    public Bundle call(String method, String arg, Bundle extras) {
        Bundle bundle = new Bundle();
        switch (method) {
            case "call": {
                extras.setClassLoader(ARanger.class.getClassLoader());
                Call call = (Call)extras.getParcelable("call");
                try {
                    bundle.putParcelable("reply", (Parcelable)this.sendCall(call));
                }
                catch (Exception e) {
                    IPCLog.e(TAG, "[call][sendCall]", e, new Object[0]);
                    bundle.putParcelable("reply", (Parcelable)Reply.obtain().setErrorCode(10).setErrorMessage(e.getMessage()));
                }
                break;
            }
            case "recycle_remote": {
                final ArrayList keys = extras.getStringArrayList("keys");
                IPCThreadCaller.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ARangerProvider.this.recycle(keys);
                        }
                        catch (Exception e) {
                            IPCLog.e(TAG, "[call][recycle]", e, new Object[0]);
                        }
                    }
                });
                break;
            }
        }
        return bundle;
    }

    @Override
    public Reply sendCall(Call call) {
        try {
            return ReplyHandlerFactory.createReplyHandler(call).handleReply();
        }
        catch (Exception e) {
            IPCLog.e(TAG, "[sendCall][handleReply]", e, new Object[0]);
            if (e instanceof IPCException) {
                return Reply.obtain().setErrorCode(((IPCException)e).getErrorCode()).setErrorMessage(e.getMessage());
            }
            return Reply.obtain().setErrorCode(11).setErrorMessage(e.getMessage());
        }
    }

    @Override
    public void recycle(List<String> keyList) {
        ObjectCenter.getInstance().deleteObjects(keyList);
    }

    @Override
    public void connect() {
        if (isConnectFlag.compareAndSet(false, true)) {
            IPCThreadCaller.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Intent intent = new Intent();
                        intent.setAction("com.taobao.aranger.CONNECT");
                        intent.putExtra("processName", IPCUtils.getCurrentProcessName());
                        ARanger.getContext().sendBroadcast(intent);
                    }
                    catch (Throwable e) {
                        IPCLog.e(TAG, "[connect][sendBroadcast]", e, new Object[0]);
                    }
                }
            });
        }
    }

    public IBinder asBinder() {
        return null;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    private class RemoteService
    extends Binder
    implements IContentProvider {
        RemoteService() {
            this.attachInterface((IInterface)this, "android.content.IContentProvider");
        }

        public IBinder asBinder() {
            return this;
        }

        protected boolean onTransact(int code, @NonNull Parcel data, Parcel reply, int flags) {
            switch (code) {
                case 0: {
                    final Call call = (Call)Call.CREATOR.createFromParcel(data);
                    if (flags == 1) {
                        IPCThreadCaller.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ARangerProvider.this.sendCall(call);
                                }
                                catch (Exception e) {
                                    IPCLog.e(TAG, "[onTransact][sendCall]", e, new Object[0]);
                                }
                            }
                        });
                    } else {
                        try {
                            Reply returnReply = ARangerProvider.this.sendCall(call);
                            if (!"void".equals(call.getMethodWrapper().getReturnType()) || returnReply.isError() || returnReply.getFlowParameterWrappers() != null) {
                                returnReply.writeToParcel(reply, 0);
                            }
                        }
                        catch (Exception e) {
                            Reply.obtain().setErrorCode(10).setErrorMessage(e.getMessage()).writeToParcel(reply, flags);
                        }
                    }
                    return true;
                }
                case 1: {
                    final ArrayList keyList = data.createStringArrayList();
                    IPCThreadCaller.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ARangerProvider.this.recycle(keyList);
                            }
                            catch (Exception e) {
                                IPCLog.e(TAG, "[onTransact][recycle]", e, new Object[0]);
                            }
                        }
                    });
                    return true;
                }
                case 21: {
                    data.enforceInterface("android.content.IContentProvider");
                    if (Build.VERSION.SDK_INT > 17) {
                        data.readString();
                    }
                    if (Build.VERSION.SDK_INT >= 29) {
                        data.readString();
                    }
                    String method = data.readString();
                    String stringArg = data.readString();
                    Bundle args = data.readBundle(((Object)((Object)this)).getClass().getClassLoader());
                    Bundle responseBundle = ARangerProvider.this.call(method, stringArg, args);
                    reply.writeNoException();
                    reply.writeBundle(responseBundle);
                    return true;
                }
            }
            return true;
        }
    }
}

