/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.provider;

import android.os.Binder;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import com.taobao.aranger.constant.Constants;
import com.taobao.aranger.core.entity.Callback;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.core.wrapper.ParameterWrapper;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.intf.IClientService;
import com.taobao.aranger.logs.IPCLog;
import com.taobao.aranger.utils.CallbackManager;
import com.taobao.aranger.utils.IPCThreadCaller;
import com.taobao.aranger.utils.ParameterTransformer;
import com.taobao.aranger.utils.TypeCenter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ClientServiceProvider
extends Binder
implements IClientService {
    private static final String TAG = ClientServiceProvider.class.getSimpleName();
    private static volatile ClientServiceProvider sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientServiceProvider getClientService() {
        if (sInstance != null) return sInstance;
        Class<ClientServiceProvider> clazz = ClientServiceProvider.class;
        synchronized (ClientServiceProvider.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ClientServiceProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private ClientServiceProvider() {
        this.attachInterface(this, Constants.CLIENT_SERVICE_DESCRIPTOR);
    }

    protected boolean onTransact(int code, @NonNull Parcel data, Parcel reply, int flags) {
        switch (code) {
            case 3: {
                final Callback callback = (Callback)Callback.CREATOR.createFromParcel(data);
                if (flags == 1) {
                    IPCThreadCaller.execute(new Runnable(){

                        @Override
                        public void run() {
                            ClientServiceProvider.this.sendCallback(callback);
                        }
                    });
                } else {
                    try {
                        Reply returnReply = this.sendCallback(callback);
                        if (!"void".equals(callback.getMethodWrapper().getReturnType()) || returnReply.isError() || returnReply.getFlowParameterWrappers() != null) {
                            returnReply.writeToParcel(reply, 0);
                        }
                    }
                    catch (Exception e) {
                        Reply.obtain().setErrorCode(8).setErrorMessage(e.getMessage()).writeToParcel(reply, flags);
                    }
                }
                return true;
            }
            case 4: {
                final ArrayList keyList = data.createStringArrayList();
                IPCThreadCaller.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ClientServiceProvider.this.recycle(keyList);
                        }
                        catch (Exception e) {
                            IPCLog.e(TAG, "[onTransact][recycle]", e, new Object[0]);
                        }
                    }
                });
            }
        }
        return true;
    }

    public IBinder asBinder() {
        return this;
    }

    @Override
    public Reply sendCallback(Callback callback) {
        Pair<Boolean, Object> pair = CallbackManager.getInstance().getCallback(callback.getKey());
        if (pair == null || pair.second == null) {
            return Reply.obtain().setErrorCode(6).setErrorMessage("can't find callback in current process");
        }
        Object callbackObject = pair.second;
        boolean uiThread = (Boolean)pair.first;
        try {
            boolean isMainThread;
            ArrayList<Integer> flowFlagIndexList = new ArrayList<Integer>();
            Method method = TypeCenter.getInstance().getMethod(callbackObject.getClass(), callback.getMethodWrapper());
            Object[] parameters = ParameterTransformer.unWrapperParameters(callback.getParameterWrappers(), flowFlagIndexList);
            ParameterWrapper[] dataFlowParameterWrappers = null;
            Object result = null;
            Exception exception = null;
            boolean bl = isMainThread = Looper.getMainLooper() == Looper.myLooper();
            if (isMainThread ^ uiThread) {
                try {
                    CountDownLatch countDownLatch = new CountDownLatch(1);
                    CallbackRunnable callbackRunnable = new CallbackRunnable(countDownLatch, method, callbackObject, parameters);
                    if (isMainThread) {
                        IPCThreadCaller.execute(callbackRunnable);
                        countDownLatch.await(1L, TimeUnit.SECONDS);
                    } else {
                        IPCThreadCaller.post(true, callbackRunnable);
                        countDownLatch.await();
                    }
                    if (callbackRunnable.getException() == null) {
                        if (!flowFlagIndexList.isEmpty()) {
                            dataFlowParameterWrappers = new ParameterWrapper[flowFlagIndexList.size()];
                            Iterator iterator = flowFlagIndexList.iterator();
                            while (iterator.hasNext()) {
                                int index = (Integer)iterator.next();
                                dataFlowParameterWrappers[index] = ParameterWrapper.obtain().setData(parameters[(Integer)flowFlagIndexList.get(index)]);
                            }
                        }
                        return Reply.obtain().setFlowParameterWrappers(dataFlowParameterWrappers).setResult(callbackRunnable.getResult());
                    }
                    return Reply.obtain().setErrorCode(4).setErrorMessage(callbackRunnable.getException().getMessage());
                }
                catch (Exception e) {
                    return Reply.obtain().setErrorCode(7).setErrorMessage("callback invoke error: " + e.getMessage());
                }
            }
            try {
                result = method.invoke(callbackObject, parameters);
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception != null) {
                exception.printStackTrace();
                throw new IPCException(4, (Throwable)exception);
            }
            if (!flowFlagIndexList.isEmpty()) {
                dataFlowParameterWrappers = new ParameterWrapper[flowFlagIndexList.size()];
                Iterator iterator = flowFlagIndexList.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    dataFlowParameterWrappers[index] = ParameterWrapper.obtain().setData(parameters[(Integer)flowFlagIndexList.get(index)]);
                }
            }
            return Reply.obtain().setFlowParameterWrappers(dataFlowParameterWrappers).setResult(result);
        }
        catch (IPCException e) {
            IPCLog.e(TAG, "[sendCallback]", e, new Object[0]);
            return Reply.obtain().setErrorCode(e.getErrorCode()).setErrorMessage(e.getMessage());
        }
    }

    @Override
    public void recycle(List<String> keyList) {
        for (String s : keyList) {
            CallbackManager.getInstance().removeCallback(s);
        }
    }

    private static class CallbackRunnable
    implements Runnable {
        private Object mResult;
        private final CountDownLatch mCountDownLatch;
        private final Method mMethod;
        private final Object mCallback;
        private final Object[] mParameters;
        private Exception mException;

        CallbackRunnable(CountDownLatch countDownLatch, Method method, Object callback, Object[] parameters) {
            this.mCountDownLatch = countDownLatch;
            this.mMethod = method;
            this.mCallback = callback;
            this.mParameters = parameters;
        }

        @Override
        public void run() {
            try {
                this.mResult = this.mMethod.invoke(this.mCallback, this.mParameters);
            }
            catch (Exception e) {
                IPCLog.e(TAG, "[CallbackRunnable][run]", e, new Object[0]);
                this.mException = e;
            }
            finally {
                this.mCountDownLatch.countDown();
            }
        }

        Object getResult() {
            return this.mResult;
        }

        Exception getException() {
            return this.mException;
        }
    }
}

