/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.proxy;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import com.taobao.aranger.constant.Constants;
import com.taobao.aranger.core.entity.Callback;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.intf.IClientService;
import java.util.List;

public class ClientServiceProxy
extends Binder
implements IClientService {
    private final IBinder mRemote;

    public static IClientService getProxy(IBinder binder) {
        if (binder == null) {
            return null;
        }
        IInterface iin = binder.queryLocalInterface(Constants.CLIENT_SERVICE_DESCRIPTOR);
        if (iin instanceof IClientService) {
            return (IClientService)iin;
        }
        return new ClientServiceProxy(binder);
    }

    private ClientServiceProxy(IBinder binder) {
        this.mRemote = binder;
    }

    @Override
    public void recycle(List<String> keyList) throws Exception {
        if (this.mRemote.isBinderAlive()) {
            Parcel data = Parcel.obtain();
            try {
                data.writeStringList(keyList);
                this.mRemote.transact(4, data, null, 1);
            }
            finally {
                data.recycle();
            }
        } else {
            throw new IPCException(5, "the remote binder is not alive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reply sendCallback(Callback callback) throws Exception {
        if (this.mRemote.isBinderAlive()) {
            Parcel data = Parcel.obtain();
            Parcel reply = null;
            try {
                if (!callback.isOneWay()) {
                    reply = Parcel.obtain();
                }
                callback.writeToParcel(data, 0);
                this.mRemote.transact(3, data, reply, callback.isOneWay() ? 1 : 0);
                Reply reply2 = reply != null && reply.dataSize() != 0 ? (Reply)Reply.CREATOR.createFromParcel(reply) : Reply.obtain().setResult(null);
                return reply2;
            }
            finally {
                data.recycle();
                if (reply != null) {
                    reply.recycle();
                }
            }
        }
        throw new IPCException(5, "the remote binder is not alive");
    }

    public IBinder asBinder() {
        return this.mRemote;
    }
}

