/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.proxy;

import android.os.IBinder;
import android.os.Parcel;
import com.taobao.aranger.core.entity.Call;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.core.ipc.provider.ARangerProvider;
import com.taobao.aranger.intf.IRemoteService;
import java.util.List;

public class RemoteServiceProxy
implements IRemoteService {
    private static volatile IRemoteService sLocalRemoteService;
    private final IBinder mRemote;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRemoteService getProxy(IBinder iBinder) {
        if (iBinder.queryLocalInterface("android.content.IContentProvider") == null) return new RemoteServiceProxy(iBinder);
        if (sLocalRemoteService != null) return sLocalRemoteService;
        Class<RemoteServiceProxy> clazz = RemoteServiceProxy.class;
        synchronized (RemoteServiceProxy.class) {
            if (sLocalRemoteService != null) return sLocalRemoteService;
            sLocalRemoteService = new ARangerProvider();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sLocalRemoteService;
        }
    }

    @Override
    public boolean isRemote() {
        return this.mRemote.queryLocalInterface("android.content.IContentProvider") == null;
    }

    private RemoteServiceProxy(IBinder remote) {
        this.mRemote = remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reply sendCall(Call call) throws Exception {
        Parcel data = Parcel.obtain();
        Parcel reply = null;
        try {
            if (!call.isOneWay()) {
                reply = Parcel.obtain();
            }
            call.writeToParcel(data, 0);
            this.mRemote.transact(0, data, reply, call.isOneWay() ? 1 : 0);
            Reply reply2 = reply != null && reply.dataSize() != 0 ? (Reply)Reply.CREATOR.createFromParcel(reply) : Reply.obtain().setResult(null);
            return reply2;
        }
        finally {
            data.recycle();
            if (reply != null) {
                reply.recycle();
            }
        }
    }

    @Override
    public void connect() throws Exception {
        Parcel data = Parcel.obtain();
        try {
            this.mRemote.transact(2, data, null, 1);
        }
        finally {
            data.recycle();
        }
    }

    @Override
    public void recycle(List<String> keyList) throws Exception {
        Parcel data = Parcel.obtain();
        try {
            data.writeStringList(keyList);
            this.mRemote.transact(1, data, null, 1);
        }
        finally {
            data.recycle();
        }
    }

    public IBinder asBinder() {
        return this.mRemote;
    }
}

