/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.wrapper;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.taobao.aranger.core.wrapper.BaseWrapper;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.logs.IPCLog;
import com.taobao.aranger.utils.SerializeUtils;
import com.taobao.aranger.utils.TypeCenter;
import com.taobao.aranger.utils.TypeUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterWrapper
extends BaseWrapper
implements Parcelable {
    private static final String TAG = ParameterWrapper.class.getSimpleName();
    public static final Parcelable.Creator<ParameterWrapper> CREATOR = new Parcelable.Creator<ParameterWrapper>(){

        public ParameterWrapper createFromParcel(Parcel in2) {
            ParameterWrapper parameterWrapper = ParameterWrapper.obtain();
            parameterWrapper.readFromParcel(in2);
            return parameterWrapper;
        }

        public ParameterWrapper[] newArray(int size) {
            return new ParameterWrapper[size];
        }
    };
    private Object mData;
    private int mFlowFlag = 0;
    private IBinder mClientServiceBinder;
    private String mTimeStamp;

    public static ParameterWrapper obtain() {
        return new ParameterWrapper();
    }

    private ParameterWrapper() {
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        parcel.writeInt(this.mFlowFlag);
        if (this.mTimeStamp != null) {
            parcel.writeInt(0);
            parcel.writeString(this.mTimeStamp);
        } else {
            parcel.writeInt(1);
        }
        if (this.mClientServiceBinder != null) {
            parcel.writeInt(0);
            parcel.writeStrongBinder(this.mClientServiceBinder);
        } else {
            parcel.writeInt(1);
        }
        SerializeUtils.writeToParcel(parcel, this.mData, flags, false);
    }

    @Override
    void readFromParcel(Parcel in2) {
        super.readFromParcel(in2);
        this.mFlowFlag = in2.readInt();
        if (in2.readInt() == 0) {
            this.mTimeStamp = in2.readString();
        }
        if (in2.readInt() == 0) {
            this.mClientServiceBinder = in2.readStrongBinder();
        }
        this.mData = SerializeUtils.readFromParcel(this.getClass().getClassLoader(), in2);
    }

    public Object getData() {
        return this.mData;
    }

    public Class<?> getClassType() throws IPCException {
        if (this.mData != null) {
            return this.mData.getClass();
        }
        if (this.getName() != null) {
            return TypeCenter.getInstance().getClassType(this.getName());
        }
        return null;
    }

    public int getFlowFlag() {
        return this.mFlowFlag;
    }

    public IBinder getClientServiceBinder() {
        return this.mClientServiceBinder;
    }

    public ParameterWrapper setData(Object data) {
        this.mData = data;
        if (this.mData == null) {
            this.setName(null);
            return this;
        }
        Class<?> clazz = data.getClass();
        this.setName(TypeUtils.getClassId(clazz));
        if (this.mFlowFlag == 1) {
            if (clazz.isArray()) {
                this.mData = Array.newInstance(clazz.getComponentType(), TypeUtils.getObjectArraySize(clazz.getName(), this.mData));
            } else if (List.class.isAssignableFrom(clazz)) {
                this.mData = new ArrayList();
            } else if (Map.class.isAssignableFrom(clazz)) {
                this.mData = new HashMap();
            } else {
                try {
                    this.mData = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    IPCLog.e(TAG, "[setData][newInstance]", e, new Object[0]);
                }
            }
        }
        return this;
    }

    public ParameterWrapper setFlowFlag(int flowFlag) {
        this.mFlowFlag = flowFlag;
        return this;
    }

    public ParameterWrapper setClientServiceBinder(IBinder clientServiceBinder) {
        this.mClientServiceBinder = clientServiceBinder;
        return this;
    }

    public ParameterWrapper setParameterName(String parameterName) {
        this.setName(parameterName);
        return this;
    }

    public ParameterWrapper setTimeStamp(String timeStamp) {
        this.mTimeStamp = timeStamp;
        return this;
    }

    public String getTimeStamp() {
        return this.mTimeStamp;
    }
}

