/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.logs;

import android.util.Log;
import com.taobao.tlog.adapter.AdapterForTLog;

public final class IPCLog {
    private static final String PRE_TAG = "ARanger.";
    private static final String TLOG_CLASS = "com.taobao.tlog.adapter.AdapterForTLog";
    private static boolean isTlogValid;
    private static volatile boolean isUseTlog;

    public static void setUseTlog(boolean enable) {
        isUseTlog = enable;
    }

    public static void d(String tag, String msg, String seq, Object ... kv) {
        if (isTlogValid && isUseTlog) {
            AdapterForTLog.logd((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv));
        } else {
            Log.d((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv));
        }
    }

    public static void i(String tag, String msg, Object ... kv) {
        if (isTlogValid && isUseTlog) {
            AdapterForTLog.logi((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv));
        } else {
            Log.i((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv));
        }
    }

    public static void w(String tag, String msg, Object ... kv) {
        if (isTlogValid && isUseTlog) {
            AdapterForTLog.logw((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv));
        } else {
            Log.w((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv));
        }
    }

    static void w(String tag, String msg, Throwable t, Object ... kv) {
        if (isTlogValid && isUseTlog) {
            AdapterForTLog.logw((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv), (Throwable)t);
        } else {
            Log.w((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv), (Throwable)t);
        }
    }

    public static void e(String tag, String msg, Object ... kv) {
        if (isTlogValid && isUseTlog) {
            AdapterForTLog.loge((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv));
        } else {
            Log.e((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv));
        }
    }

    public static void e(String tag, String msg, Throwable t, Object ... kv) {
        if (isTlogValid && isUseTlog) {
            AdapterForTLog.loge((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv), (Throwable)t);
        } else {
            Log.e((String)IPCLog.buildLogTag(tag), (String)IPCLog.buildLogMsg(msg, kv), (Throwable)t);
        }
    }

    private static String buildLogTag(String tag) {
        return PRE_TAG + tag;
    }

    private static String buildLogMsg(String msg, Object ... kv) {
        if (msg == null && kv == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(64);
        if (msg != null) {
            builder.append(msg);
        }
        if (kv != null) {
            int i = 0;
            while (i + 1 < kv.length) {
                builder.append(" ").append(kv[i] != null ? kv[i] : "").append(":").append(kv[i + 1] != null ? kv[i + 1] : "");
                i += 2;
            }
            if (i < kv.length) {
                builder.append(" ");
                builder.append(kv[i]);
            }
        }
        return builder.toString();
    }

    static {
        isUseTlog = true;
        try {
            Class.forName(TLOG_CLASS);
            isTlogValid = true;
        }
        catch (Exception e) {
            isTlogValid = false;
        }
    }
}

