/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.mit;

import com.alibaba.mtl.appmonitor.AppMonitor;
import com.alibaba.mtl.appmonitor.model.DimensionSet;
import com.alibaba.mtl.appmonitor.model.DimensionValueSet;
import com.alibaba.mtl.appmonitor.model.MeasureSet;
import com.alibaba.mtl.appmonitor.model.MeasureValueSet;
import com.taobao.aranger.logs.IPCLog;
import com.taobao.aranger.utils.IPCThreadCaller;

public class IPCMonitor {
    private static final String TAG = "IPCMonitor";
    private static final String MODULE_NAME = "ARanger";
    private static boolean isAppMonitorValid;

    static {
        try {
            Class.forName("com.alibaba.mtl.appmonitor.AppMonitor");
            isAppMonitorValid = true;
        }
        catch (Exception e) {
            isAppMonitorValid = false;
        }
    }

    public static class IpcState {
        private static final String MONITOR_POINT = "ipcState";
        private static final String DIMENSION_SERVICE_NAME = "serviceName";
        private static final String DIMENSION_METHOD_NAME = "methodName";
        private static final String DIMENSION_TYPE = "type";
        private static final String DIMENSION_RESULT = "result";
        private static final String DIMENSION_DEGRADE = "degrade";
        private static final String MEASURE_COST_TIME = "costTime";
        private static final String MEASURE_INVOKE_TIME = "invokeTime";
        private static final String MEASURE_DATA_SIZE = "dataSize";
        private static boolean isRegistered = false;
        private String serviceName;
        private String methodName;
        private int type;
        private int result;
        private int degrade;
        private long costTime;
        private long invokeTime;
        private long dataSize;

        public IpcState(int type) {
            this.type = type;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public void setResult(int result) {
            this.result = result;
        }

        public void setCostTime(long costTime) {
            this.costTime = costTime;
        }

        public void setInvokeTime(long invokeTime) {
            this.invokeTime = invokeTime;
        }

        public void setDataSize(long dataSize) {
            this.dataSize = dataSize;
        }

        public void setDegrade(boolean isDegrade) {
            this.degrade = isDegrade ? 1 : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean register() {
            if (!isAppMonitorValid) {
                return false;
            }
            IpcState ipcState = this;
            synchronized (ipcState) {
                if (isRegistered) {
                    return true;
                }
                try {
                    DimensionSet ds = DimensionSet.create();
                    ds.addDimension(DIMENSION_TYPE);
                    ds.addDimension(DIMENSION_DEGRADE);
                    ds.addDimension(DIMENSION_RESULT);
                    ds.addDimension(DIMENSION_SERVICE_NAME);
                    ds.addDimension(DIMENSION_METHOD_NAME);
                    MeasureSet ms = MeasureSet.create();
                    ms.addMeasure(MEASURE_COST_TIME);
                    ms.addMeasure(MEASURE_INVOKE_TIME);
                    ms.addMeasure(MEASURE_DATA_SIZE);
                    AppMonitor.register((String)IPCMonitor.MODULE_NAME, (String)MONITOR_POINT, (MeasureSet)ms, (DimensionSet)ds, (boolean)true);
                    isRegistered = true;
                }
                catch (Exception e) {
                    IPCLog.e(IPCMonitor.TAG, "[register][AppMonitor register]", e, new Object[0]);
                }
                return isRegistered;
            }
        }

        public void commit() {
            if (!isAppMonitorValid) {
                return;
            }
            IPCThreadCaller.post(false, new Runnable(){

                @Override
                public void run() {
                    if (!this.register()) {
                        return;
                    }
                    IPCLog.i(IPCMonitor.TAG, "[commit]", "IpcState", this.toString());
                    try {
                        DimensionValueSet dvs = DimensionValueSet.create();
                        dvs.setValue(IpcState.DIMENSION_TYPE, String.valueOf(type));
                        dvs.setValue(IpcState.DIMENSION_DEGRADE, String.valueOf(degrade));
                        dvs.setValue(IpcState.DIMENSION_RESULT, String.valueOf(result));
                        dvs.setValue(IpcState.DIMENSION_SERVICE_NAME, serviceName);
                        dvs.setValue(IpcState.DIMENSION_METHOD_NAME, methodName);
                        MeasureValueSet mvs = MeasureValueSet.create();
                        mvs.setValue(IpcState.MEASURE_COST_TIME, (double)costTime);
                        mvs.setValue(IpcState.MEASURE_INVOKE_TIME, (double)invokeTime);
                        mvs.setValue(IpcState.MEASURE_DATA_SIZE, (double)dataSize);
                        AppMonitor.Stat.commit((String)IPCMonitor.MODULE_NAME, (String)IpcState.MONITOR_POINT, (DimensionValueSet)dvs, (MeasureValueSet)mvs);
                    }
                    catch (Exception e) {
                        IPCLog.e(IPCMonitor.TAG, "[commit][AppMonitor Stat commit]", e, new Object[0]);
                    }
                }
            });
        }

        public String toString() {
            return "IpcState{serviceName='" + this.serviceName + '\'' + ", methodName='" + this.methodName + '\'' + ", type=" + this.type + ", result=" + this.result + ", degrade=" + this.degrade + ", costTime=" + this.costTime + ", invokeTime=" + this.invokeTime + ", dataSize=" + this.dataSize + '}';
        }
    }
}

