/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.util.Pair;
import com.taobao.aranger.ARanger;
import com.taobao.aranger.intf.ProcessStateListener;
import com.taobao.aranger.logs.IPCLog;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class CallbackManager {
    private static final String TAG = CallbackManager.class.getSimpleName();
    private static volatile CallbackManager sInstance = null;
    private final ConcurrentHashMap<String, CallbackWrapper> mCallbackWrapperMap;
    private final CopyOnWriteArrayList<ProcessStateListener> mProcessStateListeners;
    private final BroadcastReceiver processStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String processName = intent.getStringExtra("processName");
            if ("com.taobao.aranger.DISCONNECT".equals(intent.getAction())) {
                for (ProcessStateListener processStateListener : CallbackManager.this.mProcessStateListeners) {
                    try {
                        processStateListener.onProcessStop(processName);
                    }
                    catch (Throwable e) {
                        IPCLog.e(TAG, "[onReceive][onProcessStop]", e, new Object[0]);
                    }
                }
            } else {
                for (ProcessStateListener processStateListener : CallbackManager.this.mProcessStateListeners) {
                    try {
                        processStateListener.onProcessStart(processName);
                    }
                    catch (Throwable e) {
                        IPCLog.e(TAG, "[onReceive][onProcessStart]", e, new Object[0]);
                    }
                }
            }
        }
    };
    private final IntentFilter intentFilter = new IntentFilter();

    private CallbackManager() {
        this.mCallbackWrapperMap = new ConcurrentHashMap();
        this.mProcessStateListeners = new CopyOnWriteArrayList();
        this.intentFilter.addAction("com.taobao.aranger.CONNECT");
        this.intentFilter.addAction("com.taobao.aranger.DISCONNECT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CallbackManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<CallbackManager> clazz = CallbackManager.class;
        synchronized (CallbackManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new CallbackManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    void addCallback(String key, Object callback, boolean isWeakRef, boolean uiThread) {
        this.mCallbackWrapperMap.putIfAbsent(key, new CallbackWrapper(isWeakRef, callback, uiThread));
    }

    public Pair<Boolean, Object> getCallback(String key) {
        CallbackWrapper callbackWrapper = this.mCallbackWrapperMap.get(key);
        if (callbackWrapper == null) {
            return null;
        }
        Pair<Boolean, Object> pair = callbackWrapper.get();
        if (pair.second == null) {
            this.mCallbackWrapperMap.remove(key);
        }
        return pair;
    }

    public void removeCallback(String key) {
        this.mCallbackWrapperMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProcessStateListener(ProcessStateListener processStateListener) {
        CopyOnWriteArrayList<ProcessStateListener> copyOnWriteArrayList = this.mProcessStateListeners;
        synchronized (copyOnWriteArrayList) {
            if (this.mProcessStateListeners.isEmpty()) {
                ARanger.getContext().registerReceiver(this.processStateReceiver, this.intentFilter);
            }
            this.mProcessStateListeners.add(processStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterProcessStateListener(ProcessStateListener processStateListener) {
        CopyOnWriteArrayList<ProcessStateListener> copyOnWriteArrayList = this.mProcessStateListeners;
        synchronized (copyOnWriteArrayList) {
            this.mProcessStateListeners.remove(processStateListener);
            if (this.mProcessStateListeners.isEmpty()) {
                ARanger.getContext().unregisterReceiver(this.processStateReceiver);
            }
        }
    }

    private static class CallbackWrapper {
        private final Object mCallback;
        private final boolean mUiThread;

        CallbackWrapper(boolean isWeakRef, Object callback, boolean uiThread) {
            this.mCallback = isWeakRef ? new WeakReference<Object>(callback) : callback;
            this.mUiThread = uiThread;
        }

        Pair<Boolean, Object> get() {
            Object callback = this.mCallback instanceof WeakReference ? ((WeakReference)this.mCallback).get() : this.mCallback;
            return new Pair((Object)this.mUiThread, callback);
        }
    }
}

