/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.utils;

import android.net.Uri;
import android.os.IBinder;
import com.taobao.aranger.core.ipc.ChannelManager;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.logs.IPCLog;
import com.taobao.aranger.utils.IPCThreadCaller;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class IPCRecycle {
    private static final String TAG = IPCRecycle.class.getSimpleName();
    private static volatile IPCRecycle sInstance = null;
    private final ReferenceQueue<Object> mReferenceQueue = new ReferenceQueue();
    private final ConcurrentHashMap<PhantomReference<Object>, String> mKeyMap = new ConcurrentHashMap();

    private IPCRecycle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPCRecycle getInstance() {
        if (sInstance != null) return sInstance;
        Class<IPCRecycle> clazz = IPCRecycle.class;
        synchronized (IPCRecycle.class) {
            if (sInstance != null) return sInstance;
            sInstance = new IPCRecycle();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycle(Object target) {
        ArrayList<String> keys = new ArrayList<String>();
        ReferenceQueue<Object> referenceQueue = this.mReferenceQueue;
        synchronized (referenceQueue) {
            PhantomReference reference;
            while ((reference = (PhantomReference)this.mReferenceQueue.poll()) != null) {
                String key = this.mKeyMap.remove(reference);
                if (key == null) continue;
                keys.add(key);
            }
        }
        if (!keys.isEmpty()) {
            try {
                if (target instanceof IBinder) {
                    ChannelManager.getClientChannel((IBinder)target).recycleClient(keys);
                } else if (target instanceof Uri) {
                    ChannelManager.getRemoteChannel((Uri)target).recycleRemote(keys);
                }
            }
            catch (IPCException e) {
                IPCLog.e(TAG, "[recycle][recycleClient]", e, new Object[0]);
            }
        }
    }

    public void register(final Object target, Object object, String key) {
        this.mKeyMap.put(new PhantomReference<Object>(object, this.mReferenceQueue), key);
        IPCThreadCaller.post(false, new Runnable(){

            @Override
            public void run() {
                IPCRecycle.this.recycle(target);
            }
        });
    }
}

