/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class IPCThreadCaller {
    private static final String TAG = IPCThreadCaller.class.getName();
    private static final int CORE_POOL_SIZE = 3;
    private static volatile IPCThreadCaller sInstance;
    private final Handler mHandler;
    private final Handler mUiHandler;
    private final ExecutorService mExecutorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IPCThreadCaller getImpl() {
        if (sInstance != null) return sInstance;
        Class<IPCThreadCaller> clazz = IPCThreadCaller.class;
        synchronized (IPCThreadCaller.class) {
            if (sInstance != null) return sInstance;
            sInstance = new IPCThreadCaller();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private IPCThreadCaller() {
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.mUiHandler = new Handler(Looper.getMainLooper());
        this.mExecutorService = new ThreadPoolExecutor(3, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new IPCThreadFactory());
    }

    public static void post(boolean runOnUiThread, Runnable r) {
        if (runOnUiThread) {
            IPCThreadCaller.getImpl().mUiHandler.post(r);
        } else {
            IPCThreadCaller.getImpl().mHandler.post(r);
        }
    }

    public static void execute(Runnable r) {
        if (r != null) {
            IPCThreadCaller.getImpl().mExecutorService.execute(r);
        }
    }

    private static class IPCThreadFactory
    implements ThreadFactory {
        private final AtomicInteger mCount = new AtomicInteger();

        private IPCThreadFactory() {
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            return new Thread(r, "ARanger  Thread:" + this.mCount.getAndIncrement());
        }
    }
}

