/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.utils;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import com.taobao.aranger.ARanger;
import com.taobao.aranger.exception.IPCException;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class IPCUtils {
    private static Set<String> providerInfoSet = new CopyOnWriteArraySet<String>();
    private static List<ProviderInfo> providerInfoList = new CopyOnWriteArrayList<ProviderInfo>();
    private static String sCurrentProcessName;

    public static String getProcessNameFromUri(Uri uri) {
        for (ProviderInfo providerInfo : providerInfoList) {
            if (!IPCUtils.getContentAuthorities(providerInfo.authority).equals((Object)uri)) continue;
            return providerInfo.processName;
        }
        return null;
    }

    public static int getUserIdFromAuthority(String auth, int defaultUserId) {
        if (auth == null) {
            return defaultUserId;
        }
        int end = auth.lastIndexOf(64);
        if (end == -1) {
            return defaultUserId;
        }
        String userIdString = auth.substring(0, end);
        try {
            return Integer.parseInt(userIdString);
        }
        catch (NumberFormatException e) {
            return -10000;
        }
    }

    public static String getAuthorityWithoutUserId(String auth) {
        if (auth == null) {
            return null;
        }
        int end = auth.lastIndexOf(64);
        return auth.substring(end + 1);
    }

    private static Uri getContentAuthorities(String uri) {
        return Uri.parse((String)("content://" + uri));
    }

    public static Uri queryContentAuthorityFromProvider(ComponentName providerComponentName) throws IPCException {
        try {
            if (!providerInfoSet.contains(providerComponentName.getPackageName())) {
                providerInfoSet.add(providerComponentName.getPackageName());
                Collections.addAll(providerInfoList, ARanger.getContext().getPackageManager().getPackageInfo((String)providerComponentName.getPackageName(), (int)8).providers);
            }
            for (ProviderInfo providerInfo : providerInfoList) {
                if (!providerInfo.name.equals(providerComponentName.getClassName())) continue;
                return IPCUtils.getContentAuthorities(providerInfo.authority);
            }
        }
        catch (Exception e) {
            throw new IPCException(30, (Throwable)e);
        }
        throw new IPCException(29, "can't find authorities in the " + providerComponentName.getClass() + ", please check the provider is correct.");
    }

    public static boolean isProcessAlive(ComponentName providerComponentName) {
        String processName = "";
        try {
            if (!providerInfoSet.contains(providerComponentName.getPackageName())) {
                providerInfoSet.add(providerComponentName.getPackageName());
                Collections.addAll(providerInfoList, ARanger.getContext().getPackageManager().getPackageInfo((String)providerComponentName.getPackageName(), (int)8).providers);
            }
            for (ProviderInfo providerInfo : providerInfoList) {
                if (!providerInfo.name.equals(providerComponentName.getClassName())) continue;
                processName = providerInfo.processName;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)processName)) {
            return false;
        }
        ActivityManager am = (ActivityManager)ARanger.getContext().getSystemService("activity");
        List runningApps = am.getRunningAppProcesses();
        if (runningApps == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo processInfo : runningApps) {
            if (!processInfo.processName.equals(processName)) continue;
            return true;
        }
        return false;
    }

    public static String getCurrentProcessName() {
        if (sCurrentProcessName == null || sCurrentProcessName.length() == 0) {
            sCurrentProcessName = IPCUtils.getProcessName(Process.myPid());
        }
        return sCurrentProcessName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessName(int pid) {
        List list;
        ActivityManager mActivityManager = (ActivityManager)ARanger.getContext().getSystemService("activity");
        if (mActivityManager != null && (list = mActivityManager.getRunningAppProcesses()) != null && !list.isEmpty()) {
            for (ActivityManager.RunningAppProcessInfo appProcess : list) {
                if (appProcess == null || appProcess.pid != pid) continue;
                return appProcess.processName;
            }
        }
        byte[] b = new byte[128];
        FileInputStream in2 = null;
        try {
            in2 = new FileInputStream("/proc/" + pid + "/cmdline");
            int len = in2.read(b);
            if (len <= 0) {
                String string = null;
                return string;
            }
            for (int i = 0; i < len; ++i) {
                if (b[i] > 0) {
                    continue;
                }
                len = i;
                break;
            }
            String e = new String(b, 0, len);
            return e;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (in2 != null) {
                    in2.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

