/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.utils;

import android.content.Context;
import android.os.IBinder;
import com.taobao.aranger.ARanger;
import com.taobao.aranger.annotation.method.UIThread;
import com.taobao.aranger.annotation.parameter.WeakRef;
import com.taobao.aranger.annotation.parameter.inout;
import com.taobao.aranger.annotation.parameter.out;
import com.taobao.aranger.annotation.type.Callback;
import com.taobao.aranger.core.handler.invoc.CallbackInvocationHandler;
import com.taobao.aranger.core.ipc.provider.ClientServiceProvider;
import com.taobao.aranger.core.wrapper.ParameterWrapper;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.utils.CallbackManager;
import com.taobao.aranger.utils.IPCRecycle;
import com.taobao.aranger.utils.TimeStampGenerator;
import com.taobao.aranger.utils.TypeCenter;
import com.taobao.aranger.utils.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;

public class ParameterTransformer {
    public static ParameterWrapper[] wrapperParameters(Method method, Object[] parameters) {
        if (parameters == null) {
            return new ParameterWrapper[0];
        }
        ParameterWrapper[] parameterWrappers = new ParameterWrapper[parameters.length];
        Class<?>[] classes = method == null ? new Class[parameters.length] : method.getParameterTypes();
        Annotation[][] parameterAnnotations = method == null ? new Annotation[parameters.length][0] : method.getParameterAnnotations();
        Annotation[] methodAnnotations = method == null ? new Annotation[]{} : method.getAnnotations();
        for (int i = 0; i < parameters.length; ++i) {
            if (classes[i] != null && classes[i].isInterface() && classes[i].getAnnotation(Callback.class) != null) {
                Object parameter = parameters[i];
                String timeStamp = TimeStampGenerator.getTimeStamp();
                parameterWrappers[i] = parameter != null ? ParameterWrapper.obtain().setParameterName(classes[i].getName()).setClientServiceBinder((IBinder)ClientServiceProvider.getClientService()).setTimeStamp(timeStamp + ";" + parameter.hashCode()) : ParameterWrapper.obtain();
                if (parameterAnnotations[i] == null || parameter == null) continue;
                CallbackManager.getInstance().addCallback(timeStamp, parameter, TypeUtils.arrayContainsAnnotation(parameterAnnotations[i], WeakRef.class), TypeUtils.arrayContainsAnnotation(methodAnnotations, UIThread.class));
                continue;
            }
            if (parameters[i] instanceof Context) {
                parameterWrappers[i] = ParameterWrapper.obtain().setParameterName(Context.class.getName());
                continue;
            }
            boolean isOut = TypeUtils.arrayContainsAnnotation(parameterAnnotations[i], out.class);
            boolean isInOut = TypeUtils.arrayContainsAnnotation(parameterAnnotations[i], inout.class);
            if (isOut || isInOut) {
                if (isInOut) {
                    parameterWrappers[i] = ParameterWrapper.obtain().setFlowFlag(2).setData(parameters[i]);
                    continue;
                }
                parameterWrappers[i] = ParameterWrapper.obtain().setFlowFlag(1).setData(parameters[i]);
                continue;
            }
            parameterWrappers[i] = ParameterWrapper.obtain().setData(parameters[i]);
        }
        return parameterWrappers;
    }

    public static Object[] unWrapperParameters(ParameterWrapper[] parameterWrappers, List<Integer> flowFlagIndexList) throws IPCException {
        if (parameterWrappers == null) {
            return new Object[0];
        }
        int length = parameterWrappers.length;
        Object[] parameters = new Object[length];
        for (int i = 0; i < length; ++i) {
            ParameterWrapper parameterWrapper = parameterWrappers[i];
            if (parameterWrapper == null) {
                parameters[i] = null;
                continue;
            }
            Class<?> clazz = TypeCenter.getInstance().getClassType(parameterWrapper);
            if (clazz != null && clazz.isInterface() && clazz.getAnnotation(Callback.class) != null) {
                String[] stringStamp = parameterWrapper.getTimeStamp().split(";");
                String timeStamp = stringStamp[0];
                int hashcode = Integer.parseInt(stringStamp[1]);
                parameters[i] = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new CallbackInvocationHandler(parameterWrapper.getClientServiceBinder(), timeStamp, hashcode));
                IPCRecycle.getInstance().register(parameterWrapper.getClientServiceBinder(), parameters[i], timeStamp);
                continue;
            }
            if (clazz != null && Context.class.isAssignableFrom(clazz)) {
                parameters[i] = ARanger.getContext();
                continue;
            }
            if (parameterWrapper.getFlowFlag() != 0) {
                flowFlagIndexList.add(i);
            }
            parameters[i] = clazz == null ? null : parameterWrapper.getData();
        }
        return parameters;
    }
}

