/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.utils;

import android.os.BadParcelableException;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.text.TextUtils;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseArray;
import com.taobao.aranger.ARanger;
import com.taobao.aranger.core.wrapper.ParameterWrapper;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.utils.SharedMemory;
import com.taobao.aranger.utils.TypeCenter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SerializeUtils {
    private static final HashMap<String, Parcelable.Creator<?>> sCreatorMap = new HashMap();

    private SerializeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    private static byte[] encode(Object object) {
        Parcel parcel = Parcel.obtain();
        SerializeUtils.writeToParcel(parcel, object);
        byte[] result = parcel.marshall();
        parcel.recycle();
        return result;
    }

    private static Object decode(byte[] data) {
        if (data != null) {
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(data, 0, data.length);
            parcel.setDataPosition(0);
            Object result = SerializeUtils.readFromParcel(parcel);
            parcel.recycle();
            return result;
        }
        return null;
    }

    public static long writeToParcel(Parcel parcel, Object data, int flags, boolean compress) {
        int position = parcel.dataPosition();
        parcel.writeInt(0);
        SerializeUtils.writeToParcel(parcel, data);
        long dataSize = parcel.dataSize();
        if (compress && dataSize > 204800L) {
            parcel.setDataSize(position);
            parcel.setDataPosition(position);
            parcel.writeInt(1);
            parcel.writeParcelable(SharedMemory.getFileDescriptorFromData(SerializeUtils.encode(data)), flags);
        }
        return dataSize;
    }

    public static Object readFromParcel(ClassLoader classLoader, Parcel parcel) {
        int flag = parcel.readInt();
        if (flag == 0) {
            return SerializeUtils.readFromParcel(parcel);
        }
        return SerializeUtils.decode(SharedMemory.getDataFromFileDescriptor(parcel.readParcelable(classLoader)));
    }

    private static void writeToParcel(Parcel parcel, Object data) {
        if (data instanceof ParameterWrapper) {
            parcel.writeInt(29);
            ((ParameterWrapper)data).writeToParcel(parcel, 0);
        } else if (data instanceof ParameterWrapper[]) {
            ParameterWrapper[] parameterWrappers = (ParameterWrapper[])data;
            parcel.writeInt(30);
            parcel.writeInt(parameterWrappers.length);
            for (ParameterWrapper parameterWrapper : parameterWrappers) {
                parameterWrapper.writeToParcel(parcel, 0);
            }
        } else if (data == null) {
            parcel.writeInt(-1);
        } else if (data instanceof String) {
            parcel.writeInt(0);
            parcel.writeString((String)data);
        } else if (data instanceof Integer) {
            parcel.writeInt(1);
            parcel.writeInt(((Integer)data).intValue());
        } else if (data instanceof Map) {
            parcel.writeInt(2);
            parcel.writeMap((Map)data);
        } else if (data instanceof Bundle) {
            parcel.writeInt(3);
            parcel.writeBundle((Bundle)data);
        } else if (data instanceof Parcelable) {
            parcel.writeInt(4);
            parcel.writeParcelable((Parcelable)data, 0);
        } else if (data instanceof Short) {
            parcel.writeInt(5);
            parcel.writeInt(((Short)data).intValue());
        } else if (data instanceof Long) {
            parcel.writeInt(6);
            parcel.writeLong(((Long)data).longValue());
        } else if (data instanceof Float) {
            parcel.writeInt(7);
            parcel.writeFloat(((Float)data).floatValue());
        } else if (data instanceof Double) {
            parcel.writeInt(8);
            parcel.writeDouble(((Double)data).doubleValue());
        } else if (data instanceof Boolean) {
            parcel.writeInt(9);
            parcel.writeInt((Boolean)data != false ? 1 : 0);
        } else if (data instanceof CharSequence) {
            parcel.writeInt(10);
            TextUtils.writeToParcel((CharSequence)((CharSequence)data), (Parcel)parcel, (int)0);
        } else if (data instanceof List) {
            parcel.writeInt(11);
            parcel.writeList((List)data);
        } else if (data instanceof SparseArray) {
            parcel.writeInt(12);
            parcel.writeSparseArray((SparseArray)data);
        } else if (data instanceof boolean[]) {
            parcel.writeInt(23);
            parcel.writeBooleanArray((boolean[])data);
        } else if (data instanceof byte[]) {
            parcel.writeInt(13);
            parcel.writeByteArray((byte[])data);
        } else if (data instanceof String[]) {
            parcel.writeInt(14);
            parcel.writeStringArray((String[])data);
        } else if (data instanceof CharSequence[]) {
            parcel.writeInt(24);
        } else if (data instanceof IBinder) {
            parcel.writeInt(15);
            parcel.writeStrongBinder((IBinder)data);
        } else if (data instanceof Parcelable[]) {
            parcel.writeInt(16);
            parcel.writeString(data.getClass().getComponentType().getName());
            Parcelable[] parcelableArray = (Parcelable[])data;
            parcel.writeInt(parcelableArray.length);
            for (Parcelable parcelable : parcelableArray) {
                parcelable.writeToParcel(parcel, 0);
            }
        } else if (data instanceof int[]) {
            parcel.writeInt(18);
            parcel.writeIntArray((int[])data);
        } else if (data instanceof long[]) {
            parcel.writeInt(19);
            parcel.writeLongArray((long[])data);
        } else if (data instanceof Byte) {
            parcel.writeInt(20);
            parcel.writeInt((int)((Byte)data).byteValue());
        } else if (data instanceof double[]) {
            parcel.writeInt(28);
            parcel.writeDoubleArray((double[])data);
        } else {
            Class<?> clazz = data.getClass();
            if (clazz.isArray() && clazz.getComponentType() == Object.class) {
                parcel.writeInt(17);
                SerializeUtils.writeArray(parcel, (Object[])data);
            } else if (data instanceof Serializable) {
                parcel.writeInt(21);
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    ObjectOutputStream out2 = new ObjectOutputStream(outputStream);
                    out2.writeObject(data);
                    parcel.writeByteArray(outputStream.toByteArray());
                }
                catch (IOException e) {
                    throw new RuntimeException("Parcelable encountered IOException writing serializable object");
                }
            } else {
                throw new RuntimeException("Parcel: unable to marshal value " + data);
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            if (data instanceof Size) {
                parcel.writeInt(26);
                parcel.writeSize((Size)data);
            } else if (data instanceof SizeF) {
                parcel.writeInt(27);
                parcel.writeSizeF((SizeF)data);
            } else if (data instanceof PersistableBundle) {
                parcel.writeInt(25);
                parcel.writePersistableBundle((PersistableBundle)data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readFromParcel(Parcel parcel) {
        int type = parcel.readInt();
        switch (type) {
            case 29: {
                return ParameterWrapper.CREATOR.createFromParcel(parcel);
            }
            case 30: {
                ParameterWrapper[] parameterWrappers = new ParameterWrapper[parcel.readInt()];
                for (int i = 0; i < parameterWrappers.length; ++i) {
                    parameterWrappers[i] = (ParameterWrapper)ParameterWrapper.CREATOR.createFromParcel(parcel);
                }
                return parameterWrappers;
            }
            case -1: {
                return null;
            }
            case 0: {
                return parcel.readString();
            }
            case 1: {
                return parcel.readInt();
            }
            case 2: {
                return parcel.readHashMap(ARanger.class.getClassLoader());
            }
            case 4: {
                return parcel.readParcelable(ARanger.class.getClassLoader());
            }
            case 5: {
                return (short)parcel.readInt();
            }
            case 6: {
                return parcel.readLong();
            }
            case 7: {
                return Float.valueOf(parcel.readFloat());
            }
            case 8: {
                return parcel.readDouble();
            }
            case 9: {
                return parcel.readInt() == 1;
            }
            case 10: {
                return TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            }
            case 11: {
                return parcel.readArrayList(ARanger.class.getClassLoader());
            }
            case 23: {
                return parcel.createBooleanArray();
            }
            case 13: {
                return parcel.createByteArray();
            }
            case 14: {
                return parcel.createStringArray();
            }
            case 24: {
                CharSequence[] array = null;
                int length = parcel.readInt();
                if (length >= 0) {
                    array = new CharSequence[length];
                    for (int i = 0; i < length; ++i) {
                        array[i] = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
                    }
                }
                return array;
            }
            case 15: {
                return parcel.readStrongBinder();
            }
            case 17: {
                return SerializeUtils.readArray(parcel);
            }
            case 18: {
                return parcel.createIntArray();
            }
            case 19: {
                return parcel.createLongArray();
            }
            case 20: {
                return parcel.readByte();
            }
            case 21: {
                try {
                    ByteArrayInputStream byteInputStream = new ByteArrayInputStream(parcel.createByteArray());
                    ObjectInputStream in2 = new ObjectInputStream(byteInputStream){

                        @Override
                        protected Class<?> resolveClass(ObjectStreamClass osClass) throws IOException, ClassNotFoundException {
                            Class<?> c = Class.forName(osClass.getName(), false, ARanger.class.getClassLoader());
                            if (c != null) {
                                return c;
                            }
                            return super.resolveClass(osClass);
                        }
                    };
                    return in2.readObject();
                }
                catch (IOException e) {
                    throw new RuntimeException("Parcelable encountered IOException reading a Serializable object)");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Parcelable encountered ClassNotFoundException reading a Serializable object)");
                }
            }
            case 16: {
                Parcelable.Creator creator;
                Class<?> clazz;
                String componentTypeName = parcel.readString();
                int length = parcel.readInt();
                try {
                    clazz = TypeCenter.getInstance().getClassType(componentTypeName);
                }
                catch (IPCException e) {
                    throw new RuntimeException(e);
                }
                HashMap<String, Parcelable.Creator<?>> hashMap = sCreatorMap;
                synchronized (hashMap) {
                    creator = sCreatorMap.get(clazz.getName());
                    if (creator == null) {
                        try {
                            Field f = clazz.getField("CREATOR");
                            creator = (Parcelable.Creator)f.get(null);
                        }
                        catch (IllegalAccessException e) {
                            throw new BadParcelableException("IllegalAccessException when unmarshalling: " + clazz.getName());
                        }
                        catch (NoSuchFieldException e) {
                            throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + clazz.getName());
                        }
                        if (creator == null) {
                            throw new BadParcelableException("Parcelable protocol requires a non-null Parcelable.Creator object called CREATOR on class " + clazz.getName());
                        }
                        sCreatorMap.put(clazz.getName(), creator);
                    }
                }
                Object[] parcelableArray = creator.newArray(length);
                for (int i = 0; i < length; ++i) {
                    parcelableArray[i] = creator.createFromParcel(parcel);
                }
                return parcelableArray;
            }
            case 12: {
                return parcel.readSparseArray(ARanger.class.getClassLoader());
            }
            case 22: {
                return parcel.readSparseBooleanArray();
            }
            case 3: {
                return parcel.readBundle(ARanger.class.getClassLoader());
            }
            case 28: {
                return parcel.createDoubleArray();
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            switch (type) {
                case 25: {
                    return parcel.readPersistableBundle(ARanger.class.getClassLoader());
                }
                case 26: {
                    return parcel.readSize();
                }
                case 27: {
                    return parcel.readSizeF();
                }
            }
        }
        int off = parcel.dataPosition() - 4;
        throw new RuntimeException("Parcel " + parcel + ": Unmarshalling unknown type code " + type + " at offset " + off);
    }

    private static void writeArray(Parcel parcel, Object[] val) {
        if (val == null) {
            parcel.writeInt(-1);
            return;
        }
        int N = val.length;
        parcel.writeInt(N);
        for (int i = 0; i < N; ++i) {
            SerializeUtils.writeToParcel(parcel, val[i]);
        }
    }

    private static Object[] readArray(Parcel parcel) {
        int N = parcel.readInt();
        if (N < 0) {
            return null;
        }
        Object[] objects = new Object[N];
        for (int i = 0; i < N; ++i) {
            Object value;
            objects[i] = value = SerializeUtils.readFromParcel(parcel);
        }
        return objects;
    }
}

