/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.utils;

import android.os.Build;
import android.os.MemoryFile;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.taobao.aranger.utils.ReflectUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;

class SharedMemory {
    private static Method sGetFileDescriptorMethod;

    SharedMemory() {
    }

    static Parcelable getFileDescriptorFromData(byte[] data) {
        try {
            String name = UUID.randomUUID().toString();
            if (Build.VERSION.SDK_INT <= 26) {
                if (sGetFileDescriptorMethod == null) {
                    sGetFileDescriptorMethod = ReflectUtils.getHideMethod(MemoryFile.class, "getFileDescriptor", new Class[0]);
                }
                MemoryFile memoryFile = new MemoryFile(name, data.length);
                memoryFile.writeBytes(data, 0, 0, data.length);
                return ParcelFileDescriptor.dup((FileDescriptor)((FileDescriptor)sGetFileDescriptorMethod.invoke((Object)memoryFile, new Object[0])));
            }
            if (sGetFileDescriptorMethod == null) {
                sGetFileDescriptorMethod = ReflectUtils.getHideMethod(android.os.SharedMemory.class, "getFileDescriptor", new Class[0]);
            }
            android.os.SharedMemory sharedMemory = android.os.SharedMemory.create((String)name, (int)data.length);
            ByteBuffer byteBuffer = sharedMemory.mapReadWrite();
            byteBuffer.put(data, 0, data.length);
            return ParcelFileDescriptor.dup((FileDescriptor)((FileDescriptor)sGetFileDescriptorMethod.invoke((Object)sharedMemory, new Object[0])));
        }
        catch (Exception e) {
            throw new RuntimeException("big data encode error", e);
        }
    }

    static byte[] getDataFromFileDescriptor(Parcelable parcelable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)parcelable;
            FileInputStream fis = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            FileChannel inChannel = fis.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(1024);
            while (inChannel.read(buf) != -1) {
                byteArrayOutputStream.write(buf.array());
                buf.clear();
            }
            byte[] data = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            fis.close();
            parcelFileDescriptor.close();
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException("big data decode error", e);
        }
    }
}

