/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.utils;

import android.text.TextUtils;
import com.taobao.aranger.core.wrapper.BaseWrapper;
import com.taobao.aranger.core.wrapper.MethodWrapper;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.utils.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class TypeCenter {
    private static volatile TypeCenter sInstance = null;
    private final ConcurrentHashMap<String, Class<?>> mRawClassMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Method>> mRawMethodMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Constructor<?>> mRawConstructorMap = new ConcurrentHashMap();

    private TypeCenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCenter getInstance() {
        if (sInstance != null) return sInstance;
        Class<TypeCenter> clazz = TypeCenter.class;
        synchronized (TypeCenter.class) {
            if (sInstance != null) return sInstance;
            sInstance = new TypeCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public Method getMethod(Class<?> clazz, MethodWrapper methodWrapper) throws IPCException {
        String methodId = TypeUtils.getMethodId(methodWrapper.getName(), methodWrapper.getParameterTypes());
        ConcurrentHashMap<String, Method> methods = this.mRawMethodMap.get(clazz.getName());
        methods = methods == null ? new ConcurrentHashMap() : this.mRawMethodMap.get(clazz.getName());
        Method method = methods.get(methodId);
        if (method != null) {
            return method;
        }
        int pos = methodId.indexOf(40);
        method = TypeUtils.getMethod(clazz, methodId.substring(0, pos), this.getClassTypes(methodWrapper.getParameterTypes()), this.getClassType(methodWrapper.getReturnType()));
        if (method == null) {
            throw new IPCException(12, "Method not found: " + methodId + " in class " + clazz.getName());
        }
        methods.putIfAbsent(methodId, method);
        this.mRawMethodMap.putIfAbsent(clazz.getName(), methods);
        return method;
    }

    public Class<?> getClassType(String className) throws IPCException {
        Class<Object> clazz = this.mRawClassMap.get(className);
        if (clazz != null) {
            return clazz;
        }
        switch (className) {
            case "boolean": {
                clazz = Boolean.TYPE;
                break;
            }
            case "byte": {
                clazz = Byte.TYPE;
                break;
            }
            case "char": {
                clazz = Character.TYPE;
                break;
            }
            case "short": {
                clazz = Short.TYPE;
                break;
            }
            case "int": {
                clazz = Integer.TYPE;
                break;
            }
            case "long": {
                clazz = Long.TYPE;
                break;
            }
            case "float": {
                clazz = Float.TYPE;
                break;
            }
            case "double": {
                clazz = Double.TYPE;
                break;
            }
            case "void": {
                clazz = Void.TYPE;
                break;
            }
            default: {
                try {
                    clazz = Class.forName(className);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new IPCException(21, (Throwable)e);
                }
            }
        }
        this.mRawClassMap.putIfAbsent(className, clazz);
        return clazz;
    }

    public Class<?> getClassType(BaseWrapper wrapper) throws IPCException {
        String name = wrapper.getName();
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        return this.getClassType(name);
    }

    private Class<?>[] getClassTypes(String[] wrappers) throws IPCException {
        if (wrappers == null) {
            return new Class[0];
        }
        Class[] classes = new Class[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            classes[i] = this.getClassType(wrappers[i]);
        }
        return classes;
    }

    void registerConstructor(String constructorId, Constructor constructor) {
        this.mRawConstructorMap.putIfAbsent(constructorId, constructor);
    }

    Constructor getConstructor(String constructorId) {
        return this.mRawConstructorMap.containsKey(constructorId) ? this.mRawConstructorMap.get(constructorId) : null;
    }
}

