/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.utils;

import android.content.ComponentName;
import android.text.TextUtils;
import com.taobao.aranger.ARanger;
import com.taobao.aranger.annotation.type.ServiceName;
import com.taobao.aranger.core.ipc.provider.ARangerProvider;
import com.taobao.aranger.core.wrapper.ParameterWrapper;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.utils.TypeCenter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public final class TypeUtils {
    private TypeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String getClassId(Class<?> clazz) {
        return clazz.getName();
    }

    public static String getMethodId(String methodName, ParameterWrapper[] parameterWrappers) {
        return methodName + '(' + TypeUtils.getMethodParameters(parameterWrappers) + ')';
    }

    public static String getMethodId(String methodName, String[] parameterTypes) {
        return methodName + '(' + TypeUtils.getMethodParameters(parameterTypes) + ')';
    }

    public static String[] convertParameterTypes(ParameterWrapper[] parameterWrappers) throws IPCException {
        if (parameterWrappers == null) {
            return new String[0];
        }
        int length = parameterWrappers.length;
        String[] parameterTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            ParameterWrapper parameterWrapper = parameterWrappers[i];
            parameterTypes[i] = parameterWrapper == null ? null : TypeUtils.getClassId(parameterWrapper.getClassType());
        }
        return parameterTypes;
    }

    public static String[] convertParameterTypes(Class[] parameterClasses) {
        if (parameterClasses == null) {
            return new String[0];
        }
        int length = parameterClasses.length;
        String[] parameterTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            Class parameterClass = parameterClasses[i];
            parameterTypes[i] = parameterClass == null ? null : TypeUtils.getClassId(parameterClass);
        }
        return parameterTypes;
    }

    private static String getConstructorId(Class clazz, Class[] parameterClasses) {
        return clazz.getSimpleName() + '(' + TypeUtils.getMethodParameters(parameterClasses) + ')';
    }

    private static String getMethodParameters(ParameterWrapper[] parameterWrappers) {
        StringBuilder result = new StringBuilder();
        int length = parameterWrappers.length;
        if (length == 0) {
            return result.toString();
        }
        result.append(TypeUtils.basicNameConvert(parameterWrappers[0].getName()));
        for (int i = 1; i < length; ++i) {
            result.append(",").append(TypeUtils.basicNameConvert(parameterWrappers[i].getName()));
        }
        return result.toString();
    }

    private static String getMethodParameters(Class<?>[] classes) {
        StringBuilder result = new StringBuilder();
        int length = classes.length;
        if (length == 0) {
            return result.toString();
        }
        result.append(TypeUtils.basicNameConvert(TypeUtils.getClassId(classes[0])));
        for (int i = 1; i < length; ++i) {
            result.append(",").append(TypeUtils.basicNameConvert(TypeUtils.getClassId(classes[i])));
        }
        return result.toString();
    }

    private static String getMethodParameters(String[] parameterTypes) {
        StringBuilder result = new StringBuilder();
        int length = parameterTypes.length;
        if (length == 0) {
            return result.toString();
        }
        result.append(TypeUtils.basicNameConvert(parameterTypes[0]));
        for (int i = 1; i < length; ++i) {
            result.append(",").append(TypeUtils.basicNameConvert(parameterTypes[i]));
        }
        return result.toString();
    }

    static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterClasses, Class<?> returnClass) throws IPCException {
        Method[] methods;
        Method result = null;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !TypeUtils.classAssignable(method.getParameterTypes(), parameterClasses)) continue;
            if (result == null) {
                result = method;
                continue;
            }
            throw new IPCException(14, "There are more than one method named " + methodName + " of the class " + clazz.getName() + " matching the parameters!");
        }
        if (result == null) {
            return null;
        }
        if (result.getReturnType() != returnClass) {
            throw new IPCException(17, "The method named " + methodName + " of the class " + clazz.getName() + " matches the parameter types but not the return type. The return type is " + result.getReturnType().getName() + " but the required type is " + returnClass.getName() + ". The method in the local interface must exactly " + "match the method in the remote class.");
        }
        return result;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?>[] parameterClasses) throws IPCException {
        Constructor<?>[] constructors;
        String constructorId = TypeUtils.getConstructorId(clazz, parameterClasses);
        Constructor<?> result = TypeCenter.getInstance().getConstructor(constructorId);
        if (result != null) {
            return result;
        }
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (!TypeUtils.classAssignable(constructor.getParameterTypes(), parameterClasses)) continue;
            if (result != null) {
                throw new IPCException(15, "The class " + clazz.getName() + " has too many constructors whose " + " parameter types match the required types.");
            }
            result = constructor;
            TypeCenter.getInstance().registerConstructor(constructorId, result);
        }
        if (result == null) {
            throw new IPCException(16, "The class " + clazz.getName() + " do not have a constructor whose " + " parameter types match the required types.");
        }
        return result;
    }

    public static void validateServiceInterface(Class<?> clazz) throws IPCException {
        if (clazz == null) {
            throw new IPCException(20, "Class object is null.");
        }
        if (!clazz.isInterface()) {
            throw new IPCException(20, "Only interfaces can be passed as the parameters.");
        }
        if (clazz.getAnnotation(ServiceName.class) == null) {
            throw new IPCException(20, "the interfaces must have ServiceName annotation.");
        }
    }

    public static void validateComponentName(ComponentName providerComponentName) throws IPCException {
        if (providerComponentName == null) {
            throw new IPCException(28, "the component name is null!");
        }
        if (TextUtils.isEmpty((CharSequence)providerComponentName.getClassName()) || TextUtils.isEmpty((CharSequence)providerComponentName.getPackageName())) {
            throw new IPCException(28, "the package name or provider class name in component is null!");
        }
        if (ARanger.getContext().getPackageName().equals(providerComponentName.getPackageName())) {
            Class<?> clazz;
            try {
                clazz = Class.forName(providerComponentName.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IPCException(20, "The " + providerComponentName.getClassName() + " class not found, please check the provider class name.");
            }
            if (!ARangerProvider.class.isAssignableFrom(clazz)) {
                throw new IPCException(20, "Only class extends ARangerProvider can be passed as the parameters.");
            }
        }
    }

    public static boolean arrayContainsAnnotation(Annotation[] annotations, Class<? extends Annotation> annotationClass) {
        if (annotations == null || annotationClass == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean primitiveMatch(Class<?> class1, Class<?> class2) {
        if (!class1.isPrimitive() && !class2.isPrimitive()) {
            return false;
        }
        if (class1 == class2) {
            return true;
        }
        if (class1.isPrimitive()) {
            return TypeUtils.primitiveMatch(class2, class1);
        }
        return class1 == Boolean.class && class2 == Boolean.TYPE || class1 == Byte.class && class2 == Byte.TYPE || class1 == Character.class && class2 == Character.TYPE || class1 == Short.class && class2 == Short.TYPE || class1 == Integer.class && class2 == Integer.TYPE || class1 == Long.class && class2 == Long.TYPE || class1 == Float.class && class2 == Float.TYPE || class1 == Double.class && class2 == Double.TYPE || class1 == Void.class && class2 == Void.TYPE;
    }

    private static boolean classAssignable(Class<?>[] classes1, Class<?>[] classes2) {
        if (classes1.length != classes2.length) {
            return false;
        }
        int length = classes2.length;
        for (int i = 0; i < length; ++i) {
            if (classes2[i] == null || TypeUtils.primitiveMatch(classes1[i], classes2[i]) || classes1[i].isAssignableFrom(classes2[i])) continue;
            return false;
        }
        return true;
    }

    public static void convertObjectToArray(String className, Object destData, Object srcData) {
        switch (className) {
            case "[Z": {
                boolean[] booleanOutArray = (boolean[])srcData;
                if (booleanOutArray == null) break;
                boolean[] array = (boolean[])destData;
                System.arraycopy(booleanOutArray, 0, array, 0, array.length);
                break;
            }
            case "[B": {
                byte[] byteOutArray = (byte[])srcData;
                if (byteOutArray == null) break;
                byte[] array = (byte[])destData;
                System.arraycopy(byteOutArray, 0, array, 0, array.length);
                break;
            }
            case "[C": {
                char[] charOutArray = (char[])srcData;
                if (charOutArray == null) break;
                char[] array = (char[])destData;
                System.arraycopy(charOutArray, 0, array, 0, array.length);
                break;
            }
            case "[S": {
                short[] shortOutArray = (short[])srcData;
                if (shortOutArray == null) break;
                short[] array = (short[])destData;
                System.arraycopy(shortOutArray, 0, array, 0, array.length);
                break;
            }
            case "[I": {
                int[] intOutArray = (int[])srcData;
                if (intOutArray == null) break;
                int[] array = (int[])destData;
                System.arraycopy(intOutArray, 0, array, 0, array.length);
                break;
            }
            case "[J": {
                long[] longOutArray = (long[])srcData;
                if (longOutArray == null) break;
                long[] array = (long[])destData;
                System.arraycopy(longOutArray, 0, array, 0, array.length);
                break;
            }
            case "[F": {
                float[] floatOutArray = (float[])srcData;
                if (floatOutArray == null) break;
                float[] array = (float[])destData;
                System.arraycopy(floatOutArray, 0, array, 0, array.length);
                break;
            }
            case "[D": {
                double[] doubleOutArray = (double[])srcData;
                if (doubleOutArray == null) break;
                double[] array = (double[])destData;
                System.arraycopy(doubleOutArray, 0, array, 0, array.length);
                break;
            }
            default: {
                Object[] outArray = (Object[])srcData;
                if (outArray == null) break;
                Object[] array = (Object[])destData;
                System.arraycopy(outArray, 0, array, 0, array.length);
            }
        }
    }

    public static int getObjectArraySize(String className, Object object) {
        switch (className) {
            case "[Z": {
                return ((boolean[])object).length;
            }
            case "[B": {
                return ((byte[])object).length;
            }
            case "[C": {
                return ((char[])object).length;
            }
            case "[S": {
                return ((short[])object).length;
            }
            case "[I": {
                return ((int[])object).length;
            }
            case "[J": {
                return ((long[])object).length;
            }
            case "[F": {
                return ((float[])object).length;
            }
            case "[D": {
                return ((double[])object).length;
            }
        }
        return ((Object[])object).length;
    }

    static String basicNameConvert(String name) {
        switch (name) {
            case "java.lang.Integer": {
                return "int";
            }
            case "java.lang.Boolean": {
                return "boolean";
            }
            case "java.lang.Long": {
                return "long";
            }
            case "java.lang.Double": {
                return "double";
            }
            case "java.lang.Short": {
                return "short";
            }
            case "java.lang.Float": {
                return "float";
            }
            case "java.lang.Byte": {
                return "byte";
            }
            case "java.lang.Character": {
                return "char";
            }
        }
        return name;
    }
}

