/*
 * Decompiled with CFR 0.152.
 */
package org.android.spdy;

import android.content.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.android.spdy.AccsSSLCallback;
import org.android.spdy.SessionCb;
import org.android.spdy.SessionInfo;
import org.android.spdy.SoInstallMgrSdk;
import org.android.spdy.SpdyByteArray;
import org.android.spdy.SpdyDataProvider;
import org.android.spdy.SpdyErrorException;
import org.android.spdy.SpdyRequest;
import org.android.spdy.SpdySession;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;
import org.android.spdy.Spdycb;
import org.android.spdy.SslCertcb;
import org.android.spdy.SslPermData;
import org.android.spdy.SslVersion;
import org.android.spdy.SuperviseConnectInfo;
import org.android.spdy.SuperviseData;
import org.android.spdy.spduLog;

public final class SpdyAgent {
    private static final int MAX_SPDY_SESSION_COUNT = 50;
    private AccsSSLCallback accsSSLCallback;
    static final int SPDY_SESSION_CREATE = 4096;
    static final int SPDY_DATA_CHUNK_RECV = 4097;
    static final int SPDY_DATA_RECV = 4098;
    static final int SPDY_DATA_SEND = 4099;
    static final int SPDY_STREAM_CLOSE = 4100;
    static final int SPDY_PING_RECV = 4101;
    static final int SPDY_REQUEST_RECV = 4102;
    static final int SPDY_SESSION_CLOSE = 4103;
    static final int SPDY_STREAM_RESPONSE_RECV = 4104;
    static final int SPDY_SESSION_FAILED_ERROR = 4105;
    static final int SPDY_CUSTOM_CONTROL_FRAME_RECV = 4106;
    static final int MODE_QUIC = 256;
    private HashMap<String, SpdySession> sessionMgr = new HashMap(5);
    private LinkedList<SpdySession> sessionQueue = new LinkedList();
    private long agentNativePtr;
    private AtomicBoolean closed = new AtomicBoolean();
    private String proxyUsername = null;
    private String proxyPassword = null;
    private static final String TNET_SO_VERSION = "tnet-3.1.14";
    public static volatile boolean enableDebug = false;
    public static volatile boolean enableTimeGaurd = false;
    private static final boolean HAVE_CLOSE = false;
    private static final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static final Lock r = rwLock.readLock();
    private static final Lock w = rwLock.writeLock();
    private static volatile boolean loadSucc = false;
    private static volatile SpdyAgent gSingleInstance = null;
    private static Object lock = new Object();
    private static Object domainHashLock = new Object();
    private static HashMap<String, Integer> domainHashMap = new HashMap();
    private static int totalDomain = 0;
    private static final int KB8 = 8192;
    private static final int KB32 = 32768;
    private static final int MB5 = 0x500000;
    public static final int ACCS_TEST_SERVER = 0;
    public static final int ACCS_ONLINE_SERVER = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSpdySession(String authority, String domain, int mode) {
        if (authority != null) {
            w.lock();
            try {
                if (authority != null) {
                    this.sessionMgr.remove(authority + domain + mode);
                }
            }
            catch (Throwable thr) {
                thr.printStackTrace();
            }
            finally {
                w.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpdyAgent getInstance(Context context, SpdyVersion version, SpdySessionKind kind) throws UnsatisfiedLinkError, SpdyErrorException {
        if (gSingleInstance == null) {
            Object object = lock;
            synchronized (object) {
                if (gSingleInstance == null) {
                    gSingleInstance = new SpdyAgent(context, version, kind, null);
                }
            }
        }
        return gSingleInstance;
    }

    public static boolean checkLoadSucc() {
        return loadSucc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static SpdyAgent getInstance(Context context, SpdyVersion version, SpdySessionKind kind, AccsSSLCallback sslCallback) throws UnsatisfiedLinkError, SpdyErrorException {
        if (gSingleInstance == null) {
            Object object = lock;
            synchronized (object) {
                if (gSingleInstance == null) {
                    gSingleInstance = new SpdyAgent(context, version, kind, sslCallback);
                }
            }
        }
        return gSingleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDomainHashIndex(String domain) {
        Integer ret;
        Object object = domainHashLock;
        synchronized (object) {
            ret = domainHashMap.get(domain);
            if (ret == null) {
                domainHashMap.put(domain, ++totalDomain);
                ret = totalDomain;
            }
        }
        return ret;
    }

    private SpdyAgent(Context context, SpdyVersion version, SpdySessionKind kind, AccsSSLCallback sslCallback) throws UnsatisfiedLinkError {
        try {
            SoInstallMgrSdk.init(context);
            loadSucc = SoInstallMgrSdk.initSo(TNET_SO_VERSION, 1);
        }
        catch (Throwable ep) {
            ep.printStackTrace();
        }
        try {
            this.agentNativePtr = this.initAgent(version.getInt(), kind.getint(), SslVersion.SLIGHT_VERSION_V1.getint());
            this.accsSSLCallback = sslCallback;
        }
        catch (UnsatisfiedLinkError ep) {
            ep.printStackTrace();
        }
        this.closed.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLoadSo() throws SpdyErrorException {
        if (loadSucc) {
            return;
        }
        try {
            Object object = lock;
            synchronized (object) {
                if (loadSucc) {
                    return;
                }
                loadSucc = SoInstallMgrSdk.initSo(TNET_SO_VERSION, 1);
                this.agentNativePtr = this.initAgent(0, 0, 0);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!loadSucc) {
            throw new SpdyErrorException("TNET_JNI_ERR_LOAD_SO_FAIL", -1108);
        }
    }

    public void setProxyUsernamePassword(String un, String pw) {
        this.proxyUsername = un;
        this.proxyPassword = pw;
    }

    static void securityCheck(int total, int value) {
        if (total >= 32768) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:total=" + total, -1102);
        }
        if (value >= 8192) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:value=" + value, -1102);
        }
    }

    static void tableListJudge(int total) {
        if (total >= 0x500000) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:total=" + total, -1102);
        }
    }

    static void InvlidCharJudge(byte[] key, byte[] value) {
        int j;
        for (j = 0; j < key.length; ++j) {
            if ((key[j] & 0xFF) >= 32 && (key[j] & 0xFF) <= 126) continue;
            key[j] = 63;
        }
        for (j = 0; j < value.length; ++j) {
            if ((value[j] & 0xFF) >= 32 && (value[j] & 0xFF) <= 126) continue;
            value[j] = 63;
        }
    }

    static void headJudge(Map<String, String> head) {
        String key = null;
        String value = null;
        int total = 0;
        if (head != null) {
            Set<Map.Entry<String, String>> set = head.entrySet();
            Iterator<Map.Entry<String, String>> iter = set.iterator();
            Map.Entry<String, String> next = null;
            while (iter.hasNext()) {
                next = iter.next();
                key = next.getKey();
                value = next.getValue();
                SpdyAgent.InvlidCharJudge(key.getBytes(), value.getBytes());
                SpdyAgent.securityCheck(total += key.length() + 1 + value.length(), value.length());
            }
        }
    }

    static String mapBodyToString(Map<String, String> data) {
        int total = 0;
        String key = null;
        String value = null;
        StringBuilder build = new StringBuilder();
        if (data != null) {
            Set<Map.Entry<String, String>> set = data.entrySet();
            Iterator<Map.Entry<String, String>> iter = set.iterator();
            Map.Entry<String, String> next = null;
            while (iter.hasNext()) {
                next = iter.next();
                key = next.getKey();
                value = next.getValue();
                build.append(key).append('=').append(value).append('&');
                SpdyAgent.tableListJudge(total += key.length() + 1 + value.length());
            }
            if (build.length() > 0) {
                build.setLength(build.length() - 1);
            }
            return build.toString();
        }
        return null;
    }

    static byte[] dataproviderToByteArray(SpdyRequest req, SpdyDataProvider dataPro) {
        byte[] data = null;
        String query = null;
        SpdyAgent.headJudge(req.getHeaders());
        if (dataPro == null) {
            return null;
        }
        query = SpdyAgent.mapBodyToString(dataPro.postBody);
        data = query != null ? query.getBytes() : dataPro.data;
        if (data != null && data.length >= 0x500000) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:total=" + data.length, -1102);
        }
        return data;
    }

    @Deprecated
    public SpdySession createSession(String authority, Object sessionUserData, SessionCb sessioncb, int mode) throws SpdyErrorException {
        return this.createSession(authority, "", sessionUserData, sessioncb, null, mode, 0);
    }

    @Deprecated
    public SpdySession createSession(String authority, String domain, Object sessionUserData, SessionCb sessioncb, int mode) throws SpdyErrorException {
        return this.createSession(authority, domain, sessionUserData, sessioncb, null, mode, 0);
    }

    @Deprecated
    public SpdySession createSession(String authority, Object sessionUserData, SessionCb sessioncb, SslCertcb sslctx, int mode) throws SpdyErrorException {
        return this.createSession(authority, "", sessionUserData, sessioncb, sslctx, mode, 0);
    }

    public SpdySession createSession(SessionInfo info) throws SpdyErrorException {
        return this.createSession(info.getAuthority(), info.getDomain(), info.getSessonUserData(), info.getSessionCb(), null, info.getMode(), info.getPubKeySeqNum(), info.getConnectionTimeoutMs(), info.getCertHost());
    }

    @Deprecated
    public SpdySession createSession(String authority, String domain, Object sessionUserData, SessionCb sessioncb, SslCertcb sslctx, int mode, int seqnum) throws SpdyErrorException {
        return this.createSession(authority, domain, sessionUserData, sessioncb, sslctx, mode, seqnum, -1);
    }

    public SpdySession createSession(String authority, String domain, Object sessionUserData, SessionCb sessioncb, SslCertcb sslctx, int mode, int pubkey_seqnum, int connTimeoutM) throws SpdyErrorException {
        return this.createSession(authority, domain, sessionUserData, sessioncb, sslctx, mode, pubkey_seqnum, connTimeoutM, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdySession createSession(String authority, String domain, Object sessionUserData, SessionCb sessioncb, SslCertcb sslctx, int mode, int pubkey_seqnum, int connTimeoutMs, String certHost) throws SpdyErrorException {
        if (authority == null) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM", -1102);
        }
        String complteAuthority = authority;
        String[] hosts = authority.split("/");
        int index = hosts[0].lastIndexOf(58);
        String addr = hosts[0].substring(0, index);
        String port = hosts[0].substring(index + 1);
        byte[] proxyIp = "0.0.0.0".getBytes();
        char proxyPort = '\u0000';
        if (hosts.length != 1) {
            String[] proxyAddr = hosts[1].split(":");
            proxyIp = proxyAddr[0].getBytes();
            proxyPort = (char)Integer.parseInt(proxyAddr[1]);
        } else {
            complteAuthority = complteAuthority + "/0.0.0.0:0";
        }
        this.agentIsOpen();
        SpdySession oldsession = null;
        boolean exceed = false;
        r.lock();
        try {
            oldsession = this.sessionMgr.get(complteAuthority + domain + mode);
            if (this.sessionMgr.size() >= 50) {
                exceed = true;
            }
        }
        finally {
            r.unlock();
        }
        if (exceed) {
            throw new SpdyErrorException("SPDY_SESSION_EXCEED_MAXED: session count exceed max", -1105);
        }
        if (oldsession != null) {
            oldsession.increRefCount();
            return oldsession;
        }
        SpdySession session = null;
        w.lock();
        try {
            oldsession = this.sessionMgr.get(complteAuthority + domain + mode);
        }
        catch (Throwable thr) {
            oldsession = null;
        }
        if (oldsession != null) {
            w.unlock();
            oldsession.increRefCount();
            return oldsession;
        }
        try {
            int err;
            long ptr;
            session = new SpdySession(0L, this, complteAuthority, domain, sessioncb, mode, pubkey_seqnum, sessionUserData);
            byte[] cert_host_b = certHost == null ? null : certHost.getBytes();
            int domainIndex = this.getDomainHashIndex(domain + mode);
            long ret = this.proxyUsername != null && this.proxyPassword != null ? this.createSessionN(this.agentNativePtr, session, domainIndex, addr.getBytes(), (char)Integer.parseInt(port), proxyIp, proxyPort, this.proxyUsername.getBytes(), this.proxyPassword.getBytes(), sessionUserData, mode, pubkey_seqnum, connTimeoutMs, cert_host_b) : this.createSessionN(this.agentNativePtr, session, domainIndex, addr.getBytes(), (char)Integer.parseInt(port), proxyIp, proxyPort, null, null, sessionUserData, mode, pubkey_seqnum, connTimeoutMs, cert_host_b);
            spduLog.Logi("tnet-jni", " create new session: " + authority);
            if ((ret & 1L) == 1L) {
                ptr = 0L;
                err = (int)(ret >> 1);
            } else {
                ptr = ret;
                err = 0;
            }
            if (ptr != 0L) {
                session.setSessionNativePtr(ptr);
                this.sessionMgr.put(complteAuthority + domain + mode, session);
                this.sessionQueue.add(session);
            } else {
                if (err != 0) {
                    throw new SpdyErrorException("create session error: " + err, err);
                }
                session = null;
            }
        }
        finally {
            w.unlock();
        }
        return session;
    }

    @Deprecated
    public SpdySession submitRequest(SpdyRequest req, SpdyDataProvider dataPro, Object sessionUserData, Object streamUserData, Spdycb streamCallback, SessionCb sessioncb, SslCertcb sslctx, int sessionMode) throws SpdyErrorException {
        SpdySession session = this.createSession(req.getAuthority(), req.getDomain(), sessionUserData, sessioncb, sslctx, sessionMode, 0, req.getConnectionTimeoutMs());
        session.submitRequest(req, dataPro, streamUserData, streamCallback);
        return session;
    }

    @Deprecated
    public SpdySession submitRequest(SpdyRequest req, SpdyDataProvider dataPro, Object sessionUserData, Object streamUserData, Spdycb streamCallback, SessionCb sessioncb, SslCertcb sslctx, int sessionMode, int pubkey_seqnum) throws SpdyErrorException {
        SpdySession session = this.createSession(req.getAuthority(), req.getDomain(), sessionUserData, sessioncb, sslctx, sessionMode, pubkey_seqnum, req.getConnectionTimeoutMs());
        session.submitRequest(req, dataPro, streamUserData, streamCallback);
        return session;
    }

    public SpdySession submitRequest(SpdyRequest req, SpdyDataProvider dataPro, Object sessionUserData, Object streamUserData, Spdycb streamCallback, SessionCb sessioncb, int sessionMode, int pubkey_seqnum) throws SpdyErrorException {
        return this.submitRequest(req, dataPro, sessionUserData, streamUserData, streamCallback, sessioncb, null, sessionMode, pubkey_seqnum);
    }

    @Deprecated
    public SpdySession submitRequest(SpdyRequest req, SpdyDataProvider dataPro, Object sessionUserData, Object streamUserData, Spdycb streamCallback, SessionCb sessioncb, int sessionMode) throws SpdyErrorException {
        return this.submitRequest(req, dataPro, sessionUserData, streamUserData, streamCallback, sessioncb, null, sessionMode);
    }

    private void agentIsOpen() {
        if (this.closed.get()) {
            throw new SpdyErrorException("SPDY_JNI_ERR_ASYNC_CLOSE", -1104);
        }
        this.checkLoadSo();
    }

    public void close() {
    }

    void removeSession(SpdySession session) {
        w.lock();
        try {
            this.sessionQueue.remove(session);
        }
        finally {
            w.unlock();
        }
    }

    int closeSession(long ptr) {
        return this.closeSessionN(ptr);
    }

    static String[] mapToByteArray(Map<String, String> map) {
        if (map == null || map.size() <= 0) {
            return null;
        }
        int len = map.size() * 2;
        String[] array = new String[len];
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> iter = set.iterator();
        Map.Entry<String, String> next = null;
        int i = 0;
        while (iter.hasNext()) {
            next = iter.next();
            array[i] = next.getKey();
            array[i + 1] = next.getValue();
            i += 2;
        }
        return array;
    }

    static Map<String, List<String>> stringArrayToMap(String[] data) {
        if (data == null) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(5);
        int i = 0;
        while (i + 2 <= data.length) {
            if (data[i] == null || data[i + 1] == null) {
                return null;
            }
            List<String> value = map.get(data[i]);
            if (value == null) {
                value = new ArrayList<String>(1);
                map.put(data[i], value);
            }
            value.add(data[i + 1]);
            i += 2;
        }
        return map;
    }

    @Deprecated
    public int setSessionKind(SpdySessionKind kind) {
        int old = -1;
        this.agentIsOpen();
        try {
            old = this.setSessionKind(this.agentNativePtr, kind.getint());
        }
        catch (UnsatisfiedLinkError ep) {
            ep.printStackTrace();
        }
        return old;
    }

    @Deprecated
    public int setConnectTimeOut(int timeout) {
        int err = 0;
        this.agentIsOpen();
        try {
            err = this.setConTimeout(this.agentNativePtr, timeout);
        }
        catch (UnsatisfiedLinkError ep) {
            ep.printStackTrace();
        }
        return err;
    }

    public void setAccsSslCallback(AccsSSLCallback cb) {
        spduLog.Logi("tnet-jni", "[setAccsSslCallback] - " + cb.getClass());
        this.accsSSLCallback = cb;
    }

    private native int setConTimeout(long var1, int var3);

    private native long initAgent(int var1, int var2, int var3);

    private native int freeAgent(long var1);

    private native long getSession(long var1, byte[] var3, char var4);

    private native int closeSessionN(long var1);

    private native int setSessionKind(long var1, int var3);

    private native long createSessionN(long var1, SpdySession var3, int var4, byte[] var5, char var6, byte[] var7, char var8, byte[] var9, byte[] var10, Object var11, int var12, int var13, int var14, byte[] var15);

    private void spdySessionConnectCB(SpdySession session, SuperviseConnectInfo info) {
        spduLog.Logi("tnet-jni", "[spdySessionConnectCB] - ");
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdySessionConnectCB] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdySessionConnectCB] - session.intenalcb is null");
        } else {
            session.intenalcb.spdySessionConnectCB(session, info);
        }
    }

    private void spdyDataChunkRecvCB(SpdySession session, boolean fin, int streamId, SpdyByteArray data, int userData) {
        spduLog.Logi("tnet-jni", "[spdyDataChunkRecvCB] - ");
        long stmid = (long)streamId & 0xFFFFFFFFL;
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdyDataChunkRecvCB] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyDataChunkRecvCB] - session.intenalcb is null");
        } else {
            session.intenalcb.spdyDataChunkRecvCB(session, fin, stmid, data, userData);
        }
    }

    private void spdyDataRecvCallback(SpdySession session, boolean fin, int streamId, int length, int userData) {
        spduLog.Logi("tnet-jni", "[spdyDataRecvCallback] - ");
        long stmid = (long)streamId & 0xFFFFFFFFL;
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdyDataRecvCallback] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyDataRecvCallback] - session.intenalcb is null");
        } else {
            session.intenalcb.spdyDataRecvCallback(session, fin, stmid, length, userData);
        }
    }

    private void spdyDataSendCallback(SpdySession session, boolean fin, int streamId, int length, int userData) {
        long stmid = (long)streamId & 0xFFFFFFFFL;
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdyDataSendCallback] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyDataSendCallback] - session.intenalcb is null");
        } else {
            session.intenalcb.spdyDataSendCallback(session, fin, stmid, length, userData);
        }
    }

    private void spdyStreamCloseCallback(SpdySession session, int streamId, int statusCode, int userData, SuperviseData supData) {
        spduLog.Logi("tnet-jni", "[spdyStreamCloseCallback] - ");
        long stmid = (long)streamId & 0xFFFFFFFFL;
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamCloseCallback] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamCloseCallback] - session.intenalcb is null");
        } else {
            session.intenalcb.spdyStreamCloseCallback(session, stmid, statusCode, userData, supData);
        }
    }

    private void spdyPingRecvCallback(SpdySession session, int unique_id, Object userData) {
        spduLog.Logi("tnet-jni", "[spdyPingRecvCallback] - ");
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdyPingRecvCallback] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyPingRecvCallback] - session.intenalcb is null");
        } else {
            session.intenalcb.spdyPingRecvCallback(session, unique_id, userData);
        }
    }

    private void spdyCustomControlFrameRecvCallback(SpdySession session, Object userData, int node, int type, int flags, int length, byte[] data) {
        spduLog.Logi("tnet-jni", "[spdyCustomControlFrameRecvCallback] - ");
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameRecvCallback] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameRecvCallback] - session.intenalcb is null");
        } else {
            session.intenalcb.spdyCustomControlFrameRecvCallback(session, userData, node, type, flags, length, data);
        }
    }

    private void spdyCustomControlFrameFailCallback(SpdySession session, Object userData, int id, int error) {
        spduLog.Logi("tnet-jni", "[spdyCustomControlFrameFailCallback] - ");
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameFailCallback] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameFailCallback] - session.intenalcb is null");
        } else {
            session.intenalcb.spdyCustomControlFrameFailCallback(session, userData, id, error);
        }
    }

    private void bioPingRecvCallback(SpdySession session, int pingId) {
        spduLog.Logi("tnet-jni", "[bioPingRecvCallback] - ");
        if (session == null) {
            spduLog.Logi("tnet-jni", "[bioPingRecvCallback] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[bioPingRecvCallback] - session.intenalcb is null");
        } else {
            session.intenalcb.bioPingRecvCallback(session, pingId);
        }
    }

    private void spdyRequestRecvCallback(SpdySession session, int streamId, int userData) {
        long stmid = (long)streamId & 0xFFFFFFFFL;
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdyRequestRecvCallback] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyRequestRecvCallback] - session.intenalcb is null");
        } else {
            session.intenalcb.spdyRequestRecvCallback(session, stmid, userData);
        }
    }

    private void spdyStreamResponseRecv(SpdySession session, int streamId, String[] headers, int userData) {
        spduLog.Logi("tnet-jni", "[spdyStreamResponseRecv] - ");
        Map<String, List<String>> map = SpdyAgent.stringArrayToMap(headers);
        long stmid = (long)streamId & 0xFFFFFFFFL;
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamResponseRecv] - session is null");
        } else if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamResponseRecv] - session.intenalcb is null");
        } else {
            session.intenalcb.spdyOnStreamResponse(session, stmid, map, userData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spdySessionCloseCallback(SpdySession session, Object userData, SuperviseConnectInfo connInfo, int error) {
        spduLog.Logi("tnet-jni", "[spdySessionCloseCallback] - errorCode = " + error);
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdySessionCloseCallback] - session is null");
        } else {
            try {
                if (session.intenalcb == null) {
                    spduLog.Logi("tnet-jni", "[spdySessionCloseCallback] - session.intenalcb is null");
                } else {
                    session.intenalcb.spdySessionCloseCallback(session, userData, connInfo, error);
                }
            }
            finally {
                session.cleanUp();
            }
        }
        session.releasePptr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spdySessionFailedError(SpdySession session, int error, Object sessionUserData) {
        spduLog.Logi("tnet-jni", "[spdySessionFailedError] - ");
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdySessionFailedError] - session is null");
        } else {
            try {
                if (session.intenalcb == null) {
                    spduLog.Logi("tnet-jni", "[spdySessionFailedError] - session.intenalcb is null");
                } else {
                    session.intenalcb.spdySessionFailedError(session, error, sessionUserData);
                }
            }
            finally {
                session.cleanUp();
            }
        }
        session.releasePptr();
    }

    private void spdySessionOnWritable(SpdySession session, Object sessionUserData, int size) {
        spduLog.Logi("tnet-jni", "[spdySessionOnWritable] - ");
        if (session == null) {
            spduLog.Logi("tnet-jni", "[spdySessionOnWritable] - session is null");
        } else {
            try {
                if (session.intenalcb == null) {
                    spduLog.Logi("tnet-jni", "[spdySessionOnWritable] - session.intenalcb is null");
                } else {
                    session.intenalcb.spdySessionOnWritable(session, sessionUserData, size);
                }
            }
            catch (Throwable e) {
                spduLog.Loge("tnet-jni", "[spdySessionOnWritable] - exception:" + e);
            }
        }
    }

    private byte[] getSSLPublicKey(int seqnum, byte[] ciphertext) {
        if (this.accsSSLCallback == null) {
            spduLog.Logd("tnet-jni", "[getSSLPublicKey] - accsSSLCallback is null.");
            return null;
        }
        return this.accsSSLCallback.getSSLPublicKey(seqnum, ciphertext);
    }

    private int putSSLMeta(SpdySession session, byte[] sslMeta) {
        if (session == null) {
            spduLog.Logi("tnet-jni", "[putSSLMeta] - session is null");
            return -1;
        }
        if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[putSSLMeta] - session.intenalcb is null");
            return -1;
        }
        return session.intenalcb.putSSLMeta(session, sslMeta);
    }

    private byte[] getSSLMeta(SpdySession session) {
        if (session == null) {
            spduLog.Logi("tnet-jni", "[getSSLMeta] - session is null");
            return null;
        }
        if (session.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[getSSLMeta] - session.intenalcb is null");
            return null;
        }
        return session.intenalcb.getSSLMeta(session);
    }

    private void getPerformance(SpdySession session, SslPermData perm) {
    }

    public HashMap<String, SpdySession> getAllSession() {
        return this.sessionMgr;
    }

    private static void crashReporter(int error) {
    }

    public int configLogFile(String path, int fileSize, int fileNum) {
        return loadSucc ? this.configLogFileN(path, fileSize, fileNum) : -1;
    }

    public int configLogFile(String path, int fileSize, int fileNum, int bufferSize) {
        return loadSucc ? this.configLogFileN(path, fileSize, fileNum, bufferSize) : -1;
    }

    public void logFileFlush() {
        if (loadSucc) {
            this.logFileFlushN();
        }
    }

    public void logFileClose() {
        if (loadSucc) {
            this.logFileFlushN();
            this.logFileCloseN();
        }
    }

    private native int configLogFileN(String var1, int var2, int var3);

    private native int configLogFileN(String var1, int var2, int var3, int var4);

    private native void logFileFlushN();

    private native void logFileCloseN();

    @Deprecated
    public void switchAccsServer(int serverMode) {
    }

    @Deprecated
    public static void inspect(String message) {
    }

    private static native int configIpStackModeN(int var0);

    public static int configIpStackMode(int mode) {
        spduLog.Logi("tnet-jni", "[configIpStackMode] - " + mode);
        return SpdyAgent.configIpStackModeN(mode);
    }
}

