/*
 * Decompiled with CFR 0.152.
 */
package org.android.spdy;

import android.os.Handler;
import android.os.HandlerThread;
import java.util.concurrent.atomic.AtomicBoolean;
import org.android.spdy.Intenalcb;
import org.android.spdy.NetSparseArray;
import org.android.spdy.ProtectedPointer;
import org.android.spdy.SessionCb;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdyDataProvider;
import org.android.spdy.SpdyErrorException;
import org.android.spdy.SpdyRequest;
import org.android.spdy.SpdySessionCallBack;
import org.android.spdy.SpdyStreamContext;
import org.android.spdy.Spdycb;
import org.android.spdy.spduLog;

public final class SpdySession {
    private static volatile int count = 0;
    private SpdyAgent agent;
    private volatile long sessionNativePtr;
    private AtomicBoolean closed = new AtomicBoolean();
    private boolean sessionClearedFromSessionMgr = false;
    Intenalcb intenalcb;
    private HandlerThread thread;
    private Handler handler;
    private String authority;
    private String domain;
    private Object lock = new Object();
    private int streamcount = 1;
    private NetSparseArray<SpdyStreamContext> spdyStream = null;
    SessionCb sessionCallBack = null;
    private int pubkey_seqnum = 0;
    private Object userData = null;
    volatile int refcount = 1;
    private int mode;
    private ProtectedPointer pptr4sessionNativePtr;

    SpdySession(long ptr, SpdyAgent agent, String authority, String domain, SessionCb sessioncb, int mode, int pubkey_seqnum, Object userData) {
        this.sessionNativePtr = ptr;
        this.pptr4sessionNativePtr = new ProtectedPointer(this);
        this.pptr4sessionNativePtr.setHow2close(new ProtectedPointer.ProtectedPointerOnClose(){

            @Override
            public void close(Object data) {
                SpdySession session = (SpdySession)data;
                session.NotifyNotInvokeAnyMoreN(session.sessionNativePtr);
                session.setSessionNativePtr(0L);
            }
        });
        this.agent = agent;
        this.authority = authority;
        this.intenalcb = new SpdySessionCallBack();
        this.domain = domain;
        this.spdyStream = new NetSparseArray(5);
        this.sessionCallBack = sessioncb;
        this.pubkey_seqnum = pubkey_seqnum;
        this.mode = mode;
        this.userData = userData;
        this.closed.set(false);
    }

    public int getRefCount() {
        return this.refcount;
    }

    void increRefCount() {
        ++this.refcount;
    }

    private String getAuthority() {
        return this.authority;
    }

    public String getDomain() {
        return this.domain;
    }

    public Object getUserData() {
        return this.userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int putSpdyStreamCtx(SpdyStreamContext streamctx) {
        int old = 0;
        Object object = this.lock;
        synchronized (object) {
            old = this.streamcount++;
            this.spdyStream.put(old, streamctx);
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SpdyStreamContext getSpdyStream(int index) {
        SpdyStreamContext stm = null;
        if (index > 0) {
            Object object = this.lock;
            synchronized (object) {
                stm = this.spdyStream.get(index);
            }
        }
        return stm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSpdyStream(int index) {
        if (index > 0) {
            Object object = this.lock;
            synchronized (object) {
                this.spdyStream.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdyStreamContext[] getAllStreamCb() {
        int size = 0;
        SpdyStreamContext[] data = null;
        Object object = this.lock;
        synchronized (object) {
            size = this.spdyStream.size();
            if (size > 0) {
                data = new SpdyStreamContext[size];
                this.spdyStream.toArray((SpdyStreamContext[])data);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllStreamCb() {
        spduLog.Logd("tnet-jni", "[SpdySession.clearAllStreamCb] - ");
        Object object = this.lock;
        synchronized (object) {
            this.spdyStream.clear();
        }
    }

    SpdyAgent getSpdyAgent() {
        return this.agent;
    }

    Handler getMsgHandler() {
        return this.handler;
    }

    long getSessionNativePtr() {
        return this.sessionNativePtr;
    }

    void setSessionNativePtr(long ptr) {
        this.sessionNativePtr = ptr;
    }

    public int setOption(int optname, int optval) throws SpdyErrorException {
        this.sessionIsOpen();
        int code = 0;
        if (this.pptr4sessionNativePtr.enter()) {
            code = this.setOptionN(this.sessionNativePtr, optname, optval);
            this.pptr4sessionNativePtr.exit();
        } else {
            code = -2001;
        }
        if (code != 0) {
            throw new SpdyErrorException("setOption error: " + code, code);
        }
        return code;
    }

    public int submitPing() throws SpdyErrorException {
        this.sessionIsOpen();
        int code = 0;
        if (this.pptr4sessionNativePtr.enter()) {
            code = this.submitPingN(this.sessionNativePtr);
            this.pptr4sessionNativePtr.exit();
        } else {
            code = -2001;
        }
        if (code != 0) {
            throw new SpdyErrorException("submitPing error: " + code, code);
        }
        return code;
    }

    @Deprecated
    public int submitBioPing() throws SpdyErrorException {
        this.sessionIsOpen();
        int code = 0;
        if (this.pptr4sessionNativePtr.enter()) {
            code = this.submitBioPingN(this.sessionNativePtr);
            this.pptr4sessionNativePtr.exit();
        } else {
            code = -2001;
        }
        if (code != 0) {
            throw new SpdyErrorException("submitBioPing error: " + code, code);
        }
        return code;
    }

    public int streamReset(long streamId, int statusCode) throws SpdyErrorException {
        this.sessionIsOpen();
        spduLog.Logd("tnet-jni", "[SpdySession.streamReset] - ");
        int code = 0;
        if (this.pptr4sessionNativePtr.enter()) {
            code = this.streamCloseN(this.sessionNativePtr, (int)streamId, statusCode);
            this.pptr4sessionNativePtr.exit();
        } else {
            code = -2001;
        }
        if (code != 0) {
            throw new SpdyErrorException("streamReset error: " + code, code);
        }
        return code;
    }

    public int sendCustomControlFrame(int id, int type, int flags, int length, byte[] data) throws SpdyErrorException {
        this.sessionIsOpen();
        if (data != null && data.length <= 0) {
            data = null;
        }
        spduLog.Logi("tnet-jni", "[sendCustomControlFrame] - type: " + type);
        int code = 0;
        if (this.pptr4sessionNativePtr.enter()) {
            code = this.sendCustomControlFrameN(this.sessionNativePtr, id, type, flags, length, data);
            this.pptr4sessionNativePtr.exit();
        } else {
            code = -2001;
        }
        if (code != 0) {
            throw new SpdyErrorException("sendCustomControlFrame error: " + code, code);
        }
        return code;
    }

    public int submitRequest(SpdyRequest req, SpdyDataProvider dataPro, Object streamUserData, Spdycb streamCallBack) throws SpdyErrorException {
        if (req == null || streamUserData == null || req.getAuthority() == null) {
            throw new SpdyErrorException("submitRequest error: -1102", -1102);
        }
        this.sessionIsOpen();
        byte[] data = SpdyAgent.dataproviderToByteArray(req, dataPro);
        if (data != null && data.length <= 0) {
            data = null;
        }
        boolean finish = true;
        if (dataPro != null) {
            finish = dataPro.finished;
        }
        SpdyStreamContext context = new SpdyStreamContext(streamUserData, streamCallBack);
        int index = this.putSpdyStreamCtx(context);
        String[] nv = SpdyAgent.mapToByteArray(req.getHeaders());
        spduLog.Logi("tnet-jni", "index=" + index + "  " + "starttime=" + System.currentTimeMillis());
        int code = 0;
        if (this.pptr4sessionNativePtr.enter()) {
            code = this.submitRequestN(this.sessionNativePtr, req.getUrlPath(), (byte)req.getPriority(), nv, data, finish, index, req.getRequestTimeoutMs(), req.getRequestRdTimeoutMs());
            this.pptr4sessionNativePtr.exit();
        } else {
            code = -2001;
        }
        spduLog.Logi("tnet-jni", "index=" + index + "  " + " calltime=" + System.currentTimeMillis());
        if (code < 0) {
            this.removeSpdyStream(index);
            throw new SpdyErrorException("submitRequest error: " + code, code);
        }
        context.streamId = code;
        return code;
    }

    void sessionIsOpen() {
        if (this.closed.get()) {
            throw new SpdyErrorException("session is already closed: -1104", -1104);
        }
    }

    public int cleanUp() {
        spduLog.Logd("tnet-jni", "[SpdySession.cleanUp] - ");
        int code = 0;
        if (!this.closed.getAndSet(true)) {
            this.agent.removeSession(this);
            code = this.closeprivate();
        }
        return code;
    }

    int closeInternal() {
        int code = 0;
        if (!this.closed.getAndSet(true)) {
            code = this.closeprivate();
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int closeSession() {
        spduLog.Logd("tnet-jni", "[SpdySession.closeSession] - ");
        int code = 0;
        Object object = this.lock;
        synchronized (object) {
            if (!this.sessionClearedFromSessionMgr) {
                spduLog.Logd("tnet-jni", "[SpdySession.closeSession] - " + this.authority);
                this.agent.clearSpdySession(this.authority, this.domain, this.mode);
                this.sessionClearedFromSessionMgr = true;
                if (this.pptr4sessionNativePtr.enter()) {
                    try {
                        code = this.agent.closeSession(this.sessionNativePtr);
                    }
                    catch (UnsatisfiedLinkError ep) {
                        ep.printStackTrace();
                    }
                    finally {
                        this.pptr4sessionNativePtr.exit();
                    }
                } else {
                    code = -2001;
                }
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int closeprivate() {
        int code = 0;
        Object object = this.lock;
        synchronized (object) {
            if (!this.sessionClearedFromSessionMgr) {
                this.agent.clearSpdySession(this.authority, this.domain, this.mode);
                this.sessionClearedFromSessionMgr = true;
            }
        }
        object = this.lock;
        synchronized (object) {
            SpdyStreamContext[] stmCbs = this.getAllStreamCb();
            if (stmCbs != null) {
                for (SpdyStreamContext stm : stmCbs) {
                    spduLog.Logi("tnet-jni", "[SpdySessionCallBack.spdyStreamCloseCallback] unfinished stm=" + stm.streamId);
                    stm.callBack.spdyStreamCloseCallback(this, stm.streamId, -2001, stm.streamContext, null);
                }
            }
            this.spdyStream.clear();
        }
        return code;
    }

    void releasePptr() {
        this.pptr4sessionNativePtr.release();
    }

    private native int submitRequestN(long var1, String var3, byte var4, String[] var5, byte[] var6, boolean var7, int var8, int var9, int var10);

    private native int sendCustomControlFrameN(long var1, int var3, int var4, int var5, int var6, byte[] var7);

    private native int sendHeadersN(long var1, int var3, String[] var4, boolean var5);

    private native int streamSendDataN(long var1, int var3, byte[] var4, int var5, int var6, boolean var7);

    private native int setOptionN(long var1, int var3, int var4);

    private native int submitPingN(long var1);

    private native int submitBioPingN(long var1);

    private native int streamCloseN(long var1, int var3, int var4);

    private native int NotifyNotInvokeAnyMoreN(long var1);
}

