/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.httpdns;

import android.content.Context;
import android.text.TextUtils;
import com.alibaba.sdk.android.httpdns.DegradationFilter;
import com.alibaba.sdk.android.httpdns.HTTPDNSResult;
import com.alibaba.sdk.android.httpdns.HttpDnsService;
import com.alibaba.sdk.android.httpdns.ILogger;
import com.alibaba.sdk.android.httpdns.a;
import com.alibaba.sdk.android.httpdns.b;
import com.alibaba.sdk.android.httpdns.c;
import com.alibaba.sdk.android.httpdns.d;
import com.alibaba.sdk.android.httpdns.e;
import com.alibaba.sdk.android.httpdns.f;
import com.alibaba.sdk.android.httpdns.i;
import com.alibaba.sdk.android.httpdns.l;
import com.alibaba.sdk.android.httpdns.n;
import com.alibaba.sdk.android.httpdns.p;
import com.alibaba.sdk.android.httpdns.probe.IPProbeItem;
import com.alibaba.sdk.android.httpdns.q;
import com.alibaba.sdk.android.httpdns.s;
import com.alibaba.sdk.android.httpdns.t;
import com.alibaba.sdk.android.httpdns.u;
import com.alibaba.sdk.android.utils.AMSConfigUtils;
import com.alibaba.sdk.android.utils.AMSDevReporter;
import com.alibaba.sdk.android.utils.crashdefend.SDKMessageCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class HttpDns
implements HttpDnsService {
    private boolean isExpiredIPEnabled = false;
    private static d hostManager = d.a();
    private static DegradationFilter degradationFilter = null;
    static HttpDns instance = null;
    private static boolean inited = false;
    private static String sAccountId = null;
    private static String sSecretKey = null;
    private static Context sContext = null;

    public static synchronized HttpDnsService getService(Context context, String string) {
        if (instance == null && context != null) {
            sContext = context.getApplicationContext();
            HttpDns.setAccountId(string);
            b.a(sContext);
            com.alibaba.sdk.android.httpdns.d.b b2 = com.alibaba.sdk.android.httpdns.d.b.a(sContext);
            boolean bl = b2.a(new SDKMessageCallback(){

                public void crashDefendMessage(int n2, int n3) {
                    inited = true;
                    if (n2 > n3) {
                        b.b(true);
                    } else {
                        i.f("crash limit exceeds, httpdns disabled");
                        b.b(false);
                    }
                }
            });
            if (!inited) {
                i.f("sdk crash defend not returned");
            }
            if (b.a()) {
                HttpDns.initHttpDns(sContext, HttpDns.getAccountId(), HttpDns.getSecretKey());
            } else {
                instance = new HttpDns(sContext, HttpDns.getAccountId());
            }
        }
        return instance;
    }

    public static synchronized HttpDnsService getService(Context context, String string, String string2) {
        if (instance == null && context != null) {
            sContext = context.getApplicationContext();
            HttpDns.setAccountId(string);
            HttpDns.setSecretKey(string2);
            b.a(sContext);
            com.alibaba.sdk.android.httpdns.d.b b2 = com.alibaba.sdk.android.httpdns.d.b.a(sContext);
            boolean bl = b2.a(new SDKMessageCallback(){

                public void crashDefendMessage(int n2, int n3) {
                    inited = true;
                    if (n2 > n3) {
                        b.b(true);
                    } else {
                        i.f("crash limit exceeds, httpdns disabled");
                        b.b(false);
                    }
                }
            });
            if (!inited) {
                i.f("sdk crash defend not returned");
            }
            if (b.a()) {
                HttpDns.initHttpDns(sContext, HttpDns.getAccountId(), HttpDns.getSecretKey());
            } else {
                instance = new HttpDns(sContext, HttpDns.getAccountId());
            }
        }
        return instance;
    }

    public static synchronized HttpDnsService getService(Context context) {
        if (instance == null && context != null) {
            sContext = context.getApplicationContext();
            b.a(sContext);
            com.alibaba.sdk.android.httpdns.d.b b2 = com.alibaba.sdk.android.httpdns.d.b.a(sContext);
            boolean bl = b2.a(new SDKMessageCallback(){

                public void crashDefendMessage(int n2, int n3) {
                    inited = true;
                    if (n2 > n3) {
                        b.b(true);
                    } else {
                        i.f("crash limit exceeds, httpdns disabled");
                        b.b(false);
                    }
                }
            });
            if (!inited) {
                i.f("sdk crash defend not returned");
            }
            if (b.a()) {
                HttpDns.initHttpDns(sContext, HttpDns.getAccountId(), HttpDns.getSecretKey());
            } else {
                instance = new HttpDns(sContext, HttpDns.getAccountId());
            }
        }
        return instance;
    }

    private static void initHttpDns(Context context, String string, String string2) {
        if (instance == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(AMSDevReporter.AMSSdkExtInfoKeyEnum.AMS_EXTINFO_KEY_VERSION.toString(), "1.3.2.3-no-bssid-ssid");
            AMSDevReporter.asyncReport((Context)context, (AMSDevReporter.AMSSdkTypeEnum)AMSDevReporter.AMSSdkTypeEnum.AMS_HTTPDNS, hashMap);
            p.setContext(context);
            q.setContext(context);
            com.alibaba.sdk.android.httpdns.b.b.a(context);
            com.alibaba.sdk.android.httpdns.b.b.b(context);
            u.a(context);
            n.a().a(context, string);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                a.setSecretKey(string2);
            }
            HttpDns.reportActive(context, string);
            instance = new HttpDns(context, string);
        }
    }

    private HttpDns(Context context, String string) {
        f.c(string);
        com.alibaba.sdk.android.httpdns.a.a.a().c(context, string);
        com.alibaba.sdk.android.httpdns.a.a.a().a(com.alibaba.sdk.android.httpdns.d.b.a(context));
    }

    private static void reportActive(Context context, String string) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string)) {
            com.alibaba.sdk.android.httpdns.d.b.a(context).setAccountId(string);
            com.alibaba.sdk.android.httpdns.d.b.a(context).l();
        } else {
            i.f("report active failed due to missing context or accountid");
        }
    }

    @Override
    public void setLogEnabled(boolean bl) {
        i.setLogEnabled(bl);
    }

    @Override
    public void setPreResolveHosts(ArrayList<String> arrayList) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return;
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            String string = arrayList.get(i2);
            if (!l.b(string) || hostManager.a(string)) continue;
            c.a().submit(new q(string, s.b));
        }
    }

    @Override
    public String getIpByHostAsync(String string) {
        try {
            if (!b.a()) {
                i.f("HttpDns service turned off");
                return null;
            }
            String[] stringArray = this.getIpsByHostAsync(string);
            if (stringArray == null) {
                return null;
            }
            if (stringArray.length > 0) {
                return stringArray[0];
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String getIpByHost(String string) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return null;
        }
        String[] stringArray = this.getIpsByHost(string);
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    private String[] getIpsByHost(String string) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return f.c;
        }
        if (!l.b(string)) {
            return f.c;
        }
        if (l.c(string)) {
            return new String[]{string};
        }
        if (degradationFilter != null && degradationFilter.shouldDegradeHttpDNS(string)) {
            return f.c;
        }
        if (u.e()) {
            return this.getIpsByHostAsync(string);
        }
        e e2 = hostManager.a(string);
        if (e2 != null && e2.b() && this.isExpiredIPEnabled) {
            if (!hostManager.a(string)) {
                i.d("refresh host async: " + string);
                c.a().submit(new q(string, s.b));
            }
            return e2.getIps();
        }
        if (e2 == null || e2.b()) {
            i.d("refresh host sync: " + string);
            Future<String[]> future = c.a().submit(new q(string, s.b));
            try {
                String[] stringArray = future.get();
                return stringArray;
            }
            catch (Exception exception) {
                i.a(exception);
                return f.c;
            }
        }
        return e2.getIps();
    }

    @Override
    public String[] getIpsByHostAsync(String string) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return f.c;
        }
        if (!l.b(string)) {
            return f.c;
        }
        if (l.c(string)) {
            return new String[]{string};
        }
        if (degradationFilter != null && degradationFilter.shouldDegradeHttpDNS(string)) {
            return f.c;
        }
        e e2 = hostManager.a(string);
        boolean bl = false;
        if ((e2 == null || (bl = e2.b())) && !hostManager.a(string)) {
            if (u.e()) {
                t.a().g(string);
            } else {
                i.d("refresh host async: " + string);
                q q2 = new q(string, s.b);
                c.a().submit(q2);
            }
        } else if (e2 != null && e2.getCacheKey() != null) {
            if (u.e()) {
                t.a().g(string);
            } else {
                i.d("refresh host async: " + string);
                q q3 = new q(string, s.b);
                c.a().submit(q3);
            }
        }
        if (e2 == null) {
            HttpDns.reportUserGetIP(string, 0);
            return f.c;
        }
        if (u.e()) {
            i.d("[HttpDns] disabled return Nil.");
            HttpDns.reportUserGetIP(string, 0);
            return f.c;
        }
        if (e2.getCacheKey() != null) {
            return f.c;
        }
        if (this.isExpiredIPEnabled) {
            HttpDns.reportHttpDnsSuccess(string, 1);
            HttpDns.reportUserGetIP(string, 1);
            return e2.getIps();
        }
        if (e2.c()) {
            i.d("[HttpDns] ips from cache:" + Arrays.toString(e2.getIps()));
            return e2.getIps();
        }
        if (!bl) {
            i.d("[HttpDns] not expired return " + Arrays.toString(e2.getIps()));
            HttpDns.reportHttpDnsSuccess(string, 1);
            HttpDns.reportUserGetIP(string, 1);
            return e2.getIps();
        }
        i.f("[HttpDns] return Nil.");
        HttpDns.reportUserGetIP(string, 0);
        return f.c;
    }

    @Override
    public void setExpiredIPEnabled(boolean bl) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return;
        }
        this.isExpiredIPEnabled = bl;
        com.alibaba.sdk.android.httpdns.d.b b2 = com.alibaba.sdk.android.httpdns.d.b.a();
        if (b2 != null) {
            b2.d(bl ? 1 : 0);
        }
    }

    @Override
    public void setCachedIPEnabled(boolean bl) {
        this.setCachedIPEnabled(bl, true);
    }

    @Override
    public void setCachedIPEnabled(boolean bl, boolean bl2) {
        try {
            if (!b.a()) {
                i.f("HttpDns service turned off");
                return;
            }
            i.f("Httpdns DB cache enable = " + bl + ". autoCleanCacheAfterLoad = " + bl2);
            com.alibaba.sdk.android.httpdns.b.b.a(bl, bl2);
            d.a().a();
            com.alibaba.sdk.android.httpdns.d.b b2 = com.alibaba.sdk.android.httpdns.d.b.a();
            if (b2 != null) {
                b2.c(bl ? 1 : 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setAuthCurrentTime(long l2) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return;
        }
        a.setAuthCurrentTime(l2);
    }

    @Override
    public void setDegradationFilter(DegradationFilter degradationFilter) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return;
        }
        HttpDns.degradationFilter = degradationFilter;
    }

    @Override
    public void setPreResolveAfterNetworkChanged(boolean bl) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return;
        }
        p.i = bl;
    }

    @Override
    public void setTimeoutInterval(int n2) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return;
        }
        f.setTimeoutInterval(n2);
    }

    @Override
    public void setHTTPSRequestEnabled(boolean bl) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return;
        }
        f.setHTTPSRequestEnabled(bl);
    }

    @Override
    public void setIPProbeList(List<IPProbeItem> list) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return;
        }
        f.a(list);
    }

    @Override
    public String getSessionId() {
        return com.alibaba.sdk.android.httpdns.e.a.a().getSessionId();
    }

    @Override
    public void setLogger(ILogger iLogger) {
        i.setLogger(iLogger);
    }

    @Override
    public HTTPDNSResult getIpsByHostAsync(String string, Map<String, String> map, String string2) {
        Map<String, String> map2 = f.extra;
        map2.putAll(map);
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return new HTTPDNSResult(string, f.c, map2);
        }
        if (!l.b(string)) {
            return new HTTPDNSResult(string, f.c, map2);
        }
        if (l.c(string)) {
            return new HTTPDNSResult(string, new String[]{string}, map2);
        }
        if (degradationFilter != null && degradationFilter.shouldDegradeHttpDNS(string)) {
            return new HTTPDNSResult(string, f.c, map2);
        }
        e e2 = hostManager.a(string);
        boolean bl = false;
        if ((e2 == null || (bl = e2.b())) && !hostManager.a(string)) {
            if (u.e()) {
                t.a().g(string);
            } else {
                i.d("refresh host async: " + string);
                q q2 = new q(string, s.b, map2, string2);
                c.a().submit(q2);
            }
        } else if (e2 != null && !string2.equals(e2.getCacheKey())) {
            if (u.e()) {
                t.a().g(string);
            } else {
                i.d("refresh host async: " + string);
                q q3 = new q(string, s.b, map2, string2);
                c.a().submit(q3);
            }
        }
        if (e2 == null) {
            HttpDns.reportUserGetIP(string, 0);
            return new HTTPDNSResult(string, f.c, map2);
        }
        if (u.e()) {
            i.d("[HttpDns] disabled return Nil.");
            HttpDns.reportUserGetIP(string, 0);
            return new HTTPDNSResult(string, f.c, map2);
        }
        if (!string2.equals(e2.getCacheKey())) {
            return new HTTPDNSResult(string, f.c, map2);
        }
        if (this.isExpiredIPEnabled) {
            HttpDns.reportHttpDnsSuccess(string, 1);
            HttpDns.reportUserGetIP(string, 1);
            return new HTTPDNSResult(string, e2.getIps(), e2.a());
        }
        if (e2.c()) {
            i.d("[HttpDns] ips from cache:" + Arrays.toString(e2.getIps()));
            return new HTTPDNSResult(string, e2.getIps(), e2.a());
        }
        if (!bl) {
            i.d("[HttpDns] not expired return " + Arrays.toString(e2.getIps()));
            HttpDns.reportHttpDnsSuccess(string, 1);
            HttpDns.reportUserGetIP(string, 1);
            return new HTTPDNSResult(string, e2.getIps(), e2.a());
        }
        i.f("[HttpDns] return Nil.");
        HttpDns.reportUserGetIP(string, 0);
        return new HTTPDNSResult(string, f.c, map2);
    }

    @Override
    public void setSdnsGlobalParams(Map<String, String> map) {
        f.setSdnsGlobalParams(map);
    }

    @Override
    public void clearSdnsGlobalParams() {
        f.clearSdnsGlobalParams();
    }

    @Override
    public void setRegion(String string) {
        if (!b.a()) {
            i.f("HttpDns service turned off");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            i.f("region cannot be empty");
        } else {
            n.a().b(sContext, string);
        }
    }

    @Override
    public void enableIPv6(boolean bl) {
        com.alibaba.sdk.android.httpdns.net64.a.a().enableIPv6(bl);
        try {
            com.alibaba.sdk.android.httpdns.d.b b2 = com.alibaba.sdk.android.httpdns.d.b.a();
            if (b2 != null) {
                b2.e(bl ? 1 : 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getIPv6ByHostAsync(String string) {
        try {
            if (!b.a()) {
                i.f("HttpDns service turned off");
                return null;
            }
            if (com.alibaba.sdk.android.httpdns.net64.a.a().a()) {
                this.getIpsByHostAsync(string);
                e e2 = hostManager.a(string);
                if (e2 != null) {
                    String string2 = com.alibaba.sdk.android.httpdns.net64.a.a().getIPv6ByHostAsync(string);
                    if (this.isExpiredIPEnabled) {
                        i.d("ipv6 is expired enable, hostName: " + string + " ipv6: " + string2);
                        return string2;
                    }
                    if (!e2.b()) {
                        i.d("ipv6 is not expired, hostName: " + string + " ipv6: " + string2);
                        return string2;
                    }
                    if (e2.c()) {
                        i.d("ipv6 is from cache, hostName: " + string + " ipv6: " + string2);
                        return string2;
                    }
                    i.d("ipv6 is expired.");
                    return null;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    static synchronized void switchDnsService(boolean bl) {
        b.a(bl);
        if (!b.a()) {
            i.f("httpdns service disabled");
        }
    }

    private static void disableReport() {
        com.alibaba.sdk.android.httpdns.d.b.a().k();
    }

    private static void reportHttpDnsSuccess(String string, int n2) {
        com.alibaba.sdk.android.httpdns.d.b b2 = com.alibaba.sdk.android.httpdns.d.b.a();
        if (b2 != null) {
            b2.a(string, n2, com.alibaba.sdk.android.httpdns.d.c.a(), com.alibaba.sdk.android.httpdns.b.b.a() ? 1 : 0);
        }
    }

    private static void reportUserGetIP(String string, int n2) {
        com.alibaba.sdk.android.httpdns.d.b b2 = com.alibaba.sdk.android.httpdns.d.b.a();
        if (b2 != null) {
            b2.b(string, n2, com.alibaba.sdk.android.httpdns.d.c.a(), com.alibaba.sdk.android.httpdns.b.b.a() ? 1 : 0);
        }
    }

    private static void setAccountId(String string) {
        sAccountId = string;
    }

    private static void setSecretKey(String string) {
        sSecretKey = string;
    }

    private static String getAccountId() {
        if (!TextUtils.isEmpty((CharSequence)sAccountId)) {
            return sAccountId;
        }
        sAccountId = AMSConfigUtils.getAccountId((Context)sContext);
        return sAccountId;
    }

    private static String getSecretKey() {
        if (!TextUtils.isEmpty((CharSequence)sSecretKey)) {
            return sSecretKey;
        }
        sSecretKey = AMSConfigUtils.getHttpdnsSecretKey((Context)sContext);
        return sSecretKey;
    }
}

