/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.umcrash;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.efs.sdk.base.EfsReporter;
import com.efs.sdk.base.core.util.NetworkUtil;
import com.efs.sdk.launch.LaunchManager;
import com.efs.sdk.memoryinfo.UMMemoryMonitor;
import com.efs.sdk.pa.PAFactory;
import com.efs.sdk.pa.config.IEfsReporter;
import com.efs.sdk.pa.config.PackageLevel;
import com.uc.crashsdk.export.CrashApi;
import com.uc.crashsdk.export.CustomLogInfo;
import com.uc.crashsdk.export.ICrashClient;
import com.umeng.commonsdk.statistics.idtracking.ImprintHandler;
import com.umeng.commonsdk.statistics.internal.UMImprintChangeCallback;
import com.umeng.commonsdk.utils.UMUtils;
import com.umeng.umcrash.UMCrashCallback;
import com.umeng.umcrash.UMCrashUtils;
import com.umeng.umcrash.UMCustomLogInfoBuilder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class UMCrash {
    private static final String TAG = UMCrash.class.getSimpleName();
    private static Context mContext;
    private static boolean isDebug;
    private static boolean isEncrypt;
    private static boolean isZip;
    private static boolean isIntl;
    private static UMCrashCallback mUMCrashCallback;
    private static final String KEY_CALLBACK_USER_STRING = "um_user_string";
    public static final String KEY_CALLBACK_PAGE_ACTION = "um_action_log";
    public static final String KEY_CALLBACK_UMID = "um_umid";
    public static final String KEY_HEADER_APPKEY = "um_app_key";
    public static final String KEY_HEADER_CHANNEL = "um_app_channel";
    public static final String KEY_HEADER_OS = "um_os";
    public static final String KEY_HEADER_CRASH_VERSION = "um_crash_sdk_version";
    public static final String KEY_HEADER_PUID = "um_app_puid";
    public static final String KEY_HEADER_PROVIDER = "um_app_provider";
    public static final String KEY_HEADER_CARRIER = "um_app_carrier";
    public static final String KEY_HEADER_START_TIME = "um_app_start_time";
    public static final String KEY_HEADER_ACCESS = "um_access";
    public static final String KEY_HEADER_ACCESS_SUBTYPE = "um_access_subtype";
    public static final String KEY_HEADER_NETWORK_TYPE = "um_network_type";
    public static final String KEY_HEADER_BVER = "um_bver";
    public static final String KEY_HEADER_BSVER = "um_bsver";
    public static final String KEY_HEADER_BESRIAL = "um_bserial";
    private static String userBver;
    private static String userBsver;
    private static String userBesrial;
    public static final String KEY_HEADER_UMID = "um_umid_header";
    public static final String KEY_APM_DEFAULT_SECRET = "NEej8y@anWa*8hep";
    public static final String KEY_APM_ROOT_NAME = "UApm";
    private static String crashSdkVersion;
    private static Object pageArrayLock;
    private static ArrayList<String> mArrayList;
    private static final int KEY_MAX_LENGTH = 256;
    private static final int KEY_MAX_LENGTH_128 = 128;
    public static EfsReporter sReporter;
    private static boolean isPA;
    private static boolean isLa;
    public static final String KEY_ENABLE_CRASH_JAVA = "enableJavaLog";
    private static final boolean DEFAULT_VALUE_CRASH_JAVA = true;
    public static final String KEY_ENABLE_CRASH_NATIVE = "enableNativeLog";
    private static final boolean DEFAULT_VALUE_CRASH_NATIVE = true;
    public static final String KEY_ENABLE_CRASH_UNEXP = "enableUnexpLog";
    private static final boolean DEFAULT_VALUE_CRASH_UNEXP = false;
    public static final String KEY_ENABLE_CRASH_ALL = "enableCrashLog";
    private static final boolean DEFAULT_VALUE_CRASH_ALL = true;
    public static final String KEY_ENABLE_ANR = "enableANRLog";
    private static final boolean DEFAULT_VALUE_CRASH_ANR = true;
    public static final String KEY_ENABLE_PA = "enablePaLog";
    private static final boolean DEFAULT_VALUE_PA = true;
    public static final String KEY_ENABLE_LAUNCH = "enableLaunchLog";
    private static final boolean DEFAULT_VALUE_LAUNCH = true;
    public static final String KEY_ENABLE_MEM = "enableMemLog";
    private static final boolean DEFAULT_VALUE_MEM = true;
    private static boolean enableJavaLog;
    private static boolean enableNativeLog;
    private static boolean enableANRLog;
    private static boolean enablePaLog;
    private static boolean enableLaunchLog;
    private static boolean enableMemLog;
    private static final String KEY_ACTIITY_ON_CREATED = "onCreated";
    private static final String KEY_ACTIITY_ON_STARTED = "onStarted";
    private static final String KEY_ACTIITY_ON_RESUMED = "onResumed";
    private static final String KEY_ACTIITY_ON_PAUSED = "onPaused";
    private static final String KEY_ACTIITY_ON_STOPPED = "onStopped";
    private static final String KEY_ACTIITY_ON_DESTROYED = "onDestroyed";

    public static void setAppVersion(String version, String subVersion, String buildId) {
        try {
            String pVersion = version;
            if (!TextUtils.isEmpty((CharSequence)pVersion)) {
                int len = pVersion.trim().getBytes().length;
                if (len > 128) {
                    pVersion = UMCrashUtils.splitByByte(pVersion, 128);
                }
                userBver = pVersion;
            } else if (isDebug) {
                Log.e((String)TAG, (String)"version is null or empty !");
            }
            String pSubVersion = subVersion;
            if (!TextUtils.isEmpty((CharSequence)pSubVersion)) {
                int len = pSubVersion.trim().getBytes().length;
                if (len > 128) {
                    pSubVersion = UMCrashUtils.splitByByte(pSubVersion, 128);
                }
                userBsver = pSubVersion;
            } else if (isDebug) {
                Log.e((String)TAG, (String)"sub version is null or empty !");
            }
            String pBuildId = buildId;
            if (!TextUtils.isEmpty((CharSequence)pBuildId)) {
                int len = pBuildId.trim().getBytes().length;
                if (len > 128) {
                    pBuildId = UMCrashUtils.splitByByte(pBuildId, 128);
                }
                userBesrial = pBuildId;
            } else if (isDebug) {
                Log.e((String)TAG, (String)"build id is null or empty !");
            }
            CrashApi crashApi = CrashApi.getInstance();
            if (crashApi != null) {
                if (!TextUtils.isEmpty((CharSequence)userBver)) {
                    crashApi.addHeaderInfo(KEY_HEADER_BVER, userBver);
                }
                if (!TextUtils.isEmpty((CharSequence)userBsver)) {
                    crashApi.addHeaderInfo(KEY_HEADER_BSVER, userBsver);
                }
                if (!TextUtils.isEmpty((CharSequence)userBesrial)) {
                    crashApi.addHeaderInfo(KEY_HEADER_BESRIAL, userBesrial);
                }
            } else if (isDebug) {
                Log.e((String)TAG, (String)"set app version. crashApi is null");
            }
            HashMap<String, String> params = new HashMap<String, String>(1);
            if (!TextUtils.isEmpty((CharSequence)userBver)) {
                params.put(KEY_HEADER_BVER, userBver);
            }
            if (!TextUtils.isEmpty((CharSequence)userBsver)) {
                params.put(KEY_HEADER_BSVER, userBsver);
            }
            if (!TextUtils.isEmpty((CharSequence)userBesrial)) {
                params.put(KEY_HEADER_BESRIAL, userBesrial);
            }
            if (sReporter != null) {
                sReporter.addPublicParams(params);
            } else if (isDebug) {
                Log.e((String)TAG, (String)"set app version.  sReporter is null");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static synchronized String getUMID(Context context) {
        if (context == null) {
            return null;
        }
        String umId = null;
        Class<?> umConfigClass = null;
        try {
            umConfigClass = Class.forName("com.umeng.commonsdk.UMConfigure");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (umConfigClass != null) {
            Method umConfigMethed = null;
            try {
                umConfigMethed = umConfigClass.getMethod("getUMIDString", Context.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (umConfigMethed != null) {
                try {
                    Object o = umConfigMethed.invoke(null, context);
                    if (o != null) {
                        umId = o.toString();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return umId;
    }

    public static String getUMAPMFlag() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("version", 0);
            jsonObject.put("crash", 1);
            if (enableNativeLog) {
                jsonObject.put("crashNative", 1);
            } else {
                jsonObject.put("crashNative", 0);
            }
            if (enableANRLog) {
                jsonObject.put("anr", 1);
            } else {
                jsonObject.put("anr", 0);
            }
            if (isPA) {
                jsonObject.put("pa", 1);
            } else {
                jsonObject.put("pa", 0);
            }
            if (isLa) {
                jsonObject.put("la", 1);
            } else {
                jsonObject.put("la", 0);
            }
            if (UMMemoryMonitor.get().isEnable()) {
                jsonObject.put("mem", 1);
            } else {
                jsonObject.put("mem", 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jsonObject.toString();
    }

    public static void setDebug(boolean isD) {
        isDebug = isD;
        LaunchManager.isDebug = isD;
    }

    private static void useIntlServices(boolean isInSer) {
        isIntl = isInSer;
        if (isDebug) {
            Log.i((String)TAG, (String)("useIntlServices is " + isIntl));
        }
    }

    public static void enableNativeLog(boolean isN) {
        enableNativeLog = isN;
    }

    public static void enableANRLog(boolean isA) {
        enableANRLog = isA;
    }

    public static void initConfig(Bundle args) {
        if (args != null) {
            enableJavaLog = args.getBoolean(KEY_ENABLE_CRASH_JAVA, true);
            enableNativeLog = args.getBoolean(KEY_ENABLE_CRASH_NATIVE, true);
            if (args.getBoolean(KEY_ENABLE_CRASH_ALL, true)) {
                enableJavaLog = true;
                enableNativeLog = true;
            } else {
                enableJavaLog = false;
                enableNativeLog = false;
            }
            enableANRLog = args.getBoolean(KEY_ENABLE_ANR, true);
            enablePaLog = args.getBoolean(KEY_ENABLE_PA, true);
            enableLaunchLog = args.getBoolean(KEY_ENABLE_LAUNCH, true);
            enableMemLog = args.getBoolean(KEY_ENABLE_MEM, true);
        }
    }

    public static void enableMemoryMonitor(boolean enable) {
        UMMemoryMonitor.get().setEnable(enable);
    }

    public static void init(final Context context, String appkey, String channel) {
        block37: {
            block36: {
                if (context == null || appkey == null) {
                    Log.e((String)TAG, (String)"context is null or appkey is null, init failed.");
                    return;
                }
                mContext = context;
                try {
                    Bundle customInfo = new Bundle();
                    customInfo.putBoolean("mDebug", isDebug);
                    customInfo.putBoolean("mEncryptLog", isEncrypt);
                    customInfo.putBoolean("mZipLog", isZip);
                    customInfo.putBoolean(KEY_ENABLE_CRASH_JAVA, enableJavaLog);
                    customInfo.putBoolean(KEY_ENABLE_CRASH_NATIVE, enableNativeLog);
                    customInfo.putBoolean(KEY_ENABLE_ANR, enableANRLog);
                    customInfo.putBoolean(KEY_ENABLE_CRASH_UNEXP, false);
                    customInfo.putBoolean("mIsInternational", isIntl);
                    CrashApi mCrashApi = CrashApi.createInstanceEx((Context)context, (String)appkey, (boolean)isDebug, (Bundle)customInfo, (ICrashClient)new CrashClientImpl());
                    if (mCrashApi != null) {
                        mCrashApi.addHeaderInfo(KEY_HEADER_APPKEY, appkey);
                        mCrashApi.addHeaderInfo(KEY_HEADER_CHANNEL, channel);
                        mCrashApi.addHeaderInfo(KEY_HEADER_OS, "android");
                        mCrashApi.addHeaderInfo(KEY_HEADER_CRASH_VERSION, crashSdkVersion);
                        mCrashApi.addHeaderInfo(KEY_HEADER_UMID, UMCrash.getUMID(context));
                        try {
                            String[] strings = UMCrashUtils.getActiveUser(context);
                            if (strings != null && strings.length == 2) {
                                mCrashApi.addHeaderInfo(KEY_HEADER_PUID, strings[1]);
                                mCrashApi.addHeaderInfo(KEY_HEADER_PROVIDER, strings[0]);
                            }
                        }
                        catch (Throwable e) {
                            mCrashApi.addHeaderInfo(KEY_HEADER_PUID, "");
                            mCrashApi.addHeaderInfo(KEY_HEADER_PROVIDER, "");
                        }
                        mCrashApi.addHeaderInfo(KEY_HEADER_CARRIER, UMCrashUtils.getNetworkOperatorName(context));
                        if (!TextUtils.isEmpty((CharSequence)userBver)) {
                            mCrashApi.addHeaderInfo(KEY_HEADER_BVER, userBver);
                        }
                        if (!TextUtils.isEmpty((CharSequence)userBsver)) {
                            mCrashApi.addHeaderInfo(KEY_HEADER_BSVER, userBsver);
                        }
                        if (!TextUtils.isEmpty((CharSequence)userBesrial)) {
                            mCrashApi.addHeaderInfo(KEY_HEADER_BESRIAL, userBesrial);
                        }
                        try {
                            String[] access = NetworkUtil.getNetworkAccessMode((Context)context);
                            if ("Wi-Fi".equals(access[0])) {
                                mCrashApi.addHeaderInfo(KEY_HEADER_ACCESS, "wifi");
                            } else if ("2G/3G".equals(access[0])) {
                                mCrashApi.addHeaderInfo(KEY_HEADER_ACCESS, "2G/3G");
                            } else {
                                mCrashApi.addHeaderInfo(KEY_HEADER_ACCESS, "unknow");
                            }
                            if (!"".equals(access[1])) {
                                mCrashApi.addHeaderInfo(KEY_HEADER_ACCESS_SUBTYPE, access[1]);
                            }
                            int netType = NetworkUtil.getNetworkTypeUmeng((Context)context);
                            mCrashApi.addHeaderInfo(KEY_HEADER_NETWORK_TYPE, "" + netType);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        if (context instanceof Application) {
                            ((Application)context).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                                    UMCrash.saveActivityState(activity.getLocalClassName(), UMCrash.KEY_ACTIITY_ON_CREATED);
                                }

                                public void onActivityStarted(Activity activity) {
                                    UMCrash.saveActivityState(activity.getLocalClassName(), UMCrash.KEY_ACTIITY_ON_STARTED);
                                    UMMemoryMonitor.get().onActivityStarted(activity);
                                }

                                public void onActivityResumed(Activity activity) {
                                    UMCrash.saveActivityState(activity.getLocalClassName(), UMCrash.KEY_ACTIITY_ON_RESUMED);
                                    UMMemoryMonitor.get().onActivityResumed(activity);
                                }

                                public void onActivityPaused(Activity activity) {
                                    UMCrash.saveActivityState(activity.getLocalClassName(), UMCrash.KEY_ACTIITY_ON_PAUSED);
                                }

                                public void onActivityStopped(Activity activity) {
                                    UMCrash.saveActivityState(activity.getLocalClassName(), UMCrash.KEY_ACTIITY_ON_STOPPED);
                                    UMMemoryMonitor.get().onActivityStopped(activity);
                                }

                                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                                }

                                public void onActivityDestroyed(Activity activity) {
                                    UMCrash.saveActivityState(activity.getLocalClassName(), UMCrash.KEY_ACTIITY_ON_DESTROYED);
                                }
                            });
                            int logType = 0x100011;
                            mCrashApi.registerInfoCallback(KEY_CALLBACK_UMID, logType);
                            mCrashApi.registerInfoCallback(KEY_CALLBACK_PAGE_ACTION, logType);
                        } else {
                            Log.e((String)TAG, (String)"context not instanceof application.");
                        }
                        break block36;
                    }
                    Log.e((String)TAG, (String)"create CrashAPI is null.");
                }
                catch (Throwable customInfo) {
                    // empty catch block
                }
            }
            try {
                UMCrash.initReporter(context, appkey, channel);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                if (enablePaLog) {
                    PAFactory.Builder builder = new PAFactory.Builder(context.getApplicationContext(), new IEfsReporter(){

                        public EfsReporter getReporter() {
                            return sReporter;
                        }
                    });
                    builder.packageLevel(PackageLevel.RELEASE);
                    PAFactory paFactory = builder.build();
                    paFactory.getPaInstance().start();
                    isPA = paFactory.getConfigManager().enableTracer();
                } else {
                    Log.e((String)TAG, (String)"enablePaLog is false");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                if (enableLaunchLog) {
                    LaunchManager.init((Context)context, (EfsReporter)sReporter);
                    try {
                        isLa = LaunchManager.getLaunchConfigManager().enableTracer();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    String umid = UMUtils.getUMId((Context)context);
                    if (umid == null || TextUtils.isEmpty((CharSequence)umid)) {
                        if (isDebug) {
                            Log.i((String)TAG, (String)"begin register common callback.  key is umid.");
                        }
                        ImprintHandler.getImprintService((Context)context).registImprintCallback("umid", new UMImprintChangeCallback(){

                            public void onImprintValueChanged(String key, String value) {
                                if (isDebug) {
                                    Log.i((String)TAG, (String)("common callback.  key is " + key + "; value is " + value));
                                }
                                try {
                                    if ("umid".equals(key)) {
                                        LaunchManager.sendLaunchCache((Context)context, (String)value);
                                        ImprintHandler.getImprintService((Context)context).unregistImprintCallback("umid", (UMImprintChangeCallback)this);
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    break block37;
                }
                Log.e((String)TAG, (String)"enableLaunchLog is false");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        try {
            if (enableMemLog) {
                UMMemoryMonitor.get().start(context, sReporter);
            } else {
                Log.e((String)TAG, (String)"enableMemLog is false");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void saveActivityState(String className, String methodName) {
        try {
            if (mArrayList != null) {
                if (mArrayList.size() >= 20) {
                    mArrayList.remove(0);
                }
                mArrayList.add(className + "-" + System.currentTimeMillis() + "-" + methodName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void initReporter(Context context, String appkey, String channel) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(KEY_HEADER_UMID, UMCrash.getUMID(context));
        params.put(KEY_HEADER_CHANNEL, channel);
        params.put(KEY_HEADER_CARRIER, UMCrashUtils.getNetworkOperatorName(context));
        params.put(KEY_HEADER_OS, "android");
        params.put(KEY_HEADER_CRASH_VERSION, crashSdkVersion);
        try {
            String[] strings = UMCrashUtils.getActiveUser(context);
            if (strings != null && strings.length == 2) {
                params.put(KEY_HEADER_PUID, strings[1]);
                params.put(KEY_HEADER_PROVIDER, strings[0]);
            }
        }
        catch (Throwable e) {
            params.put(KEY_HEADER_PUID, "");
            params.put(KEY_HEADER_PROVIDER, "");
        }
        if (!TextUtils.isEmpty((CharSequence)userBver)) {
            params.put(KEY_HEADER_BVER, userBver);
        }
        if (!TextUtils.isEmpty((CharSequence)userBsver)) {
            params.put(KEY_HEADER_BSVER, userBsver);
        }
        if (!TextUtils.isEmpty((CharSequence)userBesrial)) {
            params.put(KEY_HEADER_BESRIAL, userBesrial);
        }
        sReporter = new EfsReporter.Builder(context.getApplicationContext(), appkey, KEY_APM_DEFAULT_SECRET).debug(isDebug).efsDirRootName(KEY_APM_ROOT_NAME).printLogDetail(isDebug).intl(isIntl).build();
        sReporter.addPublicParams(params);
    }

    public static void registerUMCrashCallback(UMCrashCallback umCrashCallback) {
        if (umCrashCallback != null) {
            mUMCrashCallback = umCrashCallback;
            if (CrashApi.getInstance() != null) {
                int logType = 0x100011;
                CrashApi.getInstance().registerInfoCallback(KEY_CALLBACK_USER_STRING, logType);
            } else {
                Log.e((String)TAG, (String)"callback error, instance is null.");
            }
        } else {
            Log.e((String)TAG, (String)"callback error.");
        }
    }

    public static void generateCustomLog(Throwable e, String type) {
        if (e == null || TextUtils.isEmpty((CharSequence)type)) {
            Log.e((String)TAG, (String)"generate custom log failed ! e is null or type is empty");
            return;
        }
        try {
            CustomLogInfo customLogInfo = new UMCustomLogInfoBuilder(type).stack(e).build();
            ArrayList<String> mCallbacks = new ArrayList<String>();
            mCallbacks.add(KEY_CALLBACK_UMID);
            mCallbacks.add(KEY_CALLBACK_PAGE_ACTION);
            customLogInfo.mCallbacks = mCallbacks;
            CrashApi mCrashApi = CrashApi.getInstance();
            if (mCrashApi == null) {
                Log.e((String)TAG, (String)"CrashApi is null, not init .");
            } else {
                mCrashApi.generateCustomLog(customLogInfo);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void generateCustomLog(String e, String type) {
        if (TextUtils.isEmpty((CharSequence)e) || TextUtils.isEmpty((CharSequence)type)) {
            Log.e((String)TAG, (String)"generate custom log failed ! e is null or type is empty");
            return;
        }
        try {
            CustomLogInfo info = new CustomLogInfo(null, "exception");
            ArrayList<String> mCallbacks = new ArrayList<String>();
            mCallbacks.add(KEY_CALLBACK_UMID);
            mCallbacks.add(KEY_CALLBACK_PAGE_ACTION);
            info.mCallbacks = mCallbacks;
            HashMap<String, String> kvInfoMap = new HashMap<String, String>(20);
            kvInfoMap.put("k_ct", "exception");
            kvInfoMap.put("k_ac", type);
            StringBuffer sb = new StringBuffer();
            for (Map.Entry entry : kvInfoMap.entrySet()) {
                sb.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\n");
            }
            String stack = "Exception message:\nBack traces starts.\n" + e + "\n" + "Back traces ends.";
            if (!TextUtils.isEmpty((CharSequence)stack)) {
                sb.append(stack).append("\n");
            }
            info.mData = sb;
            CrashApi mCrashApi = CrashApi.getInstance();
            if (mCrashApi == null) {
                Log.e((String)TAG, (String)"CrashApi is null, not init .");
            } else {
                mCrashApi.generateCustomLog(info);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        isDebug = true;
        isEncrypt = false;
        isZip = true;
        isIntl = false;
        crashSdkVersion = "1.4.0";
        pageArrayLock = new Object();
        mArrayList = new ArrayList(10);
        isPA = false;
        isLa = false;
        enableJavaLog = true;
        enableNativeLog = true;
        enableANRLog = true;
        enablePaLog = true;
        enableLaunchLog = true;
        enableMemLog = true;
    }

    private static class CrashClientImpl
    implements ICrashClient {
        private CrashClientImpl() {
        }

        public void onLogGenerated(File file, String s) {
        }

        public void onClientProcessLogGenerated(String s, File file, String s1) {
        }

        public File onBeforeUploadLog(File file) {
            return file;
        }

        public void onCrashRestarting(boolean b) {
        }

        public void onAddCrashStats(String s, int i, int i1) {
        }

        public String onGetCallbackInfo(String category, boolean b) {
            if (UMCrash.KEY_CALLBACK_PAGE_ACTION.equals(category)) {
                String result = null;
                try {
                    if (mArrayList != null && mArrayList.size() > 0) {
                        JSONObject jsonSec = new JSONObject();
                        jsonSec.put("source", 0);
                        jsonSec.put("action_name", (Object)"page_view");
                        JSONArray jsonParameter = new JSONArray();
                        for (int i = 0; i < mArrayList.size(); ++i) {
                            String item = (String)mArrayList.get(i);
                            if (item == null) continue;
                            JSONObject jsonitem = new JSONObject();
                            jsonitem.put("name", (Object)item);
                            jsonParameter.put((Object)jsonitem);
                        }
                        jsonSec.put("action_parameter", (Object)jsonParameter);
                        result = jsonSec.toString();
                        if (isDebug) {
                            Log.i((String)TAG, (String)("page json is " + result));
                        }
                    }
                }
                catch (Throwable jsonSec) {
                    // empty catch block
                }
                return result;
            }
            if (UMCrash.KEY_CALLBACK_UMID.equals(category)) {
                return UMCrash.getUMID(mContext);
            }
            if (UMCrash.KEY_CALLBACK_USER_STRING.equals(category)) {
                if (mUMCrashCallback != null) {
                    String callbackString = mUMCrashCallback.onCallback();
                    if (callbackString == null) {
                        return null;
                    }
                    int len = callbackString.trim().getBytes().length;
                    if (len > 256) {
                        callbackString = UMCrashUtils.splitByByte(callbackString, 256);
                    }
                    return callbackString;
                }
                return null;
            }
            return null;
        }
    }
}

