/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.base;

import android.app.Application;
import android.content.Context;
import android.os.Message;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Pair;
import android.webkit.ValueCallback;
import com.efs.sdk.base.IConfigRefreshAction;
import com.efs.sdk.base.core.b.a;
import com.efs.sdk.base.core.config.GlobalEnvStruct;
import com.efs.sdk.base.core.config.a.c;
import com.efs.sdk.base.core.controller.ControllerCenter;
import com.efs.sdk.base.core.util.a;
import com.efs.sdk.base.core.util.d;
import com.efs.sdk.base.http.HttpResponse;
import com.efs.sdk.base.observer.IConfigCallback;
import com.efs.sdk.base.observer.IEfsReporterObserver;
import com.efs.sdk.base.processor.action.ILogEncryptAction;
import com.efs.sdk.base.protocol.ILogProtocol;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EfsReporter {
    private static ControllerCenter sControllerCenter = null;

    private EfsReporter(Builder builder) {
        sControllerCenter = new ControllerCenter(builder);
    }

    @NonNull
    private GlobalEnvStruct getGlobalEnvStruct() {
        return ControllerCenter.getGlobalEnvStruct();
    }

    public void send(ILogProtocol iLogProtocol) {
        sControllerCenter.send(iLogProtocol);
    }

    public HttpResponse sendSyncImediatelly(String string, int n, String string2, File file) {
        return this.sendSyncImediatelly(string, n, string2, true, file);
    }

    public HttpResponse sendSyncImediatelly(String string, int n, String string2, boolean bl, File file) {
        return sControllerCenter.sendSyncImmediately(string, n, string2, bl, file);
    }

    public void getAllSdkConfig(String[] object, IConfigCallback stringArray) {
        String[] stringArray2 = stringArray;
        stringArray = object;
        object = c.a();
        ((c)object).e.put((IConfigCallback)stringArray2, stringArray);
        if (!((c)object).d.e.isEmpty()) {
            ((c)object).d();
        }
    }

    public Map<String, String> getAllConfig() {
        return c.a().c();
    }

    public Map<String, Object> getAllSdkConfig() {
        c c2 = c.a();
        return new HashMap<String, Object>(c2.d.e);
    }

    public void flushRecordLogImmediately(String object) {
        String string = object;
        object = a.b.a().c.a((byte)1);
        if (object != null) {
            object.a(string);
        }
    }

    public void refreshConfig(String string) {
        c.a().a(string);
    }

    public void setEnableRefreshConfigFromRemote(boolean bl) {
        c.a().c = bl;
    }

    public void addPublicParams(@NonNull Map<String, String> map) {
        if (map.size() > 0) {
            this.getGlobalEnvStruct().addPublicParams(map);
        }
    }

    public void registerCallback(int n, ValueCallback<Pair<Message, Message>> valueCallback) {
        this.getGlobalEnvStruct().registerCallback(n, valueCallback);
    }

    public static class Builder {
        private final String TAG = "efs.reporter.builder";
        private GlobalEnvStruct mGlobalEnvStruct;
        private static Map<String, EfsReporter> sInstanceMap = new ConcurrentHashMap<String, EfsReporter>();
        private static boolean sUseAppContext = true;

        public Builder(@NonNull Application application, @NonNull String string, @NonNull String string2) {
            this(application.getApplicationContext(), string, string2);
        }

        public Builder(@NonNull Context context, @NonNull String string, @NonNull String string2) {
            context = Builder.checkContext(context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new RuntimeException("EfsReporter init, appid is empty");
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new RuntimeException("EfsReporter init, secret is empty");
            }
            this.mGlobalEnvStruct = new GlobalEnvStruct();
            this.mGlobalEnvStruct.mAppContext = context;
            this.mGlobalEnvStruct.setAppid(string);
            this.mGlobalEnvStruct.setSecret(string2);
        }

        public Builder uid(String string) {
            this.mGlobalEnvStruct.setUid(string);
            return this;
        }

        public Builder debug(boolean bl) {
            this.mGlobalEnvStruct.setDebug(bl);
            return this;
        }

        public Builder enableWaStat(boolean bl) {
            this.mGlobalEnvStruct.setEnableWaStat(bl);
            return this;
        }

        public Builder printLogDetail(boolean bl) {
            this.mGlobalEnvStruct.setPrintLogDetail(bl);
            return this;
        }

        public Builder publicParams(@NonNull IPublicParams iPublicParams) {
            if (iPublicParams.getRecordHeaders() != null && iPublicParams.getRecordHeaders().size() > 0) {
                this.mGlobalEnvStruct.addPublicParams(iPublicParams.getRecordHeaders());
            }
            return this;
        }

        public Builder publicParams(@NonNull Map<String, String> map) {
            if (map.size() > 0) {
                this.mGlobalEnvStruct.addPublicParams(map);
            }
            return this;
        }

        public Builder logEncryptAction(ILogEncryptAction iLogEncryptAction) {
            this.mGlobalEnvStruct.setLogEncryptAction(iLogEncryptAction);
            return this;
        }

        public Builder configRefreshDelayMills(long l) {
            this.mGlobalEnvStruct.configRefreshDelayMills = l;
            return this;
        }

        public Builder configRefreshAction(@NonNull IConfigRefreshAction iConfigRefreshAction) {
            c.a().b = iConfigRefreshAction;
            return this;
        }

        public Builder maxConcurrentUploadCnt(int n) {
            com.efs.sdk.base.core.c.d.a().a = n;
            return this;
        }

        public Builder addEfsReporterObserver(IEfsReporterObserver iEfsReporterObserver) {
            this.mGlobalEnvStruct.addConfigObserver(iEfsReporterObserver);
            return this;
        }

        public Builder intl(boolean bl) {
            this.mGlobalEnvStruct.setIsIntl(bl);
            return this;
        }

        public Builder efsDirRootName(String string) {
            a.a(string);
            return this;
        }

        public Builder enableSendLog(boolean bl) {
            this.mGlobalEnvStruct.setEnableSendLog(bl);
            return this;
        }

        public GlobalEnvStruct getGlobalEnvStruct() {
            return this.mGlobalEnvStruct;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public EfsReporter build() {
            String string = this.getGlobalEnvStruct().getAppid();
            if (!sInstanceMap.containsKey(string)) {
                Class<EfsReporter> clazz = EfsReporter.class;
                // MONITORENTER : com.efs.sdk.base.EfsReporter.class
                if (!sInstanceMap.containsKey(string)) {
                    EfsReporter efsReporter = new EfsReporter(this);
                    sInstanceMap.put(string, efsReporter);
                    // MONITOREXIT : clazz
                    return efsReporter;
                }
                // MONITOREXIT : clazz
            }
            d.a("efs.reporter.builder", "efs-core: duplicate init", null);
            this.checkParam(string);
            return sInstanceMap.get(string);
        }

        private void checkParam(String object) {
            object = Builder.sInstanceMap.get(object).getGlobalEnvStruct();
            String string = "efs-core: duplicate init, but ";
            if (!((GlobalEnvStruct)object).mAppContext.equals(this.getGlobalEnvStruct().mAppContext)) {
                throw new RuntimeException(string + "application context is different");
            }
            if (!TextUtils.isEmpty((CharSequence)((GlobalEnvStruct)object).getSecret()) && !((GlobalEnvStruct)object).getSecret().equals(this.getGlobalEnvStruct().getSecret())) {
                throw new RuntimeException(string + "secret is different");
            }
            if (((GlobalEnvStruct)object).isIntl() != this.getGlobalEnvStruct().isIntl()) {
                throw new RuntimeException(string + "intl setting is different");
            }
            if (!TextUtils.isEmpty((CharSequence)this.getGlobalEnvStruct().getUid()) && !this.getGlobalEnvStruct().getUid().equals(((GlobalEnvStruct)object).getUid())) {
                d.a("efs.reporter.builder", string + " uid is different", null);
            }
            if (this.getGlobalEnvStruct().getPublicParamMap() != null && this.getGlobalEnvStruct().getPublicParamMap().size() > 0) {
                ((GlobalEnvStruct)object).addPublicParams(this.getGlobalEnvStruct().getPublicParamMap());
            }
        }

        private static Context checkContext(Context object) {
            if (object == null) {
                object = "context can not be null!";
                d.b("efs.base", (String)object, null);
                throw new NullPointerException();
            }
            if (!(!sUseAppContext || object instanceof Application || (object = object.getApplicationContext()) != null && object instanceof Application)) {
                object = "Can not get Application context from given context!";
                d.b("efs.base", (String)object, null);
                throw new IllegalArgumentException("Can not get Application context from given context!");
            }
            return object;
        }

        public static interface IPublicParams {
            public Map<String, String> getRecordHeaders();
        }
    }
}

