/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.innner.umcrash;

import android.os.Looper;
import java.util.HashMap;
import java.util.Map;

public class UMCrashUtil {
    private static final String TAG = "UMCrashUtil";
    private static final int MAX_THREAD_TRACE_LENGTH = 20480;

    public static Map<String, String> getAllThreadTraces() {
        HashMap<String, String> threadTraceMap = new HashMap<String, String>();
        try {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            if (allStackTraces == null) {
                return null;
            }
            Thread thread = Looper.getMainLooper().getThread();
            if (!allStackTraces.containsKey(thread)) {
                allStackTraces.put(thread, thread.getStackTrace());
            }
            long id = Thread.currentThread().getId();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                if (id == entry.getKey().getId()) continue;
                sb.setLength(0);
                if (entry.getValue() == null || entry.getValue().length == 0) continue;
                for (StackTraceElement stackTraceElement : entry.getValue()) {
                    if (sb.length() >= 20480) {
                        sb.append("\n[Stack trace size must be less than :").append(20480).append("!]");
                        break;
                    }
                    sb.append("  at ").append(stackTraceElement.toString()).append("\n");
                }
                threadTraceMap.put(entry.getKey().getName() + "(" + entry.getKey().getId() + ")", sb.toString());
            }
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
        return threadTraceMap;
    }
}

