/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.umcrash.customlog;

import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.umeng.umcrash.UMCrashUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class UAPMCustomLogManager {
    private static final String TAG = "UAPMCustomLogManager";
    private static final int MAX_CACHE_SIZE = 100;
    private static final int MAX_TAG_LENGTH = 64;
    private static final int MAX_MSG_LENGTH = 2048;
    private static int sCacheSize = 100;
    private static final JSONArray jsonObjects = new JSONArray();

    private static boolean checkParams(String tag, String msg) {
        if (TextUtils.isEmpty((CharSequence)tag) || TextUtils.isEmpty((CharSequence)msg)) {
            Log.e((String)TAG, (String)"tag or msg is empty");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCustomLogs(String tag, String message, int level) {
        Class<UAPMCustomLogManager> clazz = UAPMCustomLogManager.class;
        synchronized (UAPMCustomLogManager.class) {
            try {
                if (tag.length() > 64) {
                    tag = UMCrashUtils.splitByByte(tag, 64);
                }
                if (message.length() > 2048) {
                    message = UMCrashUtils.splitByByte(message, 2048);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("tag", (Object)tag);
                jsonObject.put("msg", (Object)message);
                jsonObject.put("l", level);
                jsonObject.put("t", System.currentTimeMillis());
                jsonObject.put("pid", Process.myPid());
                jsonObject.put("tid", Process.myTid());
                if (jsonObjects.length() >= sCacheSize) {
                    if (Build.VERSION.SDK_INT >= 19) {
                        jsonObjects.remove(0);
                        jsonObjects.put((Object)jsonObject);
                    }
                } else {
                    jsonObjects.put((Object)jsonObject);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
    }

    public static void v(String tag, String msg) {
        if (UAPMCustomLogManager.checkParams(tag, msg)) {
            Log.v((String)tag, (String)msg);
            UAPMCustomLogManager.addCustomLogs(tag, msg, 0);
        }
    }

    public static void d(String tag, String msg) {
        if (UAPMCustomLogManager.checkParams(tag, msg)) {
            Log.d((String)tag, (String)msg);
            UAPMCustomLogManager.addCustomLogs(tag, msg, 1);
        }
    }

    public static void i(String tag, String msg) {
        if (UAPMCustomLogManager.checkParams(tag, msg)) {
            Log.i((String)tag, (String)msg);
            UAPMCustomLogManager.addCustomLogs(tag, msg, 2);
        }
    }

    public static void w(String tag, String msg) {
        if (UAPMCustomLogManager.checkParams(tag, msg)) {
            Log.w((String)tag, (String)msg);
            UAPMCustomLogManager.addCustomLogs(tag, msg, 3);
        }
    }

    public static void e(String tag, String msg) {
        if (UAPMCustomLogManager.checkParams(tag, msg)) {
            Log.e((String)tag, (String)msg);
            UAPMCustomLogManager.addCustomLogs(tag, msg, 4);
        }
    }

    public static void setCache(int size) {
        if (size > 100) {
            Log.e((String)TAG, (String)"size should be less than 100");
        }
        sCacheSize = Math.min(size, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCustomLogs() {
        Class<UAPMCustomLogManager> clazz = UAPMCustomLogManager.class;
        synchronized (UAPMCustomLogManager.class) {
            try {
                // ** MonitorExit[var0] (shouldn't be in output)
                return jsonObjects.toString();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                // ** MonitorExit[var0] (shouldn't be in output)
                return "";
            }
        }
    }
}

