/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.umcrash;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.efs.sdk.base.core.util.concurrent.WorkThreadUtil;
import com.uc.crashsdk.export.CrashApi;
import com.umeng.umcrash.UMCrash;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Random;

public class UMCrashUtils {
    private static final int DEF_CLOSE_RATE = 0;
    private static final int MAX_TRACE_RATE = 100;
    public static final String UNKNOW = "";

    public static boolean random(int rate) {
        if (rate == 0) {
            return false;
        }
        if (rate == 100) {
            return true;
        }
        Random random = new Random();
        int next = random.nextInt(100);
        return next <= rate;
    }

    public static void saveInnerConfig(Context context, String key, Object value) {
        try {
            SharedPreferences.Editor editor;
            SharedPreferences sp;
            if (context != null && !TextUtils.isEmpty((CharSequence)key) && value != null && (sp = context.getSharedPreferences("um_umcrash", 0)) != null && (editor = sp.edit()) != null) {
                editor.putInt(key, Integer.parseInt(value.toString()));
                editor.commit();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static int getInnerConfig(Context context, String key, int defa) {
        try {
            SharedPreferences sp;
            if (context != null && !TextUtils.isEmpty((CharSequence)key) && (sp = context.getSharedPreferences("um_umcrash", 0)) != null) {
                defa = sp.getInt(key, defa);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return defa;
    }

    public static void setCommonTag(String key, String value) {
        try {
            Method method;
            Class<?> clazzEnum;
            Class<?> clazz = Class.forName("com.umeng.commonsdk.UMConfigure");
            if (clazz != null && (clazzEnum = Class.forName("com.umeng.commonsdk.UMConfigure$BS_TYPE")) != null && (method = clazz.getDeclaredMethod("setModuleTag", clazzEnum, String.class, String.class)) != null) {
                Enum[] enumConstants;
                method.setAccessible(true);
                for (Enum item : enumConstants = (Enum[])clazzEnum.getEnumConstants()) {
                    if (item == null || !item.name().equals("APM")) continue;
                    method.invoke(clazz, item, key, value);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static boolean isHarmony(final Context context) {
        try {
            final SharedPreferences sp = context.getSharedPreferences("um_umcrash", 0);
            if (sp.contains("um_apm_harmony")) {
                return sp.getBoolean("um_apm_harmony", false);
            }
            WorkThreadUtil.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        int id = Resources.getSystem().getIdentifier("config_os_brand", "string", "android");
                        boolean isHarmony = context.getString(id).equals("harmony");
                        sp.edit().putBoolean("um_apm_harmony", isHarmony).apply();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String[] getActiveUser(Context context) {
        if (context == null) {
            return null;
        }
        String[] activeUser = null;
        Class<?> mClass = null;
        try {
            mClass = Class.forName("com.umeng.commonsdk.utils.UMUtils");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (mClass != null) {
            Method umConfigMethed = null;
            try {
                umConfigMethed = mClass.getMethod("getActiveUser", Context.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (umConfigMethed != null) {
                try {
                    Object o = umConfigMethed.invoke(null, context);
                    if (o != null) {
                        activeUser = (String[])o;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return activeUser;
    }

    public static void setPuidAndProvider(String puid, String provider) {
        if (CrashApi.getInstance() != null) {
            CrashApi.getInstance().addHeaderInfo("um_app_puid", puid);
            CrashApi.getInstance().addHeaderInfo("um_app_provider", provider);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("um_app_puid", puid);
        params.put("um_app_provider", provider);
        if (UMCrash.getReporter() != null) {
            UMCrash.getReporter().addPublicParams(params);
        }
    }

    public static void setIntegrationTesingParams(String debugKey) {
        if (CrashApi.getInstance() != null) {
            CrashApi.getInstance().addHeaderInfo("um_dk", debugKey);
        }
        if (UMCrash.getReporter() != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("um_dk", debugKey);
            UMCrash.getReporter().addPublicParams(params);
        }
    }

    public static String getNetworkOperatorName(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (UMCrashUtils.checkPermission(context, "android.permission.READ_PHONE_STATE") && tm != null) {
                return tm.getNetworkOperatorName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return UNKNOW;
    }

    public static boolean checkPermission(Context context, String permission2) {
        boolean result;
        block7: {
            result = false;
            if (context == null) {
                return result;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Class<?> clazz = Class.forName("android.content.Context");
                    Method method = clazz.getMethod("checkSelfPermission", String.class);
                    int rest = (Integer)method.invoke((Object)context, permission2);
                    if (rest == 0) {
                        result = true;
                        break block7;
                    }
                    result = false;
                }
                catch (Throwable e) {
                    result = false;
                }
            } else {
                PackageManager pm = context.getPackageManager();
                if (pm.checkPermission(permission2, context.getPackageName()) == 0) {
                    result = true;
                }
            }
        }
        return result;
    }

    public static String splitByByte(String srcStr, int length) {
        StringBuffer sb = new StringBuffer(length);
        try {
            String tempStr;
            byte[] b;
            int srcLength = srcStr.length();
            int tempLength = 0;
            for (int i = 0; i < srcLength && length >= (tempLength += (b = (tempStr = String.valueOf(srcStr.charAt(i))).getBytes()).length); ++i) {
                sb.append(tempStr);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sb.toString();
    }
}

