/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.net;

import android.content.Context;
import com.efs.sdk.base.EfsReporter;
import com.efs.sdk.base.core.util.Log;
import com.efs.sdk.net.NetConfigManager;
import com.efs.sdk.net.OkHttpInterceptor;
import com.efs.sdk.net.OkHttpListener;
import java.util.Map;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class NetManager {
    private static final String TAG = "OkHttpManager";
    private static EfsReporter mReporter;
    private static NetConfigManager mNetConfigManager;

    public static EfsReporter getReporter() {
        return mReporter;
    }

    public static NetConfigManager getNetConfigManager() {
        return mNetConfigManager;
    }

    public static void init(Context context, EfsReporter efsReporter) {
        if (context == null || efsReporter == null) {
            Log.e((String)TAG, (String)"init net manager error! parameter is null!");
            return;
        }
        mReporter = efsReporter;
        mNetConfigManager = new NetConfigManager(context, efsReporter);
    }

    public static void get(String string, Callback callback) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().eventListenerFactory(OkHttpListener.get()).addNetworkInterceptor((Interceptor)new OkHttpInterceptor()).build();
        string = new Request.Builder().url(string).build();
        okHttpClient.newCall((Request)string).enqueue(callback);
    }

    public static void post(String string, Map<String, Object> map, Callback callback) {
        String string22;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string22 : map.keySet()) {
            stringBuilder.append(string22).append("=").append(map.get(string22)).append("&");
        }
        OkHttpClient okHttpClient = new OkHttpClient.Builder().eventListenerFactory(OkHttpListener.get()).addNetworkInterceptor((Interceptor)new OkHttpInterceptor()).build();
        string22 = RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (String)stringBuilder.toString());
        string = new Request.Builder().url(string).post((RequestBody)string22).build();
        okHttpClient.newCall((Request)string).enqueue(callback);
    }

    public static void postJson(String string, String string2, Callback callback) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().eventListenerFactory(OkHttpListener.get()).addNetworkInterceptor((Interceptor)new OkHttpInterceptor()).build();
        string2 = RequestBody.create((String)string2, (MediaType)MediaType.parse((String)"application/json;charset=utf-8"));
        string = new Request.Builder().url(string).post((RequestBody)string2).build();
        okHttpClient.newCall((Request)string).enqueue(callback);
    }
}

