/*
 * Decompiled with CFR 0.152.
 */
package com.uc.crashsdk.export;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.webkit.ValueCallback;
import com.uc.crashsdk.JNIBridge;
import com.uc.crashsdk.a;
import com.uc.crashsdk.a.h;
import com.uc.crashsdk.b;
import com.uc.crashsdk.d;
import com.uc.crashsdk.e;
import com.uc.crashsdk.export.CustomInfo;
import com.uc.crashsdk.export.CustomLogInfo;
import com.uc.crashsdk.export.DumpFileInfo;
import com.uc.crashsdk.export.ICrashClient;
import com.uc.crashsdk.export.LogType;
import com.uc.crashsdk.export.VersionInfo;
import com.uc.crashsdk.g;
import java.util.concurrent.Callable;

public class CrashApi {
    private static CrashApi a = null;
    private boolean b = false;
    private static boolean c = true;
    private static boolean d = false;

    public static synchronized CrashApi createInstance(Context context, CustomInfo customInfo, VersionInfo versionInfo, ICrashClient iCrashClient, boolean bl, boolean bl2, boolean bl3) {
        if (a == null) {
            a = new CrashApi(context, customInfo, versionInfo, iCrashClient, bl, bl2, bl3);
        }
        return a;
    }

    public static CrashApi createInstanceEx(Context context, String string, boolean bl) {
        return CrashApi.createInstanceEx(context, string, bl, null);
    }

    public static CrashApi createInstanceEx(Context context, String string, boolean bl, Bundle bundle) {
        return CrashApi.createInstanceEx(context, string, bl, bundle, null);
    }

    public static CrashApi createInstanceEx(Context context, String string, boolean bl, Bundle bundle, ICrashClient iCrashClient) {
        int n;
        if (a != null) {
            return a;
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        c = bundle.getBoolean("useApplicationContext", true);
        context = CrashApi.a(context);
        CrashApi.b(context);
        CustomInfo customInfo = new CustomInfo(string);
        new CustomInfo(string).mEnableStatReport = false;
        customInfo.mZipLog = true;
        customInfo.mPrintStackInfos = bl;
        bundle.putString("crver", "2.0");
        customInfo = g.a(customInfo, bundle);
        VersionInfo versionInfo = g.a(bundle);
        boolean bl2 = bundle.getBoolean("enableJavaLog", true);
        boolean bl3 = bundle.getBoolean("enableNativeLog", true);
        boolean bl4 = bundle.getBoolean("enableUnexpLog", com.uc.crashsdk.b.F());
        boolean bl5 = bundle.getBoolean("enableANRLog", true);
        CrashApi crashApi = CrashApi.createInstance(context, customInfo, versionInfo, iCrashClient, bl2, bl3, bl4);
        crashApi.disableLog(0x30000000);
        com.uc.crashsdk.b.a(bl5);
        if (bl3 || bl4) {
            if (e.e("libcrashsdk.so")) {
                crashApi.crashSoLoaded();
            } else {
                com.uc.crashsdk.a.a.d("crashsdk", "load libcrashsdk.so failed!");
            }
        }
        if ((n = bundle.getInt("uploadLogDelaySeconds", 15)) >= 0 && com.uc.crashsdk.b.F()) {
            e.b(n);
        }
        return crashApi;
    }

    public boolean registerCallback(int n, ValueCallback<Bundle> valueCallback) {
        if (valueCallback == null) {
            throw new NullPointerException();
        }
        switch (n) {
            case 1: {
                return com.uc.crashsdk.d.a(valueCallback);
            }
            case 2: {
                return com.uc.crashsdk.d.c(valueCallback);
            }
            case 3: {
                return com.uc.crashsdk.d.d(valueCallback);
            }
            case 4: {
                return com.uc.crashsdk.d.b(valueCallback);
            }
        }
        throw new IllegalArgumentException("Unknown event type: " + n);
    }

    public int updateCustomInfo(CustomInfo customInfo) {
        if (customInfo == null) {
            throw new NullPointerException();
        }
        return g.b(customInfo);
    }

    public int updateCustomInfo(Bundle bundle) {
        if (bundle == null) {
            throw new NullPointerException();
        }
        CustomInfo customInfo = g.a(null, bundle);
        return this.updateCustomInfo(customInfo);
    }

    public static CrashApi getInstance() {
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crashSoLoaded() {
        if (CrashApi.a("crashSoLoaded")) {
            return;
        }
        com.uc.crashsdk.b.f = true;
        CrashApi.b();
        Object object = com.uc.crashsdk.b.e;
        synchronized (object) {
            if (!com.uc.crashsdk.b.h || !com.uc.crashsdk.b.f) {
            } else if (!com.uc.crashsdk.b.c) {
                if (!com.uc.crashsdk.b.d) {
                    CrashApi.c();
                    g.d();
                }
                e.x();
                com.uc.crashsdk.b.c = true;
            }
        }
        com.uc.crashsdk.a.n();
        e.m();
    }

    public void updateVersionInfo(VersionInfo versionInfo) {
        if (versionInfo == null) {
            throw new NullPointerException();
        }
        g.a(versionInfo);
    }

    public void updateVersionInfo(Bundle bundle) {
        if (bundle == null) {
            throw new NullPointerException();
        }
        VersionInfo versionInfo = g.a(bundle);
        this.updateVersionInfo(versionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableLog(int n) {
        Object object = com.uc.crashsdk.b.e;
        synchronized (object) {
            com.uc.crashsdk.b.b(n);
            if (LogType.isForJava(n) && com.uc.crashsdk.b.a) {
                e.t();
                com.uc.crashsdk.b.a = false;
            }
            if (LogType.isForNative(n)) {
                if (com.uc.crashsdk.b.b) {
                    JNIBridge.cmd(9);
                    com.uc.crashsdk.b.b = false;
                } else {
                    com.uc.crashsdk.b.g = false;
                }
            }
            if (LogType.isForANR(n)) {
                com.uc.crashsdk.b.a(false);
            }
            if (LogType.isForUnexp(n)) {
                if (com.uc.crashsdk.b.c) {
                    if (e.z()) {
                        com.uc.crashsdk.b.c = false;
                    }
                } else {
                    com.uc.crashsdk.b.h = false;
                }
            }
            return;
        }
    }

    public boolean addStatInfo(String string, String string2) {
        if (CrashApi.a("addStatInfo")) {
            return false;
        }
        if (com.uc.crashsdk.a.g.a(string)) {
            throw new NullPointerException();
        }
        if (string.length() > 24) {
            throw new IllegalArgumentException("key is too long!");
        }
        if (string2 != null && string2.length() > 512) {
            string2 = string2.substring(0, 512);
        }
        return h.a(string, string2);
    }

    public String getCrashLogUploadUrl() {
        if (CrashApi.a("getCrashLogUploadUrl")) {
            return null;
        }
        return e.k();
    }

    public int getLastExitType() {
        if (CrashApi.a("getLastExitType")) {
            return 1;
        }
        return com.uc.crashsdk.b.I();
    }

    public int getLastExitTypeEx() {
        if (CrashApi.a("getLastExitTypeEx")) {
            return 1;
        }
        return com.uc.crashsdk.b.J();
    }

    public int getUnexpReason() {
        if (CrashApi.a("getUnexpReason")) {
            return 100;
        }
        return e.w();
    }

    public int reportCrashStats(boolean bl) {
        if (CrashApi.a("reportCrashStats")) {
            return 0;
        }
        if (g.O()) {
            com.uc.crashsdk.a.a.a("CrashApi::reportCrashStats. currentProcessOnly: " + bl);
        }
        e.d(bl);
        return e.e(bl);
    }

    public int resetCrashStats(boolean bl) {
        if (CrashApi.a("resetCrashStats")) {
            return 0;
        }
        if (g.O()) {
            com.uc.crashsdk.a.a.a("CrashApi::resetCrashStats. currentProcessOnly: " + bl);
        }
        return e.f(bl);
    }

    public void onExit() {
        com.uc.crashsdk.b.w();
    }

    public void setNewInstall() {
        if (CrashApi.a("setNewInstall")) {
            return;
        }
        com.uc.crashsdk.b.v();
    }

    public void setForeground(boolean bl) {
        com.uc.crashsdk.b.b(bl);
    }

    public void uploadCrashLogs() {
        if (CrashApi.a("uploadCrashLogs")) {
            return;
        }
        e.a(false, true);
    }

    public int registerThread(int n, String string) {
        return com.uc.crashsdk.a.a(n, string);
    }

    public boolean generateCustomLog(CustomLogInfo customLogInfo) {
        if (customLogInfo == null) {
            throw new NullPointerException();
        }
        if (customLogInfo.mData == null || customLogInfo.mLogType == null) {
            throw new NullPointerException("mData or mLogType is null!");
        }
        if (customLogInfo.mLogType.contains("_") || customLogInfo.mLogType.contains(" ")) {
            throw new IllegalArgumentException("mLogType can not contain char '_' and ' '");
        }
        StringBuilder stringBuilder = null;
        if (customLogInfo.mDumpTids != null && customLogInfo.mDumpTids.size() > 0) {
            stringBuilder = new StringBuilder();
            for (int n : customLogInfo.mDumpTids) {
                stringBuilder.append(n);
                stringBuilder.append(" ");
            }
        }
        long l = 0L;
        if (customLogInfo.mAddHeader) {
            l = 1L;
        }
        if (customLogInfo.mAddFooter) {
            l |= 2L;
        }
        if (customLogInfo.mAddLogcat) {
            l |= 4L;
        }
        if (customLogInfo.mAddThreadsDump) {
            l |= 8L;
        }
        if (customLogInfo.mAddBuildId) {
            l |= 0x10L;
        }
        if (customLogInfo.mUploadNow) {
            l |= 0x20L;
        }
        return e.a(customLogInfo.mData, customLogInfo.mLogType, l, customLogInfo.mDumpFiles, customLogInfo.mCallbacks, customLogInfo.mCachedInfos, stringBuilder != null ? stringBuilder.toString() : null);
    }

    public boolean generateCustomLog(StringBuffer stringBuffer, String string, Bundle bundle) {
        CustomLogInfo customLogInfo = new CustomLogInfo(stringBuffer, string);
        if (bundle != null) {
            customLogInfo.mAddHeader = bundle.getBoolean("mAddHeader", customLogInfo.mAddHeader);
            customLogInfo.mAddFooter = bundle.getBoolean("mAddFooter", customLogInfo.mAddFooter);
            customLogInfo.mAddLogcat = bundle.getBoolean("mAddLogcat", customLogInfo.mAddLogcat);
            customLogInfo.mUploadNow = bundle.getBoolean("mUploadNow", customLogInfo.mUploadNow);
            customLogInfo.mAddThreadsDump = bundle.getBoolean("mAddThreadsDump", customLogInfo.mAddThreadsDump);
            customLogInfo.mAddBuildId = bundle.getBoolean("mAddBuildId", customLogInfo.mAddBuildId);
            customLogInfo.mDumpFiles = bundle.getStringArrayList("mDumpFiles");
            customLogInfo.mCallbacks = bundle.getStringArrayList("mCallbacks");
            customLogInfo.mCachedInfos = bundle.getStringArrayList("mCachedInfos");
            customLogInfo.mDumpTids = bundle.getIntegerArrayList("mDumpTids");
        }
        return this.generateCustomLog(customLogInfo);
    }

    public void addHeaderInfo(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        com.uc.crashsdk.a.a(string, string2);
    }

    public int createCachedInfo(String string, int n, int n2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("capacity must > 0!");
        }
        if ((n2 & 0x100111) == 0) {
            return 0;
        }
        return com.uc.crashsdk.a.a(string, n, n2);
    }

    public int addCachedInfo(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        return com.uc.crashsdk.a.b(string, string2);
    }

    public int registerInfoCallback(String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        if ((n & 0x100111) == 0) {
            return 0;
        }
        return com.uc.crashsdk.a.a(string, n, null, 0L, 0);
    }

    public int registerInfoCallback(String string, int n, Callable<String> callable) {
        if (string == null || callable == null) {
            throw new NullPointerException();
        }
        if ((n & 0x100111) == 0) {
            return 0;
        }
        return com.uc.crashsdk.a.a(string, n, callable, 0L, 0);
    }

    public int addDumpFile(DumpFileInfo dumpFileInfo) {
        if (dumpFileInfo == null) {
            throw new NullPointerException();
        }
        if (dumpFileInfo.mCategory == null || dumpFileInfo.mFileTobeDump == null) {
            throw new NullPointerException();
        }
        if ((dumpFileInfo.mLogType & 0x100111) == 0) {
            return 0;
        }
        return com.uc.crashsdk.a.a(dumpFileInfo.mCategory, dumpFileInfo.mFileTobeDump, dumpFileInfo.mIsEncrypted, dumpFileInfo.mWriteCategory, dumpFileInfo.mLogType, dumpFileInfo.mDeleteAfterDump);
    }

    public int addDumpFile(String string, String string2, int n, Bundle bundle) {
        DumpFileInfo dumpFileInfo = new DumpFileInfo(string, string2, n);
        if (bundle != null) {
            dumpFileInfo.mIsEncrypted = bundle.getBoolean("mIsEncrypted", dumpFileInfo.mIsEncrypted);
            dumpFileInfo.mWriteCategory = bundle.getBoolean("mWriteCategory", dumpFileInfo.mWriteCategory);
            dumpFileInfo.mDeleteAfterDump = bundle.getBoolean("mDeleteAfterDump", dumpFileInfo.mDeleteAfterDump);
        }
        return this.addDumpFile(dumpFileInfo);
    }

    public Throwable getUncaughtException() {
        return e.v();
    }

    public boolean updateUnexpInfo() {
        if (CrashApi.a("updateUnexpInfo")) {
            return false;
        }
        return com.uc.crashsdk.a.a(true);
    }

    public ParcelFileDescriptor getHostFd() {
        return e.E();
    }

    public boolean setHostFd(ParcelFileDescriptor parcelFileDescriptor) {
        return e.a(parcelFileDescriptor);
    }

    public ParcelFileDescriptor getIsolatedHostFd() {
        return e.E();
    }

    public boolean setIsolatedHostFd(ParcelFileDescriptor parcelFileDescriptor) {
        return e.a(parcelFileDescriptor);
    }

    public boolean generateTraces(String string, long l) {
        if (CrashApi.a("generateTraces")) {
            return false;
        }
        if (!com.uc.crashsdk.b.d) {
            com.uc.crashsdk.a.a.d("crashsdk", "Crash so is not loaded!");
            return false;
        }
        return JNIBridge.nativeCmd(12, l, string, null) == 1L;
    }

    private CrashApi(Context context, CustomInfo customInfo, VersionInfo versionInfo, ICrashClient iCrashClient, boolean bl, boolean bl2, boolean bl3) {
        context = CrashApi.a(context);
        CrashApi.b(context);
        com.uc.crashsdk.b.g = bl2;
        com.uc.crashsdk.b.h = bl3;
        if (com.uc.crashsdk.b.L()) {
            boolean bl4 = bl;
            ICrashClient iCrashClient2 = iCrashClient;
            VersionInfo versionInfo2 = versionInfo;
            CustomInfo customInfo2 = customInfo;
            Context context2 = context;
            CrashApi.b(context2);
            CrashApi.a(context2, customInfo2, versionInfo2, iCrashClient2);
            if (bl4) {
                CrashApi.a();
            }
            if (com.uc.crashsdk.b.g && e.e("libcrashsdk.so")) {
                com.uc.crashsdk.b.f = true;
                CrashApi.b();
            }
            return;
        }
        if (customInfo == null || versionInfo == null) {
            com.uc.crashsdk.a.a.d("crashsdk", "VersionInfo and CustomInfo can not be null!");
            throw new NullPointerException();
        }
        g.a(customInfo);
        try {
            CrashApi.a(context, customInfo, versionInfo, iCrashClient);
        }
        catch (Throwable throwable) {
            CrashApi.a(throwable);
        }
        try {
            if (bl) {
                CrashApi.a();
            }
        }
        catch (Throwable throwable) {
            CrashApi.a(throwable);
        }
        try {
            com.uc.crashsdk.b.M();
            h.a();
            com.uc.crashsdk.a.d.a();
            com.uc.crashsdk.a.g.j();
        }
        catch (Throwable throwable) {
            com.uc.crashsdk.a.g.a(throwable);
        }
        try {
            if (!com.uc.crashsdk.b.a(context)) {
                com.uc.crashsdk.a.a.d("crashsdk", "registerLifecycleCallbacks failed!");
            }
        }
        catch (Throwable throwable) {
            com.uc.crashsdk.a.g.a(throwable);
        }
        try {
            com.uc.crashsdk.a.n();
            try {
                e.A();
            }
            catch (Throwable throwable) {
                com.uc.crashsdk.a.g.b(throwable);
            }
            e.B();
        }
        catch (Throwable throwable) {
            com.uc.crashsdk.a.g.a(throwable);
        }
        try {
            if (g.r() && com.uc.crashsdk.b.F()) {
                CrashApi crashApi = this;
                if (!crashApi.b) {
                    e.G();
                    crashApi.b = true;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            com.uc.crashsdk.a.g.b(throwable);
            return;
        }
    }

    private static void a() {
        if (com.uc.crashsdk.b.a) {
            com.uc.crashsdk.a.a.b("Has enabled java log!");
            return;
        }
        e.s();
        e.o();
        com.uc.crashsdk.b.a = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b() {
        Object object = com.uc.crashsdk.b.e;
        synchronized (object) {
            if (!com.uc.crashsdk.b.g || !com.uc.crashsdk.b.f) {
                return;
            }
            if (com.uc.crashsdk.b.b) {
                com.uc.crashsdk.a.a.b("Has enabled native log!");
                return;
            }
            CrashApi.c();
            e.D();
            com.uc.crashsdk.b.b = true;
            JNIBridge.cmd(6);
            g.d();
            return;
        }
    }

    private static void a(Context context, CustomInfo customInfo, VersionInfo versionInfo, ICrashClient iCrashClient) {
        com.uc.crashsdk.d.a(iCrashClient);
        g.a(customInfo, versionInfo);
        if (!com.uc.crashsdk.b.L()) {
            e.p();
            e.a(context);
            e.b(context);
        }
    }

    private static Context a(Context context) {
        if (context == null) {
            com.uc.crashsdk.a.a.d("crashsdk", "context can not be null!");
            throw new NullPointerException();
        }
        if (!(!c || context instanceof Application || (context = context.getApplicationContext()) != null && context instanceof Application)) {
            com.uc.crashsdk.a.a.d("crashsdk", "Can not get Application context from given context!");
            throw new IllegalArgumentException("Can not get Application context from given context!");
        }
        return context;
    }

    private static void b(Context context) {
        try {
            if (!d) {
                com.uc.crashsdk.a.g.a(context);
                com.uc.crashsdk.a.a = context.getPackageName();
                d = true;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashApi.a(throwable);
            return;
        }
    }

    private static void c() {
        if (com.uc.crashsdk.b.d) {
            return;
        }
        g.b();
        JNIBridge.cmd(5);
        g.c();
        com.uc.crashsdk.b.d = true;
    }

    private static void a(Throwable throwable) {
        new e().a(Thread.currentThread(), throwable, true);
    }

    private static boolean a(String string) {
        if (com.uc.crashsdk.b.L()) {
            com.uc.crashsdk.a.a.d("crashsdk", "Can not call '" + string + "' in isolated process!");
            return true;
        }
        return false;
    }
}

