/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.umcrash;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.efs.sdk.base.core.util.concurrent.WorkThreadUtil;
import com.uc.crashsdk.export.CrashApi;
import com.umeng.commonsdk.statistics.common.DeviceConfig;
import com.umeng.umcrash.UMCrash;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class UMCrashUtils {
    private static final int DEF_CLOSE_RATE = 0;
    private static final int MAX_TRACE_RATE = 100;
    public static final String UNKNOW = "";
    private static final int MAX_THREAD_TRACE_LENGTH = 20480;

    public static boolean random(int rate) {
        if (rate == 0) {
            return false;
        }
        if (rate == 100) {
            return true;
        }
        Random random = new Random();
        int next = random.nextInt(100);
        return next <= rate;
    }

    public static void saveInnerConfig(Context context, String key, Object value) {
        try {
            SharedPreferences.Editor editor;
            SharedPreferences sp;
            if (context != null && !TextUtils.isEmpty((CharSequence)key) && value != null && (sp = context.getSharedPreferences("um_umcrash", 0)) != null && (editor = sp.edit()) != null) {
                editor.putInt(key, Integer.parseInt(value.toString()));
                editor.commit();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static int getInnerConfig(Context context, String key, int defa) {
        try {
            SharedPreferences sp;
            if (context != null && !TextUtils.isEmpty((CharSequence)key) && (sp = context.getSharedPreferences("um_umcrash", 0)) != null) {
                defa = sp.getInt(key, defa);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return defa;
    }

    public static void setCommonTag(String key, String value) {
        try {
            Method method;
            Class<?> clazzEnum;
            Class<?> clazz = Class.forName("com.umeng.commonsdk.UMConfigure");
            if (clazz != null && (clazzEnum = Class.forName("com.umeng.commonsdk.UMConfigure$BS_TYPE")) != null && (method = clazz.getDeclaredMethod("setModuleTag", clazzEnum, String.class, String.class)) != null) {
                Enum[] enumConstants;
                method.setAccessible(true);
                for (Enum item : enumConstants = (Enum[])clazzEnum.getEnumConstants()) {
                    if (item == null || !item.name().equals("APM")) continue;
                    method.invoke(clazz, item, key, value);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static boolean isHarmony(final Context context) {
        try {
            final SharedPreferences sp = context.getSharedPreferences("um_umcrash", 0);
            if (sp.contains("um_apm_harmony")) {
                return sp.getBoolean("um_apm_harmony", false);
            }
            WorkThreadUtil.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        int id = Resources.getSystem().getIdentifier("config_os_brand", "string", "android");
                        boolean isHarmony = context.getString(id).equals("harmony");
                        sp.edit().putBoolean("um_apm_harmony", isHarmony).apply();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String[] getActiveUser(Context context) {
        if (context == null) {
            return null;
        }
        String[] activeUser = null;
        Class<?> mClass = null;
        try {
            mClass = Class.forName("com.umeng.commonsdk.utils.UMUtils");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (mClass != null) {
            Method umConfigMethed = null;
            try {
                umConfigMethed = mClass.getMethod("getActiveUser", Context.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (umConfigMethed != null) {
                try {
                    Object o = umConfigMethed.invoke(null, context);
                    if (o != null) {
                        activeUser = (String[])o;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return activeUser;
    }

    public static void setPuidAndProvider(String puid, String provider) {
        if (CrashApi.getInstance() != null) {
            CrashApi.getInstance().addHeaderInfo("um_app_puid", puid);
            CrashApi.getInstance().addHeaderInfo("um_app_provider", provider);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("um_app_puid", puid);
        params.put("um_app_provider", provider);
        if (UMCrash.getReporter() != null) {
            UMCrash.getReporter().addPublicParams(params);
        }
    }

    public static void setIntegrationTesingParams(String debugKey) {
        if (CrashApi.getInstance() != null) {
            CrashApi.getInstance().addHeaderInfo("um_dk", debugKey);
        }
        if (UMCrash.getReporter() != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("um_dk", debugKey);
            UMCrash.getReporter().addPublicParams(params);
        }
    }

    public static String getNetworkOperatorName(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        try {
            return DeviceConfig.getNetworkOperatorName((Context)context);
        }
        catch (Throwable throwable) {
            return UNKNOW;
        }
    }

    public static boolean checkPermission(Context context, String permission) {
        boolean result;
        block7: {
            result = false;
            if (context == null) {
                return result;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Class<?> clazz = Class.forName("android.content.Context");
                    Method method = clazz.getMethod("checkSelfPermission", String.class);
                    int rest = (Integer)method.invoke((Object)context, permission);
                    if (rest == 0) {
                        result = true;
                        break block7;
                    }
                    result = false;
                }
                catch (Throwable e) {
                    result = false;
                }
            } else {
                PackageManager pm = context.getPackageManager();
                if (pm.checkPermission(permission, context.getPackageName()) == 0) {
                    result = true;
                }
            }
        }
        return result;
    }

    public static String splitByByte(String srcStr, int length) {
        StringBuffer sb = new StringBuffer(length);
        try {
            String tempStr;
            byte[] b;
            int srcLength = srcStr.length();
            int tempLength = 0;
            for (int i = 0; i < srcLength && length >= (tempLength += (b = (tempStr = String.valueOf(srcStr.charAt(i))).getBytes()).length); ++i) {
                sb.append(tempStr);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sb.toString();
    }

    public static synchronized String getUMID(Context context) {
        if (context == null) {
            return null;
        }
        String umId = null;
        Class<?> umConfigClass = null;
        try {
            umConfigClass = Class.forName("com.umeng.commonsdk.UMConfigure");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (umConfigClass != null) {
            Method umConfigMethed = null;
            try {
                umConfigMethed = umConfigClass.getMethod("getUMIDString", Context.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (umConfigMethed != null) {
                try {
                    Object o = umConfigMethed.invoke(null, context);
                    if (o != null) {
                        umId = o.toString();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return umId;
    }

    public static synchronized String getSessionId(Context context) {
        if (context == null) {
            return null;
        }
        String sessionId = null;
        Class<?> umDeviceConfigClass = null;
        try {
            umDeviceConfigClass = Class.forName("com.umeng.commonsdk.statistics.common.DeviceConfig");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (umDeviceConfigClass != null) {
            Method umConfigMethed = null;
            try {
                umConfigMethed = umDeviceConfigClass.getMethod("getSid", Context.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (umConfigMethed != null) {
                try {
                    Object o = umConfigMethed.invoke(null, context);
                    if (o != null) {
                        sessionId = o.toString();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return sessionId;
    }

    public static Map<String, String> getAllThreadTraces() {
        HashMap<String, String> threadTraceMap = new HashMap<String, String>();
        try {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            if (allStackTraces == null) {
                return null;
            }
            Thread thread = Looper.getMainLooper().getThread();
            if (!allStackTraces.containsKey(thread)) {
                allStackTraces.put(thread, thread.getStackTrace());
            }
            long id = Thread.currentThread().getId();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                if (id == entry.getKey().getId()) continue;
                sb.setLength(0);
                if (entry.getValue() == null || entry.getValue().length == 0) continue;
                for (StackTraceElement stackTraceElement : entry.getValue()) {
                    if (sb.length() >= 20480) {
                        sb.append("\n[Stack trace size must be less than :").append(20480).append("!]");
                        break;
                    }
                    sb.append("  at ").append(stackTraceElement.toString()).append("\n");
                }
                threadTraceMap.put(entry.getKey().getName() + "(" + entry.getKey().getId() + ")", sb.toString());
            }
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
        return threadTraceMap;
    }
}

