/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.umcrash.custom_exception;

import android.text.TextUtils;
import android.util.Log;
import com.uc.crashsdk.export.CustomLogInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UMCustomLogInfoBuilder {
    public static final String LOG_TYPE = "exception";
    public static final String LOG_KEY_CT = "k_ct";
    public static final String LOG_KEY_AC = "k_ac";
    private static final String LOG_KEY_STACK_FUNC = "stackFunc";
    private static final String LOG_KEY_STACK_HASH = "stackHash";
    public static final String LOG_SECTION_SEP = "--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---";
    public static final String LINE_SEP = "\n";
    private Map<String, String> kvInfoMap = new HashMap<String, String>(20);
    private List<String> sectionList = new ArrayList<String>(5);
    private String stack;
    private CustomLogInfo mCustomLogInfo = new CustomLogInfo(new StringBuffer(), "exception");

    public UMCustomLogInfoBuilder(String subLogType) {
        this.kvInfoMap.put(LOG_KEY_CT, LOG_TYPE);
        this.kvInfoMap.put(LOG_KEY_AC, subLogType);
    }

    public UMCustomLogInfoBuilder put(String key, String value) {
        if (LOG_KEY_AC.equals(key) || LOG_KEY_CT.equals(key)) {
            Log.w((String)"crashsdk", (String)"key can not be 'k_ac' and 'k_ct'");
            return this;
        }
        this.kvInfoMap.put(key, value);
        return this;
    }

    public UMCustomLogInfoBuilder stackFunc(String stackFunc) {
        this.kvInfoMap.put(LOG_KEY_STACK_FUNC, stackFunc);
        return this;
    }

    public UMCustomLogInfoBuilder stackHash(String stackHash) {
        this.kvInfoMap.put(LOG_KEY_STACK_HASH, stackHash);
        return this;
    }

    public UMCustomLogInfoBuilder stack(Throwable t, String errorMsg) {
        return this.stack(Log.getStackTraceString((Throwable)t), errorMsg);
    }

    public UMCustomLogInfoBuilder stack(String stackStr, String errorMsg) {
        if (errorMsg == null) {
            errorMsg = "";
        }
        this.stack = "Exception message:" + errorMsg + LINE_SEP + "Back traces starts." + LINE_SEP + stackStr + "Back traces ends.";
        return this;
    }

    public UMCustomLogInfoBuilder addSection(String section) {
        this.sectionList.add(section);
        return this;
    }

    public UMCustomLogInfoBuilder uploadNow(boolean uploadNow) {
        this.mCustomLogInfo.mUploadNow = uploadNow;
        return this;
    }

    public UMCustomLogInfoBuilder addLogCat(boolean addLogcat) {
        this.mCustomLogInfo.mAddLogcat = addLogcat;
        return this;
    }

    public CustomLogInfo build() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.kvInfoMap.entrySet()) {
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append(LINE_SEP);
        }
        if (!TextUtils.isEmpty((CharSequence)this.stack)) {
            sb.append(this.stack).append(LINE_SEP);
        }
        for (String sectionText : this.sectionList) {
            sb.append(LOG_SECTION_SEP).append(LINE_SEP);
            sb.append(sectionText).append(LINE_SEP);
        }
        this.mCustomLogInfo.mData = sb;
        return this.mCustomLogInfo;
    }
}

