/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.memleaksdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.efs.sdk.base.EfsReporter;
import com.efs.sdk.base.observer.IConfigCallback;
import com.efs.sdk.base.samplingwhitelist.SamplingWhiteListUtil;
import com.efs.sdk.memleaksdk.MemLeakManager;
import java.util.Map;
import java.util.Random;

public class MemLeakConfigManager {
    private final String TAG = "MemLeakConfigManager";
    private Context mContext;
    private EfsReporter mEfsReporter;
    private int mCurrentRate = 100;
    private final int DEF_CLOSE_RATE = 0;
    private static final int MAX_MEMLEAK_TRACE_RATE = 100;
    private int mLastRate;
    private static final int A_DAY = 86400000;
    private boolean mCheckIn = false;

    public boolean enableTracer() {
        return this.mCheckIn;
    }

    public MemLeakConfigManager(Context context, EfsReporter efsReporter) {
        this.mContext = context.getApplicationContext();
        this.mEfsReporter = efsReporter;
        this.initRate();
        this.mCheckIn = this.enableMemleakTracer();
        this.resetRate();
    }

    private void initRate() {
        int n2;
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("efs_memleak", 0);
        if (sharedPreferences != null) {
            this.mLastRate = sharedPreferences.getInt("apm_memleakperf_sampling_rate_last", 0);
        }
        if ((n2 = this.getCurrentConfigRate()) != -1) {
            this.mCurrentRate = n2;
        }
    }

    private int getCurrentConfigRate() {
        int n2 = -1;
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("efs_memleak", 0);
        if (sharedPreferences != null) {
            n2 = sharedPreferences.getInt("apm_memleakperf_sampling_rate", -1);
        }
        this.mEfsReporter.getAllSdkConfig(new String[]{"apm_memleakperf_sampling_rate"}, new IConfigCallback(){

            public void onChange(Map<String, Object> map) {
                try {
                    SharedPreferences.Editor editor;
                    SharedPreferences sharedPreferences = MemLeakConfigManager.this.mContext.getSharedPreferences("efs_memleak", 0);
                    if (sharedPreferences != null && (editor = sharedPreferences.edit()) != null && map != null) {
                        Object object = map.get("apm_memleakperf_sampling_rate");
                        if (object != null) {
                            editor.putInt("apm_memleakperf_sampling_rate", Integer.parseInt(object.toString()));
                        }
                        editor.apply();
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        return n2;
    }

    private void resetRate() {
        SharedPreferences.Editor editor;
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("efs_memleak", 0);
        if (sharedPreferences != null && (editor = sharedPreferences.edit()) != null) {
            editor.putInt("apm_memleakperf_sampling_rate_last", this.mCurrentRate);
            editor.apply();
        }
    }

    private boolean enableMemleakTracer() {
        if (SamplingWhiteListUtil.isHitWL()) {
            return true;
        }
        long l2 = 0L;
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("efs_memleak", 0);
        if (sharedPreferences != null) {
            l2 = sharedPreferences.getLong("03f870871950c148387b251894ed3e88", 0L);
        }
        boolean bl2 = false;
        if (sharedPreferences != null) {
            bl2 = sharedPreferences.getBoolean("8f2f54c08600aa25915617fa1371441b", false);
        }
        if (this.mCurrentRate == 0) {
            SharedPreferences.Editor editor;
            if (bl2 && sharedPreferences != null && (editor = sharedPreferences.edit()) != null) {
                editor.putBoolean("8f2f54c08600aa25915617fa1371441b", false);
                editor.commit();
            }
            if (l2 != 0L && sharedPreferences != null && (editor = sharedPreferences.edit()) != null) {
                editor.putLong("03f870871950c148387b251894ed3e88", 0L);
                editor.commit();
            }
            return false;
        }
        return this.checkIn(this.mCurrentRate != this.mLastRate, l2, bl2, this.mCurrentRate);
    }

    private boolean checkIn(boolean bl2, Long l2, boolean bl3, int n2) {
        boolean bl4 = false;
        Long l3 = System.currentTimeMillis();
        Long l4 = l3 - l2;
        if (bl3 && l4 < 86400000L && !bl2) {
            if (MemLeakManager.isDebug) {
                Log.d((String)"MemLeakConfigManager", (String)"check in page rate. check in allready.");
            }
            return true;
        }
        if (l4 >= 86400000L || bl2) {
            SharedPreferences.Editor editor;
            if (this.random(n2)) {
                if (MemLeakManager.isDebug) {
                    Log.d((String)"MemLeakConfigManager", (String)"check in page rate. random check in");
                }
                bl4 = true;
            } else {
                if (MemLeakManager.isDebug) {
                    Log.d((String)"MemLeakConfigManager", (String)"check in page rate. random not check in!");
                }
                bl4 = false;
            }
            SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("efs_memleak", 0);
            if (sharedPreferences != null && (editor = sharedPreferences.edit()) != null) {
                editor.putBoolean("8f2f54c08600aa25915617fa1371441b", bl4);
                editor.apply();
            }
            if (sharedPreferences != null && (editor = sharedPreferences.edit()) != null) {
                editor.putLong("03f870871950c148387b251894ed3e88", l3.longValue());
                editor.apply();
            }
        } else if (MemLeakManager.isDebug) {
            Log.d((String)"MemLeakConfigManager", (String)"check in page rate. un repeat check in 24 hour!");
        }
        return bl4;
    }

    private boolean random(int n2) {
        if (n2 == 0) {
            return false;
        }
        if (n2 == 100) {
            return true;
        }
        Random random = new Random();
        int n3 = random.nextInt(100);
        return n3 <= n2;
    }
}

