/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.umcrash;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import com.efs.sdk.base.EfsReporter;
import com.efs.sdk.base.core.cache.IFileFilter;
import com.efs.sdk.base.core.util.NetworkUtil;
import com.efs.sdk.base.core.util.concurrent.WorkThreadUtil;
import com.efs.sdk.base.custommapping.IUMPerfCallback;
import com.efs.sdk.base.custommapping.InnerCustomMappingManager;
import com.efs.sdk.base.integrationtesting.IntegrationTestingUtil;
import com.efs.sdk.base.newsharedpreferences.SharedPreferencesUtils;
import com.efs.sdk.base.observer.IConfigCallback;
import com.efs.sdk.base.samplingwhitelist.SamplingWhiteListUtil;
import com.efs.sdk.fluttersdk.FlutterManager;
import com.efs.sdk.h5pagesdk.H5Manager;
import com.efs.sdk.launch.LaunchManager;
import com.efs.sdk.memleaksdk.IMemLeakClient;
import com.efs.sdk.memleaksdk.MemLeakManager;
import com.efs.sdk.memoryinfo.UMMemoryMonitor;
import com.efs.sdk.net.NetManager;
import com.efs.sdk.pa.IPaClient;
import com.efs.sdk.pa.PAFactory;
import com.efs.sdk.pa.config.IEfsReporter;
import com.efs.sdk.pa.config.PackageLevel;
import com.uc.crashsdk.export.CrashApi;
import com.uc.crashsdk.export.ICrashClient;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.statistics.idtracking.ImprintHandler;
import com.umeng.commonsdk.statistics.internal.UMImprintChangeCallback;
import com.umeng.crash.UCrash;
import com.umeng.crash.UCrashCallback;
import com.umeng.crash.UCrashConfig;
import com.umeng.logsdk.ULogManager;
import com.umeng.logsdk.UploadFileFilterCodeLog;
import com.umeng.pagesdk.PageManger;
import com.umeng.powersdk.PowerManager;
import com.umeng.umcrash.IUMCrashCallbackWithType;
import com.umeng.umcrash.UMCrashCallback;
import com.umeng.umcrash.UMCrashUtils;
import com.umeng.umcrash.custom_exception.UAPMCustomException;
import com.umeng.umcrash.custominfo.UAPMCustomInfo;
import com.umeng.umcrash.customlog.UAPMCustomLogManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UMCrash {
    private static final String TAG = UMCrash.class.getSimpleName();
    private static Context mContext;
    public static EfsReporter sReporter;
    private static boolean sIsKillProcessAfterCrash;
    private static boolean sIsEnableLogBackup;
    private static boolean isDebug;
    private static boolean isEncrypt;
    private static boolean isZip;
    private static boolean isIntl;
    private static boolean isBuildId;
    private static UMCrashCallback mUMCrashCallback;
    private static IUMCrashCallbackWithType mUMCrashCallbackWithType;
    private static final String KEY_CALLBACK_USER_STRING_JAVA = "um_user_str_java:";
    private static final String KEY_CALLBACK_USER_STRING_NATIVE = "um_user_str_native:";
    private static final String KEY_CALLBACK_USER_STRING_ANR = "um_user_str_anr:";
    public static final String KEY_CALLBACK_USER_STRING_CUSTOM_LOG = "um_user_str_custom_log:";
    public static final String KEY_CALLBACK_USER_STRING = "um_user_string";
    public static final String KEY_CALLBACK_PAGE_ACTION = "um_action_log";
    public static final String KEY_CALLBACK_UMID = "um_umid";
    public static final String KEY_CALLBACK_SESSION_ID = "um_session_id";
    public static final String KEY_CALLBACK_CUSTOM_LOG = "um_custom_log";
    public static final String KEY_CALLBACK_UM_INFOS = "um_infos:";
    public static final String KEY_CALLBACK_CUSTOM_MAPPING = "um_custom_mapping";
    public static final String KEY_HEADER_APPKEY = "um_app_key";
    public static final String KEY_HEADER_CHANNEL = "um_app_channel";
    public static final String KEY_HEADER_OS = "um_os";
    public static final String KEY_HEADER_CRASH_VERSION = "um_crash_sdk_version";
    public static final String KEY_HEADER_PUID = "um_app_puid";
    public static final String KEY_HEADER_PROVIDER = "um_app_provider";
    public static final String KEY_HEADER_CARRIER = "um_app_carrier";
    public static final String KEY_HEADER_START_TIME = "um_app_start_time";
    public static final String KEY_HEADER_ACCESS = "um_access";
    public static final String KEY_HEADER_ACCESS_SUBTYPE = "um_access_subtype";
    public static final String KEY_HEADER_NETWORK_TYPE = "um_network_type";
    public static final String KEY_HEADER_BVER = "um_bver";
    public static final String KEY_HEADER_BSVER = "um_bsver";
    public static final String KEY_HEADER_BESRIAL = "um_bserial";
    public static final String KEY_DEBUGKEY = "um_dk";
    public static final String KEY_HEADER_DEBUGKEY = "um_dk";
    private static String userBver;
    private static String userBsver;
    private static String userBesrial;
    public static final String KEY_HEADER_UMID = "um_umid_header";
    public static final String KEY_APM_DEFAULT_SECRET = "NEej8y@anWa*8hep";
    public static final String KEY_APM_ROOT_NAME = "UApm";
    private static String crashSdkVersion;
    private static Object pageArrayLock;
    private static ArrayList<String> mArrayList;
    private static final int KEY_MAX_LENGTH = 20480;
    private static final int KEY_MAX_LENGTH_128 = 128;
    private static int sApmCallbackLimit;
    private static boolean isPA;
    private static boolean isLa;
    private static boolean isNet;
    private static boolean isPage;
    private static boolean isPower;
    private static boolean isFlutter;
    private static boolean isCodeLog;
    private static boolean isMemLeak;
    public static final String KEY_ENABLE_CRASH_JAVA = "enableJavaLog";
    private static final boolean DEFAULT_VALUE_CRASH_JAVA = true;
    public static final String KEY_ENABLE_CRASH_NATIVE = "enableNativeLog";
    private static final boolean DEFAULT_VALUE_CRASH_NATIVE = true;
    public static final String KEY_ENABLE_CRASH_UNEXP = "enableUnexpLog";
    private static final boolean DEFAULT_VALUE_CRASH_UNEXP = false;
    public static final String KEY_ENABLE_ANR = "enableANRLog";
    private static final boolean DEFAULT_VALUE_CRASH_ANR = true;
    public static final String KEY_ENABLE_PA = "enablePaLog";
    private static final boolean DEFAULT_VALUE_PA = true;
    public static final String KEY_ENABLE_LAUNCH = "enableLaunchLog";
    private static final boolean DEFAULT_VALUE_LAUNCH = true;
    public static final String KEY_ENABLE_MEM = "enableMemLog";
    private static final boolean DEFAULT_VALUE_MEM = true;
    public static final String KEY_ENABLE_NET = "enableNetLog";
    private static final boolean DEFAULT_VALUE_NET = true;
    public static final String KEY_ENABLE_H5PAGE = "enableH5PageLog";
    private static final boolean DEFAULT_VALUE_H5PAGE = true;
    public static final String KEY_ENABLE_PAGE = "enablePageLog";
    private static final boolean DEFAULT_VALUE_PAGE = true;
    public static final String KEY_ENABLE_CODE_LOG = "enableCodeLog";
    private static final boolean DEFAULT_VALUE_CODE_LOG = true;
    public static final String KEY_ENABLE_POWER = "enablePowerLog";
    private static final boolean DEFAULT_VALUE_POWER = true;
    public static final String KEY_ENABLE_FLUTTER = "enableFlutterLog";
    private static final boolean DEFAULT_VALUE_FLUTTER = true;
    public static final String KEY_ENABLE_MEMLEAK = "enableMemLeakLog";
    private static final boolean DEFAULT_VALUE_MEMLEAK = true;
    private static boolean enableJavaLog;
    private static boolean enableNativeLog;
    private static boolean enableANRLog;
    private static boolean enablePaLog;
    private static boolean enableLaunchLog;
    private static boolean enableMemLog;
    private static boolean enableNetLog;
    private static boolean enableH5PageLog;
    private static boolean enablePageLog;
    private static boolean enableCodeLog;
    private static boolean enablePowerLog;
    private static boolean enableFlutterLog;
    private static boolean enableMemLeakLog;
    private static boolean enableUCJavaLog;
    private static boolean enableUCNativeLog;
    private static boolean enableUCANRLog;
    private static boolean enableUCUserLog;
    private static boolean enableUMJavaLog;
    private static boolean enableUMNativeLog;
    private static boolean enableUMANRLog;
    private static boolean enableUMUserLog;
    private static boolean enableUMAnrTrace;
    private static final long DEFAULT_PA_TIMEOUT_TIME = 2000L;
    private static long paTimeoutTime;
    public static final String KEY_PA_TIMEOUT_TIME = "pa_timeout_time";
    public static final String KEY_LOG_USER_ID = "log_user_id";
    public static final String KEY_LOG_DEVICES_ID = "log_devices_id";
    private static int index;
    private static final String INTEGRATIONTESTING_SP = "itconfig";
    public static final String SP_KEY_DEBUG = "debugkey";
    public static final String SP_KEY_TIMESTAMP = "timestamp";
    private static final String IT_DEBUGKEY = "apm_debugkey";
    private static final String IT_SENDAGING = "apm_sendaging";
    private static final String KEY_ACTIITY_ON_CREATED = "onCreated";
    private static final String KEY_ACTIITY_ON_STARTED = "onStarted";
    private static final String KEY_ACTIITY_ON_RESUMED = "onResumed";
    private static final String KEY_ACTIITY_ON_PAUSED = "onPaused";
    private static final String KEY_ACTIITY_ON_STOPPED = "onStopped";
    private static final String KEY_ACTIITY_ON_DESTROYED = "onDestroyed";
    private static boolean isOpenUserCrash;
    private static boolean isUploadNowUserCrash;

    public static EfsReporter getReporter() {
        return sReporter;
    }

    public static void isBuildId(boolean isBuId) {
        isBuildId = isBuId;
    }

    public static void setAppVersion(String version, String subVersion, String buildId) {
        try {
            String pVersion = version;
            if (!TextUtils.isEmpty((CharSequence)pVersion)) {
                int len = pVersion.trim().getBytes().length;
                if (len > 128) {
                    pVersion = UMCrashUtils.splitByByte(pVersion, 128);
                }
                userBver = pVersion;
            } else if (isDebug) {
                Log.e((String)TAG, (String)"version is null or empty !");
            }
            String pSubVersion = subVersion;
            if (!TextUtils.isEmpty((CharSequence)pSubVersion)) {
                int len = pSubVersion.trim().getBytes().length;
                if (len > 128) {
                    pSubVersion = UMCrashUtils.splitByByte(pSubVersion, 128);
                }
                userBsver = pSubVersion;
            } else if (isDebug) {
                Log.e((String)TAG, (String)"sub version is null or empty !");
            }
            String pBuildId = buildId;
            if (!TextUtils.isEmpty((CharSequence)pBuildId)) {
                int len = pBuildId.trim().getBytes().length;
                if (len > 128) {
                    pBuildId = UMCrashUtils.splitByByte(pBuildId, 128);
                }
                userBesrial = pBuildId;
            } else if (isDebug) {
                Log.e((String)TAG, (String)"build id is null or empty !");
            }
            CrashApi crashApi = CrashApi.getInstance();
            if (crashApi != null) {
                if (!TextUtils.isEmpty((CharSequence)userBver)) {
                    crashApi.addHeaderInfo(KEY_HEADER_BVER, userBver);
                    UCrash.addHeader((String)KEY_HEADER_BVER, (String)userBver);
                }
                if (!TextUtils.isEmpty((CharSequence)userBsver)) {
                    crashApi.addHeaderInfo(KEY_HEADER_BSVER, userBsver);
                    UCrash.addHeader((String)KEY_HEADER_BSVER, (String)userBsver);
                }
                if (!TextUtils.isEmpty((CharSequence)userBesrial)) {
                    crashApi.addHeaderInfo(KEY_HEADER_BESRIAL, userBesrial);
                    UCrash.addHeader((String)KEY_HEADER_BESRIAL, (String)userBesrial);
                }
            } else if (isDebug) {
                Log.e((String)TAG, (String)"set app version. crashApi is null");
            }
            HashMap<String, String> params = new HashMap<String, String>(1);
            if (!TextUtils.isEmpty((CharSequence)userBver)) {
                params.put(KEY_HEADER_BVER, userBver);
            }
            if (!TextUtils.isEmpty((CharSequence)userBsver)) {
                params.put(KEY_HEADER_BSVER, userBsver);
            }
            if (!TextUtils.isEmpty((CharSequence)userBesrial)) {
                params.put(KEY_HEADER_BESRIAL, userBesrial);
            }
            if (sReporter != null) {
                sReporter.addPublicParams(params);
            } else if (isDebug) {
                Log.e((String)TAG, (String)"set app version.  sReporter is null");
            }
            if (!TextUtils.isEmpty((CharSequence)userBver)) {
                UMCrashUtils.setCommonTag(KEY_HEADER_BVER, userBver);
            }
            if (!TextUtils.isEmpty((CharSequence)userBsver)) {
                UMCrashUtils.setCommonTag(KEY_HEADER_BSVER, userBsver);
            }
            if (!TextUtils.isEmpty((CharSequence)userBesrial)) {
                UMCrashUtils.setCommonTag(KEY_HEADER_BESRIAL, userBesrial);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static String generateNormalUserString() {
        if (mUMCrashCallbackWithType == null && mUMCrashCallback != null) {
            String callbackString = mUMCrashCallback.onCallback();
            if (callbackString == null) {
                return null;
            }
            int len = callbackString.trim().getBytes().length;
            if (len > Math.max(20480, sApmCallbackLimit)) {
                callbackString = UMCrashUtils.splitByByte(callbackString, Math.max(20480, sApmCallbackLimit));
            }
            return callbackString;
        }
        return null;
    }

    private static String generateJavaUserString() {
        if (mUMCrashCallbackWithType != null) {
            String callbackString = mUMCrashCallbackWithType.onCallback(IUMCrashCallbackWithType.CrashType.CRASH_TYPE_JAVA);
            if (callbackString == null) {
                return null;
            }
            int len = callbackString.trim().getBytes().length;
            if (len > Math.max(20480, sApmCallbackLimit)) {
                callbackString = UMCrashUtils.splitByByte(callbackString, Math.max(20480, sApmCallbackLimit));
            }
            return callbackString;
        }
        return null;
    }

    private static String generateNativeUserString() {
        if (mUMCrashCallbackWithType != null) {
            String callbackString = mUMCrashCallbackWithType.onCallback(IUMCrashCallbackWithType.CrashType.CRASH_TYPE_NATIVE);
            if (callbackString == null) {
                return null;
            }
            int len = callbackString.trim().getBytes().length;
            if (len > Math.max(20480, sApmCallbackLimit)) {
                callbackString = UMCrashUtils.splitByByte(callbackString, Math.max(20480, sApmCallbackLimit));
            }
            return callbackString;
        }
        return null;
    }

    private static String generateANRUserString() {
        if (mUMCrashCallbackWithType != null) {
            String callbackString = mUMCrashCallbackWithType.onCallback(IUMCrashCallbackWithType.CrashType.CRASH_TYPE_ANR);
            if (callbackString == null) {
                return null;
            }
            int len = callbackString.trim().getBytes().length;
            if (len > Math.max(20480, sApmCallbackLimit)) {
                callbackString = UMCrashUtils.splitByByte(callbackString, Math.max(20480, sApmCallbackLimit));
            }
            return callbackString;
        }
        return null;
    }

    private static String generateCustomUserString() {
        if (mUMCrashCallbackWithType != null) {
            String callbackString = mUMCrashCallbackWithType.onCallback(IUMCrashCallbackWithType.CrashType.CRASH_TYPE_CUSTOM_LOG);
            if (callbackString == null) {
                return null;
            }
            int len = callbackString.trim().getBytes().length;
            if (len > Math.max(20480, sApmCallbackLimit)) {
                callbackString = UMCrashUtils.splitByByte(callbackString, Math.max(20480, sApmCallbackLimit));
            }
            return callbackString;
        }
        return null;
    }

    private static String generateUMInfos() {
        JSONObject jsonSec = new JSONObject();
        try {
            if (mArrayList != null && mArrayList.size() > 0) {
                JSONObject pageActionJson = new JSONObject();
                pageActionJson.put("source", 0);
                pageActionJson.put("action_name", (Object)"page_view");
                pageActionJson.put("action_page_state", isPage);
                JSONArray jsonParameter = new JSONArray();
                for (int i = 0; i < mArrayList.size(); ++i) {
                    String item = mArrayList.get(i);
                    if (item == null) continue;
                    JSONObject jsonitem = new JSONObject();
                    jsonitem.put("name", (Object)item);
                    jsonParameter.put((Object)jsonitem);
                }
                pageActionJson.put("action_parameter", (Object)jsonParameter);
                String pageActionStr = pageActionJson.toString();
                if (isDebug) {
                    Log.i((String)TAG, (String)("page json is " + pageActionStr));
                }
                jsonSec.put(KEY_CALLBACK_PAGE_ACTION, (Object)pageActionStr);
            }
        }
        catch (Throwable pageActionJson) {
            // empty catch block
        }
        try {
            jsonSec.put(KEY_CALLBACK_SESSION_ID, (Object)UMCrashUtils.getSessionId(mContext));
            jsonSec.put(KEY_CALLBACK_CUSTOM_LOG, (Object)UAPMCustomLogManager.getCustomLogs());
            jsonSec.put(KEY_CALLBACK_CUSTOM_MAPPING, (Object)InnerCustomMappingManager.getCustomMappingJsonStr());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jsonSec.toString();
    }

    public static String getUMAPMFlag() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("version", 0);
            jsonObject.put("crash", 1);
            if (enableJavaLog) {
                jsonObject.put("crashJava", 1);
            } else {
                jsonObject.put("crashJava", 0);
            }
            if (enableNativeLog) {
                jsonObject.put("crashNative", 1);
            } else {
                jsonObject.put("crashNative", 0);
            }
            if (enableANRLog) {
                jsonObject.put("anr", 1);
            } else {
                jsonObject.put("anr", 0);
            }
            if (isPA) {
                jsonObject.put("pa", 1);
            } else {
                jsonObject.put("pa", 0);
            }
            if (isLa) {
                jsonObject.put("la", 1);
            } else {
                jsonObject.put("la", 0);
            }
            if (UMMemoryMonitor.get().isEnable()) {
                jsonObject.put("mem", 1);
            } else {
                jsonObject.put("mem", 0);
            }
            if (isNet) {
                jsonObject.put("net", 1);
            } else {
                jsonObject.put("net", 0);
            }
            if (H5Manager.getH5ConfigMananger() != null && H5Manager.getH5ConfigMananger().isH5TracerEnable()) {
                jsonObject.put("h5", 1);
            } else {
                jsonObject.put("h5", 0);
            }
            if (isOpenUserCrash) {
                jsonObject.put("crashUser", 1);
            } else {
                jsonObject.put("crashUser", 0);
            }
            if (isPage) {
                jsonObject.put("page", 1);
            } else {
                jsonObject.put("page", 0);
            }
            if (isPower) {
                jsonObject.put("power", 1);
            } else {
                jsonObject.put("power", 0);
            }
            if (isCodeLog) {
                jsonObject.put("codelog", 1);
            } else {
                jsonObject.put("codelog", 0);
            }
            if (isMemLeak) {
                jsonObject.put("memleak", 1);
            } else {
                jsonObject.put("memleak", 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jsonObject.toString();
    }

    public static void enableJavaScriptBridge(WebView webView) {
        UMCrash.enableJavaScriptBridge((View)webView);
    }

    public static void enableJavaScriptBridge(View webView) {
        try {
            H5Manager.setWebView((View)webView);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void enableKillProcessAfterCrash(boolean isKillProcessAfterCrash) {
        sIsKillProcessAfterCrash = isKillProcessAfterCrash;
    }

    public static void setDebug(boolean isD) {
        isDebug = isD;
        LaunchManager.isDebug = isD;
        H5Manager.isDebug = isD;
        PageManger.isDebug = isD;
        PowerManager.isDebug = isD;
        ULogManager.isDebug = isD;
        MemLeakManager.isDebug = isD;
    }

    private static void useIntlServices(boolean isInSer) {
        isIntl = isInSer;
        if (isDebug) {
            Log.i((String)TAG, (String)("useIntlServices is " + isIntl));
        }
    }

    @Deprecated
    public static void enableNativeLog(boolean isN) {
        enableNativeLog = isN;
    }

    @Deprecated
    public static void enableANRLog(boolean isA) {
        enableANRLog = isA;
    }

    public static void setPaTimeoutTime(long timeoutTime) {
        paTimeoutTime = timeoutTime;
    }

    public static void initConfig(Bundle args) {
        if (args != null) {
            enableJavaLog = args.getBoolean(KEY_ENABLE_CRASH_JAVA, true);
            enableNativeLog = args.getBoolean(KEY_ENABLE_CRASH_NATIVE, true);
            enableANRLog = args.getBoolean(KEY_ENABLE_ANR, true);
            enablePaLog = args.getBoolean(KEY_ENABLE_PA, true);
            enableLaunchLog = args.getBoolean(KEY_ENABLE_LAUNCH, true);
            enableMemLog = args.getBoolean(KEY_ENABLE_MEM, true);
            enableNetLog = args.getBoolean(KEY_ENABLE_NET, true);
            enableH5PageLog = args.getBoolean(KEY_ENABLE_H5PAGE, true);
            paTimeoutTime = args.getLong(KEY_PA_TIMEOUT_TIME, 2000L);
            enablePageLog = args.getBoolean(KEY_ENABLE_PAGE, true);
            try {
                enableCodeLog = args.getBoolean(KEY_ENABLE_CODE_LOG, true);
                ULogManager.setUserID((String)args.getString(KEY_LOG_USER_ID, ""));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            enablePowerLog = args.getBoolean(KEY_ENABLE_POWER, true);
            enableFlutterLog = args.getBoolean(KEY_ENABLE_FLUTTER, true);
            enableMemLeakLog = args.getBoolean(KEY_ENABLE_MEMLEAK, true);
        }
    }

    @Deprecated
    public static void enableMemoryMonitor(boolean enable) {
        UMMemoryMonitor.get().setEnable(enable);
    }

    public static void init(final Context context, final String appkey, String channel) {
        block148: {
            block147: {
                block146: {
                    block145: {
                        block144: {
                            block143: {
                                if (context == null || appkey == null) {
                                    Log.e((String)TAG, (String)"context is null or appkey is null, init failed.");
                                    return;
                                }
                                Log.e((String)TAG, (String)"==================\u53ef\u63a5\u5165\u514d\u8d39\u7684\u7f51\u7edc\u5206\u6790\u80fd\u529b!!!===================\n============================\u8be6\u60c5\u89c1============================\nhttps://developer.umeng.com/docs/193624/detail/194590#h2-n5n-d0l-fmj");
                                mContext = context;
                                try {
                                    WorkThreadUtil.submit((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                ImprintHandler.getImprintService((Context)mContext).registImprintCallback("apm_ctr_flag", new UMImprintChangeCallback(){

                                                    public void onImprintValueChanged(String key, String value) {
                                                        try {
                                                            if (!TextUtils.isEmpty((CharSequence)key) && "apm_ctr_flag".equals(key)) {
                                                                if (isDebug) {
                                                                    Log.i((String)TAG, (String)("common callback. apm ctr flag is " + value));
                                                                }
                                                                UMCrashUtils.saveInnerConfig(context.getApplicationContext(), key, value);
                                                            }
                                                        }
                                                        catch (Throwable e) {
                                                            e.printStackTrace();
                                                        }
                                                    }
                                                });
                                                String apmFlag = UMEnvelopeBuild.imprintProperty((Context)mContext, (String)"apm_ctr_flag", (String)"0");
                                                if (isDebug) {
                                                    Log.i((String)TAG, (String)("get common. apm ctr flag is " + apmFlag));
                                                }
                                                if (apmFlag != null && !TextUtils.isEmpty((CharSequence)apmFlag)) {
                                                    UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_ctr_flag", apmFlag);
                                                }
                                            }
                                            catch (Throwable e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                try {
                                    int apm_ctr_flag = UMCrashUtils.getInnerConfig(mContext, "apm_ctr_flag", 0);
                                    if (isDebug) {
                                        Log.i((String)TAG, (String)("int apm. flag is " + apm_ctr_flag));
                                    }
                                    if (apm_ctr_flag == -1) {
                                        return;
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                try {
                                    int hitWlState = UMCrashUtils.getInnerConfig(mContext, "hit_wl", 0);
                                    if (isDebug) {
                                        Log.i((String)TAG, (String)("int apm. hitWlState is " + hitWlState));
                                    }
                                    SamplingWhiteListUtil.setHitWL((hitWlState == 1 ? 1 : 0) != 0);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                final SharedPreferences sharedPreferences = SharedPreferencesUtils.getSharedPreferences((Context)context, (String)INTEGRATIONTESTING_SP);
                                try {
                                    CrashApi mCrashApi;
                                    UMCrash.initCrashState(context);
                                    Bundle customInfo = new Bundle();
                                    customInfo.putBoolean("mDebug", isDebug);
                                    customInfo.putBoolean("mEncryptLog", isEncrypt);
                                    customInfo.putBoolean("mZipLog", isZip);
                                    customInfo.putBoolean("mEnableKillProcessAfterCrash", sIsKillProcessAfterCrash);
                                    customInfo.putBoolean(KEY_ENABLE_CRASH_JAVA, enableUCJavaLog);
                                    customInfo.putBoolean(KEY_ENABLE_CRASH_NATIVE, enableUCNativeLog);
                                    customInfo.putBoolean(KEY_ENABLE_ANR, enableUCANRLog);
                                    if (sIsEnableLogBackup) {
                                        customInfo.putBoolean("mBackupLogs", true);
                                        customInfo.putString("mLogsBackupPathName", context.getApplicationInfo().dataDir + File.separator + "apm_backup_files");
                                    }
                                    if (isDebug) {
                                        Log.i((String)TAG, (String)("enable : java is " + enableJavaLog + ", native is " + enableNativeLog + ", anr is " + enableANRLog));
                                    }
                                    customInfo.putBoolean(KEY_ENABLE_CRASH_UNEXP, false);
                                    customInfo.putBoolean("mIsInternational", isIntl);
                                    customInfo.putBoolean("mDumpUserSolibBuildId", isBuildId);
                                    if (isIntl) {
                                        customInfo.putString("mCrashLogUploadUrl", "https://errnewlogos.umeng.com/upload");
                                        customInfo.putString("mCrashSDKAuthUrl", "https://errnewlogos.umeng.com");
                                        customInfo.putString("mCrashRateUploadUrl", "https://errnewlogos.umeng.com");
                                        if (isDebug) {
                                            Log.i((String)TAG, (String)"crash log domain is https://errnewlogos.umeng.com");
                                        }
                                    } else {
                                        customInfo.putString("mCrashLogUploadUrl", "https://errnewlog.umeng.com/upload");
                                        customInfo.putString("mCrashSDKAuthUrl", "https://errnewlog.umeng.com");
                                        customInfo.putString("mCrashRateUploadUrl", "https://errnewlog.umeng.com");
                                        if (isDebug) {
                                            Log.i((String)TAG, (String)"crash rate domain is https://errnewlog.umeng.com");
                                        }
                                    }
                                    if ((mCrashApi = CrashApi.createInstanceEx((Context)context, (String)appkey, (boolean)isDebug, (Bundle)customInfo, (ICrashClient)new CrashClientImpl())) != null) {
                                        mCrashApi.addHeaderInfo(KEY_HEADER_APPKEY, appkey);
                                        mCrashApi.addHeaderInfo(KEY_HEADER_CHANNEL, channel);
                                        mCrashApi.addHeaderInfo(KEY_HEADER_OS, "android");
                                        mCrashApi.addHeaderInfo(KEY_HEADER_CRASH_VERSION, crashSdkVersion);
                                        String umid = UMCrashUtils.getUMID(context);
                                        mCrashApi.addHeaderInfo(KEY_HEADER_UMID, umid);
                                        UCrash.addHeader((String)KEY_HEADER_APPKEY, (String)appkey);
                                        UCrash.addHeader((String)KEY_HEADER_CHANNEL, (String)channel);
                                        UCrash.addHeader((String)KEY_HEADER_OS, (String)"android");
                                        UCrash.addHeader((String)KEY_HEADER_CRASH_VERSION, (String)crashSdkVersion);
                                        UCrash.addHeader((String)KEY_HEADER_UMID, (String)umid);
                                        try {
                                            String[] strings = UMCrashUtils.getActiveUser(context);
                                            if (strings != null && strings.length == 2) {
                                                mCrashApi.addHeaderInfo(KEY_HEADER_PUID, strings[1]);
                                                mCrashApi.addHeaderInfo(KEY_HEADER_PROVIDER, strings[0]);
                                                UCrash.addHeader((String)KEY_HEADER_PUID, (String)strings[1]);
                                                UCrash.addHeader((String)KEY_HEADER_PROVIDER, (String)strings[0]);
                                            }
                                        }
                                        catch (Throwable e) {
                                            mCrashApi.addHeaderInfo(KEY_HEADER_PUID, "");
                                            mCrashApi.addHeaderInfo(KEY_HEADER_PROVIDER, "");
                                            UCrash.addHeader((String)KEY_HEADER_PUID, (String)"");
                                            UCrash.addHeader((String)KEY_HEADER_PROVIDER, (String)"");
                                        }
                                        mCrashApi.addHeaderInfo(KEY_HEADER_CARRIER, UMCrashUtils.getNetworkOperatorName(context));
                                        UCrash.addHeader((String)KEY_HEADER_CARRIER, (String)UMCrashUtils.getNetworkOperatorName(context));
                                        if (!TextUtils.isEmpty((CharSequence)userBver)) {
                                            mCrashApi.addHeaderInfo(KEY_HEADER_BVER, userBver);
                                            UCrash.addHeader((String)KEY_HEADER_BVER, (String)userBver);
                                        }
                                        if (!TextUtils.isEmpty((CharSequence)userBsver)) {
                                            mCrashApi.addHeaderInfo(KEY_HEADER_BSVER, userBsver);
                                            UCrash.addHeader((String)KEY_HEADER_BSVER, (String)userBsver);
                                        }
                                        if (!TextUtils.isEmpty((CharSequence)userBesrial)) {
                                            mCrashApi.addHeaderInfo(KEY_HEADER_BESRIAL, userBesrial);
                                            UCrash.addHeader((String)KEY_HEADER_BESRIAL, (String)userBesrial);
                                        }
                                        try {
                                            int netType = NetworkUtil.getNetworkTypeUmeng((Context)context);
                                            mCrashApi.addHeaderInfo(KEY_HEADER_NETWORK_TYPE, "" + netType);
                                            UCrash.addHeader((String)KEY_HEADER_NETWORK_TYPE, (String)("" + netType));
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                        }
                                        try {
                                            if (UMCrashUtils.isHarmony(context)) {
                                                mCrashApi.addHeaderInfo("others_OS", "harmony");
                                                UCrash.addHeader((String)"others_OS", (String)"harmony");
                                            } else {
                                                mCrashApi.addHeaderInfo("others_OS", "Android");
                                                UCrash.addHeader((String)"others_OS", (String)"Android");
                                            }
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                        }
                                        UMCrash.registerInfoCallback(mCrashApi);
                                        if (context instanceof Application) {
                                            ((Application)context).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                                                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                                                    Set params;
                                                    String scheme;
                                                    Uri data;
                                                    Intent intent;
                                                    UMCrash.saveActivityState(activity.getClass().getName(), UMCrash.KEY_ACTIITY_ON_CREATED);
                                                    if (index == 0 && (intent = activity.getIntent()) != null && (data = intent.getData()) != null && null != (scheme = data.getScheme()) && !scheme.isEmpty() && scheme.contains("um." + appkey) && (params = data.getQueryParameterNames()).contains(UMCrash.IT_DEBUGKEY) && params.contains(UMCrash.IT_SENDAGING)) {
                                                        String debugKey = data.getQueryParameter(UMCrash.IT_DEBUGKEY);
                                                        String sendaging = data.getQueryParameter(UMCrash.IT_SENDAGING);
                                                        long period = 0L;
                                                        try {
                                                            period = Long.parseLong(sendaging);
                                                        }
                                                        catch (NumberFormatException numberFormatException) {
                                                            // empty catch block
                                                        }
                                                        if (period < 0L) {
                                                            sharedPreferences.edit().clear().apply();
                                                            IntegrationTestingUtil.setIntegrationTestingInPeriod((boolean)false);
                                                        } else {
                                                            if (period > 6L) {
                                                                period = 6L;
                                                            }
                                                            sharedPreferences.edit().putString(UMCrash.SP_KEY_DEBUG, debugKey).apply();
                                                            sharedPreferences.edit().putLong(UMCrash.SP_KEY_TIMESTAMP, System.currentTimeMillis() + period * 60L * 60L * 1000L).apply();
                                                            UMCrashUtils.setIntegrationTesingParams(debugKey);
                                                            IntegrationTestingUtil.setIntegrationTestingInPeriod((boolean)true);
                                                        }
                                                    }
                                                }

                                                public void onActivityStarted(Activity activity) {
                                                    UMCrash.saveActivityState(activity.getClass().getName(), UMCrash.KEY_ACTIITY_ON_STARTED);
                                                    UMMemoryMonitor.get().onActivityStarted(activity);
                                                    PowerManager.onActivityStarted((Activity)activity);
                                                }

                                                public void onActivityResumed(Activity activity) {
                                                    UMCrash.saveActivityState(activity.getClass().getName(), UMCrash.KEY_ACTIITY_ON_RESUMED);
                                                    UMMemoryMonitor.get().onActivityResumed(activity);
                                                    PowerManager.onActivityResumed((Activity)activity);
                                                    index++;
                                                }

                                                public void onActivityPaused(Activity activity) {
                                                    UMCrash.saveActivityState(activity.getClass().getName(), UMCrash.KEY_ACTIITY_ON_PAUSED);
                                                    index--;
                                                }

                                                public void onActivityStopped(Activity activity) {
                                                    UMCrash.saveActivityState(activity.getClass().getName(), UMCrash.KEY_ACTIITY_ON_STOPPED);
                                                    UMMemoryMonitor.get().onActivityStopped(activity);
                                                    PowerManager.onActivityStopped((Activity)activity);
                                                }

                                                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                                                }

                                                public void onActivityDestroyed(Activity activity) {
                                                    UMCrash.saveActivityState(activity.getClass().getName(), UMCrash.KEY_ACTIITY_ON_DESTROYED);
                                                }
                                            });
                                        } else {
                                            Log.e((String)TAG, (String)"context not instanceof application.");
                                        }
                                        try {
                                            WorkThreadUtil.submit((Runnable)new Runnable(){

                                                @Override
                                                public void run() {
                                                    try {
                                                        String[] access = NetworkUtil.getNetworkAccessMode((Context)context);
                                                        if ("Wi-Fi".equals(access[0])) {
                                                            mCrashApi.addHeaderInfo(UMCrash.KEY_HEADER_ACCESS, "wifi");
                                                            UCrash.addHeader((String)UMCrash.KEY_HEADER_ACCESS, (String)"wifi");
                                                        } else if ("2G/3G".equals(access[0])) {
                                                            mCrashApi.addHeaderInfo(UMCrash.KEY_HEADER_ACCESS, "2G/3G");
                                                            UCrash.addHeader((String)UMCrash.KEY_HEADER_ACCESS, (String)"2G/3G");
                                                        } else {
                                                            mCrashApi.addHeaderInfo(UMCrash.KEY_HEADER_ACCESS, "unknow");
                                                            UCrash.addHeader((String)UMCrash.KEY_HEADER_ACCESS, (String)"unknow");
                                                        }
                                                        if (!"".equals(access[1])) {
                                                            mCrashApi.addHeaderInfo(UMCrash.KEY_HEADER_ACCESS_SUBTYPE, access[1]);
                                                            UCrash.addHeader((String)UMCrash.KEY_HEADER_ACCESS_SUBTYPE, (String)access[1]);
                                                        }
                                                    }
                                                    catch (Throwable e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                            });
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                        }
                                    } else {
                                        Log.e((String)TAG, (String)"create CrashAPI is null.");
                                    }
                                    UCrashConfig.Builder builder = new UCrashConfig.Builder().setLogEnable(isDebug).setJavaCrashEnable(enableUMJavaLog).setNativeCrashEnable(enableUMNativeLog).setAnrEnable(enableUMANRLog).setAnrTraceHkEnable(enableUMAnrTrace).setCustomEnable(enableUMUserLog).setCustomUploadImmediately(isUploadNowUserCrash).setBackupEnable(sIsEnableLogBackup).setBackupDir(context.getApplicationInfo().dataDir + File.separator + "apm_backup_files").setJavaDumpAllThreads(true).setNativeDumpAllThreads(true).setJavaCrashRethrow(!sIsKillProcessAfterCrash).setUrl((isIntl ? "https://errnewlogos.umeng.com" : "https://errnewlog.umeng.com") + "/upload").setCallback((UCrashCallback)new UCrashCallbackImpl());
                                    UCrash.init((Context)context, (UCrashConfig)builder.build());
                                }
                                catch (Throwable customInfo) {
                                    // empty catch block
                                }
                                try {
                                    int rate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_codelog_state", -1);
                                    if (isDebug) {
                                        Log.i((String)TAG, (String)("inner config : code log rate is " + rate));
                                    }
                                    if (rate == 0) {
                                        if (isDebug) {
                                            Log.i((String)TAG, (String)"inner config : code log close.");
                                        }
                                    } else if (rate == 100) {
                                        if (isDebug) {
                                            Log.i((String)TAG, (String)"inner config : code log open.");
                                        }
                                        if (enableCodeLog) {
                                            if (TextUtils.isEmpty((CharSequence)ULogManager.getDeviceID())) {
                                                String umid = UMCrashUtils.getUMID(mContext);
                                                if (isDebug) {
                                                    Log.i((String)TAG, (String)("inner config : code log set umid is " + umid));
                                                }
                                                ULogManager.setDeviceID((String)umid);
                                            }
                                            isCodeLog = true;
                                        }
                                    }
                                    if (isDebug) {
                                        Log.i((String)TAG, (String)("enable codeLog is " + isCodeLog));
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                try {
                                    UMCrash.initReporter(context, appkey, channel);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                try {
                                    String debugKey = sharedPreferences.getString(SP_KEY_DEBUG, "");
                                    if (sharedPreferences.getLong(SP_KEY_TIMESTAMP, 0L) - System.currentTimeMillis() >= 0L && !TextUtils.isEmpty((CharSequence)debugKey)) {
                                        IntegrationTestingUtil.setIntegrationTestingInPeriod((boolean)true);
                                        UMCrashUtils.setIntegrationTesingParams(debugKey);
                                    } else {
                                        sharedPreferences.edit().clear().apply();
                                        IntegrationTestingUtil.setIntegrationTestingInPeriod((boolean)false);
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                try {
                                    if (enablePaLog) {
                                        WorkThreadUtil.submit((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                try {
                                                    PAFactory.Builder builder = new PAFactory.Builder(context.getApplicationContext(), new IEfsReporter(){

                                                        public EfsReporter getReporter() {
                                                            return sReporter;
                                                        }
                                                    });
                                                    builder.packageLevel(PackageLevel.RELEASE);
                                                    builder.timeoutTime(paTimeoutTime);
                                                    builder.setPaClient((IPaClient)new PaClientImpl());
                                                    PAFactory paFactory = builder.build();
                                                    paFactory.getPaInstance().start();
                                                    isPA = paFactory.getConfigManager().enableTracer();
                                                }
                                                catch (Throwable e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        });
                                    } else if (isDebug) {
                                        Log.e((String)TAG, (String)"enablePaLog is false");
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                try {
                                    if (enableLaunchLog) {
                                        LaunchManager.init((Context)context, (EfsReporter)sReporter);
                                        try {
                                            if (LaunchManager.getLaunchConfigManager() != null) {
                                                isLa = LaunchManager.getLaunchConfigManager().enableTracer();
                                            }
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                        }
                                        String umid = UMCrashUtils.getUMID(context);
                                        if (umid == null || TextUtils.isEmpty((CharSequence)umid)) {
                                            if (isDebug) {
                                                Log.i((String)TAG, (String)"begin register common callback.  key is umid.");
                                            }
                                            ImprintHandler.getImprintService((Context)context).registImprintCallback("umid", new UMImprintChangeCallback(){

                                                public void onImprintValueChanged(String key, String value) {
                                                    if (isDebug) {
                                                        Log.i((String)TAG, (String)("common callback.  key is " + key + "; value is " + value));
                                                    }
                                                    try {
                                                        if ("umid".equals(key)) {
                                                            LaunchManager.sendLaunchCache((Context)context, (String)value);
                                                            ImprintHandler.getImprintService((Context)context).unregistImprintCallback("umid", (UMImprintChangeCallback)this);
                                                        }
                                                    }
                                                    catch (Throwable e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                            });
                                        }
                                        break block143;
                                    }
                                    if (isDebug) {
                                        Log.e((String)TAG, (String)"enableLaunchLog is false");
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                            try {
                                if (enableMemLog) {
                                    UMMemoryMonitor.get().start(context, sReporter);
                                } else if (isDebug) {
                                    Log.e((String)TAG, (String)"enableMemLog is false");
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                            try {
                                int rate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_netperf_state", -1);
                                if (isDebug) {
                                    Log.i((String)TAG, (String)("inner config : net rate is " + rate));
                                }
                                if (rate == 0) {
                                    if (isDebug) {
                                        Log.i((String)TAG, (String)"inner config : net close.");
                                    }
                                    break block144;
                                }
                                if (rate != 100) break block144;
                                if (isDebug) {
                                    Log.i((String)TAG, (String)"inner config : net open.");
                                }
                                if (enableNetLog) {
                                    NetManager.init((Context)context, (EfsReporter)sReporter);
                                    try {
                                        if (NetManager.getNetConfigManager() != null) {
                                            isNet = NetManager.getNetConfigManager().enableTracer();
                                        }
                                        break block144;
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                    break block144;
                                }
                                if (isDebug) {
                                    Log.e((String)TAG, (String)"enableNetLog is false");
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            int nativeH5Rate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_native_h5_state", -1);
                            if (isDebug) {
                                Log.i((String)TAG, (String)("inner config : nativeH5Rate is " + nativeH5Rate));
                            }
                            if (nativeH5Rate == 0) {
                                if (isDebug) {
                                    Log.i((String)TAG, (String)"inner config : h5 close.");
                                }
                            } else if (nativeH5Rate == 100) {
                                if (isDebug) {
                                    Log.i((String)TAG, (String)"inner config : h5 open.");
                                }
                                if (enableH5PageLog) {
                                    H5Manager.init((Context)context, (EfsReporter)sReporter);
                                } else if (isDebug) {
                                    Log.e((String)TAG, (String)"enableH5PageLog is false");
                                }
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        try {
                            int rate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_page_state", -1);
                            if (isDebug) {
                                Log.i((String)TAG, (String)("inner config : page rate is " + rate));
                            }
                            if (rate == 0) {
                                if (isDebug) {
                                    Log.i((String)TAG, (String)"inner config : page close.");
                                }
                                break block145;
                            }
                            if (rate != 100) break block145;
                            if (isDebug) {
                                Log.i((String)TAG, (String)"inner config : page open.");
                            }
                            if (enablePageLog) {
                                PageManger.init((Context)mContext, (EfsReporter)sReporter);
                                try {
                                    if (PageManger.getPageConfigManger() != null) {
                                        isPage = PageManger.getPageConfigManger().enableTracer();
                                    }
                                    break block145;
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                break block145;
                            }
                            if (isDebug) {
                                Log.e((String)TAG, (String)"enablePageLog is false");
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        int rate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_power_state", -1);
                        if (isDebug) {
                            Log.i((String)TAG, (String)("inner config : power rate is " + rate));
                        }
                        if (rate == 0) {
                            if (isDebug) {
                                Log.i((String)TAG, (String)"inner config : power close.");
                            }
                            break block146;
                        }
                        if (rate != 100) break block146;
                        if (isDebug) {
                            Log.i((String)TAG, (String)"inner config : power open.");
                        }
                        if (enablePowerLog) {
                            PowerManager.init((Context)mContext, (EfsReporter)sReporter);
                            try {
                                if (PowerManager.getPowerConfigManager() != null) {
                                    isPower = PowerManager.getPowerConfigManager().enableTracer();
                                }
                                break block146;
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                            break block146;
                        }
                        if (isDebug) {
                            Log.e((String)TAG, (String)"enablePowerLog is false");
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                try {
                    int rate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_flutter_state", -1);
                    if (isDebug) {
                        Log.i((String)TAG, (String)("inner config : flutter rate is " + rate));
                    }
                    if (rate == 0) {
                        if (isDebug) {
                            Log.i((String)TAG, (String)"inner config : flutter close.");
                        }
                        break block147;
                    }
                    if (rate != 100) break block147;
                    if (isDebug) {
                        Log.i((String)TAG, (String)"inner config : flutter open.");
                    }
                    if (enableFlutterLog) {
                        FlutterManager.init((Context)mContext, (EfsReporter)sReporter);
                        try {
                            if (FlutterManager.getFlutterConfigManager() != null) {
                                isFlutter = FlutterManager.getFlutterConfigManager().isFlutterEnable();
                            }
                            break block147;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        break block147;
                    }
                    if (isDebug) {
                        Log.e((String)TAG, (String)"enableFlutterLog is false");
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            try {
                int rate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_memleak_state", -1);
                if (isDebug) {
                    Log.i((String)TAG, (String)("inner config : memleak rate is " + rate));
                }
                if (rate == 0) {
                    if (isDebug) {
                        Log.i((String)TAG, (String)"inner config : memleak close.");
                    }
                    break block148;
                }
                if (rate != 100) break block148;
                if (isDebug) {
                    Log.i((String)TAG, (String)"inner config : memleak open.");
                }
                if (enableMemLeakLog) {
                    MemLeakManager.init((Context)mContext, (EfsReporter)sReporter, (IMemLeakClient)new MemLeakClientImpl());
                    try {
                        if (MemLeakManager.getMemLeakConfigManager() != null) {
                            isMemLeak = MemLeakManager.getMemLeakConfigManager().enableTracer();
                        }
                        break block148;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    break block148;
                }
                if (isDebug) {
                    Log.e((String)TAG, (String)"enableMemLeakLog is false");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        try {
            sApmCallbackLimit = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_callback_limit", -1);
            if (isDebug) {
                Log.i((String)TAG, (String)("inner config : callback limit is " + sApmCallbackLimit));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (isCodeLog) {
            ULogManager.init((Context)mContext, (EfsReporter)sReporter);
        }
    }

    private static void initCrashState(Context context) {
        try {
            int ucRate;
            int umRate;
            if (enableJavaLog) {
                umRate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_um_crash_java_sampling_rate", 100);
                enableUMJavaLog = UMCrashUtils.random(umRate);
                if (!enableUMJavaLog) {
                    ucRate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_crash_java_sampling_rate", 100);
                    enableUCJavaLog = UMCrashUtils.random(ucRate);
                }
                enableJavaLog = enableUMJavaLog || enableUCJavaLog;
            } else {
                enableUMJavaLog = false;
                enableUCJavaLog = false;
            }
            if (enableNativeLog) {
                umRate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_um_crash_native_sampling_rate", 100);
                enableUMNativeLog = UMCrashUtils.random(umRate);
                if (!enableUMNativeLog) {
                    ucRate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_crash_native_sampling_rate", 100);
                    enableUCNativeLog = UMCrashUtils.random(ucRate);
                }
                enableNativeLog = enableUMNativeLog || enableUCNativeLog;
            } else {
                enableUMNativeLog = false;
                enableUCNativeLog = false;
            }
            if (enableANRLog) {
                umRate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_um_crash_anr_sampling_rate", 100);
                enableUMANRLog = UMCrashUtils.random(umRate);
                if (!enableUMANRLog) {
                    ucRate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_crash_anr_sampling_rate", 100);
                    enableUCANRLog = UMCrashUtils.random(ucRate);
                }
                enableANRLog = enableUMANRLog || enableUCANRLog;
            } else {
                enableUMANRLog = false;
                enableUCANRLog = false;
            }
            umRate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_um_crash_user_sampling_rate", 100);
            enableUMUserLog = UMCrashUtils.random(umRate);
            if (!enableUMUserLog) {
                ucRate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_crash_user_sampling_rate", 100);
                enableUCUserLog = UMCrashUtils.random(ucRate);
            }
            isOpenUserCrash = enableUMUserLog || enableUCUserLog;
            umRate = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_um_crash_anr_trace_state", 100);
            enableUMAnrTrace = UMCrashUtils.random(umRate);
            int upload = UMCrashUtils.getInnerConfig(context.getApplicationContext(), "apm_crash_user_upload_type", -1);
            isUploadNowUserCrash = upload == 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void registerInfoCallback(CrashApi crashApi) {
        crashApi.registerInfoCallback(KEY_CALLBACK_USER_STRING_JAVA, 16);
        crashApi.registerInfoCallback(KEY_CALLBACK_USER_STRING_NATIVE, 1);
        crashApi.registerInfoCallback(KEY_CALLBACK_USER_STRING_ANR, 0x100000);
        crashApi.registerInfoCallback(KEY_CALLBACK_USER_STRING_CUSTOM_LOG, 256);
        int logType = 0x100011;
        crashApi.registerInfoCallback(KEY_CALLBACK_UM_INFOS, logType);
        crashApi.registerInfoCallback(KEY_CALLBACK_UMID, logType);
    }

    private static void saveActivityState(String className, String methodName) {
        try {
            if (mArrayList != null) {
                if (mArrayList.size() >= 20) {
                    mArrayList.remove(0);
                }
                mArrayList.add(className + "-" + System.currentTimeMillis() + "-" + methodName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void initReporter(final Context context, String appkey, String channel) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(KEY_HEADER_UMID, UMCrashUtils.getUMID(context));
        params.put(KEY_HEADER_CHANNEL, channel);
        params.put(KEY_HEADER_CARRIER, UMCrashUtils.getNetworkOperatorName(context));
        params.put(KEY_HEADER_OS, "android");
        params.put(KEY_HEADER_CRASH_VERSION, crashSdkVersion);
        try {
            String[] strings = UMCrashUtils.getActiveUser(context);
            if (strings != null && strings.length == 2) {
                params.put(KEY_HEADER_PUID, strings[1]);
                params.put(KEY_HEADER_PROVIDER, strings[0]);
            }
        }
        catch (Throwable e) {
            params.put(KEY_HEADER_PUID, "");
            params.put(KEY_HEADER_PROVIDER, "");
        }
        if (!TextUtils.isEmpty((CharSequence)userBver)) {
            params.put(KEY_HEADER_BVER, userBver);
        }
        if (!TextUtils.isEmpty((CharSequence)userBsver)) {
            params.put(KEY_HEADER_BSVER, userBsver);
        }
        if (!TextUtils.isEmpty((CharSequence)userBesrial)) {
            params.put(KEY_HEADER_BESRIAL, userBesrial);
        }
        try {
            if (UMCrashUtils.isHarmony(context)) {
                params.put("others_OS", "harmony");
            } else {
                params.put("others_OS", "Android");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        sReporter = new EfsReporter.Builder(context.getApplicationContext(), appkey, KEY_APM_DEFAULT_SECRET).debug(isDebug).enablePaBackup(sIsEnableLogBackup).efsDirRootName(KEY_APM_ROOT_NAME).printLogDetail(isDebug).intl(isIntl).enableWaStat(false).logUid(ULogManager.getUserID()).logDid(ULogManager.getDeviceID()).setOpenCodeLog(isCodeLog).build();
        sReporter.addPublicParams(params);
        try {
            if (isCodeLog) {
                UploadFileFilterCodeLog fileFilterCodeLog = new UploadFileFilterCodeLog();
                sReporter.setFileFilterCodeLog((IFileFilter)fileFilterCodeLog);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            sReporter.getAllSdkConfig(new String[]{"apm_codelog_state", "hit_wl", "apm_memleak_state", "apm_flutter_state", "apm_power_state", "apm_page_state", "apm_netperf_state", "apm_native_h5_state", "apm_crash_java_sampling_rate", "apm_crash_native_sampling_rate", "apm_crash_anr_sampling_rate", "apm_crash_user_sampling_rate", "apm_crash_user_max_count", "apm_crash_user_upload_type", "apm_callback_limit", "apm_um_crash_java_sampling_rate", "apm_um_crash_native_sampling_rate", "apm_um_crash_anr_sampling_rate", "apm_um_crash_user_sampling_rate", "apm_um_crash_anr_trace_state"}, new IConfigCallback(){

                public void onChange(Map<String, Object> map) {
                    try {
                        Object netRate = map.get("apm_netperf_state");
                        if (netRate != null) {
                            if (isDebug) {
                                Log.i((String)"efs.config", (String)("callback netRate is " + netRate.toString()));
                            }
                            UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_netperf_state", netRate);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        Object nativeH5Rate = map.get("apm_native_h5_state");
                        if (nativeH5Rate != null) {
                            if (isDebug) {
                                Log.i((String)"efs.config", (String)("callback nativeH5Rate is " + nativeH5Rate.toString()));
                            }
                            UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_native_h5_state", nativeH5Rate);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        UMCrash.saveLocalCrashSampling(context, map);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        UMCrash.updateLocalCrashConfig(context, map);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        Object uploadType = map.get("apm_crash_user_upload_type");
                        if (uploadType != null) {
                            int type;
                            if (isDebug) {
                                Log.i((String)"efs.config", (String)("callback uploadType is " + uploadType.toString()));
                            }
                            if ((type = Integer.valueOf(uploadType.toString()).intValue()) == 0) {
                                isUploadNowUserCrash = true;
                            } else {
                                isUploadNowUserCrash = false;
                            }
                            UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_crash_user_upload_type", uploadType);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        Object pageRate = map.get("apm_page_state");
                        if (pageRate != null) {
                            if (isDebug) {
                                Log.i((String)"efs.config", (String)("callback pageRate is " + pageRate.toString()));
                            }
                            UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_page_state", pageRate);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        Object codeLogRate = map.get("apm_codelog_state");
                        if (codeLogRate != null) {
                            if (isDebug) {
                                Log.i((String)"efs.config", (String)("callback codeLogRate is " + codeLogRate.toString()));
                            }
                            UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_codelog_state", codeLogRate);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        Object powerRate = map.get("apm_power_state");
                        if (powerRate != null) {
                            if (isDebug) {
                                Log.i((String)"efs.config", (String)("callback powerRate is " + powerRate));
                            }
                            UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_power_state", powerRate);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        Object hitWlState = map.get("hit_wl");
                        if (hitWlState != null) {
                            if (isDebug) {
                                Log.i((String)"efs.config", (String)("callback hitwl is " + hitWlState));
                            }
                            UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "hit_wl", hitWlState);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        Object flutterRate = map.get("apm_flutter_state");
                        if (flutterRate != null) {
                            if (isDebug) {
                                Log.i((String)"efs.config", (String)("callback flutterRate is " + flutterRate));
                            }
                            UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_flutter_state", flutterRate);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        Object memLeakRate = map.get("apm_memleak_state");
                        if (memLeakRate != null) {
                            if (isDebug) {
                                Log.i((String)"efs.config", (String)("callback memLeakRate is " + memLeakRate));
                            }
                            UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_memleak_state", memLeakRate);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        Object callbackLimit = map.get("apm_callback_limit");
                        if (callbackLimit != null) {
                            if (isDebug) {
                                Log.i((String)"efs.config", (String)("callback callbackLimit is " + callbackLimit));
                            }
                            UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_callback_limit", callbackLimit);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void saveLocalCrashSampling(Context context, Map<String, Object> map) {
        if (context != null && map != null) {
            Object ucCrashUserSampling;
            Object ucCrashANRSampling;
            Object ucCrashNativeSampling;
            Object ucCrashJavaSampling;
            Object umCrashANRTraceSampling;
            Object umCrashUserSampling;
            Object umCrashANRSampling;
            Object umCrashNativeSampling;
            Object umCrashJavaSampling = map.get("apm_um_crash_java_sampling_rate");
            if (umCrashJavaSampling != null) {
                if (isDebug) {
                    Log.i((String)"efs.config", (String)("callback umCrashJavaSampling is " + umCrashJavaSampling));
                }
                UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_um_crash_java_sampling_rate", umCrashJavaSampling);
            }
            if ((umCrashNativeSampling = map.get("apm_um_crash_native_sampling_rate")) != null) {
                if (isDebug) {
                    Log.i((String)"efs.config", (String)("callback umCrashNativeSampling is " + umCrashNativeSampling));
                }
                UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_um_crash_native_sampling_rate", umCrashNativeSampling);
            }
            if ((umCrashANRSampling = map.get("apm_um_crash_anr_sampling_rate")) != null) {
                if (isDebug) {
                    Log.i((String)"efs.config", (String)("callback umCrashANRSampling is " + umCrashANRSampling));
                }
                UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_um_crash_anr_sampling_rate", umCrashANRSampling);
            }
            if ((umCrashUserSampling = map.get("apm_um_crash_user_sampling_rate")) != null) {
                if (isDebug) {
                    Log.i((String)"efs.config", (String)("callback umCrashUserSampling is " + umCrashUserSampling));
                }
                UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_um_crash_user_sampling_rate", umCrashUserSampling);
            }
            if ((umCrashANRTraceSampling = map.get("apm_um_crash_anr_trace_state")) != null) {
                if (isDebug) {
                    Log.i((String)"efs.config", (String)("callback umCrashANRTraceSampling is " + umCrashANRTraceSampling));
                }
                UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_um_crash_anr_trace_state", umCrashANRTraceSampling);
            }
            if ((ucCrashJavaSampling = map.get("apm_crash_java_sampling_rate")) != null) {
                if (isDebug) {
                    Log.i((String)"efs.config", (String)("callback ucCrashJavaSampling is " + ucCrashJavaSampling));
                }
                UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_crash_java_sampling_rate", ucCrashJavaSampling);
            }
            if ((ucCrashNativeSampling = map.get("apm_crash_native_sampling_rate")) != null) {
                if (isDebug) {
                    Log.i((String)"efs.config", (String)("callback ucCrashNativeSampling is " + ucCrashNativeSampling));
                }
                UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_crash_native_sampling_rate", ucCrashNativeSampling);
            }
            if ((ucCrashANRSampling = map.get("apm_crash_anr_sampling_rate")) != null) {
                if (isDebug) {
                    Log.i((String)"efs.config", (String)("callback ucCrashANRSampling is " + ucCrashANRSampling));
                }
                UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_crash_anr_sampling_rate", ucCrashANRSampling);
            }
            if ((ucCrashUserSampling = map.get("apm_crash_user_sampling_rate")) != null) {
                if (isDebug) {
                    Log.i((String)"efs.config", (String)("callback ucCrashUserSampling is " + ucCrashUserSampling));
                }
                UMCrashUtils.saveInnerConfig(context.getApplicationContext(), "apm_crash_user_sampling_rate", ucCrashUserSampling);
            }
        }
    }

    private static void updateLocalCrashSampling(Object crashJavaSampling, Object crashNativeSampling, Object crashANRSampling, Object crashUserSampling) {
        CrashApi crashApi = CrashApi.getInstance();
        if (crashApi != null) {
            if (crashJavaSampling != null && UMCrashUtils.random(Integer.valueOf(crashJavaSampling.toString()))) {
                crashApi.disableLog(16);
            }
            if (crashNativeSampling != null && UMCrashUtils.random(Integer.valueOf(crashNativeSampling.toString()))) {
                crashApi.disableLog(1);
            }
            if (crashANRSampling != null && UMCrashUtils.random(Integer.valueOf(crashANRSampling.toString()))) {
                crashApi.disableLog(0x100000);
            }
            if (crashUserSampling != null && UMCrashUtils.random(Integer.valueOf(crashUserSampling.toString()))) {
                isOpenUserCrash = false;
            }
        }
    }

    private static void updateLocalCrashConfig(Context context, Map<String, Object> map) {
        if (context != null && map != null) {
            Bundle customInfo = new Bundle();
            Object crashMaxUserCount = map.get("apm_crash_user_max_count");
            if (crashMaxUserCount != null) {
                if (isDebug) {
                    Log.i((String)"efs.config", (String)("callback crashMaxUserCount is " + crashMaxUserCount.toString()));
                }
                customInfo.putInt("mMaxCustomLogCountPerTypePerDay", Integer.valueOf(crashMaxUserCount.toString()).intValue());
                customInfo.putInt("mMaxUploadCustomLogCountPerDay", Integer.valueOf(crashMaxUserCount.toString()).intValue());
                UCrash.updateCustomLogLimit((int)Integer.valueOf(crashMaxUserCount.toString()), (int)Integer.valueOf(crashMaxUserCount.toString()));
            }
            CrashApi.getInstance().updateCustomInfo(customInfo);
        }
    }

    public static void registerUMCrashCallback(UMCrashCallback umCrashCallback) {
        if (umCrashCallback != null) {
            mUMCrashCallback = umCrashCallback;
            if (CrashApi.getInstance() != null) {
                int logType = 0x100011;
                CrashApi.getInstance().registerInfoCallback(KEY_CALLBACK_USER_STRING, logType);
            } else {
                Log.e((String)TAG, (String)"callback error, instance is null.");
            }
        } else {
            Log.e((String)TAG, (String)"callback error.");
        }
    }

    public static void registerUMCrashCallback(IUMCrashCallbackWithType umCrashCallbackWithType) {
        if (umCrashCallbackWithType != null) {
            mUMCrashCallbackWithType = umCrashCallbackWithType;
        } else {
            Log.e((String)TAG, (String)"callback error.");
        }
    }

    public static void registerPerfCallback(IUMPerfCallback callback) {
        EfsReporter.registerPerfCallback((IUMPerfCallback)callback);
    }

    public static void generateCustomLog(Throwable e, String type) {
        UMCrash.generateCustomLog(e, type, false, false);
    }

    public static void generateCustomLog(Throwable e, String type, boolean withLogcat, boolean allThreadsDump) {
        UMCrash.generateCustomLog(e, type, null, withLogcat, allThreadsDump);
    }

    public static void generateCustomLog(Throwable e, String type, String errorMsg, boolean withLogcat, boolean allThreadsDump) {
        UAPMCustomException.generateCustomLog(enableUMUserLog, enableUCUserLog, isUploadNowUserCrash, e, type, errorMsg, withLogcat, allThreadsDump);
    }

    public static void generateCustomLog(String e, String type) {
        UMCrash.generateCustomLog(e, type, false, false);
    }

    public static void generateCustomLog(String e, String type, boolean withLogcat, boolean allThreadsDump) {
        UMCrash.generateCustomLog(e, type, null, withLogcat, allThreadsDump);
    }

    public static void generateCustomLog(String e, String type, String errorMsg, boolean withLogcat, boolean allThreadsDump) {
        UAPMCustomException.generateCustomLog(enableUMUserLog, enableUCUserLog, isUploadNowUserCrash, e, type, errorMsg, withLogcat, allThreadsDump);
    }

    public static void enableLogBackup(boolean isEnableLogBackup) {
        sIsEnableLogBackup = isEnableLogBackup;
    }

    public static void addCustomInfo(String key, String value) {
        UAPMCustomInfo.addCustomInfo(key, value);
    }

    public static void reRegisterAnrHandler() {
        if (enableUMANRLog) {
            UCrash.reRegisterAnrHandler();
        }
    }

    static {
        sIsKillProcessAfterCrash = true;
        sIsEnableLogBackup = false;
        isDebug = true;
        isEncrypt = false;
        isZip = true;
        isIntl = false;
        isBuildId = true;
        crashSdkVersion = "2.0.4";
        pageArrayLock = new Object();
        mArrayList = new ArrayList(10);
        sApmCallbackLimit = 0;
        isPA = false;
        isLa = false;
        isNet = false;
        isPage = false;
        isPower = false;
        isFlutter = false;
        isCodeLog = false;
        isMemLeak = false;
        enableJavaLog = true;
        enableNativeLog = true;
        enableANRLog = true;
        enablePaLog = true;
        enableLaunchLog = true;
        enableMemLog = true;
        enableNetLog = true;
        enableH5PageLog = true;
        enablePageLog = true;
        enableCodeLog = true;
        enablePowerLog = true;
        enableFlutterLog = true;
        enableMemLeakLog = true;
        enableUCJavaLog = false;
        enableUCNativeLog = false;
        enableUCANRLog = false;
        enableUCUserLog = false;
        enableUMJavaLog = true;
        enableUMNativeLog = true;
        enableUMANRLog = true;
        enableUMUserLog = true;
        enableUMAnrTrace = true;
        paTimeoutTime = 2000L;
        index = 0;
        isOpenUserCrash = true;
        isUploadNowUserCrash = false;
    }

    private static class MemLeakClientImpl
    implements IMemLeakClient {
        private MemLeakClientImpl() {
        }

        public String onGetCallbackInfo(String category) {
            if (UMCrash.KEY_CALLBACK_PAGE_ACTION.equals(category)) {
                String result = null;
                try {
                    if (mArrayList != null && mArrayList.size() > 0) {
                        JSONObject jsonSec = new JSONObject();
                        jsonSec.put("source", 0);
                        jsonSec.put("action_name", (Object)"page_view");
                        jsonSec.put("action_page_state", isPage);
                        JSONArray jsonParameter = new JSONArray();
                        for (int i = 0; i < mArrayList.size(); ++i) {
                            String item = (String)mArrayList.get(i);
                            if (item == null) continue;
                            JSONObject jsonitem = new JSONObject();
                            jsonitem.put("name", (Object)item);
                            jsonParameter.put((Object)jsonitem);
                        }
                        jsonSec.put("action_parameter", (Object)jsonParameter);
                        result = jsonSec.toString();
                        if (isDebug) {
                            Log.i((String)TAG, (String)("page json is " + result));
                        }
                    }
                }
                catch (Throwable jsonSec) {
                    // empty catch block
                }
                return result;
            }
            if (UMCrash.KEY_CALLBACK_USER_STRING.equals(category)) {
                if (mUMCrashCallbackWithType != null) {
                    String callbackString = mUMCrashCallbackWithType.onCallback(IUMCrashCallbackWithType.CrashType.CRASH_TYPE_MEM_LEAK);
                    if (callbackString == null) {
                        return null;
                    }
                    int len = callbackString.trim().getBytes().length;
                    if (len > Math.max(20480, sApmCallbackLimit)) {
                        callbackString = UMCrashUtils.splitByByte(callbackString, Math.max(20480, sApmCallbackLimit));
                    }
                    return callbackString;
                }
                if (mUMCrashCallback != null) {
                    String callbackString = mUMCrashCallback.onCallback();
                    if (callbackString == null) {
                        return null;
                    }
                    int len = callbackString.trim().getBytes().length;
                    if (len > Math.max(20480, sApmCallbackLimit)) {
                        callbackString = UMCrashUtils.splitByByte(callbackString, Math.max(20480, sApmCallbackLimit));
                    }
                    return callbackString;
                }
                return null;
            }
            return null;
        }
    }

    private static class PaClientImpl
    implements IPaClient {
        private PaClientImpl() {
        }

        public String onGetCallbackInfo(String category) {
            if (UMCrash.KEY_CALLBACK_PAGE_ACTION.equals(category)) {
                String result = null;
                try {
                    if (mArrayList != null && mArrayList.size() > 0) {
                        JSONObject jsonSec = new JSONObject();
                        jsonSec.put("source", 0);
                        jsonSec.put("action_name", (Object)"page_view");
                        jsonSec.put("action_page_state", isPage);
                        JSONArray jsonParameter = new JSONArray();
                        for (int i = 0; i < mArrayList.size(); ++i) {
                            String item = (String)mArrayList.get(i);
                            if (item == null) continue;
                            JSONObject jsonitem = new JSONObject();
                            jsonitem.put("name", (Object)item);
                            jsonParameter.put((Object)jsonitem);
                        }
                        jsonSec.put("action_parameter", (Object)jsonParameter);
                        result = jsonSec.toString();
                        if (isDebug) {
                            Log.i((String)TAG, (String)("page json is " + result));
                        }
                    }
                }
                catch (Throwable jsonSec) {
                    // empty catch block
                }
                return result;
            }
            if (UMCrash.KEY_CALLBACK_USER_STRING.equals(category)) {
                if (mUMCrashCallbackWithType != null) {
                    String callbackString = mUMCrashCallbackWithType.onCallback(IUMCrashCallbackWithType.CrashType.CRASH_TYPE_BLOCK);
                    if (callbackString == null) {
                        return null;
                    }
                    int len = callbackString.trim().getBytes().length;
                    if (len > Math.max(20480, sApmCallbackLimit)) {
                        callbackString = UMCrashUtils.splitByByte(callbackString, Math.max(20480, sApmCallbackLimit));
                    }
                    return callbackString;
                }
                if (mUMCrashCallback != null) {
                    String callbackString = mUMCrashCallback.onCallback();
                    if (callbackString == null) {
                        return null;
                    }
                    int len = callbackString.trim().getBytes().length;
                    if (len > Math.max(20480, sApmCallbackLimit)) {
                        callbackString = UMCrashUtils.splitByByte(callbackString, Math.max(20480, sApmCallbackLimit));
                    }
                    return callbackString;
                }
                return null;
            }
            return null;
        }
    }

    private static class UCrashCallbackImpl
    implements UCrashCallback {
        private UCrashCallbackImpl() {
        }

        public Map<String, String> getExtras(String type) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put(UMCrash.KEY_CALLBACK_USER_STRING, UMCrash.generateNormalUserString());
            if ("java".equals(type)) {
                args.put(UMCrash.KEY_CALLBACK_USER_STRING_JAVA, UMCrash.generateJavaUserString());
            } else if ("jni".equals(type)) {
                args.put(UMCrash.KEY_CALLBACK_USER_STRING_NATIVE, UMCrash.generateNativeUserString());
            } else if ("anr".equals(type)) {
                args.put(UMCrash.KEY_CALLBACK_USER_STRING_ANR, UMCrash.generateANRUserString());
            } else if ("exception".equals(type)) {
                args.put(UMCrash.KEY_CALLBACK_USER_STRING_CUSTOM_LOG, UMCrash.generateCustomUserString());
            }
            args.put(UMCrash.KEY_CALLBACK_UMID, UMCrashUtils.getUMID(mContext));
            args.put(UMCrash.KEY_CALLBACK_UM_INFOS, UMCrash.generateUMInfos());
            return args;
        }
    }

    private static class CrashClientImpl
    implements ICrashClient {
        private CrashClientImpl() {
        }

        public void onLogGenerated(File file, String s) {
        }

        public void onClientProcessLogGenerated(String s, File file, String s1) {
        }

        public File onBeforeUploadLog(File file) {
            return file;
        }

        public void onCrashRestarting(boolean b) {
        }

        public void onAddCrashStats(String s, int i, int i1) {
        }

        public String onGetCallbackInfo(String category, boolean b) {
            if (UMCrash.KEY_CALLBACK_UMID.equals(category)) {
                return UMCrashUtils.getUMID(mContext);
            }
            if (UMCrash.KEY_CALLBACK_UM_INFOS.equals(category)) {
                return UMCrash.generateUMInfos();
            }
            if (UMCrash.KEY_CALLBACK_USER_STRING.equals(category)) {
                return UMCrash.generateNormalUserString();
            }
            if (UMCrash.KEY_CALLBACK_USER_STRING_JAVA.equals(category)) {
                return UMCrash.generateJavaUserString();
            }
            if (UMCrash.KEY_CALLBACK_USER_STRING_NATIVE.equals(category)) {
                return UMCrash.generateNativeUserString();
            }
            if (UMCrash.KEY_CALLBACK_USER_STRING_ANR.equals(category)) {
                return UMCrash.generateANRUserString();
            }
            if (UMCrash.KEY_CALLBACK_USER_STRING_CUSTOM_LOG.equals(category)) {
                return UMCrash.generateCustomUserString();
            }
            return null;
        }
    }
}

