/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.base.core.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import com.efs.sdk.base.core.util.Log;

public class NetworkUtil {
    public static final String NETWORK_TYPE_WIFI = "wifi";
    public static final String NETWORK_CLASS_DISCONNECTED = "disconnected";
    public static final String NETWORK_CLASS_UNKNOWN = "unknown";
    public static final String NETWORK_CLASS_DENIED = "denied";
    public static final String NETWORK_CLASS_2G = "2g";
    public static final String NETWORK_CLASS_3G = "3g";
    public static final String NETWORK_CLASS_4G = "4g";
    public static final String NETWORK_CLASS_5G = "5g";
    public static final String UNKNOW = "";
    public static final String WIFI = "Wi-Fi";
    public static final String MOBILE_NETWORK = "2G/3G";

    public static NetworkInfo getActiveNetworkInfo(Context networkInfoArray) {
        NetworkInfo networkInfo;
        block4: {
            networkInfo = null;
            try {
                networkInfoArray = (ConnectivityManager)networkInfoArray.getSystemService("connectivity");
                if (networkInfoArray == null) {
                    Log.w("efs.base", "get CONNECTIVITY_SERVICE is null");
                    return null;
                }
                networkInfo = networkInfoArray.getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.isConnected() || (networkInfoArray = networkInfoArray.getAllNetworkInfo()) == null) break block4;
                for (int i = 0; i < networkInfoArray.length; ++i) {
                    if (networkInfoArray[i] == null || !networkInfoArray[i].isConnected()) continue;
                    networkInfo = networkInfoArray[i];
                    break;
                }
            }
            catch (Throwable throwable) {
                Log.e("efs.base", "get network info error", throwable);
            }
        }
        return networkInfo;
    }

    public static boolean isConnected(Context context) {
        if ((context = NetworkUtil.getActiveNetworkInfo(context)) != null && context.isConnected()) {
            return context.getState() == NetworkInfo.State.CONNECTED;
        }
        return false;
    }

    public static boolean isWifi(Context context) {
        if (NetworkUtil.isRejectAccessNetworkState(context)) {
            return false;
        }
        if ((context = NetworkUtil.getActiveNetworkInfo(context)) != null && context.isConnected()) {
            return context.getType() == 1;
        }
        return false;
    }

    public static boolean hasAccessNetworkState(Context context) {
        try {
            return context.getPackageManager().checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName()) == 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isRejectAccessNetworkState(Context context) {
        return !NetworkUtil.hasAccessNetworkState(context);
    }

    public static String getNetworkType(Context object) {
        if (NetworkUtil.isRejectAccessNetworkState((Context)object)) {
            return NETWORK_CLASS_DENIED;
        }
        if ((object = NetworkUtil.getActiveNetworkInfo((Context)object)) == null) {
            return NETWORK_CLASS_DISCONNECTED;
        }
        if (object.getType() == 1) {
            return NETWORK_TYPE_WIFI;
        }
        switch (object.getSubtype()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return NETWORK_CLASS_2G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return NETWORK_CLASS_3G;
            }
            case 13: {
                return NETWORK_CLASS_4G;
            }
            case 20: {
                return NETWORK_CLASS_5G;
            }
        }
        object = object.getSubtypeName();
        if (TextUtils.isEmpty((CharSequence)object)) {
            return NETWORK_CLASS_UNKNOWN;
        }
        if (((String)object).equalsIgnoreCase("TD-SCDMA") || ((String)object).equalsIgnoreCase("WCDMA") || ((String)object).equalsIgnoreCase("CDMA2000")) {
            return NETWORK_CLASS_3G;
        }
        return object;
    }

    public static boolean checkPermission(Context context, String string) {
        boolean bl;
        block7: {
            bl = false;
            if (context == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    if ((Integer)Class.forName("android.content.Context").getMethod("checkSelfPermission", String.class).invoke((Object)context, string) == 0) {
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
            } else if (context.getPackageManager().checkPermission(string, context.getPackageName()) == 0) {
                bl = true;
            }
        }
        return bl;
    }

    public static String[] getNetworkAccessMode(Context context) {
        String[] stringArray = new String[]{UNKNOW, UNKNOW};
        if (context == null) {
            return stringArray;
        }
        try {
            if (!NetworkUtil.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                stringArray[0] = UNKNOW;
                return stringArray;
            }
            if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
                stringArray[0] = UNKNOW;
                return stringArray;
            }
            NetworkInfo networkInfo = context.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = WIFI;
                return stringArray;
            }
            if ((context = context.getNetworkInfo(0)) != null && context.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = MOBILE_NETWORK;
                stringArray[1] = context.getSubtypeName();
                return stringArray;
            }
        }
        catch (Throwable throwable) {}
        return stringArray;
    }

    public static int getNetworkTypeUmeng(Context context) {
        return 0;
    }
}

