/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.framework;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.umeng.analytics.pro.at;
import com.umeng.commonsdk.framework.UMLogDataProtocol;
import com.umeng.commonsdk.framework.UMModuleRegister;
import com.umeng.commonsdk.internal.crash.UMCrashManager;
import com.umeng.commonsdk.statistics.common.ULog;
import com.umeng.commonsdk.statistics.internal.PreferenceWrapper;
import com.umeng.commonsdk.statistics.internal.a;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class UMFrUtils {
    private static final String KEY_LAST_SUCC_BUILD_TIME = "last_successful_build_time";
    private static final String KEY_LAST_INSTANT_SUCC_BUILD_TIME = "last_instant_build_time";
    private static Object mEnvelopeBuildTimeLock = new Object();
    private static String mDefaultEnvelopeDir = at.b().b("env");
    private static String mDefaultEnvelopeDirPath = null;
    private static Object mEnvelopeFileLock = new Object();
    private static String sCurrentProcessName = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessName(int n2) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader("/proc/" + n2 + "/cmdline"));
            String string = bufferedReader.readLine();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                string = string.trim();
            }
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static String getCurrentProcessName(Context context) {
        block7: {
            if (TextUtils.isEmpty((CharSequence)sCurrentProcessName)) {
                String string = "";
                try {
                    if (Build.VERSION.SDK_INT >= 28) {
                        string = Application.getProcessName();
                    }
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        List list;
                        int n2 = Process.myPid();
                        string = UMFrUtils.getProcessName(n2);
                        if (!TextUtils.isEmpty((CharSequence)string)) {
                            sCurrentProcessName = string;
                            break block7;
                        }
                        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                        if (activityManager == null || (list = activityManager.getRunningAppProcesses()) == null || list.size() <= 0) break block7;
                        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                            if (runningAppProcessInfo.pid != n2) continue;
                            sCurrentProcessName = runningAppProcessInfo.processName;
                            break block7;
                        }
                        break block7;
                    }
                    sCurrentProcessName = string;
                }
                catch (Throwable throwable) {
                    UMCrashManager.reportCrash(context.getApplicationContext(), throwable);
                }
            }
        }
        return sCurrentProcessName;
    }

    public static String getSubProcessName(Context context) {
        String string = "";
        try {
            String string2 = UMFrUtils.getCurrentProcessName(context);
            int n2 = string2.indexOf(":");
            if (n2 >= 0) {
                string = string2.substring(n2 + 1);
            }
            if (n2 < 0) {
                String string3 = context.getPackageName();
                int n3 = string3.length();
                int n4 = string2.length();
                string = n4 > n3 ? string2.substring(string3.length() + 1, string2.length()) : string2;
            }
        }
        catch (Throwable throwable) {
            UMCrashManager.reportCrash(context.getApplicationContext(), throwable);
        }
        return string;
    }

    private static boolean checkPermission(Context context, String string) {
        boolean bl2 = false;
        if (context != null) {
            Context context2 = context.getApplicationContext();
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Class<?> clazz = Class.forName("android.content.Context");
                    Method method = clazz.getMethod("checkSelfPermission", String.class);
                    int n2 = (Integer)method.invoke((Object)context, string);
                    bl2 = n2 == 0;
                }
                catch (Throwable throwable) {
                    bl2 = false;
                    UMCrashManager.reportCrash(context2, throwable);
                }
            } else {
                try {
                    PackageManager packageManager = context2.getPackageManager();
                    if (packageManager.checkPermission(string, context2.getPackageName()) == 0) {
                        bl2 = true;
                    }
                }
                catch (Throwable throwable) {
                    bl2 = false;
                    UMCrashManager.reportCrash(context2, throwable);
                }
            }
        }
        return bl2;
    }

    public static boolean isOnline(Context context) {
        try {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager;
            if (UMFrUtils.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")) != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null) {
                return networkInfo.isConnectedOrConnecting();
            }
        }
        catch (Throwable throwable) {
            UMCrashManager.reportCrash(context.getApplicationContext(), throwable);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int envelopeFileNumber(Context context) {
        if (context != null) {
            try {
                File file = new File(UMFrUtils.getEnvelopeDirPath(context));
                Object object = mEnvelopeFileLock;
                synchronized (object) {
                    String[] stringArray;
                    if (file.isDirectory() && (stringArray = file.list()) != null) {
                        return stringArray.length;
                    }
                }
            }
            catch (Throwable throwable) {
                UMCrashManager.reportCrash(context, throwable);
            }
            return 0;
        }
        return 0;
    }

    private static long getDistanceDays(long l2, long l3) {
        long l4 = 0L;
        long l5 = l2 < l3 ? l3 - l2 : l2 - l3;
        l4 = l5 / 86400000L;
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRedundantEnvelopeFiles(Context context, int n2) {
        Context context2 = context;
        File file = new File(UMFrUtils.getEnvelopeDirPath(context));
        Object object = mEnvelopeFileLock;
        synchronized (object) {
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length <= n2) {
                return;
            }
            Arrays.sort(fileArray, new Comparator<File>(){

                public int a(File file, File file2) {
                    long l2 = file.lastModified() - file2.lastModified();
                    if (l2 > 0L) {
                        return 1;
                    }
                    if (l2 == 0L) {
                        return 0;
                    }
                    return -1;
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((File)object, (File)object2);
                }
            });
            if (fileArray.length > n2) {
                try {
                    for (int i2 = 0; i2 < fileArray.length - n2; ++i2) {
                        boolean bl2 = fileArray[i2].delete();
                        if (bl2) continue;
                        ULog.d("--->>> remove [" + i2 + "] file fail.");
                    }
                }
                catch (Throwable throwable) {
                    UMCrashManager.reportCrash(context2, throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getEnvelopeFile(Context context) {
        if (context == null) {
            return null;
        }
        Context context2 = context;
        File file = new File(UMFrUtils.getEnvelopeDirPath(context));
        Object object = mEnvelopeFileLock;
        synchronized (object) {
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                return null;
            }
            Arrays.sort(fileArray, new Comparator<File>(){

                public int a(File file, File file2) {
                    long l2 = file.lastModified() - file2.lastModified();
                    if (l2 > 0L) {
                        return 1;
                    }
                    if (l2 == 0L) {
                        return 0;
                    }
                    return -1;
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((File)object, (File)object2);
                }
            });
            return fileArray[0];
        }
    }

    public static void syncLegacyEnvelopeIfNeeded(Context context) {
        if (context == null) {
            return;
        }
        try {
            String string = UMFrUtils.getLegacyEnvelopeDir(context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return;
            }
            if (string.equals(mDefaultEnvelopeDir)) {
                return;
            }
            String string2 = context.getFilesDir().getAbsolutePath() + "/." + string;
            File file = new File(string2);
            if (!file.exists()) {
                return;
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                try {
                    if (file.isDirectory()) {
                        file.delete();
                    }
                }
                catch (Throwable throwable) {
                    UMCrashManager.reportCrash(context, throwable);
                }
                return;
            }
            try {
                String string3 = UMFrUtils.getEnvelopeDirPath(context);
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    fileArray[i2].renameTo(new File(string3 + File.separator + fileArray[i2].getName()));
                }
                if (file.isDirectory()) {
                    file.delete();
                }
            }
            catch (Throwable throwable) {
                UMCrashManager.reportCrash(context, throwable);
            }
        }
        catch (Throwable throwable) {
            UMCrashManager.reportCrash(context, throwable);
        }
    }

    public static String getLegacyEnvelopeDir(Context context) {
        try {
            String string = UMFrUtils.getCurrentProcessName(context);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                String string2 = string;
                String string3 = at.b().b("lepd");
                String string4 = string2.replace(':', '_');
                ULog.d("--->>> getEnvelopeDir: use current process name as envelope directory.");
                return string3 + string4;
            }
        }
        catch (Throwable throwable) {
            UMCrashManager.reportCrash(context, throwable);
        }
        return mDefaultEnvelopeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEnvelopeDirPath(Context context) {
        Object object = mEnvelopeFileLock;
        synchronized (object) {
            try {
                File file;
                if (mDefaultEnvelopeDirPath == null) {
                    mDefaultEnvelopeDirPath = context.getFilesDir().getAbsolutePath() + File.separator + "." + mDefaultEnvelopeDir;
                }
                if (!(file = new File(mDefaultEnvelopeDirPath)).exists() && !file.mkdir()) {
                    ULog.d("--->>> Create Envelope Directory failed!!!");
                }
            }
            catch (Throwable throwable) {
                UMCrashManager.reportCrash(context, throwable);
            }
            return mDefaultEnvelopeDirPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastSuccessfulBuildTime(Context context) {
        Object object = mEnvelopeBuildTimeLock;
        synchronized (object) {
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(context);
            return sharedPreferences.getLong(KEY_LAST_SUCC_BUILD_TIME, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastInstantBuildTime(Context context) {
        Object object = mEnvelopeBuildTimeLock;
        synchronized (object) {
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(context);
            return sharedPreferences.getLong(KEY_LAST_INSTANT_SUCC_BUILD_TIME, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLastSuccessfulBuildTime(Context context) {
        Object object = mEnvelopeBuildTimeLock;
        synchronized (object) {
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(context);
            long l2 = System.currentTimeMillis();
            sharedPreferences.edit().putLong(KEY_LAST_SUCC_BUILD_TIME, l2).commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLastInstantBuildTime(Context context) {
        Object object = mEnvelopeBuildTimeLock;
        synchronized (object) {
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(context);
            long l2 = System.currentTimeMillis();
            sharedPreferences.edit().putLong(KEY_LAST_INSTANT_SUCC_BUILD_TIME, l2).commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int saveEnvelopeFile(Context context, String string, byte[] byArray) {
        if (byArray == null) {
            return 101;
        }
        File file = new File(UMFrUtils.getEnvelopeDirPath(context) + File.separator + string);
        Object object = mEnvelopeFileLock;
        synchronized (object) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                fileOutputStream = null;
            }
            catch (IOException iOException) {
                UMCrashManager.reportCrash(context, iOException);
                int n2 = 101;
                return n2;
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        UMCrashManager.reportCrash(context, throwable);
                    }
                }
            }
            boolean bl2 = a.a(context).a(string);
            boolean bl3 = a.a(context).b(string);
            if (bl2) {
                UMFrUtils.updateLastSuccessfulBuildTime(context);
            }
            if (bl3) {
                UMFrUtils.updateLastInstantBuildTime(context);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeEnvelopeFile(File file) {
        Context context = UMModuleRegister.getAppContext();
        Object object = mEnvelopeFileLock;
        synchronized (object) {
            try {
                if (file != null && file.exists()) {
                    return file.delete();
                }
            }
            catch (Throwable throwable) {
                UMCrashManager.reportCrash(context, throwable);
            }
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(String string) throws IOException {
        Context context = UMModuleRegister.getAppContext();
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        Object object = mEnvelopeFileLock;
        synchronized (object) {
            try {
                abstractInterruptibleChannel = new RandomAccessFile(string, "r").getChannel();
                MappedByteBuffer mappedByteBuffer = ((FileChannel)abstractInterruptibleChannel).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)abstractInterruptibleChannel).size()).load();
                byte[] byArray = new byte[(int)((FileChannel)abstractInterruptibleChannel).size()];
                if (mappedByteBuffer.remaining() > 0) {
                    mappedByteBuffer.get(byArray, 0, mappedByteBuffer.remaining());
                }
                byte[] byArray2 = byArray;
                return byArray2;
            }
            catch (IOException iOException) {
                UMCrashManager.reportCrash(context, iOException);
                throw iOException;
            }
            finally {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (Throwable throwable) {
                    UMCrashManager.reportCrash(context, throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasEnvelopeFile(Context context, UMLogDataProtocol.UMBusinessType uMBusinessType) {
        String string;
        String string2 = "a";
        if (uMBusinessType == UMLogDataProtocol.UMBusinessType.U_INTERNAL) {
            string2 = "i";
        }
        if (uMBusinessType == UMLogDataProtocol.UMBusinessType.U_ZeroEnv) {
            string2 = "z";
        }
        if (uMBusinessType == UMLogDataProtocol.UMBusinessType.U_Silent) {
            string2 = "h";
        }
        if ((string = UMFrUtils.getEnvelopeDirPath(context)) != null) {
            File file = new File(string);
            Object object = mEnvelopeFileLock;
            synchronized (object) {
                try {
                    File[] fileArray = file.listFiles();
                    if (fileArray == null || fileArray.length == 0) {
                        return false;
                    }
                    for (File file2 : fileArray) {
                        if (!file2.getName().startsWith(string2)) continue;
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    UMCrashManager.reportCrash(context, throwable);
                }
                return false;
            }
        }
        return false;
    }
}

