/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.statistics.noise;

import android.content.Context;
import android.text.TextUtils;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.statistics.common.MLog;
import com.umeng.commonsdk.statistics.idtracking.Envelope;
import com.umeng.commonsdk.statistics.idtracking.ImprintHandler;
import com.umeng.commonsdk.statistics.internal.d;

public class ABTest
implements d {
    private boolean isInTest = false;
    private int mPolicy = -1;
    private int mInterval = -1;
    private int mGroup = -1;
    private float mProb13 = 0.0f;
    private float mProb07 = 0.0f;
    private String mPoli = null;
    private Context context = null;
    private static ABTest instance = null;

    public static synchronized ABTest getService(Context context) {
        if (instance == null) {
            String string = UMEnvelopeBuild.imprintProperty(context, "client_test", null);
            int n2 = Integer.valueOf(UMEnvelopeBuild.imprintProperty(context, "test_report_interval", "0"));
            instance = new ABTest(context, string, n2);
        }
        return instance;
    }

    private ABTest(Context context, String string, int n2) {
        this.context = context;
        this.onExperimentChanged(string, n2);
    }

    private float prob(String string, int n2) {
        n2 *= 2;
        if (string == null) {
            return 0.0f;
        }
        float f2 = Integer.valueOf(string.substring(n2, n2 + 5), 16).intValue();
        float f3 = 1048576.0f;
        return f2 / f3;
    }

    public void onExperimentChanged(String string, int n2) {
        this.mInterval = n2;
        String string2 = Envelope.getSignature(this.context);
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string)) {
            this.isInTest = false;
            return;
        }
        try {
            this.mProb13 = this.prob(string2, 12);
            this.mProb07 = this.prob(string2, 6);
            if (string.startsWith("SIG7")) {
                this.parseSig7(string);
            } else if (string.startsWith("FIXED")) {
                this.parseFIXED(string);
            }
        }
        catch (Exception exception) {
            this.isInTest = false;
            MLog.e("v:" + string, exception);
        }
    }

    public static boolean validate(String string) {
        int n2;
        int n3;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String[] stringArray = string.split("\\|");
        if (stringArray.length != 6) {
            return false;
        }
        if (stringArray[0].startsWith("SIG7") && (n3 = stringArray[1].split(",").length) == (n2 = stringArray[5].split(",").length)) {
            return true;
        }
        return stringArray[0].startsWith("FIXED") && (n3 = stringArray[5].split(",").length) >= (n2 = Integer.parseInt(stringArray[1])) && n2 >= 1;
    }

    private void parseSig7(String string) {
        int n2;
        Object[] objectArray;
        if (string == null) {
            return;
        }
        String[] stringArray = string.split("\\|");
        float f2 = 0.0f;
        if (stringArray[2].equals("SIG13")) {
            f2 = Float.valueOf(stringArray[3]).floatValue();
        }
        if (this.mProb13 > f2) {
            this.isInTest = false;
            return;
        }
        float[] fArray = null;
        if (stringArray[0].equals("SIG7")) {
            objectArray = stringArray[1].split(",");
            fArray = new float[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                fArray[i2] = Float.valueOf(objectArray[i2]).floatValue();
            }
        }
        objectArray = null;
        if (stringArray[4].equals("RPT")) {
            this.mPoli = "RPT";
            String[] stringArray2 = stringArray[5].split(",");
            objectArray = new int[stringArray2.length];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                objectArray[n2] = (String)((Object)Integer.valueOf(stringArray2[n2]));
            }
        } else if (stringArray[4].equals("DOM")) {
            this.isInTest = true;
            this.mPoli = "DOM";
            try {
                String[] stringArray3 = stringArray[5].split(",");
                objectArray = new int[stringArray3.length];
                for (n2 = 0; n2 < stringArray3.length; ++n2) {
                    objectArray[n2] = (String)((Object)Integer.valueOf(stringArray3[n2]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n3 = -1;
        float f3 = 0.0f;
        for (int i3 = 0; i3 < fArray.length; ++i3) {
            if (!(this.mProb07 < (f3 += fArray[i3]))) continue;
            n3 = i3;
            break;
        }
        if (n3 != -1) {
            this.isInTest = true;
            this.mGroup = n3 + 1;
            if (objectArray != null) {
                this.mPolicy = (int)objectArray[n3];
            }
        } else {
            this.isInTest = false;
        }
    }

    private void parseFIXED(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split("\\|");
        float f2 = 0.0f;
        if (stringArray[2].equals("SIG13")) {
            f2 = Float.valueOf(stringArray[3]).floatValue();
        }
        if (this.mProb13 > f2) {
            this.isInTest = false;
            return;
        }
        int n2 = -1;
        if (stringArray[0].equals("FIXED")) {
            n2 = Integer.valueOf(stringArray[1]);
        }
        int[] nArray = null;
        if (stringArray[4].equals("RPT")) {
            this.mPoli = "RPT";
            String[] stringArray2 = stringArray[5].split(",");
            nArray = new int[stringArray2.length];
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                nArray[i2] = Integer.valueOf(stringArray2[i2]);
            }
        } else if (stringArray[4].equals("DOM")) {
            this.mPoli = "DOM";
            this.isInTest = true;
            try {
                String[] stringArray3 = stringArray[5].split(",");
                nArray = new int[stringArray3.length];
                for (int i3 = 0; i3 < stringArray3.length; ++i3) {
                    nArray[i3] = Integer.valueOf(stringArray3[i3]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 != -1) {
            this.isInTest = true;
            this.mGroup = n2;
            if (nArray != null) {
                this.mPolicy = nArray[n2 - 1];
            }
        } else {
            this.isInTest = false;
        }
    }

    public boolean isInTest() {
        return this.isInTest;
    }

    public int getTestPolicy() {
        return this.mPolicy;
    }

    public int getTestInterval() {
        return this.mInterval;
    }

    public int getGroup() {
        return this.mGroup;
    }

    public String getGroupInfo() {
        if (!this.isInTest) {
            return "error";
        }
        return String.valueOf(this.mGroup);
    }

    public String getTestName() {
        return this.mPoli;
    }

    @Override
    public void onImprintChanged(ImprintHandler.a a2) {
        String string = a2.a("client_test", null);
        int n2 = Integer.valueOf(a2.a("test_report_interval", "0"));
        this.onExperimentChanged(string, n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" p13:");
        stringBuilder.append(this.mProb13);
        stringBuilder.append(" p07:");
        stringBuilder.append(this.mProb07);
        stringBuilder.append(" policy:");
        stringBuilder.append(this.mPolicy);
        stringBuilder.append(" interval:");
        stringBuilder.append(this.mInterval);
        return stringBuilder.toString();
    }
}

