/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.vt.diff;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.statistics.idtracking.ImprintHandler;
import com.umeng.commonsdk.statistics.internal.UMImprintChangeCallback;
import com.umeng.vt.diff.util.ClassLoadUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Channel {
    private static final String UM_VISUAL_IMPRINT = "utm-visual";

    public void init(Context context) {
        if (context == null) {
            return;
        }
        context = context.getApplicationContext();
        this.loadConfig(context);
        this.registerListener(context);
    }

    public void loadConfig(Context context) {
        String string = UMEnvelopeBuild.imprintProperty(context, UM_VISUAL_IMPRINT, null);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = new String(Base64.decode((String)string, (int)0));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("data-track", string2);
            this.storeConfig(hashMap);
        }
    }

    public void registerListener(final Context context) {
        ImprintHandler.getImprintService(context).registImprintCallback(UM_VISUAL_IMPRINT, new UMImprintChangeCallback(){

            @Override
            public void onImprintValueChanged(String string, String string2) {
                if (Channel.UM_VISUAL_IMPRINT.equals(string)) {
                    Channel.this.loadConfig(context);
                }
            }
        });
    }

    private void storeConfig(Map<String, String> map) {
        try {
            Method method;
            Class<?> clazz = ClassLoadUtil.findClass("com.umeng.vt.vismode.config.ConfigTools");
            if (clazz != null && (method = clazz.getMethod("storeConfig", Map.class)) != null) {
                method.invoke(clazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]), map);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void download() {
        try {
            Method method;
            Class<?> clazz = ClassLoadUtil.findClass("com.umeng.vt.vismode.config.ConfigTools");
            if (clazz != null && (method = clazz.getMethod("download", new Class[0])) != null) {
                method.invoke(clazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]), new Object[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

