/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.statistics.common;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.umeng.analytics.pro.aa;
import com.umeng.commonsdk.UMConfigure;
import com.umeng.commonsdk.config.FieldManager;
import com.umeng.commonsdk.debug.UMRTLog;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.statistics.AnalyticsConstants;
import com.umeng.commonsdk.statistics.common.DeviceTypeEnum;
import com.umeng.commonsdk.statistics.common.HelperUtils;
import com.umeng.commonsdk.statistics.common.MLog;
import com.umeng.commonsdk.statistics.common.a;
import com.umeng.commonsdk.statistics.idtracking.c;
import com.umeng.commonsdk.statistics.idtracking.i;
import com.umeng.commonsdk.utils.UMUtils;
import com.umeng.commonsdk.utils.b;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.microedition.khronos.opengles.GL10;

public class DeviceConfig {
    protected static final String LOG_TAG = DeviceConfig.class.getName();
    public static final String UNKNOW = "";
    public static final String MOBILE_NETWORK = "2G/3G";
    public static final String WIFI = "Wi-Fi";
    public static final int DEFAULT_TIMEZONE = 8;
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_EMUI_VERSION_CODE = "ro.build.hw_emui_api_level";
    private static DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.DEFAULT;
    private static volatile String sAndroidID = "";
    private static volatile String sIDFA = "";
    private static volatile String sOAID = "";
    private static volatile String sHonorOAID = "";
    private static volatile boolean hasReadAndroidID = false;
    private static volatile boolean hasReadOAID = false;
    private static volatile boolean hasReadHonorOAID = false;
    private static volatile boolean hasReadIDFA = false;
    private static volatile String sAppName = "";
    private static volatile String sAppPkgName = "";
    private static volatile boolean hasReadOperator = false;
    private static volatile String sOperator = "";
    private static volatile boolean hasReadOperatorName = false;
    private static volatile String sOperatorName = "";
    private static volatile String sCustomAgt = "";

    public static String getImei(Context context) {
        return null;
    }

    public static String getImeiNew(Context context) {
        return null;
    }

    public static String getAndroidId(Context context) {
        if (!UMConfigure.shouldCollectAid()) {
            UMRTLog.i("MobclickRT", "disallow read aid.");
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)sAndroidID)) {
            return sAndroidID;
        }
        if (hasReadAndroidID) {
            return null;
        }
        if (FieldManager.allow("header_device_id_android_id") && context != null) {
            try {
                sAndroidID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            }
            catch (Throwable throwable) {
                if (AnalyticsConstants.UM_DEBUG) {
                    MLog.w("can't read android id");
                }
            }
            finally {
                hasReadAndroidID = true;
            }
        }
        return sAndroidID;
    }

    public static String getSerial() {
        return DeviceConfig.getSerialNo();
    }

    public static String getAppVersionCode(Context context) {
        return UMUtils.getAppVersionCode(context);
    }

    public static String getAppVersionName(Context context) {
        return UMUtils.getAppVersionName(context);
    }

    public static boolean checkPermission(Context context, String string) {
        boolean bl2;
        block7: {
            bl2 = false;
            if (context == null) {
                return bl2;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Class<?> clazz = Class.forName("android.content.Context");
                    Method method = clazz.getMethod("checkSelfPermission", String.class);
                    int n2 = (Integer)method.invoke((Object)context, string);
                    if (n2 == 0) {
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    bl2 = false;
                }
            } else {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager.checkPermission(string, context.getPackageName()) == 0) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    public static String[] getGPU(GL10 gL10) {
        try {
            String[] stringArray = new String[2];
            String string = gL10.glGetString(7936);
            String string2 = gL10.glGetString(7937);
            stringArray[0] = string;
            stringArray[1] = string2;
            return stringArray;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                MLog.e(LOG_TAG, "Could not read gpu infor:", throwable);
            }
            return new String[0];
        }
    }

    @TargetApi(value=9)
    private static String getMacByJavaAPI() {
        return UNKNOW;
    }

    private static String getMacShell() {
        return UNKNOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String reaMac(String string) {
        String string2;
        block15: {
            string2 = null;
            try {
                FileReader fileReader = new FileReader(string);
                BufferedReader bufferedReader = null;
                if (fileReader == null) break block15;
                try {
                    bufferedReader = new BufferedReader(fileReader, 1024);
                    string2 = bufferedReader.readLine();
                }
                finally {
                    if (fileReader != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string2;
    }

    public static String getCPU() {
        String string = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader("/proc/cpuinfo");
            if (fileReader != null) {
                try {
                    bufferedReader = new BufferedReader(fileReader, 1024);
                    string = bufferedReader.readLine();
                    bufferedReader.close();
                    fileReader.close();
                }
                catch (Throwable throwable) {
                    MLog.e(LOG_TAG, "Could not read from file /proc/cpuinfo", throwable);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MLog.e(LOG_TAG, "Could not open file /proc/cpuinfo", fileNotFoundException);
        }
        if (string != null) {
            int n2 = string.indexOf(58) + 1;
            string = string.substring(n2);
            return string.trim();
        }
        return UNKNOW;
    }

    public static String getDeviceId(Context context) {
        if (AnalyticsConstants.getDeviceType() == 2) {
            return DeviceConfig.getDeviceIdForBox(context);
        }
        return DeviceConfig.getDeviceIdForGeneral(context);
    }

    public static String getDeviceIdType() {
        return deviceTypeEnum.getDeviceIdType();
    }

    public static String getDeviceIdUmengMD5(Context context) {
        return HelperUtils.getUmengMD5(DeviceConfig.getDeviceId(context));
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String getMCCMNC(Context context) {
        try {
            if (context == null) {
                return null;
            }
            int n2 = context.getResources().getConfiguration().mcc;
            int n3 = context.getResources().getConfiguration().mnc;
            if (n2 != 0) {
                String string = String.valueOf(n3);
                if (n3 < 10) {
                    string = String.format("%02d", n3);
                }
                return new StringBuffer().append(String.valueOf(n2)).append(string).toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String getImsi(Context context) {
        return null;
    }

    public static String getMeid(Context context) {
        return null;
    }

    private static String meid(Context context) {
        return null;
    }

    public static String getSimICCID(Context context) {
        return null;
    }

    public static String getSecondSimIMEi(Context context) {
        return null;
    }

    public static String getRegisteredOperator(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sOperator)) {
            return sOperator;
        }
        if (hasReadOperator) {
            return null;
        }
        if (context == null) {
            return null;
        }
        String string = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                sOperator = string = telephonyManager.getNetworkOperator();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            hasReadOperator = true;
        }
        return sOperator;
    }

    public static String getNetworkOperatorName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sOperatorName)) {
            return sOperatorName;
        }
        if (hasReadOperatorName) {
            return UNKNOW;
        }
        if (context == null) {
            return UNKNOW;
        }
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                sOperatorName = telephonyManager.getNetworkOperatorName();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            hasReadOperatorName = true;
        }
        return sOperatorName;
    }

    public static String getDisplayResolution(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            if (windowManager != null) {
                windowManager.getDefaultDisplay().getMetrics(displayMetrics);
                int n2 = displayMetrics.widthPixels;
                int n3 = displayMetrics.heightPixels;
                String string = String.valueOf(n3) + "*" + String.valueOf(n2);
                return string;
            }
            return UNKNOW;
        }
        catch (Throwable throwable) {
            return UNKNOW;
        }
    }

    public static String[] getNetworkAccessMode(Context context) {
        String[] stringArray = new String[]{UNKNOW, UNKNOW};
        if (context == null) {
            return stringArray;
        }
        try {
            if (!DeviceConfig.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                stringArray[0] = UNKNOW;
                return stringArray;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                stringArray[0] = UNKNOW;
                return stringArray;
            }
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = WIFI;
                return stringArray;
            }
            NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(0);
            if (networkInfo2 != null && networkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = MOBILE_NETWORK;
                stringArray[1] = networkInfo2.getSubtypeName();
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringArray;
    }

    public static int getNetworkType(Context context) {
        return -100;
    }

    public static boolean isWiFiAvailable(Context context) {
        if (context == null) {
            return false;
        }
        return WIFI.equals(DeviceConfig.getNetworkAccessMode(context)[0]);
    }

    public static boolean isOnline(Context context) {
        if (context == null) {
            return false;
        }
        try {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager;
            if (DeviceConfig.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")) != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null) {
                return networkInfo.isConnectedOrConnecting();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static int getTimeZone(Context context) {
        if (context == null) {
            return 8;
        }
        try {
            Locale locale = DeviceConfig.getLocale(context);
            Calendar calendar = Calendar.getInstance(locale);
            if (calendar != null) {
                return calendar.getTimeZone().getRawOffset() / 3600000;
            }
        }
        catch (Throwable throwable) {
            MLog.i(LOG_TAG, "error in getTimeZone", throwable);
        }
        return 8;
    }

    public static boolean isChineseAera(Context context) {
        if (context == null) {
            return false;
        }
        try {
            String string = UMEnvelopeBuild.imprintProperty(context, "country", UNKNOW);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string.equals("cn");
            }
            if (DeviceConfig.getImsi(context) == null) {
                string = DeviceConfig.getLocaleInfo(context)[0];
                if (!TextUtils.isEmpty((CharSequence)string) && string.equalsIgnoreCase("cn")) {
                    return true;
                }
            } else {
                int n2 = context.getResources().getConfiguration().mcc;
                if (n2 == 460 || n2 == 461) {
                    return true;
                }
                if (n2 == 0 && !TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getLocaleInfo(context)[0])) && string.equalsIgnoreCase("cn")) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static String[] getLocaleInfo(Context context) {
        String[] stringArray = new String[]{"Unknown", "Unknown"};
        if (context == null) {
            return stringArray;
        }
        try {
            Locale locale = DeviceConfig.getLocale(context);
            if (locale != null) {
                stringArray[0] = locale.getCountry();
                stringArray[1] = locale.getLanguage();
            }
            if (TextUtils.isEmpty((CharSequence)stringArray[0])) {
                stringArray[0] = "Unknown";
            }
            if (TextUtils.isEmpty((CharSequence)stringArray[1])) {
                stringArray[1] = "Unknown";
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            MLog.e(LOG_TAG, "error in getLocaleInfo", throwable);
            return stringArray;
        }
    }

    private static Locale getLocale(Context context) {
        Locale locale = null;
        if (context == null) {
            locale = Locale.getDefault();
            return locale;
        }
        try {
            Configuration configuration = new Configuration();
            configuration.setToDefaults();
            Settings.System.getConfiguration((ContentResolver)context.getContentResolver(), (Configuration)configuration);
            if (configuration != null) {
                locale = configuration.locale;
            }
        }
        catch (Throwable throwable) {
            MLog.e(LOG_TAG, "fail to read user config locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String getMac(Context context) {
        return UNKNOW;
    }

    private static String getMacBySystemInterface(Context context) {
        return UNKNOW;
    }

    /*
     * Unable to fully structure code
     */
    public static int[] getResolutionArray(Context var0) {
        block13: {
            block14: {
                if (var0 == null) {
                    return null;
                }
                var1_1 = new int[2];
                var2_2 = (WindowManager)var0.getSystemService("window");
                if (var2_2 == null) break block13;
                if (Build.VERSION.SDK_INT < 17) break block14;
                var3_3 = var2_2.getDefaultDisplay();
                var4_6 = new DisplayMetrics();
                var5_8 = null;
                try {
                    var5_8 = Class.forName("android.view.Display");
                    if (var5_8 == null) break block15;
                    var6_10 = var5_8.getMethod("getRealMetrics", new Class[]{DisplayMetrics.class});
                    if (var6_10 != null) {
                        var6_10.invoke((Object)var3_3, new Object[]{var4_6});
                        var7_12 = -1;
                        var8_13 = -1;
                        var7_12 = var4_6.widthPixels;
                        var8_13 = var4_6.heightPixels;
                        if (var7_12 > var8_13) {
                            var1_1[0] = var8_13;
                            var1_1[1] = var7_12;
                        } else {
                            var1_1[0] = var7_12;
                            var1_1[1] = var8_13;
                        }
                        var1_1[0] = var4_6.widthPixels;
                        var1_1[1] = var4_6.heightPixels;
                        return var1_1;
                    }
                    ** break block16
                }
                finally {
                    return null;
                }
            }
            try {
                var3_4 = new DisplayMetrics();
                var2_2.getDefaultDisplay().getMetrics(var3_4);
                var4_7 = -1;
                var5_9 = -1;
                if ((var0.getApplicationInfo().flags & 8192) == 0) {
                    var4_7 = DeviceConfig.reflectMetrics(var3_4, "noncompatWidthPixels");
                    var5_9 = DeviceConfig.reflectMetrics(var3_4, "noncompatHeightPixels");
                }
                if (var4_7 == -1 || var5_9 == -1) {
                    var4_7 = var3_4.widthPixels;
                    var5_9 = var3_4.heightPixels;
                }
                if (var4_7 > var5_9) {
                    var1_1[0] = var5_9;
                    var1_1[1] = var4_7;
                } else {
                    var1_1[0] = var4_7;
                    var1_1[1] = var5_9;
                }
                return var1_1;
            }
            catch (Throwable var3_5) {
                // empty catch block
            }
        }
lbl-1000:
        // 1 sources

        {
            block15: {
            }
        }
    }

    private static int reflectMetrics(Object object, String string) {
        try {
            Field field = DisplayMetrics.class.getDeclaredField(string);
            field.setAccessible(true);
            return field.getInt(object);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static String getPackageName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sAppPkgName)) {
            return sAppPkgName;
        }
        String string = null;
        if (context == null) {
            return null;
        }
        sAppPkgName = string = context.getPackageName();
        return sAppPkgName;
    }

    public static String getAppSHA1Key(Context context) {
        X509Certificate x509Certificate = null;
        String string = null;
        try {
            int n2 = 64;
            PackageInfo packageInfo = b.a().a(context, DeviceConfig.getPackageName(context), n2);
            if (packageInfo != null) {
                Signature[] signatureArray = packageInfo.signatures;
                byte[] byArray = signatureArray[0].toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                CertificateFactory certificateFactory = null;
                certificateFactory = CertificateFactory.getInstance("X509");
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                byte[] byArray2 = messageDigest.digest(x509Certificate.getEncoded());
                string = DeviceConfig.byte2HexFormatted(byArray2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String getAppHashKey(Context context) {
        try {
            Signature[] signatureArray;
            int n2;
            int n3;
            int n4 = 64;
            PackageInfo packageInfo = b.a().a(context, DeviceConfig.getPackageName(context), n4);
            if (packageInfo != null && (n3 = 0) < (n2 = (signatureArray = packageInfo.signatures).length)) {
                Signature signature = signatureArray[n3];
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(signature.toByteArray());
                return Base64.encodeToString((byte[])messageDigest.digest(), (int)0).trim();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String getAppMD5Signature(Context context) {
        String string = null;
        if (context == null) {
            return string;
        }
        try {
            int n2 = 64;
            PackageInfo packageInfo = b.a().a(context, DeviceConfig.getPackageName(context), n2);
            if (packageInfo != null) {
                Signature[] signatureArray = packageInfo.signatures;
                byte[] byArray = signatureArray[0].toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray2 = messageDigest.digest(x509Certificate.getEncoded());
                string = DeviceConfig.byte2HexFormatted(byArray2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    private static String byte2HexFormatted(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2]);
            int n2 = string.length();
            if (n2 == 1) {
                string = "0" + string;
            }
            if (n2 > 2) {
                string = string.substring(n2 - 2, n2);
            }
            stringBuilder.append(string.toUpperCase(Locale.getDefault()));
            if (i2 >= byArray.length - 1) continue;
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }

    public static String getApplicationLable(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        return context.getPackageManager().getApplicationLabel(context.getApplicationInfo()).toString();
    }

    public static String getAppName(Context context) {
        block5: {
            if (!TextUtils.isEmpty((CharSequence)sAppName)) {
                return sAppName;
            }
            String string = null;
            if (context == null) {
                return string;
            }
            try {
                int n2 = 64;
                PackageInfo packageInfo = b.a().a(context, context.getPackageName(), n2);
                if (packageInfo != null) {
                    sAppName = string = packageInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
                }
            }
            catch (Throwable throwable) {
                if (!AnalyticsConstants.UM_DEBUG) break block5;
                MLog.i(LOG_TAG, throwable);
            }
        }
        return sAppName;
    }

    public static String getDeviceIdForGeneral(Context context) {
        String string = UNKNOW;
        if (context == null) {
            return string;
        }
        try {
            if (Build.VERSION.SDK_INT < 23) {
                string = DeviceConfig.getIMEI(context);
                deviceTypeEnum = DeviceTypeEnum.IMEI;
                if (TextUtils.isEmpty((CharSequence)string)) {
                    if (AnalyticsConstants.UM_DEBUG) {
                        MLog.w(LOG_TAG, "No IMEI.");
                    }
                    string = DeviceConfig.getMacBySystemInterface(context);
                    deviceTypeEnum = DeviceTypeEnum.MAC;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        if (FieldManager.allow("header_device_id_android_id")) {
                            string = DeviceConfig.getAndroidId(context);
                            deviceTypeEnum = DeviceTypeEnum.ANDROIDID;
                            if (AnalyticsConstants.UM_DEBUG) {
                                MLog.i(LOG_TAG, "getDeviceId, ANDROID_ID: " + string);
                            }
                        }
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = DeviceConfig.getSerialNo();
                            deviceTypeEnum = DeviceTypeEnum.SERIALNO;
                        }
                    }
                }
            } else if (Build.VERSION.SDK_INT == 23) {
                string = DeviceConfig.getIMEI(context);
                deviceTypeEnum = DeviceTypeEnum.IMEI;
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = DeviceConfig.getMacByJavaAPI();
                    deviceTypeEnum = DeviceTypeEnum.MAC;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        if (AnalyticsConstants.CHECK_DEVICE) {
                            string = DeviceConfig.getMacShell();
                            deviceTypeEnum = DeviceTypeEnum.MAC;
                        } else {
                            string = DeviceConfig.getMacBySystemInterface(context);
                            deviceTypeEnum = DeviceTypeEnum.MAC;
                        }
                    }
                    if (AnalyticsConstants.UM_DEBUG) {
                        MLog.i(LOG_TAG, "getDeviceId, MAC: " + string);
                    }
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        if (FieldManager.allow("header_device_id_android_id")) {
                            string = DeviceConfig.getAndroidId(context);
                            deviceTypeEnum = DeviceTypeEnum.ANDROIDID;
                            if (AnalyticsConstants.UM_DEBUG) {
                                MLog.i(LOG_TAG, "getDeviceId, ANDROID_ID: " + string);
                            }
                        }
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = DeviceConfig.getSerialNo();
                            deviceTypeEnum = DeviceTypeEnum.SERIALNO;
                        }
                    }
                }
            } else if (Build.VERSION.SDK_INT >= 29) {
                string = DeviceConfig.getOaid(context);
                deviceTypeEnum = DeviceTypeEnum.OAID;
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = DeviceConfig.getIdfa(context);
                    deviceTypeEnum = DeviceTypeEnum.IDFA;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string = DeviceConfig.getAndroidId(context);
                        deviceTypeEnum = DeviceTypeEnum.ANDROIDID;
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = DeviceConfig.getSerialNo();
                            deviceTypeEnum = DeviceTypeEnum.SERIALNO;
                            if (TextUtils.isEmpty((CharSequence)string)) {
                                string = DeviceConfig.getMacByJavaAPI();
                                deviceTypeEnum = DeviceTypeEnum.MAC;
                                if (TextUtils.isEmpty((CharSequence)string)) {
                                    string = DeviceConfig.getMacBySystemInterface(context);
                                    deviceTypeEnum = DeviceTypeEnum.MAC;
                                }
                            }
                        }
                    }
                }
            } else {
                string = DeviceConfig.getIMEI(context);
                deviceTypeEnum = DeviceTypeEnum.IMEI;
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = DeviceConfig.getSerialNo();
                    deviceTypeEnum = DeviceTypeEnum.SERIALNO;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        if (FieldManager.allow("header_device_id_android_id")) {
                            string = DeviceConfig.getAndroidId(context);
                            deviceTypeEnum = DeviceTypeEnum.ANDROIDID;
                            if (AnalyticsConstants.UM_DEBUG) {
                                MLog.i(LOG_TAG, "getDeviceId, ANDROID_ID: " + string);
                            }
                        }
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = DeviceConfig.getMacByJavaAPI();
                            deviceTypeEnum = DeviceTypeEnum.MAC;
                            if (TextUtils.isEmpty((CharSequence)string)) {
                                string = DeviceConfig.getMacBySystemInterface(context);
                                deviceTypeEnum = DeviceTypeEnum.MAC;
                                if (AnalyticsConstants.UM_DEBUG) {
                                    MLog.i(LOG_TAG, "getDeviceId, MAC: " + string);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public static String getDeviceIdForBox(Context context) {
        String string = UNKNOW;
        if (context == null) {
            return string;
        }
        try {
            if (Build.VERSION.SDK_INT < 23) {
                if (FieldManager.allow("header_device_id_android_id")) {
                    string = DeviceConfig.getAndroidId(context);
                    deviceTypeEnum = DeviceTypeEnum.ANDROIDID;
                    if (AnalyticsConstants.UM_DEBUG) {
                        MLog.i(LOG_TAG, "getDeviceId, ANDROID_ID: " + string);
                    }
                }
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = DeviceConfig.getMacBySystemInterface(context);
                    deviceTypeEnum = DeviceTypeEnum.MAC;
                    if (AnalyticsConstants.UM_DEBUG) {
                        MLog.i(LOG_TAG, "getDeviceId, MAC: " + string);
                    }
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string = DeviceConfig.getSerialNo();
                        deviceTypeEnum = DeviceTypeEnum.SERIALNO;
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = DeviceConfig.getIMEI(context);
                            deviceTypeEnum = DeviceTypeEnum.IMEI;
                        }
                    }
                }
            } else if (Build.VERSION.SDK_INT == 23) {
                if (FieldManager.allow("header_device_id_android_id")) {
                    string = DeviceConfig.getAndroidId(context);
                    deviceTypeEnum = DeviceTypeEnum.ANDROIDID;
                    if (AnalyticsConstants.UM_DEBUG) {
                        MLog.i(LOG_TAG, "getDeviceId, ANDROID_ID: " + string);
                    }
                }
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = DeviceConfig.getMacByJavaAPI();
                    deviceTypeEnum = DeviceTypeEnum.MAC;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        if (AnalyticsConstants.CHECK_DEVICE) {
                            string = DeviceConfig.getMacShell();
                            deviceTypeEnum = DeviceTypeEnum.MAC;
                        } else {
                            string = DeviceConfig.getMacBySystemInterface(context);
                            deviceTypeEnum = DeviceTypeEnum.MAC;
                        }
                    }
                    if (AnalyticsConstants.UM_DEBUG) {
                        MLog.i(LOG_TAG, "getDeviceId, MAC: " + string);
                    }
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string = DeviceConfig.getSerialNo();
                        deviceTypeEnum = DeviceTypeEnum.SERIALNO;
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = DeviceConfig.getIMEI(context);
                            deviceTypeEnum = DeviceTypeEnum.IMEI;
                        }
                    }
                }
            } else if (Build.VERSION.SDK_INT >= 29) {
                string = DeviceConfig.getOaid(context);
                deviceTypeEnum = DeviceTypeEnum.OAID;
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = DeviceConfig.getIdfa(context);
                    deviceTypeEnum = DeviceTypeEnum.IDFA;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string = DeviceConfig.getAndroidId(context);
                        deviceTypeEnum = DeviceTypeEnum.ANDROIDID;
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = DeviceConfig.getSerialNo();
                            deviceTypeEnum = DeviceTypeEnum.SERIALNO;
                            if (TextUtils.isEmpty((CharSequence)string)) {
                                string = DeviceConfig.getMacByJavaAPI();
                                deviceTypeEnum = DeviceTypeEnum.MAC;
                                if (TextUtils.isEmpty((CharSequence)string)) {
                                    string = DeviceConfig.getMacBySystemInterface(context);
                                    deviceTypeEnum = DeviceTypeEnum.MAC;
                                }
                            }
                        }
                    }
                }
            } else {
                if (FieldManager.allow("header_device_id_android_id")) {
                    string = DeviceConfig.getAndroidId(context);
                    deviceTypeEnum = DeviceTypeEnum.ANDROIDID;
                    if (AnalyticsConstants.UM_DEBUG) {
                        MLog.i(LOG_TAG, "getDeviceId: ANDROID_ID: " + string);
                    }
                }
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = DeviceConfig.getSerialNo();
                    deviceTypeEnum = DeviceTypeEnum.SERIALNO;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string = DeviceConfig.getIMEI(context);
                        deviceTypeEnum = DeviceTypeEnum.IMEI;
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = DeviceConfig.getMacByJavaAPI();
                            deviceTypeEnum = DeviceTypeEnum.MAC;
                            if (TextUtils.isEmpty((CharSequence)string)) {
                                string = DeviceConfig.getMacBySystemInterface(context);
                                deviceTypeEnum = DeviceTypeEnum.MAC;
                                if (AnalyticsConstants.UM_DEBUG) {
                                    MLog.i(LOG_TAG, "getDeviceId, MAC: " + string);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public static String getOaid(Context context) {
        if (!UMConfigure.shouldCollectOaid()) {
            return UNKNOW;
        }
        if (!TextUtils.isEmpty((CharSequence)sOAID)) {
            return sOAID;
        }
        if (hasReadOAID) {
            return UNKNOW;
        }
        String string = UNKNOW;
        if (FieldManager.allow("header_device_oaid")) {
            try {
                SharedPreferences sharedPreferences = context.getSharedPreferences(i.a, 0);
                if (sharedPreferences != null) {
                    sOAID = string = sharedPreferences.getString("key_umeng_sp_oaid", UNKNOW);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                hasReadOAID = true;
            }
        }
        return sOAID;
    }

    public static String getHonorOaid(Context context) {
        if (!UMConfigure.shouldCollectOaid()) {
            return UNKNOW;
        }
        if (!TextUtils.isEmpty((CharSequence)sHonorOAID)) {
            return sHonorOAID;
        }
        if (hasReadHonorOAID) {
            return UNKNOW;
        }
        String string = UNKNOW;
        if (FieldManager.allow("header_device_oaid")) {
            try {
                SharedPreferences sharedPreferences = context.getSharedPreferences(c.a, 0);
                if (sharedPreferences != null) {
                    sHonorOAID = string = sharedPreferences.getString("key_umeng_sp_honor_oaid", UNKNOW);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                hasReadHonorOAID = true;
            }
        }
        return sHonorOAID;
    }

    public static String getIdfa(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sIDFA)) {
            return sIDFA;
        }
        if (hasReadIDFA) {
            return UNKNOW;
        }
        String string = UNKNOW;
        try {
            if (FieldManager.allow("header_tracking_idfa")) {
                sIDFA = string = a.a(context);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            hasReadIDFA = true;
        }
        return sIDFA;
    }

    private static String getIMEI(Context context) {
        return UNKNOW;
    }

    @TargetApi(value=9)
    private static String getSerialNo() {
        return UNKNOW;
    }

    public static String getSubOSName(Context context) {
        String string = null;
        Properties properties = DeviceConfig.getBuildProp();
        try {
            string = properties.getProperty(KEY_MIUI_VERSION_NAME);
            if (TextUtils.isEmpty((CharSequence)string)) {
                if (DeviceConfig.isFlyMe()) {
                    string = "Flyme";
                } else if (DeviceConfig.isEmui(properties)) {
                    string = "Emui";
                } else if (!TextUtils.isEmpty((CharSequence)DeviceConfig.getYunOSVersion(properties))) {
                    string = "YunOS";
                }
            } else {
                string = "MIUI";
            }
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }

    public static String getSubOSVersion(Context context) {
        String string = null;
        Properties properties = DeviceConfig.getBuildProp();
        try {
            string = properties.getProperty(KEY_MIUI_VERSION_NAME);
            if (TextUtils.isEmpty((CharSequence)string)) {
                if (DeviceConfig.isFlyMe()) {
                    try {
                        string = DeviceConfig.getFlymeVersion(properties);
                    }
                    catch (Throwable throwable) {}
                } else if (DeviceConfig.isEmui(properties)) {
                    try {
                        string = DeviceConfig.getEmuiVersion(properties);
                    }
                    catch (Throwable throwable) {}
                } else {
                    try {
                        string = DeviceConfig.getYunOSVersion(properties);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }

    private static String getYunOSVersion(Properties properties) {
        try {
            String string = properties.getProperty("ro.yunos.version");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String getFlymeVersion(Properties properties) {
        try {
            String string = properties.getProperty("ro.build.display.id").toLowerCase(Locale.getDefault());
            if (string.contains("flyme os")) {
                return string.split(" ")[2];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String getEmuiVersion(Properties properties) {
        String string = null;
        try {
            string = properties.getProperty(KEY_EMUI_VERSION_CODE, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static Properties getBuildProp() {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            properties.load(fileInputStream);
        }
        catch (Throwable throwable) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return properties;
    }

    private static boolean isFlyMe() {
        try {
            Build.class.getMethod("hasSmartBar", new Class[0]);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private static boolean isEmui(Properties properties) {
        try {
            String string = properties.getProperty(KEY_EMUI_VERSION_CODE, null);
            if (string != null) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static String getDeviceType(Context context) {
        String string = "Phone";
        try {
            boolean bl2;
            if (context == null) {
                return string;
            }
            boolean bl3 = bl2 = (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
            string = bl2 ? "Tablet" : "Phone";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public static String getDBencryptID(Context context) {
        return UMUtils.genId();
    }

    public static Activity getGlobleActivity(Context context) {
        Activity activity = null;
        try {
            Class<?> clazz = Class.forName("android.app.ActivityThread");
            Object object = clazz.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field field = clazz.getDeclaredField("mActivities");
            field.setAccessible(true);
            Map map = (Map)field.get(object);
            for (Object v2 : map.values()) {
                Class<?> clazz2 = v2.getClass();
                Field field2 = clazz2.getDeclaredField("paused");
                field2.setAccessible(true);
                if (field2.getBoolean(v2)) continue;
                Field field3 = clazz2.getDeclaredField("activity");
                field3.setAccessible(true);
                activity = (Activity)field3.get(v2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return activity;
    }

    public static boolean isHarmony(Context context) {
        try {
            int n2 = Resources.getSystem().getIdentifier("config_os_brand", "string", "android");
            return context.getString(n2).equals("harmony");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getSid(Context context) {
        return aa.a().d(context);
    }

    public static String getCustomAgt() {
        if (!TextUtils.isEmpty((CharSequence)sCustomAgt)) {
            return sCustomAgt;
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("Dalvik/");
        stringBuilder.append(System.getProperty("java.vm.version"));
        stringBuilder.append(" (Linux; U; Android ");
        stringBuilder.append(")");
        sCustomAgt = stringBuilder.toString();
        return sCustomAgt;
    }

    public static boolean isSystemApp(Context context) {
        boolean bl2 = false;
        if (FieldManager.allow("check_system_app")) {
            try {
                int n2 = 0x100000;
                PackageInfo packageInfo = b.a().a(context, DeviceConfig.getPackageName(context), n2);
                if (packageInfo != null && (packageInfo.applicationInfo.flags & 1) != 0) {
                    bl2 = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl2;
    }

    public static boolean hasOpsPermission(Context context) {
        boolean bl2 = false;
        if (FieldManager.allow("check_pus_permission") && Build.VERSION.SDK_INT >= 19) {
            try {
                AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
                int n2 = appOpsManager.checkOpNoThrow("android:get_usage_stats", Process.myUid(), DeviceConfig.getPackageName(context));
                if (n2 == 0) {
                    bl2 = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl2;
    }

    public static boolean hasRequestPermission(Context context, String string) {
        boolean bl2 = false;
        if (FieldManager.allow("check_pus_permission")) {
            try {
                String[] stringArray;
                PackageManager packageManager = context.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4096);
                for (String string2 : stringArray = packageInfo.requestedPermissions) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    bl2 = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl2;
    }

    public static boolean isHonorDevice() {
        return Build.MANUFACTURER.equalsIgnoreCase("HONOR");
    }

    public static String getNotificationStatus(Context context) {
        if (!FieldManager.allow("header_ntf_switch")) {
            return "unknown";
        }
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                boolean bl2 = notificationManager.areNotificationsEnabled();
                return Boolean.toString(bl2);
            }
            catch (Throwable throwable) {
                return "unknown";
            }
        }
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                String string = context.getApplicationContext().getPackageName();
                int n2 = applicationInfo.uid;
                Class<?> clazz = Class.forName(AppOpsManager.class.getName());
                Method method = clazz.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = clazz.getDeclaredField("OP_POST_NOTIFICATION");
                int n3 = (Integer)field.get(appOpsManager);
                int n4 = (Integer)method.invoke((Object)appOpsManager, n3, n2, string);
                boolean bl3 = n4 == 0;
                return Boolean.toString(bl3);
            }
            catch (Throwable throwable) {
                return "unknown";
            }
        }
        return Boolean.toString(true);
    }

    public static int getRingerMode(Context context) {
        if (!FieldManager.allow("header_ringer_mode")) {
            return -1;
        }
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            return audioManager.getRingerMode();
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static int getRandNumber(int n2, int n3) {
        Random random = new Random();
        return random.nextInt(n3 - n2 + 1) + n2;
    }
}

