/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.umcrash;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.uc.crashsdk.export.CrashApi;
import com.uc.crashsdk.export.CustomLogInfo;
import com.uc.crashsdk.export.ICrashClient;
import com.umeng.umcrash.UMCustomLogInfoBuilder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class UMCrash {
    private static final String TAG = UMCrash.class.getSimpleName();
    private static Context mContext;
    private static boolean isDebug;
    private static boolean isEncrypt;
    private static boolean isZip;
    public static final String KEY_CALLBACK_PAGE_ACTION = "um_action_log";
    public static final String KEY_CALLBACK_UMID = "um_umid";
    public static final String KEY_HEADER_APPKEY = "um_app_key";
    public static final String KEY_HEADER_CHANNEL = "um_app_channel";
    public static final String KEY_HEADER_OS = "um_os";
    public static final String KEY_HEADER_CRASH_VERSION = "um_crash_sdk_version";
    public static final String KEY_HEADER_UMID = "um_umid_header";
    private static String crashSdkVersion;
    private static Object pageArrayLock;
    private static ArrayList<String> mArrayList;

    private static synchronized String getUMID(Context context) {
        if (context == null) {
            return null;
        }
        String umId = null;
        Class<?> umConfigClass = null;
        try {
            umConfigClass = Class.forName("com.umeng.commonsdk.UMConfigure");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (umConfigClass != null) {
            Method umConfigMethed = null;
            try {
                umConfigMethed = umConfigClass.getMethod("getUMIDString", Context.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (umConfigMethed != null) {
                try {
                    Object o = umConfigMethed.invoke(null, context);
                    if (o != null) {
                        umId = o.toString();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return umId;
    }

    public static void setDebug(boolean isD) {
        isDebug = isD;
    }

    public static void init(Context context, String appkey, String channel) {
        if (context == null || appkey == null) {
            Log.e((String)TAG, (String)"context is null or appkey is null, init failed.");
            return;
        }
        mContext = context;
        try {
            Bundle customInfo = new Bundle();
            customInfo.putBoolean("mDebug", isDebug);
            customInfo.putBoolean("mEncryptLog", isEncrypt);
            customInfo.putBoolean("mZipLog", isZip);
            customInfo.putBoolean("enableUnexpLog", false);
            CrashApi mCrashApi = CrashApi.createInstanceEx((Context)context, (String)appkey, (boolean)isDebug, (Bundle)customInfo, (ICrashClient)new CrashClientImpl());
            if (mCrashApi != null) {
                mCrashApi.addHeaderInfo(KEY_HEADER_APPKEY, appkey);
                mCrashApi.addHeaderInfo(KEY_HEADER_CHANNEL, channel);
                mCrashApi.addHeaderInfo(KEY_HEADER_OS, "android");
                mCrashApi.addHeaderInfo(KEY_HEADER_CRASH_VERSION, crashSdkVersion);
                mCrashApi.addHeaderInfo(KEY_HEADER_UMID, UMCrash.getUMID(context));
                if (context instanceof Application) {
                    ((Application)context).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                        }

                        public void onActivityStarted(Activity activity) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onActivityResumed(Activity activity) {
                            Object object = pageArrayLock;
                            synchronized (object) {
                                if (mArrayList != null) {
                                    if (mArrayList.size() >= 10) {
                                        mArrayList.remove(0);
                                    }
                                    mArrayList.add(activity.getLocalClassName() + "-" + System.currentTimeMillis());
                                }
                            }
                        }

                        public void onActivityPaused(Activity activity) {
                        }

                        public void onActivityStopped(Activity activity) {
                        }

                        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                        }

                        public void onActivityDestroyed(Activity activity) {
                        }
                    });
                    int logType = 0x100011;
                    mCrashApi.registerInfoCallback(KEY_CALLBACK_UMID, logType);
                    mCrashApi.registerInfoCallback(KEY_CALLBACK_PAGE_ACTION, logType);
                } else {
                    Log.e((String)TAG, (String)"context not instanceof application.");
                }
            } else {
                Log.e((String)TAG, (String)"create CrashAPI is null.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void generateCustomLog(Throwable e, String type) {
        if (e == null || TextUtils.isEmpty((CharSequence)type)) {
            Log.e((String)TAG, (String)"generate custom log failed ! e is null or type is empty");
            return;
        }
        try {
            CustomLogInfo customLogInfo = new UMCustomLogInfoBuilder(type).stack(e).build();
            ArrayList<String> mCallbacks = new ArrayList<String>();
            mCallbacks.add(KEY_CALLBACK_UMID);
            mCallbacks.add(KEY_CALLBACK_PAGE_ACTION);
            customLogInfo.mCallbacks = mCallbacks;
            CrashApi mCrashApi = CrashApi.getInstance();
            if (mCrashApi == null) {
                Log.e((String)TAG, (String)"CrashApi is null, not init .");
            } else {
                mCrashApi.generateCustomLog(customLogInfo);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void generateCustomLog(String e, String type) {
        if (TextUtils.isEmpty((CharSequence)e) || TextUtils.isEmpty((CharSequence)type)) {
            Log.e((String)TAG, (String)"generate custom log failed ! e is null or type is empty");
            return;
        }
        try {
            CustomLogInfo info = new CustomLogInfo(null, "exception");
            ArrayList<String> mCallbacks = new ArrayList<String>();
            mCallbacks.add(KEY_CALLBACK_UMID);
            mCallbacks.add(KEY_CALLBACK_PAGE_ACTION);
            info.mCallbacks = mCallbacks;
            HashMap<String, String> kvInfoMap = new HashMap<String, String>(20);
            kvInfoMap.put("k_ct", "exception");
            kvInfoMap.put("k_ac", type);
            StringBuffer sb = new StringBuffer();
            for (Map.Entry entry : kvInfoMap.entrySet()) {
                sb.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\n");
            }
            String stack = "Exception message:\nBack traces starts.\n" + e + "\n" + "Back traces ends.";
            if (!TextUtils.isEmpty((CharSequence)stack)) {
                sb.append(stack).append("\n");
            }
            info.mData = sb;
            CrashApi mCrashApi = CrashApi.getInstance();
            if (mCrashApi == null) {
                Log.e((String)TAG, (String)"CrashApi is null, not init .");
            } else {
                mCrashApi.generateCustomLog(info);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        isDebug = true;
        isEncrypt = false;
        isZip = true;
        crashSdkVersion = "v0.0.5";
        pageArrayLock = new Object();
        mArrayList = new ArrayList(10);
    }

    private static class CrashClientImpl
    implements ICrashClient {
        private CrashClientImpl() {
        }

        public void onLogGenerated(File file, String s) {
        }

        public void onClientProcessLogGenerated(String s, File file, String s1) {
        }

        public File onBeforeUploadLog(File file) {
            return file;
        }

        public void onCrashRestarting(boolean b) {
        }

        public void onAddCrashStats(String s, int i, int i1) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String onGetCallbackInfo(String category, boolean b) {
            if (UMCrash.KEY_CALLBACK_PAGE_ACTION.equals(category)) {
                String result = null;
                try {
                    Object object = pageArrayLock;
                    synchronized (object) {
                        if (mArrayList != null && mArrayList.size() > 0) {
                            JSONObject jsonSec = new JSONObject();
                            jsonSec.put("source", 0);
                            jsonSec.put("action_name", (Object)"page_view");
                            JSONArray jsonParameter = new JSONArray();
                            for (int i = 0; i < mArrayList.size(); ++i) {
                                String item = (String)mArrayList.get(i);
                                if (item == null) continue;
                                JSONObject jsonitem = new JSONObject();
                                jsonitem.put("name", (Object)item);
                                jsonParameter.put((Object)jsonitem);
                            }
                            jsonSec.put("action_parameter", (Object)jsonParameter);
                            result = jsonSec.toString();
                            if (isDebug) {
                                Log.i((String)TAG, (String)("page json is " + result));
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return result;
            }
            if (UMCrash.KEY_CALLBACK_UMID.equals(category)) {
                return UMCrash.getUMID(mContext);
            }
            return null;
        }
    }
}

