/*
 * Decompiled with CFR 0.152.
 */
package org.android.agoo.huawei;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.huawei.hms.aaid.HmsInstanceId;
import com.taobao.accs.common.ThreadPoolExecutorFactory;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.UtilityImpl;
import com.taobao.agoo.BaseNotifyClickActivity;
import org.android.agoo.control.NotifManager;
import org.android.agoo.huawei.HuaweiMsgParseImpl;

public class HuaWeiRegister {
    private static final String TAG = "HuaWeiRegister";
    public static boolean isChannelRegister = false;

    public static void register(Application application) {
        HuaWeiRegister.registerBundle(application, false);
    }

    public static void registerBundle(final Application application, boolean channelRegister) {
        try {
            isChannelRegister = channelRegister;
            if (!isChannelRegister && !UtilityImpl.isMainProcess((Context)application)) {
                ALog.e((String)TAG, (String)"register not in main process, return", (Object[])new Object[0]);
                return;
            }
            if (HuaWeiRegister.checkDevice() && Build.VERSION.SDK_INT >= 17) {
                BaseNotifyClickActivity.addNotifyListener((BaseNotifyClickActivity.INotifyListener)new HuaweiMsgParseImpl());
                Handler handler = new Handler(Looper.getMainLooper());
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ALog.i((String)HuaWeiRegister.TAG, (String)"register begin", (Object[])new Object[]{"isChannel", isChannelRegister});
                        HuaWeiRegister.getToken(application.getApplicationContext());
                    }
                }, 5000L);
            } else {
                ALog.e((String)TAG, (String)"register checkDevice false", (Object[])new Object[0]);
            }
        }
        catch (Throwable t) {
            ALog.e((String)TAG, (String)"register", (Throwable)t, (Object[])new Object[0]);
        }
    }

    private static void getToken(final Context context) {
        ThreadPoolExecutorFactory.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                    String value = appInfo.metaData.getString("com.huawei.hms.client.appid");
                    String appId = "";
                    if (!TextUtils.isEmpty((CharSequence)value)) {
                        appId = value.replace("appid=", "");
                    }
                    ALog.i((String)HuaWeiRegister.TAG, (String)"onToken", (Object[])new Object[]{"appId", appId});
                    String token = TextUtils.isEmpty((CharSequence)appId) ? HmsInstanceId.getInstance((Context)context).getToken() : HmsInstanceId.getInstance((Context)context).getToken(appId, "HCM");
                    if (!TextUtils.isEmpty((CharSequence)token)) {
                        ALog.i((String)HuaWeiRegister.TAG, (String)"onToken", (Object[])new Object[]{"token", token});
                        NotifManager notifyManager = new NotifManager();
                        notifyManager.init(context);
                        notifyManager.reportThirdPushToken(token, "HW_TOKEN");
                    }
                }
                catch (Exception e) {
                    Log.e((String)HuaWeiRegister.TAG, (String)"getToken failed.", (Throwable)e);
                }
            }
        });
    }

    private static boolean checkDevice() {
        boolean result = false;
        if (Build.BRAND.equalsIgnoreCase("huawei") || Build.BRAND.equalsIgnoreCase("honor")) {
            result = true;
        }
        return result;
    }
}

