/*
 * Decompiled with CFR 0.152.
 */
package org.android.agoo.huawei;

import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.text.TextUtils;
import com.huawei.hms.push.HmsMessageService;
import com.huawei.hms.push.RemoteMessage;
import com.taobao.accs.utl.ALog;
import org.android.agoo.control.AgooFactory;
import org.android.agoo.control.NotifManager;
import org.android.agoo.huawei.HuaWeiRegister;

public class HuaweiPushMessageService
extends HmsMessageService {
    private static final String TAG = "HuaweiPushMessageService";
    private static final String HUAWEI_TOKEN = "HW_TOKEN";
    private AgooFactory agooFactory;

    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        try {
            if (HuaWeiRegister.isChannelRegister) {
                Intent intent = new Intent();
                intent.setAction("org.agoo.android.intent.action.PING_V4");
                intent.setClassName("com.taobao.taobao", "com.taobao.accs.ChannelService");
                intent.putExtra("source", "huawei-bundle");
                this.startService(intent);
            }
            String msgContent = remoteMessage.getData();
            ALog.i((String)TAG, (String)"onPushMsg", (Object[])new Object[]{"content", msgContent});
            if (this.agooFactory == null) {
                this.agooFactory = new AgooFactory();
                this.agooFactory.init((Context)this, null, null);
            }
            this.agooFactory.msgRecevie(msgContent.getBytes(), "huawei", null);
        }
        catch (Throwable e) {
            ALog.e((String)TAG, (String)"onPushMsg", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public void onDeletedMessages() {
        super.onDeletedMessages();
    }

    public void onMessageSent(String s) {
        super.onMessageSent(s);
    }

    public void onSendError(String s, Exception e) {
        super.onSendError(s, e);
    }

    public void onNewToken(String token) {
        super.onNewToken(token);
        try {
            if (!TextUtils.isEmpty((CharSequence)token)) {
                ALog.i((String)TAG, (String)"onToken", (Object[])new Object[]{"token", token});
                NotifManager notifyManager = new NotifManager();
                notifyManager.init(this.getApplicationContext());
                notifyManager.reportThirdPushToken(token, HUAWEI_TOKEN);
            }
        }
        catch (Throwable e) {
            ALog.e((String)TAG, (String)"onToken", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public IBinder onBind(Intent intent) {
        return super.onBind(intent);
    }

    public int onStartCommand(Intent intent, int i, int i1) {
        return super.onStartCommand(intent, i, i1);
    }

    public void onDestroy() {
        super.onDestroy();
    }
}

