/*
 * Decompiled with CFR 0.152.
 */
package org.android.agoo.mezu;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.SystemProperties;
import android.text.TextUtils;
import com.meizu.cloud.pushsdk.PushManager;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.UtilityImpl;
import com.taobao.agoo.BaseNotifyClickActivity;

public class MeizuRegister {
    private static Context mContext;
    public static final String TAG = "MeizuPush";

    public static void register(Context context, String appId, String appKey) {
        if (context == null || TextUtils.isEmpty((CharSequence)appId) || TextUtils.isEmpty((CharSequence)appKey)) {
            return;
        }
        try {
            if (!MeizuRegister.checkDevice(context)) {
                ALog.i((String)TAG, (String)"not meizu return", (Object[])new Object[0]);
                return;
            }
            mContext = context.getApplicationContext();
            if (!UtilityImpl.isMainProcess((Context)mContext)) {
                ALog.i((String)TAG, (String)"not in main process, return", (Object[])new Object[0]);
                return;
            }
            BaseNotifyClickActivity.addNotifyListener((BaseNotifyClickActivity.INotifyListener)new MeizuMsgParseImpl());
            PushManager.register((Context)mContext, (String)appId, (String)appKey);
        }
        catch (Throwable t) {
            ALog.e((String)TAG, (String)"register", (Throwable)t, (Object[])new Object[0]);
        }
    }

    private static boolean checkDevice(Context context) {
        try {
            boolean flag;
            String var1 = SystemProperties.get((String)"ro.meizu.product.model");
            boolean bl = flag = !TextUtils.isEmpty((CharSequence)var1) || "meizu".equalsIgnoreCase(Build.BRAND) || "22c4185e".equalsIgnoreCase(Build.BRAND);
            if (!flag) {
                var1 = SystemProperties.get((String)"ro.product.other.brand");
                flag = var1.equalsIgnoreCase("Unisoc");
            }
            return flag;
        }
        catch (Throwable e) {
            ALog.e((String)TAG, (String)"checkDevice", (Throwable)e, (Object[])new Object[0]);
            return MzSystemUtils.isBrandMeizu((Context)context);
        }
    }

    static class MeizuMsgParseImpl
    implements BaseNotifyClickActivity.INotifyListener {
        MeizuMsgParseImpl() {
        }

        public String parseMsgFromIntent(Intent intent) {
            String msg = null;
            if (intent == null) {
                ALog.e((String)MeizuRegister.TAG, (String)"parseMsgFromIntent null", (Object[])new Object[0]);
                return msg;
            }
            try {
                msg = intent.getStringExtra("meizu_payload");
                ALog.i((String)MeizuRegister.TAG, (String)"parseMsgFromIntent", (Object[])new Object[]{"msg", msg});
            }
            catch (Throwable t) {
                ALog.e((String)MeizuRegister.TAG, (String)"parseMsgFromIntent", (Throwable)t, (Object[])new Object[0]);
            }
            return msg;
        }

        public String getMsgSource() {
            return "meizu";
        }
    }
}

