/*
 * Decompiled with CFR 0.152.
 */
package com.zui.opendeviceidlibrary;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.zui.deviceidservice.IDeviceidInterface;

public class OpenDeviceId {
    private Context mContext = null;
    private IDeviceidInterface mDeviceidInterface;
    private static String TAG = "OpenDeviceId library";
    private static boolean DBG = false;
    private ServiceConnection mConnection;
    private CallBack mCallerCallBack = null;

    public int init(Context context, CallBack<String> listener) {
        if (context == null) {
            throw new NullPointerException("Context can not be null.");
        }
        this.mContext = context;
        this.mCallerCallBack = listener;
        this.mConnection = new ServiceConnection(){

            public synchronized void onServiceConnected(ComponentName className, IBinder service) {
                OpenDeviceId.this.mDeviceidInterface = IDeviceidInterface.Stub.asInterface(service);
                if (OpenDeviceId.this.mCallerCallBack != null) {
                    OpenDeviceId.this.mCallerCallBack.serviceConnected("Deviceid Service Connected", OpenDeviceId.this);
                }
                OpenDeviceId.this.logPrintI("Service onServiceConnected");
            }

            public void onServiceDisconnected(ComponentName className) {
                OpenDeviceId.this.mDeviceidInterface = null;
                OpenDeviceId.this.logPrintI("Service onServiceDisconnected");
            }
        };
        Intent intent = new Intent();
        intent.setClassName("com.zui.deviceidservice", "com.zui.deviceidservice.DeviceidService");
        boolean bindSuccessful = this.mContext.bindService(intent, this.mConnection, 1);
        if (bindSuccessful) {
            this.logPrintI("bindService Successful!");
            return 1;
        }
        this.logPrintI("bindService Failed!");
        return -1;
    }

    public String getOAID() {
        if (this.mContext == null) {
            this.logPrintE("Context is null.");
            throw new IllegalArgumentException("Context is null, must be new OpenDeviceId first");
        }
        try {
            if (this.mDeviceidInterface != null) {
                return this.mDeviceidInterface.getOAID();
            }
        }
        catch (RemoteException e) {
            this.logPrintE("getOAID error, RemoteException!");
            e.printStackTrace();
        }
        return null;
    }

    public String getUDID() {
        if (this.mContext == null) {
            this.logPrintE("Context is null.");
            throw new IllegalArgumentException("Context is null, must be new OpenDeviceId first");
        }
        try {
            if (this.mDeviceidInterface != null) {
                return this.mDeviceidInterface.getUDID();
            }
        }
        catch (RemoteException e) {
            this.logPrintE("getUDID error, RemoteException!");
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logPrintE("getUDID error, Exception!");
            e.printStackTrace();
        }
        return null;
    }

    public boolean isSupported() {
        try {
            if (this.mDeviceidInterface != null) {
                this.logPrintI("Device support opendeviceid");
                return this.mDeviceidInterface.isSupport();
            }
        }
        catch (RemoteException e) {
            this.logPrintE("isSupport error, RemoteException!");
            return false;
        }
        return false;
    }

    public String getVAID() {
        if (this.mContext == null) {
            this.logPrintI("Context is null.");
            throw new IllegalArgumentException("Context is null, must be new OpenDeviceId first");
        }
        String packagename = this.mContext.getPackageName();
        this.logPrintI("liufeng, getVAID package\uff1a" + packagename);
        if (packagename != null && !packagename.equals("")) {
            try {
                if (this.mDeviceidInterface != null) {
                    return this.mDeviceidInterface.getVAID(packagename);
                }
            }
            catch (RemoteException e) {
                this.logPrintE("getVAID error, RemoteException!");
                e.printStackTrace();
            }
        } else {
            this.logPrintI("input package is null!");
        }
        return null;
    }

    public String getAAID() {
        if (this.mContext == null) {
            this.logPrintI("Context is null.");
            throw new IllegalArgumentException("Context is null, must be new OpenDeviceId first");
        }
        String packagename = this.mContext.getPackageName();
        this.logPrintI("liufeng, getAAID package\uff1a" + packagename);
        String retStr = null;
        if (packagename != null && !packagename.equals("")) {
            try {
                boolean ifCreate;
                if (this.mDeviceidInterface != null && ((retStr = this.mDeviceidInterface.getAAID(packagename)) == null || "".equals(retStr)) && (ifCreate = this.mDeviceidInterface.createAAIDForPackageName(packagename))) {
                    retStr = this.mDeviceidInterface.getAAID(packagename);
                }
            }
            catch (RemoteException e) {
                this.logPrintE("getAAID error, RemoteException!");
            }
        } else {
            this.logPrintI("input package is null!");
        }
        return retStr;
    }

    public void shutdown() {
        try {
            this.mContext.unbindService(this.mConnection);
            this.logPrintI("unBind Service successful");
        }
        catch (IllegalArgumentException e) {
            this.logPrintE("unBind Service exception");
        }
        this.mDeviceidInterface = null;
    }

    public void setLogEnable(boolean enable) {
        DBG = enable;
    }

    private void logPrintI(String str) {
        if (DBG) {
            Log.i((String)TAG, (String)str);
        }
    }

    private void logPrintE(String str) {
        if (DBG) {
            Log.e((String)TAG, (String)str);
        }
    }

    public static interface CallBack<T> {
        public void serviceConnected(T var1, OpenDeviceId var2);
    }
}

