/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.heytap.mcssdk.PushService;
import com.heytap.mcssdk.constant.Constants;
import com.heytap.mcssdk.utils.ApkInfoUtil;
import com.heytap.mcssdk.utils.LogUtil;

public class SharedPreferenceManager {
    private static final String SHARED_PREFS_NAME = "shared_msg_sdk";
    private static final String HAS_DEFAULT_CHANNEL_CREATED = "hasDefaultChannelCreated";
    private static final String STATIC_INFOMATION_SDK_VERSION = "lastUpLoadInfoSDKVersionName";
    private static final String STATIC_INFOMATION_UNIQUE_ID = "lastUploadInfoUniqueID";
    private static final String DECRYPT_TAG = "decryptTag";
    private Context mContext;
    private SharedPreferences mSharedPrefs;
    private Object prefsLock = new Object();

    public boolean hasDefaultChannelCreated() {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        boolean hasDefaultChannelCreated = false;
        if (sharedPreferences != null) {
            hasDefaultChannelCreated = sharedPreferences.getBoolean(HAS_DEFAULT_CHANNEL_CREATED, false);
        }
        return hasDefaultChannelCreated;
    }

    public void setHasDefaultChannelCreated(boolean hasCreated) {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            sharedPreferences.edit().putBoolean(HAS_DEFAULT_CHANNEL_CREATED, hasCreated).commit();
        }
    }

    public void saveSDKVersionName() {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            sharedPreferences.edit().putString(STATIC_INFOMATION_SDK_VERSION, "3.1.0").commit();
        }
    }

    public void saveLastUploadUniqueID(String uniqueID) {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            sharedPreferences.edit().putString(STATIC_INFOMATION_UNIQUE_ID, uniqueID).commit();
        }
    }

    public String getLastUpdataUniqueID() {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        String uniqueID = "";
        if (sharedPreferences != null) {
            uniqueID = sharedPreferences.getString(STATIC_INFOMATION_UNIQUE_ID, "");
        }
        return uniqueID;
    }

    public String getLastUploadInfoSDKVersion() {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        String lastUpdatedSDKVersionName = "";
        if (sharedPreferences != null) {
            lastUpdatedSDKVersionName = sharedPreferences.getString(STATIC_INFOMATION_SDK_VERSION, "");
        }
        return lastUpdatedSDKVersionName;
    }

    public void saveDecryptTag(String tag) {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            sharedPreferences.edit().putString(DECRYPT_TAG, tag).commit();
        }
    }

    public String getDecryptTag() {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        String decryptTag = "DES";
        if (sharedPreferences != null) {
            decryptTag = sharedPreferences.getString(DECRYPT_TAG, "DES");
        }
        return decryptTag;
    }

    public int getIntData(String key) {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            return sharedPreferences.getInt(key, 0);
        }
        return 0;
    }

    public int getIntData(String key, int value) {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            return sharedPreferences.getInt(key, value);
        }
        return value;
    }

    public long getLongData(String key) {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            return sharedPreferences.getLong(key, Constants.UNKNOWN_LONG.longValue());
        }
        return Constants.UNKNOWN_LONG;
    }

    public long getLongData(String key, long value) {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            return sharedPreferences.getLong(key, value);
        }
        return value;
    }

    public void setIntData(String key, int value) {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt(key, value);
            editor.apply();
        }
    }

    public void setLongData(String key, long value) {
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putLong(key, value);
            editor.apply();
        }
    }

    private SharedPreferenceManager() {
        Context context = PushService.getInstance().getContext();
        if (context != null) {
            this.mContext = this.getStorageContext(context);
        }
        if (this.mContext != null) {
            this.mSharedPrefs = this.mContext.getSharedPreferences(SHARED_PREFS_NAME, 0);
        }
    }

    private Context getStorageContext(Context context) {
        boolean fbeVersion = ApkInfoUtil.isFBEVersion();
        LogUtil.d("fbeVersion is " + fbeVersion);
        if (fbeVersion && Build.VERSION.SDK_INT >= 24) {
            return context.createDeviceProtectedStorageContext();
        }
        return context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedPreferences getSharedPrefs() {
        if (this.mSharedPrefs != null) {
            return this.mSharedPrefs;
        }
        Object object = this.prefsLock;
        synchronized (object) {
            if (this.mSharedPrefs == null && this.mContext != null) {
                this.mSharedPrefs = this.mContext.getSharedPreferences(SHARED_PREFS_NAME, 0);
                return this.mSharedPrefs;
            }
            return this.mSharedPrefs;
        }
    }

    public static SharedPreferenceManager getInstance() {
        return SharedPreferenceManagerInstanceHolder.INSTANCE;
    }

    private static class SharedPreferenceManagerInstanceHolder {
        static SharedPreferenceManager INSTANCE = new SharedPreferenceManager();

        private SharedPreferenceManagerInstanceHolder() {
        }
    }
}

