/*
 * Decompiled with CFR 0.152.
 */
package org.android.agoo.oppo;

import android.content.Context;
import android.text.TextUtils;
import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.callback.ICallBackResultService;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.UtilityImpl;
import com.taobao.agoo.BaseNotifyClickActivity;
import org.android.agoo.control.NotifManager;
import org.android.agoo.oppo.OppoMsgParseImpl;

public class OppoRegister {
    public static final String TAG = "OppoPush";
    private static final String OPPO_TOKEN = "OPPO_TOKEN";
    private static Context mContext;

    public static void register(Context context, String appKey, String appSecret) {
        try {
            mContext = context.getApplicationContext();
            if (!UtilityImpl.isMainProcess((Context)mContext)) {
                ALog.i((String)TAG, (String)"not in main process, return", (Object[])new Object[0]);
                return;
            }
            HeytapPushManager.init((Context)mContext, ((OppoRegister.mContext.getApplicationInfo().flags & 2) != 0 ? 1 : 0) != 0);
            if (HeytapPushManager.isSupportPush()) {
                BaseNotifyClickActivity.addNotifyListener((BaseNotifyClickActivity.INotifyListener)new OppoMsgParseImpl());
                ALog.i((String)TAG, (String)"register oppo begin ", (Object[])new Object[0]);
                HeytapPushManager.register((Context)mContext, (String)appKey, (String)appSecret, (ICallBackResultService)new ICallBackResultService(){

                    public void onRegister(int i, String s) {
                        ALog.i((String)OppoRegister.TAG, (String)("onRegister regid=" + s), (Object[])new Object[0]);
                        OppoRegister.reportToken(mContext, s);
                    }

                    public void onUnRegister(int i) {
                        ALog.e((String)OppoRegister.TAG, (String)("onUnRegister code=" + i), (Object[])new Object[0]);
                    }

                    public void onSetPushTime(int i, String s) {
                        ALog.i((String)OppoRegister.TAG, (String)"onSetPushTime", (Object[])new Object[0]);
                    }

                    public void onGetPushStatus(int i, int i1) {
                        ALog.i((String)OppoRegister.TAG, (String)"onGetPushStatus", (Object[])new Object[0]);
                    }

                    public void onGetNotificationStatus(int i, int i1) {
                        ALog.i((String)OppoRegister.TAG, (String)"onGetNotificationStatus", (Object[])new Object[0]);
                    }
                });
            } else {
                ALog.i((String)TAG, (String)"not support oppo push", (Object[])new Object[0]);
            }
        }
        catch (Throwable t) {
            ALog.e((String)TAG, (String)"register error", (Throwable)t, (Object[])new Object[0]);
        }
    }

    private static void reportToken(Context context, String token) {
        if (!TextUtils.isEmpty((CharSequence)token) && context != null) {
            NotifManager notifyManager = new NotifManager();
            notifyManager.init(context.getApplicationContext());
            notifyManager.reportThirdPushToken(token, OPPO_TOKEN, true);
        }
    }
}

