/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.common;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.ta.utdid2.device.UTDevice;
import com.umeng.commonsdk.config.FieldManager;
import com.umeng.commonsdk.debug.UMLog;
import com.umeng.commonsdk.utils.UMUtils;
import com.umeng.message.PushAgent;
import com.umeng.message.proguard.c;
import com.umeng.message.proguard.h;
import com.umeng.message.util.a;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class UmengMessageDeviceConfig {
    private static final String b = UmengMessageDeviceConfig.class.getSimpleName();
    protected static final String a = "Unknown";
    private static final String c = "2G/3G";
    private static final String d = "Wi-Fi";
    public static final int DEFAULT_TIMEZONE = 8;
    private static boolean e = false;

    public static boolean isCommonConfig(String string) {
        boolean bl = true;
        try {
            bl = FieldManager.allow((String)string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isCommonConfigNew(String string) {
        try {
            Method method;
            Class<?> clazz = Class.forName("com.umeng.commonsdk.config.FieldManager");
            if (clazz != null && (method = clazz.getMethod("allow", String.class)) != null) {
                Object object = method.invoke(null, string);
                return (Boolean)object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static String getAppVersionCode(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            int n = packageInfo.versionCode;
            return String.valueOf(n);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return a;
        }
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return a;
        }
    }

    public static boolean checkPermission(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.checkPermission(string, context.getPackageName()) == 0;
    }

    public static String getCPU() {
        String string = null;
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_cpu")) {
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                fileReader = new FileReader("/proc/cpuinfo");
                if (fileReader != null) {
                    try {
                        bufferedReader = new BufferedReader(fileReader, 1024);
                        string = bufferedReader.readLine();
                        bufferedReader.close();
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"Could not read from file /proc/cpuinfo", iOException.getMessage()});
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"Could not open file /proc/cpuinfo", fileNotFoundException.getMessage()});
            }
            if (string != null) {
                int n = string.indexOf(58) + 1;
                string = string.substring(n).trim();
            }
        }
        return string;
    }

    public static String getDeviceId(Context context) {
        String string = "";
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_imei")) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager == null) {
                UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"No IMEI."});
            }
            try {
                if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                    string = telephonyManager.getDeviceId();
                }
            }
            catch (Exception exception) {
                UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"No IMEI.", exception.getMessage()});
            }
        }
        if (TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)string)) {
            UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"Failed to take imei as IMEI. Try to use Secure.ANDROID_ID instead."});
            if (UmengMessageDeviceConfig.isCommonConfigNew("push_android_id")) {
                string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            }
            UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"getDeviceId: Secure.ANDROID_ID: " + string});
            if (TextUtils.isEmpty((CharSequence)string)) {
                UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"Failed to take Secure.ANDROID_ID as IMEI. Try to use Serial_number instead."});
                if (UmengMessageDeviceConfig.isCommonConfigNew("push_serialNo")) {
                    string = UmengMessageDeviceConfig.getSerial_number();
                }
                UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"getDeviceId: Serial_number: " + string});
                return string;
            }
        }
        return string;
    }

    public static String getDIN(Context context) {
        String string = "";
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_imei")) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager == null) {
                UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"No IMEI."});
            }
            try {
                if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE") && !TextUtils.isEmpty((CharSequence)(string = telephonyManager.getDeviceId()))) {
                    return string;
                }
            }
            catch (Exception exception) {
                UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"No IMEI.", exception.getMessage()});
            }
        }
        return "";
    }

    public static String getDINAes(Context context) {
        String string;
        block2: {
            string = "";
            try {
                string = UmengMessageDeviceConfig.getDIN(context);
                String string2 = PushAgent.getInstance(context).getMessageAppkey();
                string = string2 != null && 24 == string2.length() ? com.umeng.message.proguard.c.a(string, "utf-8", string2.substring(0, 16)) : com.umeng.message.proguard.c.a(new String[]{string, "utf-8"});
            }
            catch (Exception exception) {
                if (exception == null) break block2;
                UMLog.mutlInfo((String)b, (int)1, (String[])new String[]{"getDINAes:" + exception.getMessage()});
            }
        }
        return string;
    }

    public static String getAndroidId(Context context) {
        String string = null;
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_settings_android_id") && (string = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id")) == null) {
            string = "";
        }
        return string;
    }

    public static String getSerial_number() {
        String string = "";
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_serialNo")) {
            if (Build.VERSION.SDK_INT <= 25) {
                string = Build.SERIAL;
            } else {
                try {
                    Class<?> clazz = Class.forName("android.os.Build");
                    Method method = clazz.getMethod("getSerial", new Class[0]);
                    string = (String)method.invoke(clazz, new Object[0]);
                }
                catch (Throwable throwable) {
                    string = "";
                }
            }
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    public static String getDeviceIdMD5(Context context) {
        return h.a(UmengMessageDeviceConfig.getDeviceId(context));
    }

    public static String[] getNetworkAccessMode(Context context) {
        String[] stringArray = new String[]{a, a};
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_network_access_mode")) {
            try {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivityManager == null) {
                    return stringArray;
                }
                NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
                if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                    stringArray[0] = d;
                    return stringArray;
                }
                NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(0);
                if (networkInfo2 != null && networkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                    stringArray[0] = c;
                    stringArray[1] = networkInfo2.getSubtypeName();
                    return stringArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public static boolean isOnline(Context context) {
        try {
            NetworkInfo networkInfo = null;
            if (UmengMessageDeviceConfig.isCommonConfigNew("push_on_line")) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                networkInfo = connectivityManager.getActiveNetworkInfo();
            }
            if (networkInfo != null) {
                return networkInfo.isConnectedOrConnecting();
            }
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static int getTimeZone(Context context) {
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_time_zone")) {
            try {
                Locale locale = UmengMessageDeviceConfig.a(context);
                Calendar calendar = Calendar.getInstance(locale);
                if (calendar != null) {
                    return calendar.getTimeZone().getRawOffset() / 3600000;
                }
            }
            catch (Exception exception) {
                UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"error in getTimeZone", exception.getMessage()});
            }
        }
        return 8;
    }

    public static String[] getLocaleInfo(Context context) {
        String[] stringArray = new String[2];
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_locale_info")) {
            try {
                Locale locale = UmengMessageDeviceConfig.a(context);
                if (locale != null) {
                    stringArray[0] = locale.getCountry();
                    stringArray[1] = locale.getLanguage();
                }
                if (TextUtils.isEmpty((CharSequence)stringArray[0])) {
                    stringArray[0] = a;
                }
                if (TextUtils.isEmpty((CharSequence)stringArray[1])) {
                    stringArray[1] = a;
                }
                return stringArray;
            }
            catch (Exception exception) {
                UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"error in getLocaleInfo", exception.getMessage()});
            }
        }
        return stringArray;
    }

    private static Locale a(Context context) {
        Locale locale = null;
        try {
            Configuration configuration = new Configuration();
            Settings.System.getConfiguration((ContentResolver)context.getContentResolver(), (Configuration)configuration);
            if (configuration != null) {
                locale = configuration.locale;
            }
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"fail to read user config locale"});
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String getMetaData(Context context, String string) {
        try {
            String string2;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && (string2 = applicationInfo.metaData.getString(string)) != null) {
                return string2.trim();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{String.format("Could not read meta-data %s from AndroidManifest.xml.", string)});
        return null;
    }

    public static String getDummyId(Context context) {
        return "02:00:00:00:00:00";
    }

    public static String getUmid(Context context) {
        String string = UmengMessageDeviceConfig.b(context);
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static String b(Context context) {
        return UMUtils.getUMId((Context)context);
    }

    public static String getResolution(Context context) {
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_resolution")) {
            try {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                windowManager.getDefaultDisplay().getMetrics(displayMetrics);
                int n = -1;
                int n2 = -1;
                if ((context.getApplicationInfo().flags & 0x2000) == 0) {
                    n = UmengMessageDeviceConfig.a(displayMetrics, "noncompatWidthPixels");
                    n2 = UmengMessageDeviceConfig.a(displayMetrics, "noncompatHeightPixels");
                }
                if (n == -1 || n2 == -1) {
                    n = displayMetrics.widthPixels;
                    n2 = displayMetrics.heightPixels;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(n);
                stringBuffer.append("*");
                stringBuffer.append(n2);
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"read resolution fail", exception.getMessage()});
            }
        }
        return a;
    }

    private static int a(Object object, String string) {
        try {
            Field field = DisplayMetrics.class.getDeclaredField(string);
            if (field != null) {
                field.setAccessible(true);
                return field.getInt(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return -1;
    }

    public static String getOperator(Context context) {
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_operator")) {
            try {
                return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
            }
            catch (Exception exception) {
                UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"read carrier fail", exception.getMessage()});
            }
        }
        return a;
    }

    public static String getChannel(Context context) {
        String string = a;
        try {
            Object object;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && applicationInfo.metaData != null && (object = applicationInfo.metaData.get("UMENG_CHANNEL")) != null) {
                String string2 = object.toString();
                if (string2 != null) {
                    string = string2;
                } else {
                    UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"\u5728AndroidManifest.xml\u4e2d\u8bfb\u53d6\u4e0d\u5230UMENG_CHANNEL meta-data"});
                }
            }
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"\u5728AndroidManifest.xml\u4e2d\u8bfb\u53d6\u4e0d\u5230UMENG_CHANNEL meta-data"});
            exception.printStackTrace();
        }
        return string;
    }

    public static String getPackageName(Context context) {
        return context.getPackageName();
    }

    public static String getApplicationLable(Context context) {
        return context.getPackageManager().getApplicationLabel(context.getApplicationInfo()).toString();
    }

    public static String getUtdid(Context context) {
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_utdid")) {
            try {
                return UTDevice.getUtdid((Context)context);
            }
            catch (Throwable throwable) {
                UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"\u83b7\u53d6utdid\u5931\u8d25. " + throwable.getMessage()});
            }
        }
        return "";
    }

    public static boolean isServiceWork(Context context, String string, String string2) {
        boolean bl = false;
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_service_work")) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List list = activityManager.getRunningServices(Integer.MAX_VALUE);
            if (list.size() <= 0) {
                return false;
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string3 = ((ActivityManager.RunningServiceInfo)list.get((int)i2)).service.getClassName().toString();
                String string4 = ((ActivityManager.RunningServiceInfo)list.get((int)i2)).service.getPackageName().toString();
                if (!string3.equals(string) || !string4.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static String getServiceName(Context context, String string, String string2) {
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_service_name")) {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = new Intent();
            intent.setAction(string);
            List list = packageManager.queryIntentServices(intent, 0);
            ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
            if (list != null && list.size() > 0) {
                for (ResolveInfo resolveInfo : list) {
                    if (!resolveInfo.serviceInfo.packageName.equals(string2)) continue;
                    arrayList.add(resolveInfo);
                }
            }
            if (arrayList != null && arrayList.size() > 0) {
                return ((ResolveInfo)arrayList.get((int)0)).serviceInfo.name;
            }
        }
        return null;
    }

    public static boolean isIntentExist(Context context, String string, String string2) {
        Intent intent;
        PackageManager packageManager;
        List list;
        boolean bl = false;
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_intent_exist") && !(list = (packageManager = context.getPackageManager()).queryIntentActivities(intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string)), 0)).isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!((ResolveInfo)list.get((int)i2)).activityInfo.packageName.equalsIgnoreCase(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean getDataData(String string) {
        File file = null;
        boolean bl = false;
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_data_data")) {
            file = new File("/data/app/" + string + "-1.apk");
            bl = file.exists();
            if (!bl) {
                file = new File("/data/app/" + string + "-2.apk");
                bl = file.exists();
            }
            if (!bl) {
                file = new File("/data/app/" + string + ".apk");
                bl = file.exists();
            }
            if (!bl) {
                file = new File("/data/app/" + string + "-1");
                bl = file.exists();
            }
            if (!bl) {
                file = new File("/data/app/" + string + "-2");
                bl = file.exists();
            }
        }
        return bl;
    }

    public static boolean isMiui8() {
        boolean bl = false;
        try {
            a a2 = com.umeng.message.util.a.g();
            String string = a2.a("ro.miui.ui.version.name");
            if (string != null && string.contains("8")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static String isNotificationEnabled(Context context) {
        String string = "unknown";
        if (UmengMessageDeviceConfig.isCommonConfigNew("push_notification_enabled") && Build.VERSION.SDK_INT >= 19) {
            try {
                AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                String string2 = context.getApplicationContext().getPackageName();
                int n = applicationInfo.uid;
                Class<?> clazz = null;
                clazz = Class.forName(AppOpsManager.class.getName());
                Method method = clazz.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = clazz.getDeclaredField("OP_POST_NOTIFICATION");
                int n2 = (Integer)field.get(appOpsManager);
                int n3 = (Integer)method.invoke((Object)appOpsManager, n2, n, string2);
                string = String.valueOf(n3 == 0);
            }
            catch (Exception exception) {
                UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"\u901a\u77e5\u5f00\u5173\u662f\u5426\u6253\u5f00\u5f02\u5e38"});
            }
        }
        return string;
    }
}

