/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.tag;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.umeng.commonsdk.debug.UMLog;
import com.umeng.message.MessageSharedPrefs;
import com.umeng.message.UTrack;
import com.umeng.message.common.UmengMessageDeviceConfig;
import com.umeng.message.common.d;
import com.umeng.message.common.inter.ITagManager;
import com.umeng.message.util.HttpRequest;
import com.umeng.message.util.e;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class TagManager {
    private static final String a = TagManager.class.getName();
    private static final String b = "ok";
    private static final String c = "fail";
    @SuppressLint(value={"StaticFieldLeak"})
    private static TagManager d;
    private Context e;
    private static ITagManager f;

    private TagManager(Context context) {
        this.e = context.getApplicationContext();
    }

    public static synchronized TagManager getInstance(Context context) {
        if (d == null) {
            d = new TagManager(context.getApplicationContext());
            try {
                Class<?> clazz = Class.forName("com.umeng.message.common.impl.json.JTagManager");
                Class[] classArray = new Class[]{Context.class};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{context};
                f = (ITagManager)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return d;
    }

    public void addTags(final TCallBack tCallBack, final String ... stringArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ITagManager.Result result = new ITagManager.Result();
                if (stringArray == null || stringArray.length == 0) {
                    String string = "No tags";
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    result.setErrors(string);
                    tCallBack.onMessage(false, result);
                    return;
                }
                if (!TagManager.this.d()) {
                    String string = "No utdid or device_token";
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    result.setErrors(string);
                    tCallBack.onMessage(false, result);
                    return;
                }
                if (TagManager.this.e()) {
                    String string = "Tag API is disabled by the server";
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    result.setErrors(string);
                    tCallBack.onMessage(false, result);
                    return;
                }
                String string = TagManager.this.a(MessageSharedPrefs.getInstance(TagManager.this.e).get_addTagsInterval(), stringArray);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    result.setErrors(string);
                    tCallBack.onMessage(false, result);
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                if (stringArray.length > 0) {
                    for (JSONObject jSONObject : stringArray) {
                        boolean bl = MessageSharedPrefs.getInstance(TagManager.this.e).isTagSet((String)jSONObject);
                        if (bl || arrayList.contains(jSONObject)) continue;
                        byte[] byArray = null;
                        try {
                            byArray = jSONObject.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            unsupportedEncodingException.printStackTrace();
                        }
                        if (byArray.length > 128 || byArray.length < 0) continue;
                        arrayList.add((String)jSONObject);
                    }
                }
                if (arrayList.size() == 0) {
                    result = TagManager.this.f();
                    tCallBack.onMessage(true, result);
                    return;
                }
                try {
                    JSONObject jSONObject = TagManager.this.c();
                    jSONObject.put("tags", (Object)com.umeng.message.util.e.a(arrayList));
                    result = f.addTags(jSONObject, stringArray);
                    tCallBack.onMessage(true, result);
                }
                catch (Exception exception) {
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"\u6dfb\u52a0tag\u5f02\u5e38"});
                }
            }
        };
        com.umeng.message.common.d.a(runnable);
    }

    public void addWeightedTags(final TCallBack tCallBack, final Hashtable<String, Integer> hashtable) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ITagManager.Result result = new ITagManager.Result();
                if (!TagManager.this.d()) {
                    String string = "No utdid or device token";
                    result.setErrors(string);
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    tCallBack.onMessage(false, result);
                    return;
                }
                if (hashtable == null || hashtable.size() == 0) {
                    String string = "No weighted tags";
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    result.setErrors(string);
                    tCallBack.onMessage(false, result);
                    return;
                }
                if (hashtable.size() > 64) {
                    String string = "The maximum number of adding weighted tags per request is 64";
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    result.setErrors(string);
                    tCallBack.onMessage(false, result);
                    return;
                }
                String string = TagManager.this.a(MessageSharedPrefs.getInstance(TagManager.this.e).getAddWeightedTagsInterval(), hashtable);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    result.setErrors(string);
                    tCallBack.onMessage(false, result);
                    return;
                }
                try {
                    JSONObject jSONObject = new JSONObject();
                    for (String string2 : hashtable.keySet()) {
                        int n = (Integer)hashtable.get(string2);
                        jSONObject.put(string2, n);
                    }
                    JSONObject jSONObject2 = TagManager.this.c();
                    jSONObject2.put("tags", (Object)jSONObject);
                    tCallBack.onMessage(true, f.addWeightedTags(jSONObject2, hashtable));
                }
                catch (Exception exception) {
                    if (exception != null) {
                        exception.printStackTrace();
                    }
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"\u6dfb\u52a0\u52a0\u6743\u6807\u7b7e\u5f02\u5e38"});
                }
            }
        };
        com.umeng.message.common.d.a(runnable);
    }

    private String a(String string, String ... stringArray) {
        Object object = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null && stringArray.length > 0) {
            for (String string2 : stringArray) {
                boolean bl = MessageSharedPrefs.getInstance(this.e).isTagSet(string2);
                if (bl || arrayList.contains(string2)) continue;
                byte[] byArray = null;
                try {
                    byArray = string2.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                if (byArray.length <= 128 && byArray.length >= 0) {
                    arrayList.add(string2);
                    continue;
                }
                object = "\u90e8\u5206Tags\u957f\u5ea6\u4e0d\u5728\u9650\u52360\u5230128\u4e2a\u5b57\u7b26\u4e4b\u95f4";
                return object;
            }
        }
        if (string == null) {
            return object;
        }
        try {
            ITagManager.Result exception = new ITagManager.Result(new JSONObject(string), false);
            long l2 = System.currentTimeMillis();
            object = arrayList.size() > 0 ? (exception.remain >= 0 && arrayList.size() <= exception.remain ? (exception.interval == 0L || (l2 - exception.last_requestTime) / 1000L > exception.interval ? null : "interval\u9650\u5236") : "Tags\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc71024") : null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    private String a(String string, Hashtable<String, Integer> hashtable) {
        String string2 = null;
        for (String string3 : hashtable.keySet()) {
            try {
                byte[] byArray = string3.getBytes("UTF-8");
                if (byArray.length > 128 && byArray.length <= 0) {
                    return "\u90e8\u5206Tags\u957f\u5ea6\u4e0d\u5728\u9650\u52360\u5230128\u4e2a\u5b57\u7b26\u4e4b\u95f4";
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"UnsupportedEncodingException"});
                return "\u90e8\u5206Tags\u957f\u5ea6\u4e0d\u5728\u9650\u52360\u5230128\u4e2a\u5b57\u7b26\u4e4b\u95f4";
            }
            if (hashtable.get(string3) >= -10 && hashtable.get(string3) <= 10) continue;
            return "\u90e8\u5206Tags\u6743\u503c\u4e0d\u5728-10\u523010\u4e4b\u95f4";
        }
        if (string == null) {
            return null;
        }
        try {
            ITagManager.Result result = new ITagManager.Result(new JSONObject(string), true);
            long l2 = System.currentTimeMillis();
            string2 = result.interval == 0L || (l2 - result.last_requestTime) / 1000L > result.interval ? null : "interval\u9650\u5236";
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return string2;
    }

    private String b(String string, String ... stringArray) {
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : stringArray) {
            byte[] byArray = null;
            try {
                byArray = string3.getBytes("UTF-8");
                if (byArray.length > 128 || byArray.length < 0) {
                    string2 = "\u90e8\u5206Tags\u957f\u5ea6\u4e0d\u5728\u9650\u52360\u5230128\u4e2a\u5b57\u7b26\u4e4b\u95f4";
                    return string2;
                }
                arrayList.add(string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"UnsupportedEncodingException"});
                return "\u90e8\u5206Tags\u957f\u5ea6\u4e0d\u5728\u9650\u52360\u5230128\u4e2a\u5b57\u7b26\u4e4b\u95f4";
            }
        }
        if (string == null) {
            return null;
        }
        try {
            ITagManager.Result jSONException = new ITagManager.Result(new JSONObject(string), true);
            long l2 = System.currentTimeMillis();
            if (arrayList.size() > 0) {
                string2 = jSONException.interval == 0L || (l2 - jSONException.last_requestTime) / 1000L > jSONException.interval ? null : "interval\u9650\u5236";
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return string2;
    }

    private String a(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        try {
            ITagManager.Result result = new ITagManager.Result(new JSONObject(string), bl);
            long l2 = System.currentTimeMillis();
            string2 = result.interval == 0L || (l2 - result.last_requestTime) / 1000L > result.interval ? null : "interval\u9650\u5236";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private void a(final TCallBack tCallBack, final String ... stringArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ITagManager.Result result = null;
                if (TagManager.this.e()) {
                    try {
                        throw new Exception("Tag API is disabled by the server.");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        tCallBack.onMessage(false, result);
                        return;
                    }
                }
                if (!TagManager.this.d()) {
                    try {
                        throw new Exception("No utdid or device_token");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        tCallBack.onMessage(false, result);
                        return;
                    }
                }
                if (stringArray == null || stringArray.length == 0) {
                    try {
                        throw new Exception("No tags");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        tCallBack.onMessage(false, result);
                        return;
                    }
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : stringArray) {
                    arrayList.add(string);
                }
                if (arrayList.size() == 0) {
                    result = TagManager.this.f();
                    tCallBack.onMessage(true, result);
                    return;
                }
                JSONObject jSONObject = null;
                try {
                    jSONObject = TagManager.this.c();
                    jSONObject.put("tags", (Object)com.umeng.message.util.e.a(arrayList));
                    result = f.update(jSONObject, stringArray);
                    tCallBack.onMessage(true, result);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    tCallBack.onMessage(true, result);
                }
            }
        };
        com.umeng.message.common.d.a(runnable);
    }

    public void deleteTags(final TCallBack tCallBack, final String ... stringArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ITagManager.Result result = null;
                String string = TagManager.this.a(MessageSharedPrefs.getInstance(TagManager.this.e).get_deleteTagsInterval(), stringArray);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    try {
                        throw new Exception(string);
                    }
                    catch (Exception exception) {
                        if (exception != null) {
                            UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"exception:" + exception.getMessage()});
                        }
                        tCallBack.onMessage(false, result);
                        return;
                    }
                }
                if (TagManager.this.e()) {
                    try {
                        throw new Exception("Tag API is disabled by the server.");
                    }
                    catch (Exception exception) {
                        if (exception != null) {
                            UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"exception:" + exception.getMessage()});
                        }
                        tCallBack.onMessage(false, result);
                        return;
                    }
                }
                if (!TagManager.this.d()) {
                    try {
                        throw new Exception("No utdid or device_token");
                    }
                    catch (Exception exception) {
                        if (exception != null) {
                            UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"exception:" + exception.getMessage()});
                        }
                        tCallBack.onMessage(false, result);
                        return;
                    }
                }
                if (stringArray == null || stringArray.length == 0) {
                    try {
                        throw new Exception("No tags");
                    }
                    catch (Exception exception) {
                        if (exception != null) {
                            UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"exception:" + exception.getMessage()});
                        }
                        tCallBack.onMessage(false, result);
                        return;
                    }
                }
                JSONObject jSONObject = null;
                try {
                    jSONObject = TagManager.this.c();
                    jSONObject.put("tags", (Object)com.umeng.message.util.e.a(stringArray));
                    result = f.deleteTags(jSONObject, stringArray);
                    tCallBack.onMessage(true, result);
                }
                catch (Exception exception) {
                    if (exception != null) {
                        UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"exception:" + exception.getMessage()});
                    }
                    tCallBack.onMessage(false, result);
                }
            }
        };
        com.umeng.message.common.d.a(runnable);
    }

    public void deleteWeightedTags(final TCallBack tCallBack, final String ... stringArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ITagManager.Result result = new ITagManager.Result();
                if (!TagManager.this.d()) {
                    String string = "\u7f3a\u5c11utdid\u6216device token";
                    result.setErrors(string);
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    tCallBack.onMessage(false, result);
                    return;
                }
                if (stringArray == null || stringArray.length == 0) {
                    String string = "\u6ca1\u6709\u52a0\u6743\u6807\u7b7e";
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    result.setErrors(string);
                    tCallBack.onMessage(false, result);
                    return;
                }
                if (stringArray.length > 64) {
                    String string = "\u6bcf\u6b21\u8bf7\u6c42\u6700\u591a\u5220\u966464\u4e2a\u52a0\u6743\u6807\u7b7e";
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    result.setErrors(string);
                    tCallBack.onMessage(false, result);
                    return;
                }
                String string = TagManager.this.b(MessageSharedPrefs.getInstance(TagManager.this.e).getDeleteWeightedTagsInterval(), stringArray);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    result.setErrors(string);
                    tCallBack.onMessage(false, result);
                    return;
                }
                try {
                    JSONObject jSONObject = TagManager.this.c();
                    jSONObject.put("tags", (Object)com.umeng.message.util.e.a(stringArray));
                    tCallBack.onMessage(true, f.deleteWeightedTags(jSONObject, stringArray));
                }
                catch (Exception exception) {
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"\u5220\u9664\u52a0\u6743\u6807\u7b7e\u5f02\u5e38"});
                }
            }
        };
        com.umeng.message.common.d.a(runnable);
    }

    private void a(final TCallBack tCallBack) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ITagManager.Result result = null;
                if (TagManager.this.e()) {
                    try {
                        throw new Exception("Tag API\u88ab\u670d\u52a1\u5668\u7981\u6b62");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        tCallBack.onMessage(false, result);
                        return;
                    }
                }
                if (!TagManager.this.d()) {
                    try {
                        throw new Exception("\u7f3a\u5c11utdid\u6216device token");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        tCallBack.onMessage(false, result);
                        return;
                    }
                }
                JSONObject jSONObject = null;
                try {
                    jSONObject = TagManager.this.c();
                    result = f.reset(jSONObject);
                    tCallBack.onMessage(true, result);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    tCallBack.onMessage(false, result);
                }
            }
        };
        com.umeng.message.common.d.a(runnable);
    }

    public void getTags(final TagListCallBack tagListCallBack) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List<String> list = null;
                String string = TagManager.this.a(MessageSharedPrefs.getInstance(TagManager.this.e).get_getTagsInterval(), false);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    try {
                        throw new Exception(string);
                    }
                    catch (Exception exception) {
                        if (exception != null) {
                            UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"exception:" + exception.getMessage()});
                        }
                        tagListCallBack.onMessage(false, list);
                        return;
                    }
                }
                if (TagManager.this.e()) {
                    try {
                        throw new Exception("Tag API\u88ab\u670d\u52a1\u5668\u7981\u6b62.");
                    }
                    catch (Exception exception) {
                        if (exception != null) {
                            UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"exception:" + exception.getMessage()});
                        }
                        tagListCallBack.onMessage(false, list);
                        return;
                    }
                }
                if (!TagManager.this.d()) {
                    try {
                        throw new Exception("\u7f3a\u5c11utdid\u6216device token");
                    }
                    catch (Exception exception) {
                        if (exception != null) {
                            UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"exception:" + exception.getMessage()});
                        }
                        tagListCallBack.onMessage(false, list);
                        return;
                    }
                }
                JSONObject jSONObject = null;
                try {
                    jSONObject = TagManager.this.c();
                    list = f.getTags(jSONObject);
                    tagListCallBack.onMessage(true, list);
                }
                catch (Exception exception) {
                    if (exception != null) {
                        UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"exception:" + exception.getMessage()});
                    }
                    tagListCallBack.onMessage(false, list);
                }
            }
        };
        com.umeng.message.common.d.a(runnable);
    }

    public void getWeightedTags(final WeightedTagListCallBack weightedTagListCallBack) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                if (!TagManager.this.d()) {
                    String string = "\u7f3a\u5c11utdid\u6216device token";
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    weightedTagListCallBack.onMessage(false, hashtable);
                    return;
                }
                String string = TagManager.this.a(MessageSharedPrefs.getInstance(TagManager.this.e).getListWeightedTagsInterval(), true);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{string});
                    weightedTagListCallBack.onMessage(false, hashtable);
                    return;
                }
                try {
                    JSONObject jSONObject = TagManager.this.c();
                    hashtable = f.getWeightedTags(jSONObject);
                    weightedTagListCallBack.onMessage(true, hashtable);
                }
                catch (Exception exception) {
                    UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"\u83b7\u53d6\u52a0\u6743\u6807\u7b7e\u5217\u8868\u5f02\u5e38"});
                    weightedTagListCallBack.onMessage(false, hashtable);
                }
            }
        };
        com.umeng.message.common.d.a(runnable);
    }

    private JSONObject c() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("header", (Object)UTrack.getInstance(this.e).getHeader());
        String string = UmengMessageDeviceConfig.getUtdid(this.e);
        jSONObject.put("utdid", (Object)string);
        jSONObject.put("device_token", (Object)MessageSharedPrefs.getInstance(this.e).getDeviceToken());
        jSONObject.put("ts", System.currentTimeMillis());
        return jSONObject;
    }

    private static JSONObject a(JSONObject jSONObject, String string) throws JSONException {
        String string2 = HttpRequest.post(string).acceptJson().contentType("application/json").send(jSONObject.toString()).body("UTF-8");
        UMLog.mutlInfo((String)a, (int)2, (String[])new String[]{"postJson() url=" + string + "\n request = " + jSONObject + "\n response = " + string2});
        return new JSONObject(string2);
    }

    private boolean d() {
        if (TextUtils.isEmpty((CharSequence)UmengMessageDeviceConfig.getUtdid(this.e))) {
            UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"UTDID\u4e3a\u7a7a"});
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)MessageSharedPrefs.getInstance(this.e).getDeviceToken())) {
            UMLog.mutlInfo((String)a, (int)0, (String[])new String[]{"Device token\u4e3a\u7a7a"});
            return false;
        }
        return true;
    }

    private boolean e() {
        boolean bl;
        int n = MessageSharedPrefs.getInstance(this.e).getTagSendPolicy();
        boolean bl2 = bl = n == 1;
        if (bl) {
            UMLog.mutlInfo((String)a, (int)2, (String[])new String[]{"Tag API\u88ab\u670d\u52a1\u5668\u7981\u6b62"});
        }
        return bl;
    }

    private ITagManager.Result f() {
        ITagManager.Result result = new ITagManager.Result(new JSONObject(), false);
        result.remain = MessageSharedPrefs.getInstance(this.e).getTagRemain();
        result.status = b;
        result.jsonString = "status:" + result.status + "," + " remain:" + result.remain + "," + "description:" + result.status;
        return result;
    }

    public static interface WeightedTagListCallBack {
        public void onMessage(boolean var1, Hashtable<String, Integer> var2);
    }

    public static interface TagListCallBack {
        public void onMessage(boolean var1, List<String> var2);
    }

    public static interface TCallBack {
        public void onMessage(boolean var1, ITagManager.Result var2);
    }
}

